<?php $form = $this->beginWidget('UActiveForm', array(
        'id' => 'usuarios-agencias-form',
        'enableAjaxValidation' => false,
        'method' => 'post',
        'type' => 'horizontal',
        'disableAjaxValidationAttributes' => array('RegistrationForm_verifyCode'),
        'clientOptions' => array(
            'validateOnSubmit' => true,
        ),
        'htmlOptions' => array(
            'enctype' => 'multipart/form-data'
        )
    )); ?>

    <style type="text/css">
        .foto_principal_logo {
            width: 150px;
            height: 150px;
            margin-right: 10px;
        }

        .foto_principal_logo img {
            width: 100%;
            border-radius: 5px;
        }
    </style>

    <div class="content-wrapper container-xxl p-0">

        <div class="content-body">
            <div class="row">
                <div class="col-12">

                    <!-- profile -->
                    <div class="card">
                        <?php echo $form->errorSummary(array($model, $profile, $datosusuario)); ?>
                        <div class="card-header border-bottom">
                            <h4 class="card-title">Editar mi perfil - <?= $datosusuario->idAgencia->nombre_comercial; ?></h4>
                        </div>
                        <div class="card-body py-2 my-25">
                            <!-- header section -->

                            <div class="col-12 mb-2">
                                <div class="border rounded p-2">
                                    <h4 class="mb-1">Foto principal</h4>
                                    <div class="d-flex flex-column flex-md-row align-items-center">
                                        <div class="foto_principal_logo">

                                            <?php
                                                if ($datosusuario->foto) {
                                                    echo CHtml::image(Yii::app()->baseUrl . "/images/usuarios/" . $datosusuario->foto);
                                                } else {
                                                    echo CHtml::image(Yii::app()->baseUrl . "/images/profile-default.svg");
                                                }
                                            ?>

                                        </div>
                                        <!-- <img src="../../../app-assets/images/slider/03.jpg" id="blog-feature-image" class="rounded me-2 mb-1 mb-md-0" width="170" height="110" alt="Blog Featured Image" /> -->
                                        <div class="featured-info">
                                            <!-- <small class="text-muted">Required image resolution 800x400, image size 10mb.</small>
                                        <p class="my-50">
                                            <a href="#" id="blog-image-text">C:\fakepath\banner.jpg</a>
                                        </p> -->
                                            <div class="d-inline-block">
                                                <?php echo $form->fileField($datosusuario, 'foto', array('class' => 'form-control', 'maxlength' => 250)); ?>
                                                <p>Tipo de archivos permitidos: jpg, png, jpeg.</p>
                                                <!-- <input class="form-control" type="file" id="blogCustomFile" accept="image/*" /> -->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--/ header section -->

                            <!-- form -->
                            <form class="validate-form mt-2 pt-50">
                                <div class="row">

                                    <?php
                                        $profileFields = $profile->getFields();
                                        if ($profileFields) {
                                            foreach ($profileFields as $field) {

                                                if ($widgetEdit = $field->widgetEdit($profile)) {
                                                    echo '<div class="form-group">';
                                                    echo $form->textFieldRow($profile, $field->varname, array('class' => 'form-control'));
                                                    echo $widgetEdit;
                                                    echo $form->error($profile, $field->varname, array('class' => 'help-inline'));
                                                    echo '</div>';
                                                    echo '<div class="form-group"><div class="form-control">' . $widgetEdit . '</div></div>';
                                                } elseif ($field->range) {
                                                    echo $form->dropDownListRow($profile, $field->varname, Profile::range($field->range));
                                                } elseif ($field->field_type == "TEXT") {
                                                    echo $form->textAreaRow($profile, $field->varname, array('rows' => 6, 'cols' => 50));
                                                } else {
                                                    echo '<div class="col-12 col-md-4 mb-1">';
                                                    echo $form->textFieldRow($profile, $field->varname, array('class' => 'form-control', 'size' => 60, 'maxlength' => (($field->field_size) ? $field->field_size : 255)));
                                                    echo '</div>';
                                                }
                                            }
                                        }
                                    ?>
                                    <!-- <label class="form-label" for="accountFirstName">First Name</label>
                                    <input type="text" class="form-control" id="accountFirstName" name="firstName" placeholder="John" value="John" data-msg="Please enter first name" /> -->

                                    <!-- <div class="col-12 col-sm-6 mb-1">
                                    <label class="form-label" for="accountLastName">Last Name</label>
                                    <input type="text" class="form-control" id="accountLastName" name="lastName" placeholder="Doe" value="Doe" data-msg="Please enter last name" />
                                </div> -->
                                    <div class="col-12 col-sm-4 mb-1">
                                        <label class="form-label" for="usernameinput">Usuario</label>
                                        <?php echo $form->textField($model, 'username', array('class' => 'form-control', 'id' => 'usernameinput', 'maxlength' => 50)); ?>
                                        <!-- <input type="text" class="form-control" id="accountOrganization" name="organization" placeholder="Organization name" value="PIXINVENT" /> -->
                                    </div>
                                    <div class="col-12 col-sm-4 mb-1">
                                        <label class="form-label" for="accountEmail">Email</label>
                                        <?php echo $form->textField($model, 'email', array('class' => 'form-control', 'id' => 'accountEmail', 'maxlength' => 50)); ?>
                                    </div>
                                    <!-- <div class="col-12 col-sm-4 mb-1">
                                    <label class="form-label" for="password2input">Usuario</label>
                                    <?php //echo $form->passwordFieldRow($model, 'verifyPassword', array('class' => 'form-control', 'id' => 'password2input', 'maxlength' => 50));
                                    ?>
                                    </div> -->
                                    <div class="col-12 col-md-4 mb-1">
                                        <label class="form-label" for="passwordinput">Contraseña</label>
                                        <?php echo $form->passwordField($model, 'password', array('class' => 'form-control', 'id' => 'passwordinput', 'maxlength' => 50)); ?>
                                        
                                        <!-- <input type="email" class="form-control" id="accountEmail" name="email" placeholder="Email" value="johndoe@gmail.com" /> -->
                                    </div>
                                    <!-- <div class="col-12 col-sm-4 mb-1">
                                    <label class="form-label" for="Telefonoform">Teléfono</label>
                                    <?php //echo $form->textField($datosusuario, 'telefono', array('class' => 'form-control', 'id' => 'Telefonoform', 'maxlength' => 10)); 
                                    ?>
                                </div> -->
                                    <div class="col-12 col-sm-4 mb-1">
                                        <label class="form-label" for="fechanacimiento">Fecha de nacimiento</label>
                                        <?php echo $form->dateField($datosusuario, 'fecha_nacimiento', array('class' => 'form-control', 'id' => 'fechanacimiento')); ?>

                                    </div>
                                    <!-- <div class="col-12 col-sm-9 mb-1">
                                    <label class="form-label" for="direccionform">Dirección</label>
                                    <?php //echo $form->textField($datosusuario, 'direccion', array('class' => 'form-control', 'id' => 'direccionform', 'maxlength' => 85)); 
                                    ?>
                                    
                                </div> -->
                                    <?php
                                        $style="";
                                        $ua_model = UsuariosAgencias::model()->find("id_usuario = ". Yii::app()->user->id);
                                        if($ua_model->rol == "Agente") {
                                            $style="style='display: none'";
                                        }
                                    ?>
                                    <div class="col-12 col-sm-3 mb-1">
                                        <label class="form-label" for="rolform">Rol</label>
                                        <?php //echo $form->textField($datosusuario, 'rol', array('class' => 'form-control', 'id' => 'rolform', 'maxlength' => 20)); 
                                        ?>

                                        <?php echo $form->dropDownList($datosusuario, 'rol', array('Agente' => 'Agente', 'Agente de bodas' => 'Agente de bodas', 'Contabilidad' => 'Contabilidad', 'Propietario' => 'Propietario', 'Administrador' => 'Administrador'), array('class' => 'form-control', 'id' => 'rolform')); ?>
                                        <!-- <input type="text" class="form-control account-zip-code" id="accountZipCode" name="zipCode" placeholder="Code" maxlength="6" /> -->
                                    </div>
                                    <div class="col-12 col-sm-3 mb-1">
                                        <label class="form-label" for="estatusform">estatus</label>
                                        <?php //echo $form->textField($datosusuario, 'rol', array('class' => 'form-control', 'id' => 'rolform', 'maxlength' => 20)); 
                                        ?>

                                        <?php echo $form->dropDownList($datosusuario, 'status_laboral', array('1' => 'Activo',  '0' => 'Desactivado'), array('class' => 'form-control', 'id' => 'estatusform')); ?>
                                        <!-- <input type="text" class="form-control account-zip-code" id="accountZipCode" name="zipCode" placeholder="Code" maxlength="6" /> -->
                                    </div>
                                    <div class="col-12">
                                        <?php $this->widget('bootstrap.widgets.TbButton', array(
                                            'buttonType' => 'submit',
                                            'type' => 'primary',
                                            'icon' => 'ok white',
                                            'label' => $model->isNewRecord ? 'Crear' : 'Guardar',
                                        )); ?>
                                        <?php $this->widget('bootstrap.widgets.TbButton', array(
                                            'buttonType' => 'reset',
                                            'icon' => 'remove',
                                            'label' => 'Limpiar',
                                        )); ?>
                                    </div>
                                </div>
                            </form>
                            <!--/ form -->
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>

    <?php $this->endWidget(); ?>


<?php
    Yii::app()->clientScript->registerScript('headers', '
        var id_agencia = "' . $_GET['id'] . '";
        var baseUrl = "' . Yii::app()->baseUrl . '";
    ', CClientScript::POS_HEAD);

    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/js/usuarios_agenciaVUE.js?v=' . time(), CClientScript::POS_END);
?>