<style>
    .invoice-add .invoice-preview-card .invoice-product-details,
    .invoice-edit .invoice-preview-card .invoice-product-details {
        padding: 0rem 3.45rem 0rem;
    }

    .list-group-item {
        padding: 0.75rem 0rem;
    }

    .float-btn {
        position: fixed;
        margin-right: 2rem;
        width: 18%;
        /* position:fixed;
        right:0;
        top:50%; */
    }

    [v-cloak] {
        display: none;
    }

    .form-control:disabled,
    .form-control[readonly] {
        background-color: #FFFFFF !important;
    }

    .invoice-add .invoice-preview-card .invoice-product-details .product-details-border,
    .invoice-edit .invoice-preview-card .invoice-product-details .product-details-border {
        border: 1px solid #D8D6DE !important;
    }

    .border-start {
        border-left: 1px solid #D8D6DE !important;
    }

    .btn-addon {
        padding: 0.786rem 0.5rem !important;
    }

    .input-group.has-validation>.dropdown-toggle:nth-last-child(n+4),
    .input-group.has-validation>:nth-last-child(n+3):not(.dropdown-toggle):not(.dropdown-menu),
    .input-group:not(.has-validation)>.dropdown-toggle:nth-last-child(n+3),
    .input-group:not(.has-validation)>:not(:last-child):not(.dropdown-toggle):not(.dropdown-menu) {
        border-top-right-radius: 0.357rem !important;
        border-bottom-right-radius: 0.357rem !important;
    }

    input[type="file"] {
        display: none;
    }

    .card {
        margin-bottom: 1rem !important;
    }
</style>

<section id="app-sales" class="invoice-add-wrapper" v-cloak>
    <form action="#" @submit.prevent="saveSale">
        <div class="row invoice-add">
            <!-- Invoice Add Left starts -->
            <div class="col-xl-9 col-md-8 col-12">
                <div class="card invoice-preview-card">
                    <!-- Header starts -->
                    <div class="card-body invoice-padding pb-0">
                        <div class="d-flex justify-content-between flex-md-row flex-column invoice-spacing mt-0">
                            <div>
                                <?php $this->renderPartial("/site/_infoAgenciaInvoice"); ?>
                            </div>
                            <div class="invoice-number-date mt-md-0 mt-2">
                                <!-- <div class="d-flex align-items-center justify-content-md-end mb-1" v-if="action == 'update'">
                                    <h4 class="invoice-title">Folio</h4>
                                    <div class="input-group input-group-merge invoice-edit-input-group">
                                        <input type="text" class="form-control invoice-edit-input" v-model="sale_model.folio" readonly />
                                    </div>
                                </div> -->
                                <div class="d-flex align-items-center mb-1" v-if="action == 'update'">
                                    <span class="title">Folio</span>
                                    <input type="text" class="form-control invoice-edit-input" v-model="sale_model.folio" readonly />
                                </div>
                                <div class="d-flex align-items-center mb-1">
                                    <span class="title">Moneda *</span>
                                    <select type="text" class="form-control invoice-edit-input" v-model="sale_model.moneda" required>
                                        <option value="MXN">MXN</option>
                                        <option value="USD">USD</option>
                                    </select>
                                </div>
                                <div class="d-flex align-items-center mb-1">
                                    <span class="title">Fecha *</span>
                                    <input type="text" class="form-control invoice-edit-input date-picker" required />
                                </div>
                                <div class="d-flex align-items-center mb-1">
                                    <span class="title">Límite de cambios *</span>
                                    <input type="text" id="cancel-limit" class="form-control invoice-edit-input" required />
                                </div>
                                <div class="d-flex align-items-center mb-1">
                                    <span class="title">Cargos por servicios *</span>
                                    <input type="number" step="any" class="form-control invoice-edit-input" v-model="sale_model.cargo_servicios" required />
                                </div>
                                <div class="d-flex align-items-center mb-1">
                                    <span class="title">Tipo venta *</span>
                                    <select class="form-control invoice-edit-input" v-model="sale_model.id_tipo_venta" @change="loadGroups" required>
                                        <option selected value="0">No Aplica</option>
                                        <option :value="sale_type.id" v-text="sale_type.tipo" v-for="sale_type in sale_types_array"></option>
                                    </select>
                                </div>
                                <!-- <div class="d-flex align-items-center" v-if="action == 'update'">
                                    <span class="title">Límite Cliente</span>
                                    <span v-text="payment_limit"></span>
                                </div> -->
                            </div>
                        </div>
                    </div>
                    <!-- Header ends -->

                    <hr class="invoice-spacing" />

                    <!-- Address and Contact starts -->
                    <div class="card-body invoice-padding pt-0">
                        <div class="row row-bill-to invoice-spacing">
                            <div class="col-xl-5 mb-lg-1 col-bill-to ps-0">
                                <h6 class="invoice-to-title">Vendido a *</h6>
                                <div class="invoice-customer">
                                    <select class="invoiceto form-select" required>
                                        <option></option>
                                    </select>
                                </div>
                                <div class="customer-details mt-1">
                                    <p class="mb-25">
                                        <strong>Nombre:</strong> <span v-if="customer_selected.id" v-text="customer_selected.text"></span>
                                    </p>
                                    <p class="mb-0">
                                        <strong>Teléfono:</strong> <span v-if="customer_selected.id" v-text="customer_selected.phone"></span>
                                    </p>
                                    <p class="mb-0">
                                        <strong>Correo:</strong> <span v-if="customer_selected.id" v-text="customer_selected.mail"></span>
                                    </p>
                                </div>
                            </div>
                            <div class="col-xl-7 p-0 ps-xl-2 mt-xl-0 mt-2">
                                <h6 class="invoice-to-title">Pasajero titular *</h6>
                                <div class="invoice-customer">
                                    <input type="text" class="form-control" id="input-own-pax" v-model="sale_model.pasajero_titular" required>
                                </div>
                                <div class="mt-1">
                                    <label for="input-description" class="form-label">Descripción</label>
                                    <textarea class="form-control" id="input-description" rows="1" v-model="sale_model.descripcion"></textarea>
                                </div>
                                <div class="mt-1" v-if="sale_model.id_tipo_venta == 1 || sale_model.id_tipo_venta == 2">
                                    <label class="form-label">Derivado de: *</label>
                                    <select class="form-control" v-model="sale_model.pertenece_a">
                                        <option value="" selected hidden>-- Seleccione --</option>
                                        <option :value="group.id" v-text="group.text" v-for="group in groups_array"></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Address and Contact ends -->

                    <!-- Product Details starts -->
                    <div class="card-body invoice-padding invoice-product-details">
                        <div class="source-item">
                            <div :class="[index == (service_array.length- 1) ? '' : 'mb-3', 'row']" v-for="(service, index) in service_array">
                                <div class="col-12 d-flex product-details-border position-relative pe-0">
                                    <div class="w-100 pe-lg-0 pe-1 py-2">
                                        <div class="row">
                                            <div class="col-lg-5 col-12 mb-lg-0 mb-2 mt-lg-0 mt-2">
                                                <label class="form-label">Proveedor *</label>
                                                <select :id="'slct-provider-' + index" class="form-select item-details" :data-index="index" required>
                                                    <option></option>
                                                </select>
                                            </div>
                                            <div class="col-lg-3 col-12 my-lg-0 my-2">
                                                <label class="form-label">Código</label>
                                                <input type="text" maxlength="10" class="form-control" v-model="service.codigo" />
                                            </div>
                                            <div class="col-lg-4 col-12 my-lg-0 my-2">
                                                <label class="form-label">Tipo servicio *</label>
                                                <select class="form-select item-details" v-model="service.id_tipo_servicio" @change="setSaleDetail(index)" required>
                                                    <option value="" selected hidden>Seleccione</option>
                                                    <option v-for="service_type in service_types_array" v-text="service_type.tipo_servicio" :value="service_type.id_servicio"></option>
                                                </select>
                                            </div>
                                        </div>

                                        <div v-if="service.id_tipo_servicio == 1">
                                            <?php $this->renderPartial("renders/_HotelForm"); ?>
                                        </div>
                                        <div v-else-if="service.id_tipo_servicio == 2 || service.id_tipo_servicio == 6">
                                            <?php $this->renderPartial('renders/_FlightsMovesForm'); ?>
                                        </div>
                                        <div class="col-lg-12 my-lg-0 my-2" v-else-if="service.id_tipo_servicio == 3 || service.id_tipo_servicio == 4">
                                            <div class="row mt-1">
                                                <div class="col-8">
                                                    <label class="form-label">Fecha servicio</label>
                                                    <input type="text" :id="'dp-stay-' + index" class="form-control">
                                                </div>
                                                <div class="col-4">
                                                    <label class="form-label">Fecha evento</label>
                                                    <input class="form-control" type="date" v-model="service.desglose.fecha_evento">
                                                </div>

                                                <div class="w-100 mt-1"></div>

                                                <div class="col-5" v-if="service.id_tipo_servicio == 3">
                                                    <label class="form-label">Nombre de evento o festejado</label>
                                                    <input class="form-control" type="text" v-model="service.desglose.novios">
                                                </div>
                                                <div class="col-5" v-if="service.id_tipo_servicio == 4">
                                                    <label class="form-label">Novios (Escribir "novio" y "novia")</label>
                                                    <input class="form-control" type="text" v-model="service.desglose.novios">
                                                </div>
                                                <div class="col">
                                                    <label class="form-label">Tipo Habitación</label>
                                                    <input class="form-control" type="text" v-model="service.desglose.tipo_hab">
                                                </div>
                                                <div class="col-3">
                                                    <label class="form-label">No. Hab.</label>
                                                    <input class="form-control" type="number" v-model="service.desglose.no_hab">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 mt-1" v-else-if="service.id_tipo_servicio != ''">
                                            <div class="row">
                                                <div class="col" v-if="service.id_tipo_servicio != 3 && service.id_tipo_servicio != 4">
                                                    <label class="form-label">Pasajeros *</label>
                                                    <div class="input-group">
                                                        <input type="text" class="form-control dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false" v-model="service.desglose.ocupacion" :aria-describedby="'btn-addon-' + index" readonly>
                                                        <button :id="'btn-addon-' + index" class="btn btn-addon btn-outline-primary" type="button" data-bs-toggle="modal" data-bs-target="#pax-list-modal" @click="editPaxList(index)"><i data-feather="edit"></i></button>
                                                        <div class="dropdown-menu p-2">
                                                            <div class="row">
                                                                <div class="col">
                                                                    <label class="form-label">Adultos</label>
                                                                    <select class="form-control" v-model="service.desglose.adultos" @change="changeOccupancy(index)">
                                                                        <option :value="adult" v-text="adult" :selected="adult == 2" v-for="adult in array_adults"></option>
                                                                    </select>
                                                                </div>
                                                                <div class="col">
                                                                    <label class="form-label">Menores</label>
                                                                    <select class="form-control" v-model="service.desglose.menores" @change="changeOccupancy(index)">
                                                                        <option :value="child" v-text="child" v-for="child in array_children"></option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <label class="form-label">Fecha servicio</label>
                                                    <input type="text" :id="'dp-stay-' + index" class="form-control">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row mt-2">
                                            <div class="col-7">
                                                <label class="form-label">Descripción</label>
                                                <textarea class="form-control" rows="1" v-model="service.descripcion"></textarea>
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Límite Pago *</label>
                                                <input type="text" :id="'dp-limit-' + index" class="form-control" required>
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Límite cliente</label>
                                                <input type="text" :id="'dp-customer-limit-' + index" class="form-control">
                                            </div>
                                        </div>
                                        <div class="row mt-2" v-if="action == 'create' || service.id_ventaservicio == 0">
                                            <div class="col">
                                                <label class="form-label">Comisión Proveedor *</label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control" step="any" v-model="service.comision" v-if="service.desglose.comision == '%'" required>
                                                    <input type="number" class="form-control" step="any" v-model="service.comision_pesos" v-else required>
                                                    <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-text="service.desglose.comision"></button>
                                                    <div class="dropdown-menu dropdown-menu-end">
                                                        <a class="dropdown-item" href="javascript:;" @click="changeComissionType(index)">%</a>
                                                        <a class="dropdown-item" href="javascript:;" @click="changeComissionType(index)">MXN</a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Tarifa Pública *</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input type="number" class="form-control" v-model="service.tarifa_publica" step="any" required>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Fee</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input type="number" class="form-control" v-model="service.fee" step="any">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Tarifa Agencia *</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input type="number" class="form-control" v-model="service.costo" step="any" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mt-2" v-else>
                                            <div class="col">
                                                <label class="form-label">Tarifa Pública *</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input type="number" class="form-control" v-model="service.tarifa_publica" step="any" required>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Comisión *</label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control" step="any" v-model="service.comision" required>
                                                    <span class="input-group-text">%</span>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Comisión (Pesos) *</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input type="number" class="form-control" step="any" v-model="service.comision_pesos" required>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Fee</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input type="number" class="form-control" step="any" v-model="service.fee">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Costo *</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input type="number" class="form-control" step="any" v-model="service.costo" required>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="ms-1 d-flex flex-column align-items-center justify-content-between border-start invoice-product-actions py-50 px-25">
                                        <a @click="removeService(index)"><i data-feather="x" class="font-medium-3"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="row my-1 text-end">
                                <div class="col-12 px-0">
                                    <button type="button" class="btn btn-primary btn-sm btn-add-new" @click="addService()">
                                        <i data-feather="plus" class="me-25"></i>
                                        <span class="align-middle">Agregar servicio</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Product Details ends -->

                    <!-- Invoice Total starts -->
                    <div class="card-body invoice-padding" style="padding: 0 2.5rem 2.5rem 2.5rem;">
                        <div class="row invoice-sales-total-wrapper">
                            <div class="col-md-6 order-md-1 order-2">
                                <label for="note" class="form-label fw-bold">Observaciones:</label>
                                <textarea class="form-control" rows="2" id="note" v-model="sale_model.observaciones"></textarea>
                            </div>
                            <div class="col-md-6 d-flex justify-content-end order-md-2 order-1">
                                <div class="invoice-total-wrapper">
                                    <div class="invoice-total-item">
                                        <p class="invoice-total-title">Subtotal:</p>
                                        <p class="invoice-total-amount" v-text="calculateSubtotal()"></p>
                                    </div>
                                    <div class="invoice-total-item">
                                        <p class="invoice-total-title">Fee:</p>
                                        <p class="invoice-total-amount" v-text="calculateFee()"></p>
                                    </div>
                                    <hr class="my-50" />
                                    <div class="invoice-total-item">
                                        <p class="invoice-total-title">Total:</p>
                                        <p class="invoice-total-amount" v-text="calculateTotal()"></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Invoice Total ends -->
                </div>
            </div>
            <!-- Invoice Add Left ends -->

            <!-- Invoice Add Right starts -->
            <div class="col-xl-3 col-md-4 col-12">
                <section class="float-btn">
                    <div class="card">
                        <div class="card-body">
                            <!-- <a href="./app-invoice-preview.html" class="btn btn-outline-primary w-100 mb-75">Pagar</a> -->
                            <button type="submit" class="btn btn-sm btn-primary w-100">Guardar</button>
                            <div v-if="load_info">
                                <a :href="baseUrl + '/formatos/contrato/' + sale_model.contratos.id_contrato" class="btn btn-sm btn-outline-primary w-100 mt-1" target="_blank" v-if="action == 'update'">Ver contrato</a>
                                <a href="javascript:;" @click="showContractLinkAlert()" class="btn btn-sm btn-outline-primary w-100 mt-1" v-if="action == 'update'">Enviar contrato</a>
                            </div>
                            <a :href="baseUrl + '/caja/accountDetail/' +  sale_model.id_venta" class="btn btn-sm btn-outline-primary w-100 mt-1" target="_blank" v-if="action == 'update'">Ver comprobante</a>
                            <button type="button" class="btn btn-sm btn-outline-success w-100 mt-1" v-if="action == 'update'" data-bs-toggle="modal" data-bs-target="#paymentPromiseModal">Promesa de pago</button>
                        </div>
                    </div>
                    <div v-if="load_info">
                        <div class="card" v-if="action == 'update' && sale_model.contratos.hasOwnProperty('id_contrato')">
                            <div class="card-body">
                                <h5 class="card-title">Contratos anteriores</h5>
                                <p v-if="sale_model.contratos.version == 1">No hay contratos anteriores.</p>
                                <ul class="list-group list-group-flush" v-else>
                                    <li class="list-group-item" v-for="contrato in (parseInt(sale_model.contratos.version) - 1)">
                                        <a :href="baseUrl + '/files/previous-contracts/Contrato-' + sale_model.folio + '-V' + contrato + '.pdf'" target="_blank" v-text="'Contrato Versión ' + contrato"></a>
                                    </li>
                                </ul>
                                <label for="contract-upload" style="cursor: pointer;" class="btn btn-sm btn-outline-primary w-100 mt-1">
                                    <i class="fa fa-cloud-upload"></i> Agregar contrato
                                </label>
                                <input id="contract-upload" type="file" accept="application/pdf" @change="uploadContract" />
                            </div>
                        </div>
                    </div>
                    <div class="card" style="max-height: 15rem; overflow-y:auto" v-if="action == 'update'">
                        <div class="card-body">
                            <h5 class="card-title">Pagos</h5>
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item" v-for="payment in sale_payments_array">
                                    <div class="row">
                                        <div class="col" v-text="payment.idFormaPago.descripcion"></div>
                                        <div class="col">
                                            <div v-text="getPaymentDate(payment)"></div>
                                            <div v-text="calculateSalePayments(payment.pagosDetalles)"></div>
                                        </div>
                                        <div class="col-1" v-if="payment.comprobante != null">
                                            <a :href="baseUrl + '/images/comprobantes/pagos/' + payment.comprobante" target="_blank"><i data-feather="eye"></i></a>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                            <p v-if="sale_payments_array.length == 0">No hay pagos registrados.</p>
                        </div>
                    </div>
                </section>
            </div>
            <!-- Invoice Add Right ends -->
        </div>
    </form>

    <!-- Contract Link Modal -->
    <div class="modal fade" id="contract-link-modal" tabindex="-1" aria-labelledby="contract-link-label" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="contract-link-label">Enviar link de firma para contrato</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" :key="key_flight_stop">
                    <label class="form-label">Correo del cliente</label>
                    <input type="email" class="form-control" v-model="contract_email">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-danger" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-primary" data-bs-dismiss="modal" @click="sendContractLink()">Enviar</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Contract Link Modal -->

    <!-- Stop Flights Modal -->
    <div class="modal fade" id="stop-flight-modal" tabindex="-1" aria-labelledby="stop-flight-label" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="stop-flight-label">Editar escalas</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" :key="key_flight_stop">
                    <div v-if="aux_index >= 0">
                        <div v-if="service_array[aux_index].id_tipo_servicio == 6">
                            <div class="row">
                                <div class="col">Escalas origen</div>
                                <div class="col">
                                    <div class="text-end">
                                        <button class="btn btn-sm btn-primary" @click="addFlightStop('O')"><i data-feather="plus"></i> Escala</button>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-1" v-for="(flight_stop_origin, fsoi) in service_array[aux_index].desglose.escalas_origen">
                                <div class="col-12 d-flex position-relative pe-0 rounded" style="border: 1px solid #ebe9f1">
                                    <div class="w-100 pe-lg-0 pe-1 py-2">
                                        <div class="row">
                                            <div class="col">
                                                <label class="form-label">Origen</label>
                                                <input class="form-control" type="text" v-model="flight_stop_origin.origen">
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Destino</label>
                                                <input class="form-control" type="text" v-model="flight_stop_origin.destino">
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Fecha</label>
                                                <input class="form-control" type="date" v-model="flight_stop_origin.fecha_origen">
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Salida origen</label>
                                                <input class="form-control" type="time" v-model="flight_stop_origin.salida_origen">
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Fecha</label>
                                                <input class="form-control" type="date" v-model="flight_stop_origin.fecha_destino">
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Llegada destino</label>
                                                <input class="form-control" type="time" v-model="flight_stop_origin.llegada_destino">
                                            </div>
                                        </div>

                                    </div>

                                    <div class="ms-1 d-flex flex-column align-items-center justify-content-between border-start invoice-product-actions py-50 px-25">
                                        <a @click="deleteFlightStop('O', fsoi)"><i data-feather="x" class="font-medium-3"></i></a>
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-1" v-if="service_array[aux_index].desglose.redondo">
                                <div class="col">Escalas destino</div>
                                <div class="col">
                                    <div class="text-end">
                                        <button class="btn btn-sm btn-primary" @click="addFlightStop('D')"><i data-feather="plus"></i> Escala</button>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-1" v-for="(flight_stop, fsdi) in service_array[aux_index].desglose.escalas_destino">
                                <div class="col-12 d-flex position-relative pe-0 rounded" style="border: 1px solid #ebe9f1">
                                    <div class="w-100 pe-lg-0 pe-1 py-2">
                                        <div class="row">
                                            <div class="col">
                                                <label class="form-label">Origen</label>
                                                <input class="form-control" type="text" v-model="flight_stop.origen">
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Destino</label>
                                                <input class="form-control" type="text" v-model="flight_stop.destino">
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Fecha</label>
                                                <input class="form-control" type="date" v-model="flight_stop.fecha_origen">
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Salida origen</label>
                                                <input class="form-control" type="time" v-model="flight_stop.salida_origen">
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Fecha</label>
                                                <input class="form-control" type="date" v-model="flight_stop.fecha_destino">
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Llegada destino</label>
                                                <input class="form-control" type="time" v-model="flight_stop.llegada_destino">
                                            </div>
                                        </div>

                                    </div>

                                    <div class="ms-1 d-flex flex-column align-items-center justify-content-between border-start invoice-product-actions py-50 px-25">
                                        <a @click="deleteFlightStop('D', fsdi)"><i data-feather="x" class="font-medium-3"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-outline-primary" data-bs-dismiss="modal">Aceptar</button>
                </div>
            </div>
        </div>
    </div>
    <!-- /Stop Flights Modal -->

    <!-- Add New Provider Sidebar -->
    <?php $this->renderPartial("//proveedores/_modalCreate"); ?>
    <!-- /Add New Provider Sidebar -->

    <!-- Pax List -->
    <div class="modal fade" id="pax-list-modal" tabindex="-1" aria-labelledby="paxLabel" aria-hidden="true">
        <div id="modal-pax" class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="paxLabel">Editar pasajeros</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div v-if="index_aux >= 0">
                        <section v-if="service_array[index_aux].id_tipo_servicio == 1">
                            <div v-for="(hab, index_hab) in service_array[index_aux].desglose.habitaciones">
                                <h4 class="text-center" v-text="'Habitación ' + (index_hab + 1)"></h4>
                                <div class="row" v-for="adulto in hab.pasajeros.adultos">
                                    <div class="col">
                                        <label class="form-label">Nombre(s)</label>
                                        <input type="text" class="form-control" v-model="adulto.nombre" />
                                    </div>
                                    <div class="col">
                                        <label class="form-label">Apellidos</label>
                                        <input type="text" class="form-control" v-model="adulto.apellidos" />
                                    </div>
                                </div>
                                <h4 class="text-center mt-1" v-if="hab.menores > 0">Menores</h4>
                                <div class="row" v-for="menor in hab.pasajeros.menores">
                                    <div class="col-5">
                                        <label class="form-label">Nombre(s)</label>
                                        <input type="text" class="form-control" v-model="menor.nombre" />
                                    </div>
                                    <div class="col-5">
                                        <label class="form-label">Apellidos</label>
                                        <input type="text" class="form-control" v-model="menor.apellidos" />
                                    </div>
                                    <div class="col">
                                        <label class="form-label">Edad</label>
                                        <input type="text" class="form-control" v-model="menor.edad" />
                                    </div>
                                </div>
                            </div>
                        </section>
                        <section v-else-if="service_array[index_aux].id_tipo_servicio == 2 || service_array[index_aux].id_tipo_servicio == 6 || service_array[index_aux].id_tipo_servicio == 5 || service_array[index_aux].id_tipo_servicio == 7 || service_array[index_aux].id_tipo_servicio == 8 || service_array[index_aux].id_tipo_servicio == 9 || service_array[index_aux].id_tipo_servicio == 10">
                            <div class="row" v-for="adulto in service_array[index_aux].desglose.pasajeros.adultos">
                                <div class="col">
                                    <label class="form-label">Nombre(s)</label>
                                    <input type="text" class="form-control" v-model="adulto.nombre" />
                                </div>
                                <div class="col">
                                    <label class="form-label">Apellidos</label>
                                    <input type="text" class="form-control" v-model="adulto.apellidos" />
                                </div>
                                <div class="col-8" v-if="service_array[index_aux].desglose.internacional == 1">
                                    <div class="row">
                                        <div class="col-3">
                                            <div class="row g-0">
                                                <div class="col">
                                                    <label class="form-label">Día</label>
                                                    <input type="text" class="form-control" placeholder="DD" maxlength="2" v-model="adulto.fecha_nacimiento.dia">
                                                </div>
                                                <div class="col">
                                                    <label class="form-label">Mes</label>
                                                    <input type="text" class="form-control" placeholder="MM" maxlength="2" v-model="adulto.fecha_nacimiento.mes">
                                                </div>
                                                <div class="col-5">
                                                    <label class="form-label">Año</label>
                                                    <input type="text" class="form-control year-input" placeholder="YYYY" maxlength="4" v-model="adulto.fecha_nacimiento.año">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col">
                                            <label class="form-label">No. Pasaporte</label>
                                            <input type="text" class="form-control" v-model="adulto.no_pasaporte" />
                                        </div>
                                        <div class="col">
                                            <label class="form-label">No. Visa</label>
                                            <input type="text" class="form-control" v-model="adulto.no_visa" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <h4 class="text-center mt-1" v-if="service_array[index_aux].desglose.menores > 0">Menores</h4>

                            <div class="row g-1" v-for="(menor, m) in service_array[index_aux].desglose.pasajeros.menores">
                                <div class="col">
                                    <label class="form-label">Nombre(s)</label>
                                    <input type="text" class="form-control" v-model="menor.nombre" />
                                </div>
                                <div class="col">
                                    <label class="form-label">Apellidos</label>
                                    <input type="text" class="form-control" v-model="menor.apellidos" />
                                </div>
                                <div class="col">
                                    <div class="row g-0">
                                        <div class="col">
                                            <label class="form-label">Día</label>
                                            <input type="text" class="form-control" placeholder="DD" maxlength="2" v-model="menor.fecha_nacimiento.dia">
                                        </div>
                                        <div class="col">
                                            <label class="form-label">Mes</label>
                                            <input type="text" class="form-control" placeholder="MM" maxlength="2" v-model="menor.fecha_nacimiento.mes">
                                        </div>
                                        <div class="col">
                                            <label class="form-label">Año</label>
                                            <input type="text" class="form-control year-input" placeholder="YYYY" maxlength="4" v-model="menor.fecha_nacimiento.año" @change="setAgeChild(m)">
                                        </div>
		                                <div class="col">
		                                    <label class="form-label">Edad</label>
		                                    <input type="text" class="form-control" readonly v-model="menor.edad" />
		                                </div>
                                    </div>
                                </div>

                                <div class="col-5" v-if="service_array[index_aux].desglose.internacional">
                                    <div class="row">
                                        <div class="col">
                                            <label class="form-label">No. Pasaporte</label>
                                            <input type="text" class="form-control" v-model="menor.no_pasaporte" />
                                        </div>
                                        <div class="col">
                                            <label class="form-label">No. Visa</label>
                                            <input type="text" class="form-control" v-model="menor.no_visa" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
                        <section :data-target="service_array[index_aux].id_tipo_servicio" v-else-if="service_array[index_aux].id_tipo_servicio != 3 && service_array[index_aux].id_tipo_servicio != 4">
                        </section>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Aceptar</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Pax List -->

</section>

<div class="modal fade" id="paymentPromiseModal" tabindex="-1" aria-labelledby="promisePaymentLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="promisePaymentLabel">Promesa de pago</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row g-1">
                    <div class="col">
                        <label class="form-label">Tipo plazo</label>
                        <select class="form-control" v-model="period">
                            <option value="" selected hidden>-- Seleccione --</option>
                            <option value="weekly">Semanal</option>
                            <option value="biweekly">Quincenal</option>
                            <option value="monthly">Mensual</option>
                        </select>
                    </div>
                    <div class="col">
                        <label class="form-label">Monto</label>
                        <input type="text" class="form-control" v-model="amount">
                    </div>
                    <div class="col">
                        <label class="form-label">Fecha inicio</label>
                        <input type="date" class="form-control" v-model="start_date">
                        <!-- <button class="btn btn-primary w-100" style="margin-top: 1.7rem;" @click="calculatePaymentPromise()">Generar</button> -->
                    </div>
                    <div class="col-6">
                        <button class="btn btn-primary w-100" @click="calculatePaymentPromise()">Generar</button>
                    </div>
                    <div class="col-6">
                        <button class="btn btn-primary w-100" @click="deletePaymentsPromises()">Eliminar</button>
                    </div>
                </div>
                <!-- <div class="form-check mt-50">
                    <input class="form-check-input" type="checkbox" v-model="first_payment" id="firstPaymentLabel">
                    <label class="form-check-label" for="firstPaymentLabel">
                        Primer pago el día de la venta
                    </label>
                </div> -->
                <table class="table table-sm table-bordered table-striped mt-1" v-if="payments_array.length > 0">
                    <thead class="text-center">
                        <tr>
                            <th>#</th>
                            <th>Fecha</th>
                            <th>Monto</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="text-center" v-for="(payment, index) in payments_array">
                            <td v-text="(index + 1)"></td>
                            <td v-text="parseDate(payment.fecha)"></td>
                            <td v-text="parseAsPrice(payment.monto)"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-primary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal" @click="savePaymentsPromises()">Guardar</button>
            </div>
        </div>
    </div>
</div>

<!-- Add New Customer Sidebar -->
<?php $this->renderPartial("/clientes/_form"); ?>
<!-- /Add New Customer Sidebar -->

<?php
Yii::app()->clientScript->registerScript('id0', '
        var baseUrl = "' . Yii::app()->baseUrl . '";
        var action = "' . $action . '";
        var info_agencia = ' . CJSON::encode($_SESSION['Agencia']) . ';
        var id_usuario = ' . Yii::app()->user->id . ';
        var view = "ventas";
    ', CClientScript::POS_HEAD);

if ($action == "update") {
    Yii::app()->clientScript->registerScript('id_venta', '
            var id_venta = ' . $_GET["id"] . ';
        ', CClientScript::POS_HEAD);
}

$baseUrl = "https://erp.2businesstravel.com/admin/template/vuexy";
Yii::app()->clientScript->registerCssFile($baseUrl . '/vendors/css/pickers/flatpickr/flatpickr.min.css');
/* Yii::app()->clientScript->registerCssFile($baseUrl .'/vendors/css/forms/select/select2.min.css'); */
Yii::app()->clientScript->registerCssFile($baseUrl . '/css/plugins/forms/pickers/form-flat-pickr.min.css');
Yii::app()->clientScript->registerCssFile($baseUrl . '/css/pages/app-invoice.min.css');

Yii::app()->clientScript->registerScriptFile($baseUrl . '/vendors/js/forms/repeater/jquery.repeater.min.js', CClientScript::POS_END);
/* Yii::app()->clientScript->registerScriptFile($baseUrl.'/vendors/js/forms/select/select2.full.min.js', CClientScript::POS_END); */
Yii::app()->clientScript->registerScriptFile($baseUrl . '/vendors/js/pickers/flatpickr/flatpickr.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://npmcdn.com/flatpickr@4.6.9/dist/l10n/es.js', CClientScript::POS_END);
//Yii::app()->clientScript->registerScriptFile($baseUrl .'/js/scripts/pages/app-invoice.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js', CClientScript::POS_END);

Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/vue/clientes-cu.js?v=' . time(), CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/vue/proveedor-create.js?v=' . time(), CClientScript::POS_END);
if ($action == "update") {
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/vue/promesa-pago.js?v=' . time(), CClientScript::POS_END);
}
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/vue/ventas-cu.js?v=' . time(), CClientScript::POS_END);
?>