<?php
	$this->breadcrumbs = array(
		'Ventases' => array('index'),
		$model->id_venta,
	);
?>
<style type="text/css">
	.info {
		background-color: paleturquoise;
		padding: 5px;
		margin: 10px 0px;
		color: #333;
		font-size: 15px;
	}
</style>

<?php if (Yii::app()->user->hasFlash('success')) : ?>
	<div class="info">
		<?php echo Yii::app()->user->getFlash('success'); ?>
	</div>
<?php endif; ?>
<hr />
<?php
	$this->beginWidget('zii.widgets.CPortlet', array(
		'htmlOptions' => array(
			'class' => ''
		)
	));

	$this->endWidget();
?>

<div class="">
	<a href="<?= Yii::app()->createUrl('ventas/misventas'/*,array('id'=>$_SESSION['Agencia']->id_agencia)*/) ?>" class="btn mb-1 btn-warning btn-rounded my-1"><span class="btn-icon-left"><i class="icono fas fa-arrow-left"></i> </span>Regresar</a>

	<!-- Default Breadcrumb Starts -->
	<section id="default-breadcrumb">
		<div class="row">
			<div class="col-sm-12">
				<div class="card">
					<div class="card-header">
						<h4 class="card-title">Detalles de la venta #<?php echo $model->folio; ?></h4>
					</div>
					<div class="card-body">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb">
								<li class="breadcrumb-item"><a href="/admin">Inicio</a></li>
								<li class="breadcrumb-item"><a href="<?= Yii::app()->createUrl('ventas/misventas'/*,array('id'=>$_SESSION['Agencia']->id_agencia)*/) ?>">Lista de ventas</a></li>
								<li class="breadcrumb-item active" aria-current="page">Detalles de la venta</li>
							</ol>
						</nav>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Default Breadcrumb Ends -->
</div>

<section id="basic-tabs-components">
	<div class="row match-height">
		<!-- Basic Tabs starts -->
		<div class="col-xl-12">
			<div class="card">
				<div class="card-body">
					<ul class="nav nav-tabs" role="tablist">
						<li class="nav-item">
							<a class="nav-link active" id="venta-tab" data-bs-toggle="tab" href="#venta" aria-controls="venta" role="tab" aria-selected="true">Datos de la venta</a>
						</li>
						<li class="nav-item">
							<a class="nav-link" id="cliente-tab" data-bs-toggle="tab" href="#cliente" aria-controls="cliente" role="tab" aria-selected="false">Detalles del Cliente</a>
						</li>
						<li class="nav-item">
							<a class="nav-link" id="servicio-tab" data-bs-toggle="tab" href="#servicio" aria-controls="servicio" role="tab" aria-selected="false">Detalles del Servicio</a>
						</li>
					</ul>

					<div class="tab-content">
						<div class="tab-pane active" id="venta" aria-labelledby="venta-tab" role="tabpanel">
							<div class='printableArea'>
								<?php $this->widget('bootstrap.widgets.TbDetailView', array(
									'data' => $model,
									'attributes' => array(
										'folio',
										'fecha',
										'pasajero_titular',
										'descripcion',
										'observaciones',
										'moneda',
									),
								)); ?>
							</div>
						</div>

						<!-- tab clientes -->
						<div class="tab-pane" id="cliente" aria-labelledby="cliente-tab" role="tabpanel">
							<h3>Datos Generales de la venta 
								<?php
									echo $model->pasajero_titular;
									echo ' #' . $model->folio;
								?>
							</h3>

							<?php $this->renderPartial('_ventasClientes2', array(
								'id_venta' => $model->id_venta,
							)); ?>
						</div>

						<!-- fin tab clientes -->

						<!-- tab servicios -->
						<div class="tab-pane" id="servicio" aria-labelledby="servicio-tab" role="tabpanel">
							<h3>Servicios contratados por 
								<?php
									echo $model->pasajero_titular;
									echo ' #' . $model->folio;
								?>
							</h3>
							<a href="<?= Yii::app()->createUrl('ventas/updateServicio', array('id' => $model->id_venta)); ?>" class="btn btn-gradient-success">Agregar Nuevo Servicio</a>
							<?php $this->renderPartial('_ventaServicios', array(
								'id_venta' => $model->id_venta,
							));
							?>
						</div>
						<!-- fin tab servicios -->
					</div>
				</div>
			</div>
		</div>
		<!-- Basic Tabs ends -->
	</div>
</section>

<?php
	Yii::app()->clientScript->registerScript('headers2', ' 
    	var id_venta = "'. $_GET['id'] .'";
    ', CClientScript::POS_HEAD);

	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/js/ventas_agenciaVUE.js?v=' . time(), CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/js/clientes_ventasVUE.js?v=' . time(), CClientScript::POS_END);
?>
<style type="text/css" media="print">
	body {
		visibility: hidden;
	}

	.printableArea {
		visibility: visible;
	}
</style>