# AdminKit - Bootstrap 5 Admin Template ![Twitter URL](https://img.shields.io/twitter/url?style=social&url=https%3A%2F%2Fadminkit.io%2F&text=AdminKit%20-%20Open%20Source%20Bootstrap%205%20Admin%20Template)

A professional Admin & Dashboard template based on Bootstrap 5 that comes with hundreds of UI components, forms, tables, charts, pages and icons. AdminKit **does not require jQuery** and neither does one of the 3rd party libraries AdminKit is using.

<strong><a href="https://demo.adminkit.io/">View Demo</a> | <a href="https://github.com/adminkit/adminkit/archive/master.zip">Download ZIP</a> | <a href="https://adminkit.io/">Visit Website</a></strong>

[![AdminKit Demo](https://assets.adminkit.io/banners/adminkit-bootstrap-5-admin-template.png)](https://demo.adminkit.io/)

## Status

![Version](https://img.shields.io/github/package-json/v/adminkit/adminkit) ![License](https://img.shields.io/badge/license-MIT-blue.svg) [![GitHub issues open](https://img.shields.io/github/issues/adminkit/adminkit.svg)](https://github.com/adminkit/adminkit/issues?q=is%3Aopen+is%3Aissue) [![GitHub issues closed](https://img.shields.io/github/issues-closed-raw/adminkit/adminkit.svg)](https://github.com/adminkit/adminkit/issues?q=is%3Aissue+is%3Aclosed) [![GitHub Stars](https://img.shields.io/github/stars/adminkit/adminkit.svg?color=green)](https://github.com/adminkit/adminkit/stargazers) [![Live Demo](https://img.shields.io/badge/demo-online-green.svg)](https://demo.adminkit.io/)

## Features

* **Customizable:** You don't need to be an expert to customize AdminKit. Our code is very readable and well documented.
* **Fully Responsive:** With mobile, tablet & desktop support it doesn't matter what device you're using. AdminKit is responsive in all browsers.
* **Cross-Browser:** Our themes are working perfectly with Chrome, Firefox, Safari, Opera, and Edge. We're working hard to support them.
* **Clean Code:** We strictly follow Bootstrap's guidelines to make your integration as easy as possible. All code is handwritten.
* **No jQuery:** AdminKit, and all third-party libraries used in the admin template, do not require jQuery as a dependency.
* **Regular Updates:** From time to time you'll receive an update containing new components, improvements, and bugfixes.

## Quick start

### Download

* Clone this repo `git clone https://github.com/adminkit/adminkit.git`
* [Download from GitHub](https://github.com/adminkit/adminkit/archive/master.zip)
* [Download from Website](https://adminkit.io/#download)

### Build tools

The theme includes a custom Webpack file, which can be used to quickly recompile and minify theme assets while developing or for deployment. You'll need to install Node.js before using Webpack.

Once Node.js is installed, run npm install to install the rest of AdminKit's dependencies. All dependencies will be downloaded to the node_modules directory.

```sh
npm install
```

Now you're ready to modify the source files and generate new dist/ files. AdminKit uses webpack-dev-server to automatically detect file changes and start a local webserver at http://localhost:8080.

```sh
npm start
```

Compile, optimize, minify and uglify all source files to dist/ folder:

```sh
npm run build
```

## Browser Support

| <img src="https://assets.adminkit.io/browsers/edge.png" alt="Edge" width="24px" height="24px" /><br/>Edge | <img src="https://assets.adminkit.io/browsers/firefox.png" alt="Firefox" width="24px" height="24px" /><br/>Firefox | <img src="https://assets.adminkit.io/browsers/chrome.png" alt="Chrome" width="24px" height="24px" /><br/>Chrome | <img src="https://assets.adminkit.io/browsers/safari.png" alt="Safari" width="24px" height="24px" /><br/>Safari | <img src="https://assets.adminkit.io/browsers/safari-ios.png" alt="iOS Safari" width="24px" height="24px" /><br/>iOS Safari |
| --------- | --------- | --------- | --------- | --------- |
| last version| last 2 versions| last 2 versions| last 2 versions| last 2 versions

## Resources

* [Demo](https://demo.adminkit.io/)
* [Website](https://adminkit.io/)
* [Documentation](https://adminkit.io/docs)
* [Support](https://adminkit.io/support/)
* [Affiliate Program](https://adminkit.io/affiliate-program)

## Bugs and feature requests

Found a bug or have a feature request? [Please open a new issue](https://github.com/adminkit/adminkit/issues/new).

## Upgrade to Pro version

Get more power with AdminKit Pro, a premium variant of AdminKit, featuring hundreds of UI components, forms, tables, charts, pages, and icons. Check out [AdminKit Pro - Bootstrap 5 Admin Template](https://adminkit.io/pricing/).
