const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: false,
})

Vue.http.options.emulateJSON = true;
var appAccounts = new Vue({
    el: "#account-app",
    data: {
        baseUrl: baseUrl,

        account_model: {
            id_cuenta: 0,
            cuenta: "",
            descripcion: "",
            estatus: 1,
        },
        accounts_array: [],
        accounts_table: ""
    },
    mounted: function() {
        this.loadAccountTable();

        this.cu_modal = new bootstrap.Modal(document.getElementById('cu-accounts'), {
            keyboard: false
        })
    },
    methods: {
        saveAccount: function() {
            this.$http.post(this.baseUrl + '/cuentasAgencia/create/', this.account_model).then(function(response) {
                this.cu_modal.hide();
                if (response.body.id_cuenta) {
                    appAccounts.accounts_table.ajax.reload();
                    Toast.fire({
                        icon: 'success',
                        text: 'Se creó una nueva cuenta bancaria.'
                    });
                } else {
                    Toast.fire({
                        icon: 'error',
                        text: "Algo salió mal, recargue la página e intentelo de nuevo",
                    });
                }
            }, function(e) {
                console.log(e);
            });
        },
        updateAccount: function() {
            this.$http.post(this.baseUrl + '/cuentasAgencia/update/', this.account_model).then(function(response) {
                this.cu_modal.hide();
                if (response.body.id_cuenta) {
                    appAccounts.accounts_table.ajax.reload();
                    Toast.fire({
                        icon: 'success',
                        text: 'Se actualizó la información de la cuenta bancaria.'
                    });
                } else {
                    Toast.fire({
                        icon: 'error',
                        text: "Algo salió mal, recargue la página e intentelo de nuevo",
                    });
                }
            }, function(e) {
                console.log(e);
            });
        },
        deleteAccount: function(index) {
            this.account_model.id_cuenta = this.accounts_array[index].id_cuenta;
            Swal.fire({
                title: '¿Seguro?',
                text: "Cambiará el estatus de la cuenta bancaria en el sistema",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Confirmar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    this.$http.post(this.baseUrl + '/cuentasAgencia/delete/' + appAccounts.account_model.id_cuenta).then(function(response) {
                        appAccounts.clearModel();
                        var response_var = response.body;
                        if (response_var.success) {
                            appAccounts.accounts_table.ajax.reload();
                            Toast.fire({
                                icon: 'success',
                                text: 'Se cambió el estatus de la cuenta bancaria.'
                            });
                        } else {
                            Toast.fire({
                                icon: 'error',
                                text: "Algo salió mal, recargue la página e intentelo de nuevo",
                            });
                        }
                    }, function(e) {
                        console.log(e);
                        Swal.fire({
                            type: 'error',
                            title: "¡Ops!",
                            html: "Algo salió mal. <div class='mt-1>" + e.body.data.message + "</div>",
                        });
                    });
                }
            });
        },
        loadAccountTable: function() {
            var that = this;
            var url_rq = this.baseUrl + "/cuentasAgencia/getAgencyAccounts";
            this.accounts_table = $("#account-table").DataTable({
                scrollX: true,
                bDestroy: true,
                scrollCollapse: true,
                language: { url: "//cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                ajax: {
                    "url": url_rq,
                    "dataSrc": function(json) {
                        that.accounts_array = json;
                        return json;
                    }
                },
                columns: [{
                    data: "id_cuenta",
                    render: function(data, type, row, meta) {
                        return meta.row + 1;
                    }
                }, {
                    data: "descripcion",
                }, {
                    data: "cuenta",
                }, {
                    data: "estatus",
                    render: function(data, type, row, meta) {
                        return row.estatus == "1" ? "Activa" : "Desactivada";
                    }
                }, {
                    data: "id_cuenta",
                    sortable: false,
                    render: function(data, type, row, meta) {
                        return '<a href="javascript:;" class="edit-record" data-account="' + row.id_cuenta + '" data-bs-toggle="modal" data-bs-target="#cu-accounts">' + feather.icons.edit.toSvg() + '</a><a href="javascript:;" class="delete-record ms-50" data-account="' + row.id_cuenta + '">' + feather.icons.trash.toSvg() + '</a>';
                    }
                }]
            });
        },
        clearModel: function() {
            this.account_model = {
                id_cuenta: 0,
                cuenta: "",
                descripcion: "",
                estatus: 1,
            };
        }
    }
});

$("body").on("click", ".edit-record", function() {
    var account_id = $(this).attr("data-account");
    var accountFinded = appAccounts.accounts_array.findIndex(x => x.id_cuenta == account_id);
    appAccounts.account_model = appAccounts.accounts_array[accountFinded];
});

$("body").on("click", ".delete-record", function() {
    var account_id = $(this).attr("data-account");
    var accountFinded = appAccounts.accounts_array.findIndex(x => x.id_cuenta == account_id);
    appAccounts.deleteAccount(accountFinded);
});

var myModalEl = document.getElementById('cu-accounts')
myModalEl.addEventListener('hide.bs.modal', function(event) {
    appAccounts.clearModel();
})