const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: false,
});

Vue.http.options.emulateJSON = true;
var appToS = new Vue({
    el: '#tos-app',
    data: {
        baseUrl: baseUrl,

        info_tos: {
            terminos_general: "",
            terminos_grupos: "",
        },
        general_tos: "",
        groups_tos: "",
    },
    created: function() {
        this.loadToS();
    },
    methods: {
        loadToS: function() {
            this.$http.get(this.baseUrl + '/terminos/getToS/').then(function(response) {
                if(response.body.id) this.info_tos = response.body;

                /* if(response.body.id) {
                    $("#tos-general").val(this.info_tos.terminos_general);
                    $("#tos-groups").val(this.info_tos.terminos_grupos);
                }
                this.initCkEditors(); */
            }, function(e) {
                console.log(e);
            });
        },
        saveToS: function() {
            this.$http.post(this.baseUrl + '/terminos/saveToS/', this.info_tos).then(function(response) {
                if(response.body.id) {
                    Toast.fire({
                        icon: 'success',
                        text: 'Se actualizaron los términos y condiciones.'
                    });
                } else {
                    Toast.fire({
                        icon: 'error',
                        text: "Algo salió mal, recargue la página e intentelo de nuevo",
                    });
                }
            }, function(e) {
                console.log(e);
            });
        },
        initCkEditors: function() {
            ClassicEditor.create(document.querySelector('#tos-general'), {
                toolbar: {
                    removeItems: ['uploadImage', 'mediaEmbed'],
                }
            }).then(general_editor => {
                appToS.general_tos = general_editor;
            });

            ClassicEditor.create(document.querySelector('#tos-groups'), {
                toolbar: {
                    removeItems: ['uploadImage', 'mediaEmbed'],
                }
            }).then(groups_editor => {
                appToS.groups_tos = groups_editor;
            });
        }
    }
});