const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    timer: 3000,
    showConfirmButton: false,
    //timerProgressBar: true,
});

Vue.http.options.emulateJSON = true;
var appCaja = new Vue({
    el: "#app-caja",
    data: {
        baseUrl: baseUrl,
        loaded: false,

        dropify: "",
        check_sale_payments: false,
        services_array: [],
        sale_model: {},
        sales_array: [],
        accounts_array: [],
        payment_model: {
            id_pago: 0,
            descripcion: "",
            file_comprobante: "",
            fecha: moment().format("YYYY-MM-DD"),
            id_forma_pago: 1,
            id_cuenta: "",
            payment_details: []
        },
        id_payment: 0,
        ways_to_pay: [],
        ways_to_pay_account: [1, 11, 12],
        sale_payments_array: [],

        total_amount: 0,
        total_payments: 0,
        total_balance: 0,

        sale_amount: 0,
        sale_payments: 0,
        sale_balance: 0,

        email_model: "",
        loading_payment: true,

        code_filter: "",
        name_filter: "",
        service_filter: "",
        status_filter: 0
    },
    created: function() {
        this.loadAgencySales();
        this.loadAgencyAccounts();
        this.loadWaysToPay();
        this.loadTypeServices();

        this.formatter = new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD',
        });
    },
    methods: {
        savePayment: function() {
            this.email_model = this.sales_array[this.aux_index].idCliente.correo;
            $("#btn-send").prop("disabled", true);
            $("#btn-print").addClass("disabled");
            var form_data = this.getFormData();
            var url = this.baseUrl + (this.payment_model.id_pago > 0 ? "/caja/updatePayment" : "/caja/savePayment");
            this.$http.post(url, form_data).then(function(response) {
                if (response.body.id_pago) {
                    var that = this;
                    response.body.pagosDetalles.forEach(element => {
                        var index = that.sale_model.ventasServicioses.findIndex(x => x.id_ventaservicio == element.id_ventaservicio);
                        that.sale_model.ventasServicioses[index].pagosDetalles.push(element);
                        that.payment_model.payment_details[index].monto = "";
                    })
                    this.payment_code = response.body.id_pago;
                    this.calculateSaleAmounts();
                    this.getTotalBalance();

                    // this.payment_model.id_pago = response.body.id_pago;
                    this.id_payment = response.body.id_pago;
                    this.loading_payment = false;
                    $("#btn-send").prop("disabled", false);
                    $("#btn-print").removeClass("disabled");

                    Vue.nextTick(function() {
                        feather.replace();
                    });

                    Toast.fire({
                        icon: 'success',
                        title: 'Pago guardado con éxito'
                    });
                }
            }, function(ex) {
                console.log(ex);
            })
        },
        confirmSave: function() {
            var total_payment = 0;
            this.payment_model.payment_details.forEach(element => {
                if(parseFloat(element.monto)) total_payment += parseFloat(element.monto);
            });
            Swal.fire({
                title: '¿Seguro?',
                text: "¿Está seguro que desea capturar la cantidad de "+ this.formatter.format(total_payment) +" para este contrato?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Confirmar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    var myModal = new bootstrap.Modal(document.getElementById('invoice-modal'), {
                        keyboard: false
                    })
                    myModal.show();
                    appCaja.savePayment()
                }
            });
        },
        editPayment: function(payment) {
            var that = this;
            this.payment_model = payment;
            this.payment_model.payment_details = [];

            var id_venta = payment.pagosDetalles[0].idVentaservicio.id_venta;
            var index = this.sales_array.findIndex(x => x.id_venta == id_venta);
            
            this.sales_array[index].ventasServicioses.forEach(element => {
                var is = payment.pagosDetalles.findIndex(x => x.id_ventaservicio == element.id_ventaservicio);
                if(is >= 0) {
                    that.payment_model.payment_details.push({
                        id_pago_detalle: payment.pagosDetalles[is].id_pago_detalle,
                        monto: parseFloat(payment.pagosDetalles[is].monto)
                    });
                } else {
                    that.payment_model.payment_details.push({
                        id_ventaservicio: element.id_ventaservicio,
                        id_pago: payment.id_pago,
                        monto: ""
                    });
                }
            });

            this.dropify.destroy();
            this.stepper.previous();
            Vue.nextTick(() => {
                if(payment.comprobante != null) appCaja.dropify.settings.defaultFile = appCaja.baseUrl + "/images/comprobantes/pagos/" + payment.comprobante;
                appCaja.dropify.init();
            })
        },
        deletePayment: function(payment_code) {
            var index = this.sale_payments_array.findIndex(x => x.id_pago == payment_code);
            this.$http.get(this.baseUrl + "/caja/deletePayment/" + payment_code).then(function(response) {
                if(response.body.success) {
                    this.sale_payments_array.splice(index, 1);
                    Toast.fire({
                        icon: 'success',
                        title: 'Pagos eliminados'
                    })
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: '¡Ops!',
                        text: 'Algo salió mal',
                    })
                }
            }, function() {
                console.log('Error')
            })
        },
        showDeleteAlert: function(payment) {
            var total = 0;
            payment.pagosDetalles.forEach(detalle => {
                total += detalle.monto;
            });
            Swal.fire({
                title: '¿Seguro?',
                text: "¿Está seguro que desea eliminar este pago por un monto total de " + this.formatter.format(total) + "?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Confirmar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    appCaja.deletePayment(payment.id_pago);
                }
            });
        },
        sendInvoice: function() {
            this.$http.post(this.baseUrl + "/caja/sendInvoice?id_pago=" + this.payment_code + "&email=" + this.email_model).then(function(response) {
                if (response.body.success) {
                    Toast.fire({
                        icon: 'success',
                        title: 'Recibo enviado correctamente'
                    })
                }
            }, function(ex) {
                console.log(ex);
            })
        },
        loadAgencyAccounts: function() {
            this.$http.get(this.baseUrl + "/caja/getAgencyAccounts").then(function(response) {
                this.accounts_array = response.body;
                if (this.accounts_array.length == 1) {
                    this.payment_model.id_cuenta = response.body[0].id_cuenta;
                }
            }, function() {
                console.log('Error')
            })
        },
        loadWaysToPay: function() {
            this.$http.get(this.baseUrl + "/caja/getWaysToPay").then(function(response) {
                this.ways_to_pay = response.body;
            }, function() {
                console.log('Error')
            })
        },
        loadTypeServices: function() {
            this.$http.get(this.baseUrl + "/tipoServicios/serviciosapi").then(function(response) {
                this.services_array = response.body;
            }, function() {
                console.log('Error')
            })
        },
        loadAgencySales: function() {
            this.$http.get(this.baseUrl + "/caja/getAgencySales").then(function(response) {
                this.sales_array = response.body;
                this.getTotalBalance();
                Vue.nextTick(function() {
                    appCaja.initStepper();
                })
            }, function() {
                console.log('Error')
            })
        },
        getTotalSale: function(service, i) {
            var total = parseFloat(service.tarifa_publica);
            if(!isNaN(parseFloat(service.fee))) {
                total += parseFloat(service.fee);
            }
            appCaja.sales_array[i].total_venta = total;
            return this.formatter.format(total);
        },
        getTotalBalance: function() {
            var total = 0;
            var payments = 0;
            this.sales_array.forEach(sale => {
                sale.ventasServicioses.forEach(element => {
                    total += parseFloat(element.tarifa_publica);
                    if (element.fee) {
                        total += parseFloat(element.fee);
                    }

                    element.pagosDetalles.forEach(payment => {
                        payments += parseFloat(payment.monto);
                    });
                });
            });

            this.total_amount = this.formatter.format(total);
            this.total_payments = this.formatter.format(payments);
            this.total_balance = this.formatter.format((total - payments));
        },
        getSaleBalance: function(sale) {
            var cost = 0;
            var payments = 0;
            sale.ventasServicioses.forEach(element => {
                cost += parseFloat(element.tarifa_publica);
                if (element.fee) {
                    cost += parseFloat(element.fee);
                }

                element.pagosDetalles.forEach(payment => {
                    payments += parseFloat(payment.monto);
                });
            });
            if(parseFloat(sale.cargo_servicios)) cost += parseFloat(sale.cargo_servicios);

            return this.formatter.format((cost - payments));
        },
        getServiceBalance: function(service, index) {
            var payments = 0;
            service.pagosDetalles.forEach(element => {
                payments += parseFloat(element.monto);
            });
            var cost = parseFloat(service.tarifa_publica);
            if (parseFloat(service.fee)) cost += parseFloat(service.fee);
            if(this.sale_model.ventasServicioses.length == 1 || index == 0) {
                if(parseFloat(this.sale_model.cargo_servicios)) cost += parseFloat(this.sale_model.cargo_servicios);
            }
            var balance = cost - payments;
            return this.formatter.format(balance);
        },
        getServicesImages: function(sale, index) {
            var temp = "", html = "";
            sale.ventasServicioses.forEach((element, i) => {
                var image = "";
                switch(parseInt(element.id_tipo_servicio)) {
                    case 1:
                        image = "hospedaje-icon";
                        break;

                    case 2:
                        image = "traslado-icon";
                        break;

                    case 3:
                        image = "grupo-icon";
                        break;

                    case 4:
                        image = "boda-icon";
                        break;

                    case 5:
                        image = "tour-icon";
                        break;

                    case 6:
                        image = "vuelos-icon";
                        break;

                    case 7:
                        image = "renta-icon";
                        break;

                    case 8:
                        image = "actividades-icon";
                        break;

                    case 9:
                        image = "transporte-icon";
                        break;
                }
                if(sale.ventasServicioses.length > 1) {
                    if(i <=3) {
                        switch(i) {
                                case 0: 
                                    temp = "<div style='width:{width}; height: {height}; background-size: cover; background-image: url("+ this.baseUrl +"/images/icons/{index}.png); position: absolute; top: 0; left: 0;'></div>";
                                    break;
        
                                case 1:
                                    temp = "<div style='width:{width}; height: {height}; background-size: cover; background-image: url("+ this.baseUrl +"/images/icons/{index}.png); position: absolute; bottom: 0; right: 0;'></div>"
                                    break;
        
                                case 2:
                                    temp = "<div style='width:{width}; height: {height}; background-size: cover; background-image: url("+ this.baseUrl +"/images/icons/{index}.png); position: absolute; top: 0; right: 0;'></div>"
                                    break;
        
                                case 3:
                                    temp = "<div style='width:{width}; height: {height}; background-size: cover; background-image: url("+ this.baseUrl +"/images/icons/{index}.png); position: absolute; bottom: 0; left: 0;'></div>"
                                    break;
                            }
                            html += temp.replace(/\{height\}/g, "90px").replace(/\{width\}/g, "93px").replace("{index}", image);
                    }
                } else {
                    temp = "<div style='width:{width}; height: {height}; background-size: cover; background-image: url("+ this.baseUrl +"/images/icons/{index}.png); position: unset!important; bottom: 0; right: 0;'></div>"
                    html += temp.replace(/\{height\}/g, "100%").replace(/\{width\}/g, "100%").replace("{index}", image);
                }
            });
            return html;
        },
        getSalePayments: function(sale_code) {
            this.$http.get(this.baseUrl + "/caja/getSalePayments/" + sale_code).then(function(response) {
                this.sale_payments_array = response.body;
                Vue.nextTick(function() {
                    feather.replace();
                })
            }, function() {
                console.log('Error')
            })
        },
        setSaleModels: function(sale_code) {
            this.payment_model.payment_details = [];

            this.getSalePayments(sale_code);
            this.aux_index = this.sales_array.findIndex(x => x.id_venta == sale_code);
            this.clearPaymentModel();

            var that = this;
            this.sales_array[this.aux_index].ventasServicioses.forEach(element => {
                that.payment_model.payment_details.push({
                    id_ventaservicio: element.id_ventaservicio,
                    monto: "",
                });
            });
            this.sale_model = this.sales_array[this.aux_index];

            this.calculateSaleAmounts();
            this.nextStep();
        },
        setFileToModel: function() {
            this.payment_model.file_comprobante = event.target.files[0];
        },
        calculateSalePayments: function(payments) {
            var total = 0;
            payments.forEach(element => {
                total += parseFloat(element.monto);
            });
            return this.formatter.format(total);
        },
        calculateSaleAmounts: function() {
            this.check_sale_payments = false;
            var sale_amount = 0;
            var sale_payments = 0;
            this.sale_model.ventasServicioses.forEach(element => {
                sale_amount += parseFloat(element.tarifa_publica);
                if (parseFloat(element.fee)) {
                    sale_amount += parseFloat(element.fee);
                }

                element.pagosDetalles.forEach(payment => {
                    sale_payments += parseFloat(payment.monto);
                    appCaja.check_sale_payments = true;
                });
            });
            if(parseFloat(this.sale_model.cargo_servicios)) sale_amount += parseFloat(this.sale_model.cargo_servicios);
            this.sale_amount = this.formatter.format(sale_amount);
            this.sale_payments = this.formatter.format(sale_payments);

            var sale_balance = sale_amount - sale_payments;
            this.sale_balance = this.formatter.format(sale_balance);
        },
        getPaymentDate: function(payment) {
            var aux_date = moment(payment.fecha).format("DD/MM/YYYY");
            var aux_log = moment(payment.log).format("DD/MM/YYYY");
            if(aux_date == aux_log) {
                return aux_log;
            }
            return aux_date;
        },
        clearPaymentModel: function() {
            this.payment_model.id_pago = 0;
            this.payment_model.descripcion = "";
            this.payment_model.id_forma_pago = 1;
            this.payment_model.id_cuenta = "";
        },
        getFormData: function() {
            var form_data = new FormData();
            var that = this;
            for (var key in this.payment_model) {
                if(key != "idFormaPago" && key != "pagosDetalles") {
                    form_data.append(key, that.payment_model[key]);
                    if(key == "payment_details") {
                        that.payment_model.payment_details.forEach(element => {
                            form_data.append("payment_details[]", JSON.stringify(element));
                        });
                    }
                }
            }

            return form_data;
        },
        initStepper: function() {
            var e = document.querySelector(".checkout-tab-steps");
            this.stepper = new Stepper(e, {
                linear: !1
            });
            /* $(e).find(".btn-next").each((function() {
                $(this).on("click", (function(s) {
                    appCaja.stepper.next()
                }))
            })) */
        },
        initDropify: function() {
            Vue.nextTick(() => {
                if(appCaja.dropify == "") {
                    var dropify = $("#dropify").dropify();
                    appCaja.dropify = dropify.data("dropify");
                } else {
                    $(".dropify-clear").trigger("click");
                    /* appCaja.dropify.destroy();
                    appCaja.dropify.init(); */
                }
            })
        },
        nextStep: function() {
            this.stepper.next();
            this.initDropify();
        },
        wayToPayAccount: function(way_to_pay) {
            var aux = parseInt(way_to_pay);
            return this.ways_to_pay_account.includes(aux);
        },
        formatPrice: function(price) {
            var aux = parseFloat(price);
            return aux ? this.formatter.format(aux) + " MXN" : "0.00 MXN";
        },
        formatDate: function(date_string) {
            return moment(date_string).format("DD/MM/YYYY");
        }
    },
    computed: {
        filteredSales() {
            var that = this;
            return this.sales_array.filter(sale => {
                return sale.pasajero_titular.toLowerCase().includes(this.name_filter);
            }).filter(sale => {
                if (this.service_filter != "") {
                    return sale.ventasServicioses.some(service => {
                        return service.id_tipo_servicio == that.service_filter;
                    });
                }
                return sale;
            }).filter(code => {
                return code.folio.toLowerCase().includes(this.code_filter.toLowerCase());
            }).filter(status => {
                if(this.status_filter) {
                    return status.estatus == "pagado";
                } else {
                    return status.estatus == "venta";
                }
            })
        }
    }
});