var appCustomerCrud = new Vue({
    el: "#cu-customers",
    data: {
        baseUrl: baseUrl,
        view: view,

        customer_model: {
            id_cliente: 0,
            nombre: "",
            telefono: "",
            telefono_secundario: "",
            correo: "",
            direccion: "",
            id_agencia: id_agencia,
        },
    },
    methods: {
        createCustomer: function() {
            this.$http.post(this.baseUrl + "/clientes/createApi/", this.customer_model).then(function(response) {
                if (response.body.id) {
                    if (this.view == "ventas" || this.view == "modal") {
                        if(this.view == "ventas") appSales.customers_array.push(response.body);
                        if(this.view == "modal") console.log("test");

                        var newOption = new Option(response.body.text, response.body.id, true, true);
                        $('.invoiceto').append(newOption).trigger('change');
                    } else {
                        appCustomer.customers_table.ajax.reload();
                    }

                    var myModalEl = document.getElementById('cu-customers');
                    var modal = bootstrap.Modal.getInstance(myModalEl);
                    modal.toggle();

                    Toast.fire({
                        icon: 'success',
                        title: 'Cliente registrado'
                    })
                    this.clearCustomerModel();
                } else {
                    var error_table = "<table class='table table-bordered text-white'>"
                    Object.values(response.body).forEach(element => {
                        error_table += "<tr><td>" + element + "</td></tr>";
                    });
                    error_table += "</table>";
                    Swal.fire({
                        title: '¡Ops!',
                        icon: 'error',
                        html: "<p align='center'>Algo salió mal</p>" + error_table,
                    });
                }
            }, function() {
                console.log('Error')
            });
        },
        updateCustomer: function() {
            this.$http.post(this.baseUrl + "/clientes/updateApi/", this.customer_model).then(function(response) {
                if (response.body.id_cliente) {
                    appCustomer.customers_table.ajax.reload();
                    Toast.fire({
                        icon: 'success',
                        title: 'Cliente actualizado'
                    })
                    this.clearCustomerModel();
                } else {
                    var error_table = "<table class='table table-bordered text-white'>"
                    Object.values(response.body).forEach(element => {
                        error_table += "<tr><td>" + element + "</td></tr>";
                    });
                    error_table += "</table>";
                    Swal.fire({
                        title: '¡Ops!',
                        icon: 'error',
                        html: "<p align='center'>Algo salió mal</p>" + error_table,
                    });
                }
            }, function() {
                console.log('Error')
            });
        },
        clearCustomerModel: function() {
            this.customer_model = {
                id_cliente: 0,
                nombre: "",
                telefono: "",
                correo: "",
                id_agencia: id_agencia,
            }
        },
    }
})