const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    timer: 3000,
    showConfirmButton: false,
    //timerProgressBar: true,
});

Vue.http.options.emulateJSON = true;
var appCustomer = new Vue({
    el: "#clients-app",
    data: {
        baseUrl: baseUrl,
        customers_table: "",
        customers_array: [],

        billing_model: {
            id_cliente_info_fiscal: 0,
            rfc: "",
            razon_social: "",
            calle: "",
            no_exterior: "",
            no_interior: "",
            cp: "",
            colonia: "",
            municipio: "",
            ciudad: "",
            estado: "",
            pais: "",
            correo: "",
            cfdi: "",
            metodo_pago: "",
            forma_pago: "",
        },
        user_model: {
            code: 0,
            firstname: "",
            lastname: "",
            user: "",
            pwd: ""
        }
    },
    mounted: function () {
        this.loadTable();
    },
    methods: {
        addBillingInfo: function () {
            this.$http.post(this.baseUrl + "/clientes/setBillingData/", this.billing_model).then(function (response) {
                if (response.body.id_cliente_info_fiscal) {
                    Toast.fire({
                        icon: 'success',
                        title: 'Datos fiscales guardados'
                    })

                    var myModalEl = document.getElementById('billing-info');
                    var modal = bootstrap.Modal.getInstance(myModalEl);
                    modal.toggle();
                    this.clearBillingModel();
                } else {
                    var error_table = "<table class='table table-bordered text-white'>"
                    Object.values(response.body).forEach(element => {
                        error_table += "<tr><td>" + element + "</td></tr>";
                    });
                    error_table += "</table>";
                    Swal.fire({
                        title: '¡Ops!',
                        icon: 'error',
                        html: "<p align='center'>Algo salió mal</p>" + error_table,
                    });
                }
            }, function () {
                console.log('Error')
            });
        },
        loadTable: function () {
            var url_rq = this.baseUrl + "/clientes/clientesapi";
            this.customers_table = $("#clients-table").DataTable({
                language: { url: "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                responsive: true,
                // scrollY: 400,
                scrollX: true,
                ajax: {
                    "url": url_rq,
                    "dataSrc": function (json) {
                        appCustomer.customers_array = json;
                        return json;
                    }
                },
                dom: 'Bfrtip',
                bDestroy: true,
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print',
                ],
                columns: [{
                    title: '#',
                    data: 'id_cliente',
                    render: function (data, type, row, meta) {
                        return meta.row + 1;
                    }
                },
                {
                    title: 'Nombre',
                    data: 'nombre'
                },
                {
                    title: 'Teléfono',
                    data: 'telefono',
                    render: function (data, type, row, meta) {
                        if (row.telefono == null) return "Sin registro";
                        var phone = row.telefono.replace(/[^\w\s]/gi, '');
                        phone = phone.replace(/\s/g, '');
                        return "<a href='https://web.whatsapp.com/send?phone=52" + phone + "' target='_blank'>" + row.telefono + "</a>";
                    }
                },
                {
                    title: 'Tel Secundario',
                    data: 'telefono_secundario',
                    render: function (data, type, row, meta) {
                        if (data == null) return "Sin registro";
                        return data;
                    }
                },
                {
                    title: 'Email',
                    data: 'correo',
                    render: function (data, type, row, meta) {
                        if (data == null) return "Sin registro";
                        return data;
                    }
                },
                {
                    title: 'Dirección',
                    data: 'direccion',
                    render: function (data, type, row, meta) {
                        if (data == null) return "Sin registro";
                        return data;
                    }
                },
                {
                    title: '',
                    data: null,
                    orderable: false,
                    render: function (data) {
                        var user_icon = "";
                        if (!data.usuarioCliente.id_user) {
                            user_icon = '<a href="javascript:;" data-bs-toggle="modal" data-bs-target="#client-user" class="user-record ms-25" onclick="appCustomer.getSeparatedName(' + data.id_cliente + ')">' + feather.icons["user-plus"].toSvg() + '</a>';
                        } else {
                            user_icon = '<a href="' + appCustomer.baseUrl + '/usuariosAgencias/update/' + data.usuarioCliente.id_user + '" class="user-record ms-25">' + feather.icons.user.toSvg() + '</a>';
                        }
                        return '<a href="' + appCustomer.baseUrl + '/clientes/' + data.id_cliente + '" class="edit-rate-record">' + feather.icons.eye.toSvg() + '</a><a href="javascript:;" data-bs-toggle="modal" data-bs-target="#cu-customers" data-customer=' + data.id_cliente + ' class="edit-record ms-25">' + feather.icons.edit.toSvg() + '</a><a href="javascript:;" data-bs-toggle="modal" data-bs-target="#billing-info" data-customer=' + data.id_cliente + ' class="billing-data ms-25">' + feather.icons["file-text"].toSvg() + '</a><a onclick="appCustomer.deleteClient(' + data.id_cliente + ')" href="javascript:void(0)" class="delete-rate-record ms-25">' + feather.icons.trash.toSvg() + '</a>' + user_icon;
                    }
                },
                ]
            });
        },
        deleteClient: function (venta) {
            var that = this;
            Swal.fire({
                title: '¿Estas seguro que desea eliminarlo?',
                text: "Se eliminara permanentemente",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    that.$http.get(that.baseUrl + "/clientes/delete/" + venta).then(function (response) {
                        console.log(response.data.estatus);
                        if (response.data.estatus == 200) {
                            that.loadTable();
                            Toast.fire({
                                icon: 'success',
                                title: 'El usuario se ha eliminado'
                            });
                            // toastr.success("Se ha eliminado correctamente", "Servicio Eliminado", {
                            //     timeOut: 2000,
                            //     closeButton: !0,
                            //     debug: !1,
                            //     newestOnTop: !0,
                            //     progressBar: !0,
                            //     positionClass: "toast-bottom-right",
                            //     preventDuplicates: !0,
                            //     onclick: null,
                            //     showDuration: "300",
                            //     hideDuration: "100",
                            //     extendedTimeOut: "100",
                            //     showEasing: "swing",
                            //     hideEasing: "linear",
                            //     showMethod: "fadeIn",
                            //     hideMethod: "fadeOut",
                            //     tapToDismiss: !1
                            // })
                        } else {
                            Swal.fire({
                                title: 'Error',
                                timer: 2000,
                                icon: 'error',
                                text: response.data.mensaje,
                            })
                        }
                    }, function (error) {
                        Swal.fire({
                            title: 'Error',
                            timer: 2000,
                            icon: 'error',
                            text: 'Ha ocurrido un error',
                        },)
                    });
                }
            })
        },
        createClientUser: function () {
            if (this.user_model.user == '' || this.user_model.pwd == '') {
                Toast.fire({
                    icon: 'warning',
                    title: 'Complete los campos de usuario y contraseña.'
                });
            } else {
                this.$http.post(this.baseUrl + "/clientes/createClientUser/", this.user_model).then(function (response) {
                    if (response.body.success == 500) {
                        Swal.fire({
                            title: '¡Ops!',
                            icon: 'error',
                            html: response.body.error,
                        });
                    } else {
                        if (response.body.success) {
                            this.customers_table.ajax.reload();
                            Toast.fire({
                                icon: 'success',
                                title: 'Usuario del cliente creado'
                            });
                            var myModalEl = document.getElementById('client-user');
                            var modal = bootstrap.Modal.getInstance(myModalEl);
                            modal.toggle();
                        } else {
                            var error_table = "<table class='table table-bordered text-white'>";
                            Object.values(response.body[response.body.error]).forEach((element) => {
                                error_table += "<tr><td>" + element + "</td></tr>";
                            });
                            error_table += "</table>";
                            Swal.fire({
                                title: '¡Ops!',
                                icon: 'error',
                                html: "<p align='center'>Algo salió mal</p>" + error_table,
                            });
                        }
                    }
                }, function () {
                    console.log('Error')
                });
            }
        },
        getSeparatedName: function (customer_code) {
            var index = this.customers_array.findIndex(x => x.id_cliente == customer_code);
            this.user_model.code = customer_code;
            var full_name = this.customers_array[index].nombre;
            this.user_model.firstname = this.getGuestName(full_name, "firstname");
            this.user_model.lastname = this.getGuestName(full_name, "lastname");
        },
        getGuestName: function (name, type) {
            var name_array = name.split(" ");
            var result = "";
            if (type == "firstname") {
                if (name_array.length == 2) {
                    result = name_array[0];
                } else if (name_array.length >= 3) {
                    var aux = 2;
                    for (let i = 0; i < name_array.length - aux; i++) {
                        if (name_array[i] != "") result += name_array[i] + " ";
                    }
                    result = result.slice(0, -1);
                }

            } else {
                if (name_array.length == 2) {
                    result = name_array[1];
                } else if (name_array.length >= 3) {
                    var aux = 2;
                    for (let i = aux; i < name_array.length; i++) {
                        if (name_array[i] != "") result += name_array[i] + " ";
                    }
                    result = result.slice(0, -1);
                }
            }
            return result;
        },
        clearBillingModel: function () {
            this.billing_model = {
                id_cliente_info_fiscal: 0,
                rfc: "",
                razon_social: "",
                calle: "",
                no_exterior: "",
                no_interior: "",
                cp: "",
                colonia: "",
                municipio: "",
                ciudad: "",
                estado: "",
                pais: "",
                correo: "",
                cfdi: "",
                metodo_pago: "",
                forma_pago: "",
            };
        },
        clearCustomerModel: function () {
            appCustomerCrud.clearCustomerModel();
        }
    }
});

$("body").on("click", ".edit-record", function () {
    var customer_code = $(this).attr("data-customer");
    var customerFinded = appCustomer.customers_array.findIndex(x => x.id_cliente == customer_code);
    appCustomerCrud.customer_model = appCustomer.customers_array[customerFinded];
});

$("body").on("click", ".billing-data", function () {
    var customer_code = $(this).attr("data-customer");
    var customerFinded = appCustomer.customers_array.findIndex(x => x.id_cliente == customer_code);
    if (appCustomer.customers_array[customerFinded].clienteInfoFiscal.id_cliente_info_fiscal) {
        appCustomer.billing_model = appCustomer.customers_array[customerFinded].clienteInfoFiscal;
    }
});

var billing_modal = document.getElementById('billing-info')
billing_modal.addEventListener('hidden.bs.modal', function (event) {
    appCustomer.clearBillingModel();
})