const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    timer: 3000,
    showConfirmButton: false,
    //timerProgressBar: true,
});

Vue.http.options.emulateJSON = true;
var appContracts = new Vue({
    el: "#app-contracts",
    data: {
        baseUrl: baseUrl,
        action: action,
        id_usuario: id_usuario,
        id_agencia: id_agencia,

        request_model: {},
        contract_model: {
            id_cotizacion: 0,
            observaciones: "",
            fecha_inicial: "",
            fecha_final: "",
            id_usuario: 0,
            id_agencia: 0,
            id_cliente: 0,
            id_solicitud: null,
            log: "",
        },
        price_array: [],
        customers_array: [],
        customer_selected: {},

        providers_array: [],
        service_types_array: [],

        price_flatpickr: "",
        flatpickr_array: [],
        flatpickr_arrive: [],
        flatpickr_end: [],

        provider_model: {
            id_proveedor: 0,
            id_agencia: id_agencia,
            nombre_comercial: "",
            correo: "",
            direccion: "",
            cuidad: "",
            estado: "",
            codigo_postal: "",
            detalles: "",
            comision: "",
        },

        array_adults: [1, 2, 3, 4, 5, 6, 7, 8],
        array_children: [0, 1, 2, 3, 4, 5],
        age_options: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17],

        contract_loading: false,
    },
    created: function() {
        this.loadCustomers();
        this.loadProviders();
        this.loadServiceTypes();
        if (this.action == "update") {
            this.loadPriceInfo();
        }
        if (this.action == "update" || with_request) {
            this.contract_model.id_solicitud = request_code;
        }

        this.formatter = new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD',
        });
    },
    mounted: function() {
        this.initLibraries();
    },
    methods: {
        saveSale: function() {
            event.preventDefault();
            this.price_array.forEach((element, index) => {
                var array_dates = ($("#dp-stay-" + index).val()).split(" a ");
                appContracts.price_array[index].inicio_servicio = moment(array_dates[0], "DD/MM/YYYY").format("YYYY-MM-DD");
                fecha_final = array_dates[0];
                if (array_dates.length > 1) {
                    fecha_final = array_dates[1];
                }
                appContracts.price_array[index].fin_servicio = moment(fecha_final, "DD/MM/YYYY").format("YYYY-MM-DD");
            });
            var rq = {
                price: appContracts.contract_model,
                price_array: appContracts.price_array
            }
            var url_rq = "",
                success_msg = "";
            if (this.action == "update") {
                url_rq = this.baseUrl + "/cotizaciones/updateApi/";
                success_msg = "Contrato actualizada";
            } else {
                url_rq = this.baseUrl + "/cotizaciones/createApi/";
                success_msg = "Contrato guardada";
            }
            this.$http.post(url_rq, rq).then(function(response) {
                if (response.body.price.id_cotizacion) {
                    //window.location.href = this.baseUrl + '/ventas/';
                    Toast.fire({
                        icon: 'success',
                        title: success_msg
                    })
                } else {
                    var error_msg = "",
                        contract_detail_error = "";
                    error_msg = "Error al guardar la contrato";

                    Object.values(response.body).forEach(element => {
                        error_msg += "<tr><td>" + element + "</td></tr>";
                    });
                    error_msg += "</table>";
                    if (response.body.price_detail.errors > 0) {
                        var contract_detail_error = "Error al guardar el detalle de contrato";
                        contract_detail_error += "<table class='table table-bordered text-white'>";
                        Object.values(response.body).forEach(element => {
                            contract_detail_error += "<tr><td>" + element + "</td></tr>";
                        });
                        contract_detail_error += "</table>";
                    }
                    Swal.fire({
                        icon: 'error',
                        title: '¡Oops!',
                        html: 'Algo salió mal' + error_msg + contract_detail_error,
                    })
                }
            }, function() {
                console.log('Error')
            })
        },
        createProvider: function() {
            this.$http.post(this.baseUrl + "/proveedores/createApi/", this.provider_model).then(function(response) {
                if (response.body.id_proveedor) {
                    this.providers_array.push({
                        id: response.body.id_proveedor,
                        text: response.body.nombre_comercial,
                        comision: response.body.comision,
                    });
                    var newOption = new Option(response.body.nombre_comercial, response.body.id_proveedor, true, true);
                    $("#slct-provider-" + this.index_provider).append(newOption).trigger('change');

                    Toast.fire({
                        icon: 'success',
                        title: 'Proveedor registrado'
                    })
                    this.clearProviderModel();
                } else {
                    var error_table = "<table class='table table-bordered text-white'>"
                    Object.values(response.body).forEach(element => {
                        error_table += "<tr><td>" + element + "</td></tr>";
                    });
                    error_table += "</table>";
                    Swal.fire({
                        title: '¡Ops!',
                        icon: 'error',
                        html: "<p align='center'>Algo salió mal</p>" + error_table,
                    });
                }
            }, function() {
                console.log('Error')
            })
        },
        convertPriceToContract: function() {
            this.contract_loading = true;
            this.$http.post(this.baseUrl + "/cotizaciones/convertPriceToContract/" + this.contract_model.id_solicitud).then(function(response) {
                if (response.body.success) {
                    //window.location.href = this.baseUrl + '/ventas/';
                    Toast.fire({
                        icon: 'success',
                        title: 'Contrato creado'
                    });
                } else {
                    var error_msg = "<div class='text-center'>Error al guardar el contrato";
                    error_msg += "<table class='table table-bordered'>";
                    Object.values(response.body.error).forEach(element => {
                        error_msg += "<tr><td>" + element + "</td></tr>";
                    });
                    error_msg += "</table></div>";

                    Swal.fire({
                        icon: 'error',
                        title: '¡Oops!',
                        html: error_msg,
                    });
                }
                this.contract_loading = false;
            }, function() {
                console.log('Error')
            })
        },
        clearProviderModel: function() {
            this.provider_model = {
                id_proveedor: 0,
                id_agencia: id_agencia,
                nombre_comercial: "",
                correo: "",
                direccion: "",
                cuidad: "",
                estado: "",
                codigo_postal: "",
                detalles: "",
                comision: "",
            }
        },
        loadPriceInfo: function() { //se usará para cuando sea update de una cotización 
            this.$http.post(this.baseUrl + "/cotizaciones/getPriceInfo/" + price_code).then(function(response) {
                this.contract_model = response.body;
                this.request_model = response.body.idSolicitud;
                this.price_array = response.body.cotizacionDetalles;
                this.price_flatpickr.setDate(moment(this.contract_model.log).format("DD/MM/YYYY"));

                var newOption = new Option(this.contract_model.idSolicitud.idCliente.nombre, this.contract_model.idSolicitud.idCliente.id_cliente, true, true);
                $('.invoiceto').append(newOption).trigger('change');

                for (let index = 0; index < appContracts.price_array.length; index++) {
                    Vue.nextTick(function() {
                        feather.replace();
                        appContracts.flatpickr_array.push($("#dp-stay-" + index).flatpickr({
                            mode: "range",
                            dateFormat: "d/m/Y",
                            locale: "es",
                            onClose: function(selectedDates, dateStr, instance) {
                                console.log(selectedDates);
                                console.log(dateStr);
                                console.log(instance);
                            },
                        }));
                        appContracts.flatpickr_array[index].setDate(moment(appContracts.price_array[index].desglose.fecha_inicio).format("DD/MM/YYYY") + " a " + moment(appContracts.price_array[index].desglose.fecha_fin).format("DD/MM/YYYY"));

                        if (appContracts.price_array[index].id_tipo_servicio == 2 || appContracts.price_array[index].id_tipo_servicio == 6) {
                            appContracts.flatpickr_arrive.push($("#tp-arrive-" + index).flatpickr({
                                enableTime: true,
                                noCalendar: true,
                                dateFormat: "H:i",
                                locale: "es",
                            }));
                            if (appContracts.price_array[index].hora_llegada != null || appContracts.price_array[index].hora_llegada != "" || appContracts.price_array[index].hora_llegada != "0000-00-00") appContracts.flatpickr_arrive[index].setDate(moment(appContracts.price_array[index].desglose.hora_llegada, "HH:mm").format("HH:mm"));

                            appContracts.flatpickr_end.push($("#tp-end-" + index).flatpickr({
                                enableTime: true,
                                noCalendar: true,
                                dateFormat: "H:i",
                                locale: "es",
                            }));
                            if (appContracts.price_array[index].hora_salida != null || appContracts.price_array[index].hora_salida != "" || appContracts.price_array[index].hora_salida != "0000-00-00") appContracts.flatpickr_end[index].setDate(moment(appContracts.price_array[index].desglose.hora_salida, "HH:mm").format("HH:mm"));
                        }

                        appContracts.initSelect2(index);
                        $('#slct-provider-' + index).val(appContracts.price_array[index].id_proveedor);
                        $('#slct-provider-' + index).trigger("change");
                    })
                }

            }, function() {
                console.log('Error')
            })
        },
        loadProviders: function() {
            this.$http.get(this.baseUrl + "/proveedores/getProviders/" + this.id_agencia).then(function(response) {
                this.providers_array = response.body;
                this.initSelect2(0);
            }, function() {
                console.log('Error')
            })
        },
        loadCustomers: function() {
            this.$http.get(this.baseUrl + "/ventas/searchCustomers/").then(function(response) {
                this.customers_array = response.body;
                this.initSelect2Customers();
            }, function() {
                console.log('Error')
            })
        },
        loadServiceTypes: function() {
            this.$http.get(this.baseUrl + "/tipoServicios/serviciosapi/").then(function(response) {
                this.service_types_array = response.body;
            }, function() {
                console.log('Error')
            })
        },
        changeComissionType: function(index) {
            this.price_array[index].tipo_comision = this.price_array[index].tipo_comision == "%" ? "MXN" : "%";
        },
        addPrice: function() {
            this.price_array.push({
                desglose: {},
                observaciones: "",
                comision: "",
                comision_pesos: "",
                fee: null,
                total_neto: "",
                total_publico: "",
                id_proveedor: "",
                id_cotizacion: price_code,
                id_tipo_servicio: "",
                log: "",
            });

            var index = this.price_array.length - 1;
            Vue.nextTick(function() {
                appContracts.initSelect2(index);
                feather.replace();
            });
        },
        setPriceDetail: function(index) {
            if (this.price_array[index].desglose) {
                var desglose = {};
                var timepicker = false;
                if (this.price_array[index].id_tipo_servicio == 1) {
                    desglose = {
                        hotel: "",
                        destino: "",
                        fecha_fin: "2022-10-30",
                        fecha_inicio: "2022-10-27",
                        comision: "%",
                        habitaciones: [{
                            plan: "",
                            adultos: "2",
                            menores: "0",
                            edades: [],
                            ocupacion: "2 adulto(s), 0 menor(es)",
                            tipo_cama: "",
                            total_neto: "",
                            total_publico: "",
                            base_habitacion: "",
                            tipo_habitacion: ""
                        }]
                    };
                } else if (this.price_array[index].id_tipo_servicio == 2 || this.price_array[index].id_tipo_servicio == 6) {
                    timepicker = true;
                    desglose = {
                        adultos: "2",
                        menores: "0",
                        fecha_fin: "2022-10-30",
                        fecha_inicio: "2022-10-27",
                        comision: "%",
                        origen: "",
                        destino: "",
                        hora_llegada: "20:00:00",
                        hora_salida: "16:00:00",
                        equipaje: []
                    };
                } else {

                }
                this.price_array[index].desglose = desglose;

                var index = this.price_array.length - 1;
                Vue.nextTick(function() {
                    feather.replace();

                    if (appContracts.price_array.length > 1) {
                        var array_date = ($("#dp-stay-0").val()).split(" a ");
                        $("#dp-stay-" + index).flatpickr({
                            mode: "range",
                            dateFormat: "d/m/Y",
                            defaultDate: [array_date[0], array_date[1]],
                            locale: "es",
                            onClose: function(selectedDates, dateStr, instance) {
                                appContracts.onCloseFlapickr(selectedDates, dateStr, instance);
                            },
                        });
                    } else {
                        $("#dp-stay-" + index).flatpickr({
                            mode: "range",
                            dateFormat: "d/m/Y",
                            locale: "es",
                            onClose: function(selectedDates, dateStr, instance) {
                                appContracts.onCloseFlapickr(selectedDates, dateStr, instance);
                            },
                        });
                    }

                    if (timepicker) {
                        appContracts.flatpickr_arrive.push($("#tp-arrive-" + index).flatpickr({
                            enableTime: true,
                            noCalendar: true,
                            dateFormat: "H:i",
                            locale: "es",
                            minDate: "today"
                        }));
                        appContracts.flatpickr_end.push($("#tp-end-" + index).flatpickr({
                            enableTime: true,
                            noCalendar: true,
                            dateFormat: "H:i",
                            locale: "es",
                            minDate: "today"
                        }));
                    }
                })
            }
        },
        removePrice: function(index) {
            this.price_array.splice(index, 1);
        },
        addRoom: function(index) {
            this.price_array[index].desglose.habitaciones.push({
                plan: "",
                adultos: "2",
                menores: "0",
                ocupacion: "2 adulto(s), 0 menor(es)",
                tipo_cama: "",
                total_neto: "",
                total_publico: "",
                base_habitacion: "",
                tipo_habitacion: ""
            });
            Vue.nextTick(function() {
                feather.replace();
            });
        },
        deleteRoom: function(index_price, index) {
            this.price_array[index_price].desglose.habitaciones.splice(index, 1);
        },
        changeOccupancy: function(index_price, index) {
            this.price_array[index_price].desglose.habitaciones[index].ocupacion = this.price_array[index_price].desglose.habitaciones[index].adultos + " adulto(s), " + this.price_array[index_price].desglose.habitaciones[index].menores + " menor(es)";

            this.price_array[index_price].desglose.habitaciones[index].edades = [];
            var no_menores = this.price_array[index_price].desglose.habitaciones[index].menores;
            var that = this;
            for (let i = 0; i < no_menores; i++) {
                that.price_array[index_price].desglose.habitaciones[index].edades.push({ edad: 0 });
            }
        },
        initLibraries: function() {
            var i = new Date;
            if (this.action == "update") {
                this.price_flatpickr = $(".date-picker").flatpickr({
                    defaultDate: i,
                    dateFormat: "d/m/Y",
                    locale: "es"
                });
            }
            /* $("#dp-stay-0").flatpickr({
                mode: "range",
                dateFormat: "d/m/Y",
                locale: "es",
                onClose: function(selectedDates, dateStr, instance) {
                    console.log(selectedDates);
                    console.log(dateStr);
                    console.log(instance);
                },
            });
            $("#tp-arrive-0").flatpickr({
                dateFormat: "d/m/Y",
                locale: "es",
                minDate: "today"
            });
            $("#tp-end-0").flatpickr({
                dateFormat: "d/m/Y",
                locale: "es",
                minDate: "today"
            }); */
        },
        initSelect2Customers: function() {
            var p = $(".invoiceto");
            $(document).on("click", ".add-new-customer", (function() { p.select2("close") }))
            p.select2({
                placeholder: "Seleccione un cliente",
                data: appContracts.customers_array,
                dropdownParent: $(".invoice-customer"),
            }).on("change", (function() {
                var e = $(this);
                //console.log(e.val());
                appContracts.contract_model.id_cliente = e.val();
                var index = appContracts.customers_array.findIndex(x => x.id == e.val());
                appContracts.customer_selected = appContracts.customers_array[index];
            })).on("select2:open", (function() {
                appCustomerCrud.clearCustomerModel();
                $(".select2-search__field")[0].focus();
                $(document).find(".add-new-customer").length || $(document).find(".select2-results__options").before('<div class="add-new-customer btn btn-flat-success cursor-pointer rounded-0 text-start mb-50 p-50 w-100" data-bs-toggle="modal" data-bs-target="#cu-customers">' + feather.icons.plus.toSvg({ class: "font-medium-1 me-50" }) + '<span class="align-middle">Agregar Cliente</span></div>')
            }))
        },
        initSelect2: function(index) {
            $(document).on("click", ".add-new-provider", (function() { $("#slct-provider-" + index).select2("close") }))
            $("#slct-provider-" + index).select2({
                placeholder: "Seleccione un proveedor",
                data: appContracts.providers_array,
            }).on("change", (function() {
                var e = $(this);
                var index = e.attr('data-index');
                appContracts.price_array[index].id_proveedor = e.val();
                var index_provider = appContracts.providers_array.findIndex(x => x.id == e.val());
                appContracts.price_array[index].comision = appContracts.providers_array[index_provider].comision;
            })).on("select2:open", (function() {
                $(".select2-search__field")[0].focus();
                $(document).find(".add-new-provider").length || $(document).find(".select2-results__options").before('<div class="add-new-provider btn btn-flat-success cursor-pointer rounded-0 text-start mb-50 p-50 w-100" data-bs-toggle="modal" data-bs-target="#add-new-provider-sidebar" data-index="' + index + '">' + feather.icons.plus.toSvg({ class: "font-medium-1 me-50" }) + '<span class="align-middle">Agregar Proveedor</span></div>')
            }))
        },
        calculateSubtotal: function() {
            var subtotal = 0;
            this.price_array.forEach(element => {
                if (parseFloat(element.total_publico)) {
                    subtotal += parseFloat(element.total_publico);
                }
            });
            return this.formatter.format(subtotal);
        },
        calculateFee: function() {
            var fee = 0;
            this.price_array.forEach(element => {
                if (parseFloat(element.fee)) {
                    fee += parseFloat(element.fee);
                }
            });
            return this.formatter.format(fee);
        },
        calculateTotal: function() {
            var total = 0;
            var that = this;
            this.price_array.forEach(element => {
                if (parseFloat(element.total_publico) || element.id_tipo_servicio == 1) {
                    that.calculateCommission(element);
                    if (element.comision_pesos > 0) {
                        element.costo = element.total_publico - element.comision_pesos;
                    } else {
                        element.costo = (element.total_publico * ((100 - element.comision) / 100));
                    }
                    total += parseFloat(element.total_publico);
                }

                if (parseFloat(element.fee)) {
                    total += parseFloat(element.fee);
                }
            });
            return this.formatter.format(total);
        },
        calculateCommission: function(element) {
            /* if (element.desglose.comision == "%") {
                element.comision_pesos = (element.comision * element.total_publico) / 100;
            } else {
                element.comision = (element.comision_pesos * 100) / element.total_publico;
            } */
            if (element.desglose.comision == "%") {
                var aux_com = element.comision / 100;

                if (element.id_tipo_servicio == 1) {
                    var total_item = 0;
                    element.desglose.habitaciones.forEach(item => {
                        if (item.total_publico > 0) {
                            total_item += parseFloat(item.total_publico);
                            item.total_neto = (parseFloat(item.total_publico) / (1 + aux_com)).toFixed(2);
                        }
                    });

                    element.total_publico = total_item;
                }

                if (element.total_publico > 0) {
                    element.total_neto = (element.total_publico / (1 + aux_com)).toFixed(2);
                    element.comision_pesos = (element.total_publico - element.total_neto).toFixed(2);
                }
            } else {
                if (element.comision_pesos > 0) {

                    var aux_neto = (element.total_publico - element.comision_pesos).toFixed(2);
                    element.total_neto = aux_neto;
                    element.comision = (((element.total_publico / aux_neto) * 100) - 100).toFixed(2);
                }
            }
        },
        changeComissionType: function(index) {
            this.price_array[index].desglose.comision = this.price_array[index].desglose.comision == "%" ? "MXN" : "%";
        },
        onCloseFlapickr: function(selectedDates, dateStr, instance) {
            if (appContracts.contract_model.fecha_inicial == "") {
                var dateAux = dateStr.split(" a ");
                dateAux.forEach((dateItem, index) => {
                    if (index == 0) {
                        appContracts.contract_model.fecha_inicial = moment(dateItem, "DD/MM/YYYY").format("YYYY-MM-DD");
                    } else {
                        appContracts.contract_model.fecha_final = moment(dateItem, "DD/MM/YYYY").format("YYYY-MM-DD");
                    }
                })
            } else {
                var start_date = moment(appContracts.contract_model.fecha_inicial, "DD/MM/YYYY").format("YYYY-MM-DD");
                var end_date = moment(appContracts.contract_model.fecha_final, "DD/MM/YYYY").format("YYYY-MM-DD");
                var dateAux = dateStr.split(" a ");
                dateAux.forEach((dateItem, index) => {
                    var formatDate = moment(dateItem, "DD/MM/YYYY").format("YYYY-MM-DD");
                    if (index == 0 && moment(formatDate).isBefore(start_date)) {
                        appContracts.contract_model.fecha_inicial = moment(dateItem, "DD/MM/YYYY").format("YYYY-MM-DD");
                    } else if (index == 1 && moment(formatDate).isAfter(end_date)) {
                        appContracts.contract_model.fecha_final = moment(dateItem, "DD/MM/YYYY").format("YYYY-MM-DD");
                    } else {
                        console.log(dateItem, appContracts.contract_model.fecha_inicial, appContracts.contract_model.fecha_final);
                    }
                })
            }
        },
        formatPrice: function(price) {
            var aux = parseFloat(price);
            return this.formatter.format(aux) + " MXN";
        },
        formatDate: function(date_string) {
            return moment(date_string).format("DD/MM/YYYY");
        }
    }
})

$("body").on("click", ".add-new-provider", function() {
    var index = $(this).attr("data-index");
    appContracts.index_provider = index;
});