const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    timer: 3000,
    showConfirmButton: false,
    //timerProgressBar: true,
});

Vue.http.options.emulateJSON = true;
var appContracts = new Vue({
    el: "#app-contracts",
    data: {
        baseUrl: baseUrl,

        contracts_table: "",
        contracts_array: [],

        selected_contract: 0,
        customer_model: {},
    },
    mounted: function() {
        this.loadContractsTable();
    },
    methods: {
        loadContractsTable: function() {
            var that = this;
            var url_rq = this.baseUrl + "/contratos/getContracts";
            this.contracts_table = $("#contracts-table").DataTable({
                language: { url: "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                ajax: {
                    "url": url_rq,
                    "dataSrc": function(json) {
                        that.contracts_array = json;
                        return json;
                    }
                },
                //scrollX: true,
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"B><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                bDestroy: true,
                buttons: [{
                    extend: "collection",
                    className: "btn btn-outline-secondary dropdown-toggle me-2",
                    text: feather.icons.share.toSvg({ class: "font-small-4 me-50" }) + "Exportar",
                    buttons: [{
                        extend: "csv",
                        text: feather.icons["file-text"].toSvg({ class: "font-small-4 me-50" }) + "Csv",
                        className: "dropdown-item",
                        //exportOptions: { columns: [3, 4, 5, 6, 7] } 
                    }, {
                        extend: "excel",
                        text: feather.icons.file.toSvg({ class: "font-small-4 me-50" }) + "Excel",
                        className: "dropdown-item",
                    }, {
                        extend: "pdf",
                        text: feather.icons.clipboard.toSvg({ class: "font-small-4 me-50" }) + "Pdf",
                        className: "dropdown-item",
                    }, {
                        extend: "copy",
                        text: feather.icons.copy.toSvg({ class: "font-small-4 me-50" }) + "Copiar",
                        className: "dropdown-item",
                    }],
                    init: function(e, t, a) {
                        $(t).removeClass("btn-secondary"), $(t).parent().removeClass("btn-group"), setTimeout((function() { $(t).closest(".dt-buttons").removeClass("btn-group").addClass("d-inline-flex") }), 50)

                    }
                }],
                columns: [{
                        data: 'id_contrato',
                        render: function(data, type, row, meta) {
                            return meta.row + 1;
                        }
                    },
                    { data: 'idCotizacion.idCliente.nombre' },
                    { data: 'idCotizacion.id_cotizacion' },
                    {
                        data: 'idUserCreo.profiles.firstname',
                        render: function(data, type, row, meta) {
                            return row.idUserCreo.profiles.firstname + " " + row.idUserCreo.profiles.lastname;
                        }
                    },
                    {
                        data: 'log',
                        render: function(data, type, row, meta) {
                            return moment(row.log).format("DD/MM/YYYY");
                        }
                    },
                    {
                        data: 'estatus',
                        render: function(data, type, row, meta) {
                            return row.estatus == "C" ? "Creado" : "Firmado";
                        }
                    },
                    {
                        data: "id_grupo",
                        orderable: false,
                        render: function(data, type, row, meta) {
                            return '<a href="' + appContracts.baseUrl + '/formatos/contrato/' + row.id_contrato + '" target="_blank">' + feather.icons.eye.toSvg() + '</a><a href="javascript:;" class="ms-50 edit-record" data-contract=' + row.id_contrato + '>' + feather.icons.mail.toSvg() + '</a><a href="javascript:void(0)" class="ms-50 delete-record" data-contract=' + row.id_contrato + '>' + feather.icons["trash-2"].toSvg() + '</a>';
                        }
                    },

                ],
                "drawCallback": function(settings, json) {
                    //appGroups.addCssToTable();
                }
            });
        },
        checkEmail: async(inputValue) => {
            const { value: email } = await Swal.fire({
                title: 'Enviar enlace para firma de contrato',
                input: 'email',
                inputValue: inputValue,
                inputLabel: 'Verifique el correo electrónico',
                confirmButtonText: 'Enviar',

                showCancelButton: true,
                cancelButtonText: "Cancelar",
            })

            if (email) {
                appContracts.sendLinkSignature(email);
            }
        },
        sendLinkSignature: function(email) {
            var rq = { contract_code: this.selected_contract, customer_code: this.customer_model.customer_code, email: email };
            this.$http.post(this.baseUrl + "/contratos/sendLinkSignature/", rq).then(function(response) {
                this.providers_array = response.body;
                if (response.body.success) {
                    Toast.fire({
                        icon: 'success',
                        text: 'Se ha enviado el correo.'
                    });
                } else {
                    Toast.fire({
                        icon: 'error',
                        text: "Algo salió mal, recargue la página e intentelo de nuevo",
                    });
                }
            }, function() {
                console.log('Error')
            })
        }
    }
});

$("body").on("click", ".edit-record", function() {
    var contract_code = $(this).attr("data-contract");
    appContracts.selected_contract = contract_code;
    var index = appContracts.contracts_array.findIndex(x => x.id_contrato == contract_code);
    var email = appContracts.contracts_array[index].idCotizacion.idCliente.correo;
    appContracts.customer_model = { email: appContracts.contracts_array[index].idCotizacion.idCliente.correo, customer_code: appContracts.contracts_array[index].idCotizacion.id_cliente }
    appContracts.checkEmail(email);
});