flatpickr.localize(flatpickr.l10ns.es);
flatpickr.l10ns.default.firstDayOfWeek = 7;
const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    timer: 3000,
    showConfirmButton: false,
    //timerProgressBar: true,
});

Vue.http.options.emulateJSON = true;
var appPrices = new Vue({
    el: "#app-prices",
    mixins: [ appProveedorCreate ],
    data: {
        baseUrl: baseUrl,
        aux_index: -1,
        key_flight_stop: 0,
        formatter: new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD',
        }),

        array_adults: [1, 2, 3, 4, 5, 6, 7, 8],
        array_children: [0, 1, 2, 3, 4, 5],
        age_options: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17],
        
        check_sale_payments: true,
        price_model: {},
        sale_model: {
            id_venta: 0,
            folio: "",
            fecha: "",
            pasajero_titular: "",
            descripcion: "",
            observaciones: "",
            cargo_servicios: "",
            limite_cancelacion: "",
            moneda: "MXN",
            estatus: "venta",
            id_agencia: id_agencia,
            id_usuario: id_usuario,
            id_cliente: 0,
        },
        service_array: [],
        index_aux: -1,
        comission_type: "%",
        customers_array: [],
        customer_selected: {},

        service_types_array: [],
        hotels_array: [],

        sale_flatpickr: "",
        cancel_limit_flatpickr: "",
        flatpickr_array: [],
        flatpickr_limit: [],
        flatpickr_customer_limit: [],
        flatpickr_arrive: [],
        flatpickr_end: [],
    },
    created: function() {
        this.loadProviders();
        this.loadCustomers();
        this.loadServiceTypes();
    },
    mounted: function() {
        var i = new Date;
        this.sale_flatpickr = $(".date-picker").flatpickr({
            defaultDate: i,
            dateFormat: "d/m/Y",
        });
        this.cancel_limit_flatpickr = $("#cancel-limit").flatpickr({
            dateFormat: "d/m/Y"
        });
        this.loadPriceInfo();
    },
    methods: {
        saveSale: function() {
            event.preventDefault();
            this.sale_model.fecha = moment($(".date-picker").val(), "DD/MM/YYYY").format("YYYY-MM-DD");
            this.sale_model.limite_cancelacion = $("#cancel-limit").val() != "" ? moment($("#cancel-limit").val(), "DD/MM/YYYY").format("YYYY-MM-DD") : "";
            this.service_array.forEach((element, index) => {
                var array_dates = ($("#dp-stay-" + index).val()).split(" a ");
                appPrices.service_array[index].inicio_servicio = moment(array_dates[0], "DD/MM/YYYY").format("YYYY-MM-DD");
                fecha_final = array_dates[0];
                if (array_dates.length > 1) {
                    fecha_final = array_dates[1];
                }
                appPrices.service_array[index].fin_servicio = moment(fecha_final, "DD/MM/YYYY").format("YYYY-MM-DD");
                appPrices.service_array[index].fecha_limite = moment($("#dp-limit-" + index).val(), "DD/MM/YYYY").format("YYYY-MM-DD");
                appPrices.service_array[index].limite_cliente = moment($("#dp-customer-limit-" + index).val(), "DD/MM/YYYY").format("YYYY-MM-DD");
            });
            var rq = {
                sale: appPrices.sale_model,
                services: appPrices.service_array,
                price_code: price_code,
            }
            var url_rq = this.baseUrl + "/ventas/createApi/";
            this.$http.post(url_rq, rq).then(function(response) {
                if(response.body.success) {
                    Toast.fire({
                        icon: 'success',
                        title: 'Venta registrada'
                    })
                    window.location.href = this.baseUrl + '/ventas/update/' + response.body.sale.id_venta;
                } else {
                    var error_table = "<table class='table table-bordered text-white'>";
                        switch(response.body.error) {
                            case "sale":
                            case "group":
                                Object.values(response.body[response.body.error]).forEach(element => {
                                    error_table += "<tr><td>" + element + "</td></tr>";
                                });
                                break;
                            
                            case "service":
                                response.body.services.forEach(item => {
                                    if(!item.id_ventaservicio) {
                                        Object.values(item).forEach(element => {
                                            error_table += "<tr><td>" + element + "</td></tr>";
                                        });
                                    }
                                });
                                break;
                        }
                        error_table += "</table>";
                        Swal.fire({
                            title: '¡Ops!',
                            icon: 'error',
                            html: "<p align='center'>Algo salió mal</p>" + error_table,
                        });
                }
            }, function() {
                console.log('Error')
            })
        },
        loadPriceInfo: function() { //se usará para cuando sea update de una venta 
            this.$http.get(this.baseUrl + "/cotizaciones/getPriceInfo/" + price_code).then(function(response) {
                var aux_price = response.body;
                var aux_detail = response.body.cotizacionDetalles;
                this.sale_model.fecha = aux_price.log;

                var aux_cliente = aux_price.id_solicitud == null ? this.sale_model.pasajero_titular = aux_price.idCliente : this.sale_model.pasajero_titular = aux_price.idSolicitud.idCliente;
                this.sale_model.pasajero_titular = aux_cliente.nombre;
                this.sale_model.observaciones = aux_price.observaciones;
                this.sale_model.cargo_servicios = aux_price.cargo_servicios;
                this.sale_model.id_cliente = aux_price.id_cliente;
                
                this.sale_flatpickr.setDate(moment(this.sale_model.fecha).format("DD/MM/YYYY"));
                this.customers_array.push({
                    id: aux_cliente.id_cliente,
                    text: aux_cliente.nombre,
                    mail: aux_cliente.correo,
                    phone: aux_cliente.telefono,
                })
                var newOption = new Option(aux_cliente.nombre, aux_cliente.id_cliente, true, true);
                $('.invoiceto').append(newOption).trigger('change');

                for (let i = 0; i < aux_detail.length; i++) {
                    var service = {
                        id_ventaservicio: 0,
                        id_venta: 0,
                        id_proveedor: aux_detail[i].id_proveedor,
                        id_tipo_servicio: aux_detail[i].id_tipo_servicio,
                        codigo: "",
                        descripcion: aux_detail[i].observaciones,
                        desglose: aux_detail[i].desglose,
                        inicio_servicio: aux_detail[i].desglose.fecha_inicio,
                        fin_servicio: aux_detail[i].desglose.fecha_fin,
                        fecha_limite: "",
                        limite_cliente: "",
                        comision: aux_detail[i].comision,
                        comision_pesos: aux_detail[i].comision_pesos,
                        tipo_comision: aux_detail[i].desglose.comision,
                        tarifa_publica: aux_detail[i].total_publico,
                        fee: "",
                        costo: aux_detail[i].total_neto,
                    }

                    if(service.desglose.escala) {
                        if(!service.desglose.escalas_origen) service.desglose.escalas_origen = [];
                        if(service.desglose.redondo) {
                            if(!service.desglose.escalas_destino) service.desglose.escalas_destino = [];
                        }
                    }

                    if(aux_detail[i].id_tipo_servicio == 1) {
                        service.desglose.habitaciones = aux_detail[i].desglose.habitaciones;
                        for (let j = 0; j < aux_detail[i].desglose.habitaciones.length; j++) {
                            service.desglose.habitaciones[j].pasajeros = {
                                adultos: [],
                                menores: []
                            }
                            for (let k = 0; k < service.desglose.habitaciones[j].adultos; k++) {
                                service.desglose.habitaciones[j].pasajeros.adultos.push({
                                    nombre: "",
                                    apellidos: ""
                                });
                            }

                            for (let k = 0; k < service.desglose.habitaciones[j].menores; k++) {
                                service.desglose.habitaciones[j].pasajeros.menores.push({
                                    nombre: "",
                                    apellidos: "",
                                    edad: ""
                                });
                            }
                        }
                    /* } else if(aux_detail[i].id_tipo_servicio == 2 || aux_detail[i].id_tipo_servicio == 6) { */
                    } else {
                        service.desglose.redondo = service.desglose.redondo;
                        service.desglose.pasajeros = {
                            adultos: [],
                            menores: []
                        }
                        for (let j = 0; j < service.desglose.adultos; j++) {
                            service.desglose.pasajeros.adultos.push({
                                nombre: "",
                                apellidos: ""
                            })
                        }

                        for (let j = 0; j < service.desglose.menores; j++) {
                            service.desglose.pasajeros.menores.push({
                                nombre: "",
                                apellidos: "",
                                edad: ""
                            })
                        }
                    }
                    appPrices.service_array.push(service);
                    
                    Vue.nextTick(function() {
                        appPrices.flatpickr_array.push($("#dp-stay-" + i).flatpickr({
                            mode: "range",
                            dateFormat: "d/m/Y",
                        }));
                        appPrices.flatpickr_array[i].setDate(moment(service.inicio_servicio).format("DD/MM/YYYY") + " a " + moment(service.fin_servicio).format("DD/MM/YYYY"));
    
                        appPrices.flatpickr_limit.push($("#dp-limit-" + i).flatpickr({
                            dateFormat: "d/m/Y",
                        }));
    
                        appPrices.flatpickr_customer_limit.push($("#dp-customer-limit-" + i).flatpickr({
                            dateFormat: "d/m/Y",
                            minDate: "today"
                        }));
    
                        appPrices.initSelect2(i);
                        $('#slct-provider-' + i).val(service.id_proveedor);
                        
                        if(appPrices.service_array[i].id_tipo_servicio == 1) {
                            appPrices.initHotelSelect2(i);
                            var newOption = new Option(appPrices.service_array[i].desglose.hotel, appPrices.service_array[i].desglose.hotel, true, true);
                            $('#slct-hotel-' + i).append(newOption);
                        }
                        
                        setTimeout(() => {
                            $('#slct-provider-' + i).trigger("change");
                            if(appPrices.service_array[i].id_tipo_servicio == 1) $('#slct-hotel-' + i).trigger('change');
                        }, 100);
                        feather.replace();
                    })
                }
            }, function() {
                console.log('Error')
            })
        },
        loadCustomers: function() {
            this.$http.get(this.baseUrl + "/ventas/searchCustomers/").then(function(response) {
                this.customers_array = response.body;
                this.initSelect2Customers();
            }, function() {
                console.log('Error')
            })
        },
        loadServiceTypes: function() {
            this.$http.get(this.baseUrl + "/tipoServicios/serviciosapi/").then(function(response) {
                this.service_types_array = response.body;
            }, function() {
                console.log('Error')
            })
        },
        changeComissionType: function(index) {
            this.service_array[index].tipo_comision = this.service_array[index].tipo_comision == "%" ? "MXN" : "%";
        },
        addRoom: function(index) {
            this.service_array[index].desglose.habitaciones.push({
                plan: "",
                adultos: "2",
                menores: "0",
                ocupacion: "2 adulto(s), 0 menor(es)",
                pasajeros: {
                    adultos: [{
                        nombre: "",
                        apellidos: "",
                    }, {
                        nombre: "",
                        apellidos: "",
                    }],
                    menores: [],
                },
                edades: [],
                tipo_cama: "",
                total_neto: "",
                total_publico: "",
                base_habitacion: "",
                tipo_habitacion: ""
            });
            Vue.nextTick(function() {
                feather.replace();
            });
        },
        deleteRoom: function(index_price, index) {
            this.service_array[index_price].desglose.habitaciones.splice(index, 1);
        },
        changeOccupancy: function(index_price, index = -1) {
            if(index >= 0) {
                this.service_array[index_price].desglose.habitaciones[index].ocupacion = this.service_array[index_price].desglose.habitaciones[index].adultos + " adulto(s), " + this.service_array[index_price].desglose.habitaciones[index].menores + " menor(es)";
                
                this.service_array[index_price].desglose.habitaciones[index].edades = [];
                var no_menores = this.service_array[index_price].desglose.habitaciones[index].menores;
                var that = this;
                for (let i = 0; i < no_menores; i++) {
                    that.service_array[index_price].desglose.habitaciones[index].edades.push({ edad: 0 });
                }

                /* add - remove adults of pax array */
                if(this.service_array[index_price].desglose.habitaciones[index].adultos > this.service_array[index_price].desglose.habitaciones[index].pasajeros.adultos.length) {
                    var count = this.service_array[index_price].desglose.habitaciones[index].adultos - this.service_array[index_price].desglose.habitaciones[index].pasajeros.adultos.length;
                    for (let i = 0; i < count; i++) {
                        that.service_array[index_price].desglose.habitaciones[index].pasajeros.adultos.push({
                            nombre: "",
                            apellidos: "",
                        });
                    }
                }

                if(this.service_array[index_price].desglose.habitaciones[index].adultos < this.service_array[index_price].desglose.habitaciones[index].pasajeros.adultos) {
                    var count = this.service_array[index_price].desglose.habitaciones[index].pasajeros.adultos.length - this.service_array[index_price].desglose.habitaciones[index].adultos;
                    for (let i = 0; i < count; i++) {
                        that.service_array[index_price].desglose.habitaciones[index].pasajeros.adultos.pop();
                    }
                }
                /* add - remove adults of pax array */

                /* add - remove children of pax array */
                if(this.service_array[index_price].desglose.habitaciones[index].menores > this.service_array[index_price].desglose.habitaciones[index].pasajeros.menores.length) {
                    var count = this.service_array[index_price].desglose.habitaciones[index].menores - this.service_array[index_price].desglose.habitaciones[index].pasajeros.menores.length;
                    for (let i = 0; i < count; i++) {
                        that.service_array[index_price].desglose.habitaciones[index].pasajeros.menores.push({
                            nombre: "",
                            apellidos: "",
                            edad: "",
                        });
                    }
                }

                if(this.service_array[index_price].desglose.habitaciones[index].menores < this.service_array[index_price].desglose.habitaciones[index].pasajeros.menores.length) {
                    var count = this.service_array[index_price].desglose.habitaciones[index].pasajeros.menores.length - this.service_array[index_price].desglose.habitaciones[index].menores;
                    for (let i = 0; i < count; i++) {
                        that.service_array[index_price].desglose.habitaciones[index].pasajeros.menores.pop();
                    }
                }
                /* add - remove children of pax array */
            } else {
                this.service_array[index_price].desglose.ocupacion = this.service_array[index_price].desglose.adultos + " adulto(s), " + this.service_array[index_price].desglose.menores + " menor(es)";

                this.service_array[index_price].desglose.edades = [];
                var no_menores = this.service_array[index_price].desglose.menores;
                var that = this;
                /* for (let i = 0; i < no_menores; i++) {
                    that.service_array[index_price].desglose.edades.push({ edad: 0 });
                } */
                
                /* add - remove adults of pax array */
                if(this.service_array[index_price].desglose.adultos > this.service_array[index_price].desglose.pasajeros.adultos.length) {
                    var count = this.service_array[index_price].desglose.adultos - this.service_array[index_price].desglose.pasajeros.adultos.length;
                    for (let i = 0; i < count; i++) {
                        that.service_array[index_price].desglose.pasajeros.adultos.push({
                            nombre: "",
                            apellidos: "",
                        });
                    }
                }

                if(this.service_array[index_price].desglose.adultos < this.service_array[index_price].desglose.pasajeros.adultos.length) {
                    var count = this.service_array[index_price].desglose.pasajeros.adultos.length - this.service_array[index_price].desglose.adultos;
                    for (let i = 0; i < count; i++) {
                        that.service_array[index_price].desglose.pasajeros.adultos.pop();
                    }
                }
                /* add - remove adults of pax array */

                /* add - remove children of pax array */
                if(this.service_array[index_price].desglose.menores > this.service_array[index_price].desglose.pasajeros.menores.length) {
                    var count = this.service_array[index_price].desglose.menores - this.service_array[index_price].desglose.pasajeros.menores.length;
                    for (let i = 0; i < count; i++) {
                        that.service_array[index_price].desglose.pasajeros.menores.push({
                            nombre: "",
                            apellidos: "",
                            edad: "",
                        });
                    }
                }

                if(this.service_array[index_price].desglose.menores < this.service_array[index_price].desglose.pasajeros.menores.length) {
                    var count = this.service_array[index_price].desglose.pasajeros.menores.length - this.service_array[index_price].desglose.menores;
                    for (let i = 0; i < count; i++) {
                        that.service_array[index_price].desglose.pasajeros.menores.pop();
                    }
                }
                /* add - remove children of pax array */
            }
        },
        editPaxList: function(index) {
            var aux = this.index_aux;
            this.index_aux = index;
            if(aux == -1) {
                Vue.nextTick(() => {
                    var myModal = new bootstrap.Modal(document.getElementById('pax-list-modal'));
                    myModal.show();
                })
            }
        },
        changeRoundService: function(index) {
            var service_date = $("#dp-stay-" + index).val();
            if(this.service_array[index].desglose.redondo) {
                appPrices.flatpickr_array[index].set("mode", "range");
                var new_date = $("#dp-stay-" + index).val() + " a " + moment($("#dp-stay-" + index).val(), "DD/MM/YYYY").add(3, "days").format("DD/MM/YYYY");
                appPrices.flatpickr_array[index].setDate(new_date);
            } else {
                if(service_date != "") {
                    var array_date = ($("#dp-stay-" + index).val()).split(" a ");
                    var new_date = array_date[0];
                    appPrices.flatpickr_array[index].setDate(new_date);
                }
                appPrices.flatpickr_array[index].set("mode", "single");
            }
        },
        addService: function() {
            this.service_array.push({
                id_ventaservicio: 0,
                id_venta: 0,
                id_proveedor: "",
                id_tipo_servicio: "",
                codigo: "",
                descripcion: "",
                desglose: {},
                inicio_servicio: "",
                fin_servicio: "",
                fecha_limite: "",
                limite_cliente: 0,
                comision: "",
                comision_pesos: "",
                tipo_comision: "%",
                tarifa_publica: "",
                fee: "",
                costo: "",
            });
            var index = this.service_array.length - 1;
            Vue.nextTick(function() {
                feather.replace();
                $("#dp-stay-" + index).flatpickr({
                    mode: "range",
                    dateFormat: "d/m/Y",
                });
                $("#dp-limit-" + index).flatpickr({
                    dateFormat: "d/m/Y",
                    minDate: "today"
                });
                $("#dp-customer-limit-" + index).flatpickr({
                    dateFormat: "d/m/Y",
                    minDate: "today"
                });
                appPrices.initSelect2(index);
            })
        },
        removeService: function(index) {
            this.service_array.splice(index, 1);
        },
        setSaleDetail: function(index) {
            if (this.service_array[index].desglose) {
                var desglose = {};
                var timepicker = false;
                if (this.service_array[index].id_tipo_servicio == 1) {
                    desglose = {
                        hotel: "",
                        destino: "",
                        comision: "%",
                        habitaciones: [{
                            plan: "",
                            adultos: "2",
                            menores: "0",
                            ocupacion: "2 adulto(s), 0 menor(es)",
                            pasajeros: {
                                adultos: [{
                                    nombre: "",
                                    apellidos: "",
                                }, {
                                    nombre: "",
                                    apellidos: "",
                                }],
                                menores: [],
                            },
                            edades: [],
                            tipo_cama: "",
                            total_neto: "",
                            total_publico: "",
                            base_habitacion: "",
                            tipo_habitacion: ""
                        }]
                    };
                } else if (this.service_array[index].id_tipo_servicio == 2 || this.service_array[index].id_tipo_servicio == 6) {
                    timepicker = true;
                    desglose = {
                        aerolinea: "",
                        redondo: 1,
                        internacional: 1,
                        adultos: "2",
                        menores: "0",
                        ocupacion: "2 adulto(s), 0 menor(es)",
                        pasajeros: {
                            adultos: [{
                                nombre: "",
                                apellidos: "",
                            }, {
                                nombre: "",
                                apellidos: "",
                            }],
                            menores: [],
                        },
                        fecha_fin: "2022-10-30",
                        fecha_inicio: "2022-10-27",
                        comision: "%",
                        origen: "",
                        destino: "",
                        horario_origen: {
                            salida: "",
                            llegada: ""
                        },
                        horario_destino: {
                            salida: "",
                            llegada: "",
                        },
                        equipaje: []
                    };
                } /* else if(this.service_array[index].id_tipo_servicio == 3 || this.service_array[index].id_tipo_servicio == 4) {
                    desglose = {
                        fecha_evento: "",
                        tipo_hab: "",
                        no_hab: "",
                    };
                    if(this.service_array[index].id_tipo_servicio == 4) {
                        desglose.novios = "";
                    }
                } */
                this.service_array[index].desglose = desglose;

                var index = this.service_array.length - 1;
                Vue.nextTick(function() {
                    feather.replace();
                    
                    var array_date = ($("#dp-stay-0").val()).split(" a ");
                    var aux_default_date = appPrices.service_array.length > 1 ? [array_date[0], array_date[1]] : [moment().format("DD/MM/YYYY"), moment().add(3, 'days').format("DD/MM/YYYY")];

                    appPrices.flatpickr_array.push(flatpickr(("#dp-stay-" + index), {
                        mode: "range",
                        dateFormat: "d/m/Y",
                        defaultDate: aux_default_date,
                        minDate: "today",
                        onValueUpdate: function(dObj, dStr, fp, dayElem) {
                            var stay = dStr.split(" a ");
                            if(stay.length > 1) {
                                appPrices.service_array[index].inicio_servicio = moment(stay[0], "DD/MM/YYYY").format("YYYY-MM-DD");
                                appPrices.service_array[index].fin_servicio = moment(stay[1], "DD/MM/YYYY").format("YYYY-MM-DD");
                            } else {
                                appPrices.service_array[index].inicio_servicio = moment(stay[0], "DD/MM/YYYY").format("YYYY-MM-DD");
                                appPrices.service_array[index].fin_servicio = null;
                            }
                        },
                    }));

                    appPrices.initHotelSelect2(index);
                })
            }
        },
        setFlightType: function(index) {
            if(this.service_array[index].desglose.internacional) {
                var that = this;
                this.service_array[index].desglose.pasajeros.adultos.forEach(function(element, i) {
                    that.service_array[index].desglose.pasajeros.adultos[i].no_pasaporte = "";
                    that.service_array[index].desglose.pasajeros.adultos[i].no_visa = "";
                });
    
                this.service_array[index].desglose.pasajeros.menores.forEach(function(element, i) {
                    that.service_array[index].desglose.pasajeros.menores[i].no_pasaporte = "";
                    that.service_array[index].desglose.pasajeros.menores[i].no_visa = "";
                });
            }
        },
        changeFlightType: function(index) {
            if(this.service_array[index].desglose.escala) {
                this.service_array[index].desglose.escalas_origen = [];
                if(this.service_array[index].desglose.redondo) this.service_array[index].desglose.escalas_destino = [];
            } else {
                delete this.service_array[index].desglose.escalas_origen;
                if(this.service_array[index].desglose.redondo) delete this.service_array[index].desglose.escalas_destino;
            }
        },
        addFlightStop: function(stop_type) {
            this.key_flight_stop++;
            var nodo = stop_type == "O" ? "escalas_origen" : "escalas_destino";
            this.service_array[this.aux_index].desglose[nodo].push({
                origen: "",
                destino: "",
                fecha_origen: "",
                salida_origen: "",
                fecha_destino: "",
                llegada_destino: ""
            });
            Vue.nextTick(() => {
                feather.replace();
            })
        },
        deleteFlightStop: function(stop_type, stop_index) {
            this.key_flight_stop++;
            var nodo = stop_type == "O" ? "escalas_origen" : "escalas_destino";
            this.service_array[this.aux_index].desglose[nodo].splice(stop_index, 1);
            Vue.nextTick(() => {
                feather.replace();
            })
        },
        showFlightStophModal: function(index) {
            this.aux_index = index;
            Vue.nextTick(() => {
                feather.replace();
            })
        },
        initLibraries: function() {
            $("#dp-stay-0").flatpickr({
                mode: "range",
                dateFormat: "d/m/Y",
            });
            $("#dp-limit-0").flatpickr({
                dateFormat: "d/m/Y",
                minDate: "today"
            });
            $("#dp-customer-limit-0").flatpickr({
                dateFormat: "d/m/Y",
                minDate: "today"
            });
        },
        initSelect2Customers: function() {
            var p = $(".invoiceto");
            $(document).on("click", ".add-new-customer", (function() { p.select2("close") }))
            p.select2({
                placeholder: "Seleccione un cliente",
                data: appPrices.customers_array,
                dropdownParent: $(".invoice-customer"),
            }).on("change", (function() {
                var e = $(this);
                //console.log(e.val());
                appPrices.sale_model.id_cliente = e.val();
                var index = appPrices.customers_array.findIndex(x => x.id == e.val());
                appPrices.customer_selected = appPrices.customers_array[index];
            })).on("select2:open", (function() {
                appCustomerCrud.clearCustomerModel();
                $(".select2-search__field")[0].focus();
                $(document).find(".add-new-customer").length || $(document).find(".select2-results__options").before('<div class="add-new-customer btn btn-flat-success cursor-pointer rounded-0 text-start mb-50 p-50 w-100" data-bs-toggle="modal" data-bs-target="#cu-customers">' + feather.icons.plus.toSvg({ class: "font-medium-1 me-50" }) + '<span class="align-middle">Agregar Cliente</span></div>')
            }))
        },
        initHotelSelect2: function(index) {
            $("#slct-hotel-" + index).select2({
                placeholder: "Seleccione un hotel",
                minimumInputLength: 3,
                ajax: {
                    url: appPrices.baseUrl + "/site/searchHotel",
                    dataType: 'json',
                    processResults: function (data) {
                        appPrices.hotels_array = data;
                        return {
                            results: data
                        };
                    }
                }
            }).on("change", (function() {
                if(appPrices.hotels_array.length > 0) {
                    var e = $(this);
                    var found_index = appPrices.hotels_array.findIndex(x => x.id == e.val());
                    appPrices.service_array[index].desglose.hotel = appPrices.hotels_array[found_index].text;
                    appPrices.service_array[index].desglose.destino = appPrices.hotels_array[found_index].destino;
                }
            })).on("select2:open", (function() {
                $(".select2-search__field")[0].focus();
            }))
        },
        calculateSubtotal: function() {
            var subtotal = 0;
            this.service_array.forEach(element => {
                if (parseFloat(element.tarifa_publica)) {
                    subtotal += parseFloat(element.tarifa_publica);
                }
            });
            return this.formatter.format(subtotal);
        },
        calculateFee: function() {
            var fee = 0;
            this.service_array.forEach(element => {
                if (parseFloat(element.fee)) {
                    fee += parseFloat(element.fee);
                }
            });
            return this.formatter.format(fee);
        },
        calculateTotal: function() {
            var total = 0;
            this.service_array.forEach(element => {
                if (parseFloat(element.tarifa_publica)) {
                    if (element.tipo_comision == "%") {
                        element.costo = (element.tarifa_publica * ((100 - element.comision) / 100));
                    } else {
                        element.costo = element.tarifa_publica - element.comision_pesos;
                    }
                    appPrices.calculateCommission(element)
                    total += parseFloat(element.tarifa_publica);
                }

                if (parseFloat(element.fee)) {
                    total += parseFloat(element.fee);
                }
            });
            if(parseFloat(this.sale_model.cargo_servicios)) {
                total += parseFloat(this.sale_model.cargo_servicios);
            }
            return this.formatter.format(total);
        },
        calculateCommission: function(element) {
            if (element.tipo_comision == "%") {
                element.comision_pesos = (element.comision * element.tarifa_publica) / 100;
            } else {
                element.comision = (element.comision_pesos * 100) / element.tarifa_publica;
            }
        },
        formatPrice: function(price) {
            var aux = parseFloat(price);
            return this.formatter.format(aux) + " MXN";
        },
        formatDate: function(date_string) {
            return moment(date_string).format("DD/MM/YYYY");
        }
    }
})

$("body").on("click", ".add-new-provider", function() {
    var index = $(this).attr("data-index");
    appPrices.index_provider = index;
});

var flightStopsModal = document.getElementById('stop-flight-modal')
flightStopsModal.addEventListener('hidden.bs.modal', function (event) {
    appPrices.aux_index = -1;
})