flatpickr.localize(flatpickr.l10ns.es);
flatpickr.l10ns.default.firstDayOfWeek = 7;
const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    timer: 3000,
    showConfirmButton: false,
    //timerProgressBar: true,
});

Vue.http.options.emulateJSON = true;
var appPrices = new Vue({
    el: "#app-prices",
    mixins: [ appProveedorCreate ],
    data: {
        baseUrl: baseUrl,
        action: action,
        id_usuario: id_usuario,
        id_agencia: id_agencia,

        aux_index: -1,
        key_flight_stop: 0,
        request_model: {},
        price_model: {
            id_cotizacion: 0,
            observaciones: "",
            fecha_inicial: "",
            fecha_final: "",
            cargo_servicios: "",
            estatus: "cotizacion",
            id_usuario: 0,
            id_agencia: 0,
            id_cliente: 0,
            id_solicitud: null,
            log: "",
        },
        price_array: [],
        customers_array: [],
        customer_selected: {},

        service_types_array: [],
        hotels_array: [],

        price_flatpickr: "",
        flatpickr_array: [],
        flatpickr_arrive: [],
        flatpickr_end: [],

        array_adults: [1, 2, 3, 4, 5, 6, 7, 8],
        array_children: [0, 1, 2, 3, 4, 5],
        age_options: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17],

        contract_loading: false,
    },
    created: function() {
        this.loadCustomers();
        this.loadProviders();
        this.loadServiceTypes();
        if (this.action == "update") {
            this.loadPriceInfo();
        }
        if (this.action == "update" || with_request) {
            this.price_model.id_solicitud = request_code;
        }

        this.formatter = new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD',
        });
    },
    mounted: function() {
        this.initLibraries();

        if(with_request) {
            this.loadRequestInfo();
        }
    },
    methods: {
        saveSale: function() {
            event.preventDefault();
            //this.price_model.fecha = moment($(".date-picker").val(), "DD/MM/YYYY").format("YYYY-MM-DD");
            this.price_array.forEach((element, index) => {
                var array_dates = ($("#dp-stay-" + index).val()).split(" a ");
                appPrices.checkStayDates($("#dp-stay-" + index).val());
                appPrices.price_array[index].desglose.fecha_inicio = moment(array_dates[0], "DD/MM/YYYY").format("YYYY-MM-DD");
                fecha_final = array_dates[0];
                if (array_dates.length > 1) {
                    fecha_final = array_dates[1];
                }
                appPrices.price_array[index].desglose.fecha_fin = moment(fecha_final, "DD/MM/YYYY").format("YYYY-MM-DD");
            });
            /* if(this.price_array.fecha_inicial == "") {

            } */
            delete appPrices.price_model.cotizacionDetalles;
            delete appPrices.price_model.idSolicitud;
            var rq = {
                price: appPrices.price_model,
                price_array: appPrices.price_array
            }
            var url_rq = "",
                success_msg = "";
            if (this.action == "update") {
                url_rq = this.baseUrl + "/cotizaciones/updateApi/";
                success_msg = "Cotización actualizada";
            } else {
                url_rq = this.baseUrl + "/cotizaciones/createApi/";
                success_msg = "Cotización guardada";
            }
            this.$http.post(url_rq, rq).then(function(response) {
                this.response_aux = response.body;
                if (response.body.success) {
                    Toast.fire({
                        icon: 'success',
                        title: success_msg
                    });
                    window.location.href = this.baseUrl + '/cotizaciones/update/' + response.body.price.id_cotizacion;
                } else {
                    var error_msg = "";
                    error_msg = "<div class='text-white text-center'>Error al guardar la cotización";
                    error_msg += "<table class='table table-bordered text-white'>";

                    Object.values(response.body.errors).forEach(element => {
                        error_msg += "<tr><td>" + element + "</td></tr>";
                    });
                    error_msg += "</table>";

                    if (response.body.price_detail.errors > 0) {
                        error_msg += "<p>Error al guardar el detalle de cotización</p>";
                        error_msg += "<table class='table table-bordered text-white'>";
                        Object.values(response.body.response).forEach(element => {
                            error_msg += "<tr><td>" + element + "</td></tr>";
                        });
                        error_msg += "</table>";
                    }
                    error_msg += "</div>";
                    Swal.fire({
                        icon: 'error',
                        title: '¡Oops!',
                        html: error_msg,
                    })
                }
            }, function() {
                console.log('Error')
            })
        },
        loadRequestInfo: function() {
            this.$http.get(this.baseUrl + "/solicitudes/getRequestInfo/" + this.price_model.id_solicitud).then(function(response) {
                this.price_model.id_cliente = response.body.id_cliente;
                $(".invoiceto").val(this.price_model.id_cliente);
                $(".invoiceto").trigger("change");
            }, function() {
                console.log('Error')
            })
        },
        loadPriceInfo: function() { //se usará para cuando sea update de una cotización 
            this.$http.post(this.baseUrl + "/cotizaciones/getPriceInfo/" + price_code).then(function(response) {
                this.price_model = response.body;
                this.request_model = response.body.idSolicitud;
                this.price_array = response.body.cotizacionDetalles;
                this.price_flatpickr.setDate(moment(this.price_model.log).format("DD/MM/YYYY"));

                if(this.price_model.id_solicitud == null) {
                    var newOption = new Option(this.price_model.idCliente.nombre, this.price_model.idCliente.id_cliente, true, true);
                    $('.invoiceto').append(newOption).trigger('change');
                } else {
                    var newOption = new Option(this.price_model.idSolicitud.idCliente.nombre, this.price_model.idSolicitud.idCliente.id_cliente, true, true);
                    $('.invoiceto').append(newOption).trigger('change');
                }

                for (let index = 0; index < appPrices.price_array.length; index++) {
                    Vue.nextTick(function() {
                        feather.replace();
                        appPrices.flatpickr_array.push($("#dp-stay-" + index).flatpickr({
                            mode: "range",
                            dateFormat: "d/m/Y",
                            locale: "es",
                            onClose: function(selectedDates, dateStr, instance) {
                                // ----- REVISAR -----
                            },
                        }));
                        appPrices.flatpickr_array[index].setDate(moment(appPrices.price_array[index].desglose.fecha_inicio).format("DD/MM/YYYY") + " a " + moment(appPrices.price_array[index].desglose.fecha_fin).format("DD/MM/YYYY"));

                        appPrices.initSelect2(index);
                        $("#slct-provider-" + index).val(appPrices.price_array[index].id_proveedor);
                        
                        appPrices.initHotelSelect2(index);
                        var newOption = new Option(appPrices.price_array[index].desglose.hotel, appPrices.price_array[index].desglose.hotel, true, true);
                        $("#slct-hotel-" + index).append(newOption);

                        if(appPrices.price_array[index].desglose.escala) {
                            if(!appPrices.price_array[index].desglose.escalas_origen) appPrices.price_array[index].desglose.escalas_origen = [];
                            if(appPrices.price_array[index].desglose.redondo) {
                                if(!appPrices.price_array[index].desglose.escalas_destino) appPrices.price_array[index].desglose.escalas_destino = [];
                            }
                        }

                        setTimeout(() => {
                            if(appPrices.price_array[index].id_tipo_servicio == 1) $('#slct-hotel-' + index).trigger('change');
                            $('#slct-provider-' + index).trigger("change");
                        }, 100);
                    })
                }

            }, function() {
                console.log('Error')
            })
        },
        loadCustomers: function() {
            this.$http.get(this.baseUrl + "/ventas/searchCustomers/").then(function(response) {
                this.customers_array = response.body;
                this.initSelect2Customers();
            }, function() {
                console.log('Error')
            })
        },
        loadServiceTypes: function() {
            this.$http.get(this.baseUrl + "/tipoServicios/serviciosapi/").then(function(response) {
                this.service_types_array = response.body;
            }, function() {
                console.log('Error')
            })
        },
        changeComissionType: function(index) {
            this.price_array[index].tipo_comision = this.price_array[index].tipo_comision == "%" ? "MXN" : "%";
        },
        changeRoundService: function(index) {
            var service_date = $("#dp-stay-" + index).val();
            if(this.price_array[index].desglose.redondo) {
                appPrices.flatpickr_array[index].set("mode", "range");
                var new_date = $("#dp-stay-" + index).val() + " a " + moment($("#dp-stay-" + index).val(), "DD/MM/YYYY").add(3, "days").format("DD/MM/YYYY");
                appPrices.flatpickr_array[index].setDate(new_date);
            } else {
                if(service_date != "") {
                    var array_date = ($("#dp-stay-" + index).val()).split(" a ");
                    var new_date = array_date[0];
                    appPrices.flatpickr_array[index].setDate(new_date);
                }
                appPrices.flatpickr_array[index].set("mode", "single");
            }
        },
        addPrice: function() {
            this.price_array.push({
                desglose: {},
                observaciones: "",
                comision: "",
                comision_pesos: "",
                fee: null,
                total_neto: "",
                total_publico: "",
                id_proveedor: "",
                id_cotizacion: price_code,
                id_tipo_servicio: "",
                log: "",
            });

            var index = this.price_array.length - 1;
            Vue.nextTick(function() {
                appPrices.initSelect2(index);
                feather.replace();
            });
        },
        setPriceDetail: function(index) {
            if (this.price_array[index].desglose) {
                var desglose = {};
                if (this.price_array[index].id_tipo_servicio == 1) {
                    desglose = {
                        hotel: "",
                        destino: "",
                        fecha_fin: "",
                        fecha_inicio: "",
                        comision: "%",
                        habitaciones: [{
                            plan: "",
                            adultos: 2,
                            menores: 0,
                            edades: [],
                            ocupacion: "2 adulto(s), 0 menor(es)",
                            tipo_cama: "",
                            total_neto: "",
                            total_publico: "",
                            base_habitacion: "",
                            tipo_habitacion: ""
                        }]
                    };
                } else if (this.price_array[index].id_tipo_servicio == 2 || this.price_array[index].id_tipo_servicio == 6) {
                    desglose = {
                        redondo: 1,
                        adultos: this.price_array.length > 1 ? 0 : 2,
                        menores: 0,
                        ocupacion: "2 adulto(s), 0 menor(es)",
                        fecha_fin: "",
                        fecha_inicio: "",
                        comision: "%",
                        origen: "",
                        destino: "",
                        salida_origen: "",
                        llegada_destino: "",
                        salida_destino: "",
                        llegada_origen: "",
                        equipaje: []
                    };

                    if(this.price_array[index].id_tipo_servicio == 2) { //traslados
                        desglose.recogida_hotel = "";
                    }

                    if(this.price_array[index].id_tipo_servicio == 6) { //vuelos
                        desglose.aerolinea = "";
                        desglose.internacional = 0;
                        desglose.escala = 0;
                    }
                }  else {
                    desglose = {
                        adultos: this.price_array.length > 1 ? 0 : 2,
                        menores: 0,
                        ocupacion: "2 adulto(s), 0 menor(es)",
                        comision: "%",
                        fecha_fin: "",
                        fecha_inicio: "",
                    }
                }
                this.price_array[index].desglose = desglose;

                if(this.price_array.length > 1) {
                    var that = this;
                    var find = this.price_array.findIndex(x => x.id_tipo_servicio == this.price_array[index].id_tipo_servicio);
                    if(find >= 0 && find != index) {
                        if(this.price_array[index].id_tipo_servicio == 1) {
                            this.price_array[index].desglose.habitaciones = this.price_array[find].desglose.habitaciones;
                        } else if([ 2, 6 ].includes(parseInt(this.price_array[index].id_tipo_servicio))) {
                            this.price_array[index].desglose.adultos = this.price_array[find].desglose.adultos;
                            this.price_array[index].desglose.menores = this.price_array[find].desglose.menores;
                            this.price_array[index].desglose.ocupacion = this.price_array[find].desglose.ocupacion;
                            if(this.price_array[find].desglose.menores > 0) {
                                this.price_array[index].desglose.edades = this.price_array[find].desglose.edades;
                            }
                        }
                    } else {
                        find = this.price_array.findIndex((x, i) => x.id_tipo_servicio != this.price_array[index].id_tipo_servicio );
                        if(this.price_array[index].id_tipo_servicio == 1) {
                            this.price_array[index].desglose.habitaciones[0].adultos = this.price_array[find].desglose.adultos;
                            this.price_array[index].desglose.habitaciones[0].menores = this.price_array[find].desglose.menores;
                            this.price_array[index].desglose.habitaciones[0].ocupacion = this.price_array[find].desglose.adultos + " adulto(s), " + this.price_array[find].desglose.menores + " menor(es)";
                            if(this.price_array[index].desglose.habitaciones[0].menores.length > 0) {
                                this.price_array[find].desglose.edades.forEach(edad => {
                                    that.price_array[index].desglose.habitaciones[0].edades.push({
                                        edad: edad.edad,
                                    });
                                });
                            }
                        } else {
                            if(this.price_array[find].id_tipo_servicio == 1) {
                                this.price_array[index].desglose.adultos = 0;
                                this.price_array[index].desglose.menores = 0;
                                this.price_array[find].desglose.habitaciones.forEach(hab => {
                                    that.price_array[index].desglose.adultos += parseInt(hab.adultos);
                                    that.price_array[index].desglose.menores += parseInt(hab.menores);
                                    if(hab.menores > 0) {
                                        hab.edades.forEach(edad => {
                                            that.price_array[index].desglose.edades.push({
                                                edad: edad,
                                            })
                                        });
                                    }
                                });
                            } else {
                                if([2,6].includes(parseInt(this.price_array[index].id_tipo_servicio))) {
                                    this.price_array[index].desglose.salida_origen = this.price_array[find].desglose.salida_origen;
                                    this.price_array[index].desglose.llegada_destino = this.price_array[find].desglose.llegada_destino;
                                    this.price_array[index].desglose.salida_destino = this.price_array[find].desglose.salida_destino;
                                    this.price_array[index].desglose.llegada_origen = this.price_array[find].desglose.llegada_origen;
                                }
                                this.price_array[index].desglose.adultos = this.price_array[find].desglose.adultos;
                                this.price_array[index].desglose.menores = this.price_array[find].desglose.menores;
                                if(this.price_array[index].desglose.menores > 0) {
                                    this.price_array[index].desglose.edades = this.price_array[find].desglose.edades;
                                }

                                this.price_array[index].desglose.ocupacion = this.price_array[index].desglose.adultos + " adulto(s), " + this.price_array[index].desglose.menores + " menor(es)";
                            }
                        }
                    }
                }

                var index = this.price_array.length - 1;
                Vue.nextTick(function() {
                    feather.replace();

                    var array_date = ($("#dp-stay-0").val()).split(" a ");
                    var aux_default_date = appPrices.price_array.length > 1 ? [array_date[0], array_date[1]] : [moment().format("DD/MM/YYYY"), moment().add(3, 'days').format("DD/MM/YYYY")];

                    appPrices.flatpickr_array.splice(index, 1);
                    appPrices.flatpickr_array.push(flatpickr(("#dp-stay-" + index), {
                        mode: "range",
                        dateFormat: "d/m/Y",
                        defaultDate: aux_default_date,
                        minDate: "today",
                        onValueUpdate: function(dObj, dStr, fp, dayElem) {
                            if (appPrices.price_model.fecha_inicial == "") {
                                var dateAux = dStr.split(" a ");
                                if(dateAux.length > 1) {
                                    dateAux.forEach((dateItem, i) => {
                                        if (i == 0) {
                                            appPrices.price_model.fecha_inicial = moment(dateItem, "DD/MM/YYYY").format("YYYY-MM-DD");
                                        } else {
                                            appPrices.price_model.fecha_final = moment(dateItem, "DD/MM/YYYY").format("YYYY-MM-DD");
                                        }
                                    })
                                }
                            } else {
                                var start_date = moment(appPrices.price_model.fecha_inicial, "DD/MM/YYYY").format("YYYY-MM-DD");
                                var end_date = moment(appPrices.price_model.fecha_final, "DD/MM/YYYY").format("YYYY-MM-DD");
                                var dateAux = dStr.split(" a ");
                                dateAux.forEach((dateItem, i) => {
                                    var formatDate = moment(dateItem, "DD/MM/YYYY").format("YYYY-MM-DD");
                                    if (i == 0 && moment(formatDate).isBefore(start_date)) {
                                        appPrices.price_model.fecha_inicial = moment(dateItem, "DD/MM/YYYY").format("YYYY-MM-DD");
                                    } else if (i == 1 && moment(formatDate).isAfter(end_date)) {
                                        appPrices.price_model.fecha_final = moment(dateItem, "DD/MM/YYYY").format("YYYY-MM-DD");
                                    } else {
                                        console.log(dateItem, appPrices.price_model.fecha_inicial, appPrices.price_model.fecha_final);
                                    }
                                });
                            }
                        },
                    }));
                    
                    appPrices.initHotelSelect2(index);
                })
            }
        },
        removePrice: function(index) {
            this.price_array.splice(index, 1);
        },
        addRoom: function(index) {
            this.price_array[index].desglose.habitaciones.push({
                plan: "",
                adultos: "2",
                menores: "0",
                ocupacion: "2 adulto(s), 0 menor(es)",
                tipo_cama: "",
                total_neto: "",
                total_publico: "",
                base_habitacion: "",
                tipo_habitacion: ""
            });
            Vue.nextTick(function() {
                feather.replace();
            });
        },
        deleteRoom: function(index_price, index) {
            this.price_array[index_price].desglose.habitaciones.splice(index, 1);
        },
        changeOccupancy: function(index_price, index = -1) {
            if(index >= 0) {
                this.price_array[index_price].desglose.habitaciones[index].ocupacion = this.price_array[index_price].desglose.habitaciones[index].adultos + " adulto(s), " + this.price_array[index_price].desglose.habitaciones[index].menores + " menor(es)";
                this.price_array[index_price].desglose.habitaciones[index].edades = [];
                var no_menores = this.price_array[index_price].desglose.habitaciones[index].menores;
                var that = this;
                for (let i = 0; i < no_menores; i++) {
                    that.price_array[index_price].desglose.habitaciones[index].edades.push({ edad: 0 });
                }
            } else {
                this.price_array[index_price].desglose.ocupacion = this.price_array[index_price].desglose.adultos + " adulto(s), " + this.price_array[index_price].desglose.menores + " menor(es)";
                this.price_array[index_price].desglose.edades = [];
                var no_menores = this.price_array[index_price].desglose.menores;
                var that = this;
                for (let i = 0; i < no_menores; i++) {
                    that.price_array[index_price].desglose.edades.push({ edad: 0 });
                }
            }
        },
        changeFlightType: function(index) {
            if(this.price_array[index].desglose.escala) {
                this.price_array[index].desglose.escalas_origen = [];
                if(this.price_array[index].desglose.redondo) this.price_array[index].desglose.escalas_destino = [];
            } else {
                delete this.price_array[index].desglose.escalas_origen;
                if(this.price_array[index].desglose.redondo) delete this.price_array[index].desglose.escalas_destino;
            }
        },
        addFlightStop: function(stop_type) {
            this.key_flight_stop++;
            var nodo = stop_type == "O" ? "escalas_origen" : "escalas_destino";
            this.price_array[this.aux_index].desglose[nodo].push({
                origen: "",
                destino: "",
                fecha_origen: "",
                salida_origen: "",
                fecha_destino: "",
                llegada_destino: ""
            });
            Vue.nextTick(() => {
                feather.replace();
            })
        },
        deleteFlightStop: function(stop_type, stop_index) {
            this.key_flight_stop++;
            var nodo = stop_type == "O" ? "escalas_origen" : "escalas_destino";
            this.price_array[this.aux_index].desglose[nodo].splice(stop_index, 1);
            Vue.nextTick(() => {
                feather.replace();
            })
        },
        showFlightStophModal: function(index) {
            this.aux_index = index;
            Vue.nextTick(() => {
                feather.replace();
            })
        },
        initLibraries: function() {
            var i = new Date;
            if (this.action == "update") {
                this.price_flatpickr = $(".date-picker").flatpickr({
                    defaultDate: i,
                    dateFormat: "d/m/Y",
                    locale: "es"
                });
            }
            /* $("#dp-stay-0").flatpickr({
                mode: "range",
                dateFormat: "d/m/Y",
                locale: "es",
                onClose: function(selectedDates, dateStr, instance) {
                    console.log(selectedDates);
                    console.log(dateStr);
                    console.log(instance);
                },
            });
            $("#tp-arrive-0").flatpickr({
                dateFormat: "d/m/Y",
                locale: "es",
                minDate: "today"
            });
            $("#tp-end-0").flatpickr({
                dateFormat: "d/m/Y",
                locale: "es",
                minDate: "today"
            }); */
        },
        initSelect2Customers: function() {
            var p = $(".invoiceto");
            $(document).on("click", ".add-new-customer", (function() { p.select2("close") }))
            p.select2({
                placeholder: "Seleccione un cliente",
                data: appPrices.customers_array,
                dropdownParent: $(".invoice-customer"),
            }).on("change", (function() {
                var e = $(this);
                appPrices.price_model.id_cliente = e.val();
                var index = appPrices.customers_array.findIndex(x => x.id == e.val());
                appPrices.customer_selected = appPrices.customers_array[index];
            })).on("select2:open", (function() {
                appCustomerCrud.clearCustomerModel();
                $(".select2-search__field")[0].focus();
                $(document).find(".add-new-customer").length || $(document).find(".select2-results__options").before('<div class="add-new-customer btn btn-flat-success cursor-pointer rounded-0 text-start mb-50 p-50 w-100" data-bs-toggle="modal" data-bs-target="#cu-customers">' + feather.icons.plus.toSvg({ class: "font-medium-1 me-50" }) + '<span class="align-middle">Agregar Cliente</span></div>')
            }))
        },
        initHotelSelect2: function(index) {
            $("#slct-hotel-" + index).select2({
                placeholder: "Seleccione un hotel",
                minimumInputLength: 3,
                ajax: {
                    url: appPrices.baseUrl + "/site/searchHotel",
                    dataType: 'json',
                    processResults: function (data) {
                        appPrices.hotels_array = data;
                        return {
                            results: data
                        };
                    }
                }
            }).on("change", (function() {
                if(appPrices.hotels_array.length > 0) {
                    var e = $(this);
                    var found_index = appPrices.hotels_array.findIndex(x => x.id == e.val());
                    appPrices.price_array[index].desglose.hotel = appPrices.hotels_array[found_index].text;
                    appPrices.price_array[index].desglose.destino = appPrices.hotels_array[found_index].destino;
                }
            })).on("select2:open", (function() {
                $(".select2-search__field")[0].focus();
            }))
        },
        initSelect2: function(index) {
            $(document).on("click", ".add-new-provider", (function() { $("#slct-provider-" + index).select2("close") }))
            $("#slct-provider-" + index).select2({
                placeholder: "Seleccione un proveedor",
                data: appPrices.providers_array,
            }).on("change", (function() {
                var e = $(this);
                var index = e.attr('data-index');
                appPrices.price_array[index].id_proveedor = e.val();
                var index_provider = appPrices.providers_array.findIndex(x => x.id == e.val());
                if(appPrices.providers_array[index_provider].comision != null) appPrices.price_array[index].comision = appPrices.providers_array[index_provider].comision;
            })).on("select2:open", (function() {
                $(".select2-search__field")[0].focus();
                $(document).find(".add-new-provider").length || $(document).find(".select2-results__options").before('<div class="add-new-provider btn btn-flat-success cursor-pointer rounded-0 text-start mb-50 p-50 w-100" data-bs-toggle="modal" data-bs-target="#add-new-provider-sidebar" data-index="' + index + '">' + feather.icons.plus.toSvg({ class: "font-medium-1 me-50" }) + '<span class="align-middle">Agregar Proveedor</span></div>')
            }))
        },
        calculateSubtotal: function() {
            var subtotal = 0;
            this.price_array.forEach(element => {
                if (parseFloat(element.total_publico)) {
                    subtotal += parseFloat(element.total_publico);
                }
            });
            return this.formatter.format(subtotal);
        },
        calculateFee: function() {
            var fee = 0;
            this.price_array.forEach(element => {
                if (parseFloat(element.fee)) {
                    fee += parseFloat(element.fee);
                }
            });
            return this.formatter.format(fee);
        },
        calculateTotal: function() {
            var total = 0;
            var that = this;
            this.price_array.forEach(element => {
                if (parseFloat(element.total_publico) || element.id_tipo_servicio == 1) {
                    that.calculateCommission(element);
                    if (element.comision_pesos > 0) {
                        element.costo = element.total_publico - element.comision_pesos;
                    } else {
                        element.costo = (element.total_publico * ((100 - element.comision) / 100));
                    }
                    total += parseFloat(element.total_publico);
                }

                if (parseFloat(element.fee)) {
                    total += parseFloat(element.fee);
                }
            });
            if(parseFloat(this.price_model.cargo_servicios)) {
                total += parseFloat(this.price_model.cargo_servicios);
            }
            return this.formatter.format(total);
        },
        calculateCommission: function(element) {
            /* if (element.desglose.comision == "%") {
                element.comision_pesos = (element.comision * element.total_publico) / 100;
            } else {
                element.comision = (element.comision_pesos * 100) / element.total_publico;
            } */
            if (element.desglose.comision == "%") {
                var aux_com = element.comision / 100;

                if (element.id_tipo_servicio == 1) {
                    var total_item = 0;
                    element.desglose.habitaciones.forEach(item => {
                        if (item.total_publico > 0) {
                            total_item += parseFloat(item.total_publico);
                            item.total_neto = (parseFloat(item.total_publico) / (1 + aux_com)).toFixed(2);
                        }
                    });

                    element.total_publico = total_item;
                }

                if (element.total_publico > 0) {
                    element.total_neto = (element.total_publico / (1 + aux_com)).toFixed(2);
                    element.comision_pesos = (element.total_publico - element.total_neto).toFixed(2);
                }
            } else {
                if (element.comision_pesos > 0) {

                    var aux_neto = (element.total_publico - element.comision_pesos).toFixed(2);
                    element.total_neto = aux_neto;
                    element.comision = (((element.total_publico / aux_neto) * 100) - 100).toFixed(2);
                }
            }
        },
        changeComissionType: function(index) {
            this.price_array[index].desglose.comision = this.price_array[index].desglose.comision == "%" ? "MXN" : "%";
        },
        onCloseFlapickr: function(selectedDates, dateStr, instance) {
            appPrices.checkStayDates(dateStr);
        },
        checkStayDates: function(dateStr){
            if (appPrices.price_model.fecha_inicial == "") {
                var dateAux = dateStr.split(" a ");
                dateAux.forEach((dateItem, index) => {
                    if (index == 0) {
                        appPrices.price_model.fecha_inicial = moment(dateItem, "DD/MM/YYYY").format("YYYY-MM-DD");
                    } else {
                        appPrices.price_model.fecha_final = moment(dateItem, "DD/MM/YYYY").format("YYYY-MM-DD");
                    }
                })
            } else {
                var start_date = moment(appPrices.price_model.fecha_inicial, "DD/MM/YYYY").format("YYYY-MM-DD");
                var end_date = moment(appPrices.price_model.fecha_final, "DD/MM/YYYY").format("YYYY-MM-DD");
                var dateAux = dateStr.split(" a ");
                dateAux.forEach((dateItem, index) => {
                    var formatDate = moment(dateItem, "DD/MM/YYYY").format("YYYY-MM-DD");
                    if (index == 0 && moment(formatDate).isBefore(start_date)) {
                        appPrices.price_model.fecha_inicial = moment(dateItem, "DD/MM/YYYY").format("YYYY-MM-DD");
                    } else if (index == 1 && moment(formatDate).isAfter(end_date)) {
                        appPrices.price_model.fecha_final = moment(dateItem, "DD/MM/YYYY").format("YYYY-MM-DD");
                    } else {
                    }
                })
            }
        },
        formatPrice: function(price) {
            var aux = parseFloat(price);
            return this.formatter.format(aux) + " MXN";
        },
        formatDate: function(date_string) {
            return moment(date_string).format("DD/MM/YYYY");
        }
    }
})

$("body").on("click", ".add-new-provider", function() {
    var index = $(this).attr("data-index");
    appPrices.index_provider = index;
});

var flightStopsModal = document.getElementById('stop-flight-modal')
flightStopsModal.addEventListener('hidden.bs.modal', function (event) {
    appPrices.aux_index = -1;
})