const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    timer: 3000,
    showConfirmButton: false,
    //timerProgressBar: true,
});

Vue.http.options.emulateJSON = true;
var appPrices = new Vue({
    el: "#prices-index",
    data: {
        baseUrl: baseUrl,
        formatter: "",

        prices_array: [],
    },
    created: function() {
        this.formatter = new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD',
        });
    },
    mounted: function() {
        this.loadPriceTable();
    },
    methods: {
        getPrices: function() {
            this.$http.get(this.baseUrl + "/cotizaciones/getPrices").then(function(response) {
                this.prices_array = response.body;

                Vue.nextTick(function() {
                    feather.replace();
                });
            }, function() {
                console.log('Error')
            })
        },
        deletePrice: function(price_code) {
            this.$http.get(this.baseUrl + "/cotizaciones/deleteApi/" + price_code).then(function(response) {
                if(response.body.success) {
                    this.accounts_table.ajax.reload();
                    Toast.fire({
                        icon: 'success',
                        title: 'Pagos eliminados'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: '¡Ops!',
                        text: 'Algo salió mal',
                    })
                }

                Vue.nextTick(function() {
                    feather.replace();
                });
            }, function() {
                console.log('Error')
            })
        },
        loadPriceTable: function() {
            var that = this;
            var url_rq = this.baseUrl + "/cotizaciones/getPrices";
            this.accounts_table = $("#price-table").DataTable({
                scrollX: true,
                bDestroy: true,
                scrollCollapse: true,
                language: { url: "//cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                ajax: {
                    "url": url_rq,
                    "dataSrc": function(json) {
                        that.prices_array = json;
                        return json;
                    }
                },
                order: [[4, 'desc']],
                columns: [{
                    data: "id_cuenta",
                    render: function(data, type, row, meta) {
                        return meta.row + 1;
                    }
                }, {
                    title: "Cliente",
                    data: "idCliente.nombre",
                }, {
                    title: "Fecha creación",
                    data: "log",
                    render: $.fn.dataTable.render.moment("YYYY-MM-DD HH:mm:ss", "DD/MM/YYYY HH:mm:ss")
                }, {
                    title: "Estancia",
                    render: function(data, type, row, meta) {
                        return moment(row.fecha_inicial).format("DD/MM/YYYY") + " a " + moment(row.fecha_final).format("DD/MM/YYYY");
                    }
                }, {
                    title: "T. Pública",
                    render: function(data, type, row, meta) {
                        var total = 0;
                        row.cotizacionDetalles.forEach(element => {
                            total += parseFloat(element.total_publico);
                            if(!isNaN(parseFloat(element.fee))) {
                                total += parseFloat(element.fee);
                            }
                        });
                        return that.formatter.format(total);
                    }
                }, {
                    title: "Agente",
                    data: "idUsuario.username"
                }, {
                    title: "Estatus",
                    render: function(data, type, row, meta) {
                        return row.estatus == "cotizacion" ? "Cotización" : "Contrato";
                    }
                }, {
                    title: "",
                    sortable: false,
                    render: function(data, type, row, meta) {
                        var options = '<a href="'+ that.baseUrl +'/cotizaciones/update/' + row.id_cotizacion + '">' + feather.icons.eye.toSvg() + '</a>';
                        if(row.estatus != "venta") {
                            options += '<a class="ms-50" href="javascript:void(0)" onclick="appPrices.showDeleteAlert(' + row.id_cotizacion + ')">' + feather.icons.trash.toSvg() + '</a>';
                        }
                        return options;
                    }
                }]
            });
        },
        showDeleteAlert: function(price_code) {
            Swal.fire({
                title: '¿Seguro?',
                text: "¿Está seguro que desea eliminar la cotización?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Confirmar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    appPrices.deletePrice(price_code)
                }
            });
        },
        getTotalPrice: function(price) {
            var total = 0;
            price.cotizacionDetalles.forEach(item => {
                total += parseFloat(item.total_publico);
            });
            return this.formatPrice(total);
        },
        getTotalBooking: function(bookings) {
            var total = 0;
            bookings.forEach(element => {
                total += parseFloat(element.total_publico);
            });
            return this.formatPrice(total);
        },
        formatDate: function(string_date) {
            return moment(string_date).format("DD/MM/YYYY");
        },
        formatPrice: function(price) {
            var aux = parseFloat(price);
            return aux ? this.formatter.format(aux) + " MXN" : "0.00 MXN";
        },
    }
})