var formatter = new Intl.NumberFormat('en-US', {
    style: 'currency',
    currency: 'USD',
    minimumFractionDigits: 2
    // These options are needed to round to whole numbers if that's what you want.
    //minimumFractionDigits: 0, // (this suffices for whole numbers, but will print 2500.10 as $2,500.1)
    //maximumFractionDigits: 0, // (causes 2500.99 to be printed as $2,501)
});

var cuentasPorCobrar = new Vue({
    el: '#cuentasPorCobrar',
    data: {
        baseUrl: baseUrl,
        sales_array: [],
    },
    mounted: function () {
        this.loadSalesTable();
    },
    methods: {
        loadSalesTable: function () {

            $("#cobrar-datatable thead tr").clone(!0).appendTo("#cobrar-datatable thead"), $("#cobrar-datatable thead tr:eq(1) th").each((function (t) {
                var a = $(this).text();
                if (t != 9) {
                    $(this).html('<input type="text" class="form-control form-control-sm" placeholder="BUSCAR ' + a + '" />'), $("input", this).on("keyup change", (function () {
                        cuentasPorCobrar.sales_table.column(t).search() !== this.value && cuentasPorCobrar.sales_table.column(t).search(this.value).draw();
                    }))
                }
            }));

            var url_rq = this.baseUrl + "/caja/getServicesSalesAgency";
            this.sales_table = $("#cobrar-datatable").DataTable({
                language: { url: "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                scrollX: true,
                ajax: {
                    "url": url_rq,
                    "dataSrc": function (json) {
                        cuentasPorCobrar.sales_array = json;
                        return json;
                    }
                },
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"B><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                bDestroy: true,
                buttons: [{
                    extend: "collection",
                    className: "btn btn-outline-secondary dropdown-toggle me-2",
                    text: feather.icons.share.toSvg({ class: "font-small-4 me-50" }) + "Exportar",
                    buttons: [{
                        extend: "csv",
                        text: feather.icons["file-text"].toSvg({ class: "font-small-4 me-50" }) + "Csv",
                        className: "dropdown-item",
                        //exportOptions: { columns: [3, 4, 5, 6, 7] } 
                    }, {
                        extend: "excel",
                        text: feather.icons.file.toSvg({ class: "font-small-4 me-50" }) + "Excel",
                        className: "dropdown-item",
                    }, {
                        extend: "pdf",
                        text: feather.icons.clipboard.toSvg({ class: "font-small-4 me-50" }) + "Pdf",
                        className: "dropdown-item",
                    }, {
                        extend: "copy",
                        text: feather.icons.copy.toSvg({ class: "font-small-4 me-50" }) + "Copiar",
                        className: "dropdown-item",
                    }],
                    init: function (e, t, a) {
                        $(t).removeClass("btn-secondary"), $(t).parent().removeClass("btn-group"), setTimeout((function () { $(t).closest(".dt-buttons").removeClass("btn-group").addClass("d-inline-flex") }), 50)
                    }
                }],
                "drawCallback": function (settings, json) {
                    cuentasPorCobrar.addCssToTable();
                },
                scrollCollapse: true,
                columns: [{
                    data: "idVenta.folio",
                    render: function (data, type, row, meta) {
                        return "<a href='" + this.baseUrl + "/ventas/update/" + row.idVenta.id_venta + "'>" + data + "</a>";
                    }
                }, {
                    data: 'idVenta.pasajero_titular',
                    render: function (data, type, row, meta) {
                        if (typeof data == "undefined" || data == "") {
                            return "Sin pasajeros";
                        } else {
                            return data;
                        }
                    }
                }, {
                    data: 'descripcion',
                    render: function (data, type, row, meta) {
                        if (typeof data == "undefined" || data == "") {
                            return "Sin descripción";
                        } else {
                            return data;
                        }
                    }
                },
                // {
                //     data: 'idVenta.idTipoVenta.tipo',
                //     render: function(data, type, row, meta) {
                //         if (typeof data == "undefined" || data == "") {
                //             return "NA";
                //         } else {
                //             return data;
                //         }
                //     }
                // }, 
                {
                    data: 'idVenta.perteneceA.folio',
                    render: function (data, type, row, meta) {
                        if (typeof data == "undefined" || data == "") {
                            return "NA";
                        } else {
                            return data;
                        }
                    }
                }, {
                    data: 'log',
                    render: function (data, type, row, meta) {
                        return moment(data).format("DD/MM/YYYY").replace('.', '');
                    }
                }, {
                    data: null,
                    render: function (data, type, row, meta) {
                        return row.limite_agencia == null ? moment(row.fecha_limite).format("DD/MM/YYYY") : moment(row.limite_agencia).format("DD/MM/YYYY");
                    }
                }, {
                    data: null,
                    className: "text-right",
                    width: "12%",
                    render: function (data, type, row, meta) {
                        var total = parseFloat(row.tarifa_publica);
                        if (parseFloat(row.fee)) total += parseFloat(row.fee);
                        return $.fn.dataTable.render.number(',', '.', 2, '$').display(total);
                        //return "$ " + (redondear / 1).toFixed(2).replace(',', '.').toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                    }
                }, {
                    data: null,
                    className: "text-right",
                    width: "12%",
                    render: function (data, type, row, meta) {
                        var payments = 0;
                        row.pagosDetalles.forEach(payment => {
                            payments += parseFloat(payment.monto);
                        });
                        return $.fn.dataTable.render.number(',', '.', 2, '$').display(payments);
                        //return "$ " + (redondear / 1).toFixed(2).replace(',', '.').toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                    }
                }, {
                    data: null,
                    className: "text-right",
                    width: "12%",
                    render: function (data, type, row, meta) {
                        var total = parseFloat(row.tarifa_publica);
                        if (parseFloat(row.fee)) total += parseFloat(row.fee);

                        var payments = 0;
                        row.pagosDetalles.forEach(payment => {
                            payments += parseFloat(payment.monto);
                        });
                        var balance = parseFloat(total - payments);

                        return $.fn.dataTable.render.number(',', '.', 2, '$').display(balance);
                        //return "$ " + (balance / 1).toFixed(2).replace(',', '.').toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                    }
                }],
                footerCallback: function (row, data, start, end, display) {
                    var api = this.api();

                    // Recalcular totales
                    var total = 0,
                        payments = 0,
                        balance = 0;

                    api.rows({ page: 'current' }).data().each(function (rowData) {
                        total += parseFloat(rowData.tarifa_publica);
                        if (parseFloat(rowData.fee)) total += parseFloat(rowData.fee);

                        rowData.pagosDetalles.forEach(payment => {
                            payments += parseFloat(payment.monto);
                        });
                    });

                    balance = total - payments;

                    var total_general = 0,
                        payments_general = 0,
                        balance_general = 0;
                    data.forEach(element => {
                        total_general += parseFloat(element.tarifa_publica);
                        if (parseFloat(element.fee)) total_general += parseFloat(element.fee);

                        element.pagosDetalles.forEach(payment => {
                            payments_general += parseFloat(payment.monto);
                        });
                    });
                    balance_general = total_general - payments_general;

                    let intVal = function (i) {
                        return typeof i === 'string'
                            ? i.replace(/[\$,]/g, '') * 1
                            : typeof i === 'number'
                                ? i
                                : 0;
                    };


                    // Actualizar los valores en los footers
                    $(api.column(5, { page: 'current' }).footer()).html($.fn.dataTable.render.number(',', '.', 2, '$').display(total));
                    $(api.column(6, { page: 'current' }).footer()).html($.fn.dataTable.render.number(',', '.', 2, '$').display(payments));
                    $(api.column(7, { page: 'current' }).footer()).html($.fn.dataTable.render.number(',', '.', 2, '$').display(balance));

                    setTimeout(() => {
                        $('.global-totals #total_general').html($.fn.dataTable.render.number(',', '.', 2, '$').display(total_general))
                        $('.global-totals #pagado_general').html($.fn.dataTable.render.number(',', '.', 2, '$').display(payments_general))
                        $('.global-totals #saldo_general').html($.fn.dataTable.render.number(',', '.', 2, '$').display(balance_general))
                    }, 1000);
                }



            });
        },

        addCssToTable: function () {
            setTimeout(() => { }, 1000);
        },
    }
});