var formatter = new Intl.NumberFormat('en-US', {
    style: 'currency',
    currency: 'USD',
    minimumFractionDigits: 2
        // These options are needed to round to whole numbers if that's what you want.
        //minimumFractionDigits: 0, // (this suffices for whole numbers, but will print 2500.10 as $2,500.1)
        //maximumFractionDigits: 0, // (causes 2500.99 to be printed as $2,501)
});
var appCuentasPorCobrar = new Vue({
    el: '#cuentasPorCobrar',
    data: {
        baseUrl: baseUrl,
        sales_array: [],
        proveedores_array: [],
        servicios_array: [],
        service_table: '',
        filters: {
            minDate: moment().startOf('year').format('DD/MM/YYYY'),
            maxDate: moment().endOf('year').format('DD/MM/YYYY'),
            provider: '0',
            service: '0'
        }
    },
    created: function() {
        this.loadProviders();
        this.loadServices();
    },
    mounted: function() {
        this.initFlatpickr();
        this.loadServiceTable();
    },
    methods: {
        loadServices: function() {
            this.$http.get(this.baseUrl + '/reportes/obtenerServicios').then(response => {
                this.servicios_array = response.data;
            }, response => console.log(response));
        },
        loadProviders: function() {
            this.$http.get(this.baseUrl + '/proveedores/ProveedoresApi').then(response => {
                this.proveedores_array = response.data;
            }, response => console.log(response));
        },
        loadServiceTable: function() {
            var data = {
                "minDate": moment($("#min-date").val(), "DD/MM/YYYY").format("YYYY-MM-DD"),
                "maxDate": moment($("#max-date").val(), "DD/MM/YYYY").format("YYYY-MM-DD"),
                "proveedorSelected": this.filters.provider,
                "servicioSelected": this.filters.service,
            }
            var url_rq = this.baseUrl + "/caja/getServicesSalesAgency";
            var table = $(".datatable");
            this.service_table = table.DataTable({
                language: { url: "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                scrollX: true,
                ajax: {
                    "url": url_rq,
                    "type": 'POST',
                    "data": data,
                    "dataSrc": function(json) {
                        appCuentasPorCobrar.sales_array = json;
                        return json;
                    }
                },
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"B><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                bDestroy: true,
                buttons: [{
                    extend: "collection",
                    className: "btn btn-outline-secondary dropdown-toggle me-2",
                    text: feather.icons.share.toSvg({ class: "font-small-4 me-50" }) + "Exportar",
                    buttons: [{
                        extend: "csv",
                        text: feather.icons["file-text"].toSvg({ class: "font-small-4 me-50" }) + "Csv",
                        className: "dropdown-item",
                        //exportOptions: { columns: [3, 4, 5, 6, 7] } 
                    }, {
                        extend: "excel",
                        text: feather.icons.file.toSvg({ class: "font-small-4 me-50" }) + "Excel",
                        className: "dropdown-item",
                    }, {
                        extend: "pdf",
                        text: feather.icons.clipboard.toSvg({ class: "font-small-4 me-50" }) + "Pdf",
                        className: "dropdown-item",
                    }, {
                        extend: "copy",
                        text: feather.icons.copy.toSvg({ class: "font-small-4 me-50" }) + "Copiar",
                        className: "dropdown-item",
                    }],
                    init: function(e, t, a) {
                        $(t).removeClass("btn-secondary"), $(t).parent().removeClass("btn-group"), setTimeout((function() { $(t).closest(".dt-buttons").removeClass("btn-group").addClass("d-inline-flex") }), 50)

                    }
                }],
                scrollCollapse: true,
                columns: [{
                    data: 'idVenta.folio',
                    title: 'Folio',
                    render: function(data, type, row, meta) {
                        if (typeof row.id_venta === "undefined" || row.id_venta === "") {
                            return 'Sin Código';
                        } else {
                            return "<a href='" + this.baseUrl + "/ventas/update/" + row.id_venta + "'>" + data + "</a>";
                        }
                    }
                }, {
                    title: 'Proveedor',
                    data: 'idProveedor.nombre_comercial',
                    render: function(data, type, row, meta) {
                        return typeof data === "undefined" ? "Sin proveedor" : data;
                    }
                }, {
                    title: 'Servicio',
                    data: 'idTipoServicio.tipo_servicio',
                    render: function(data, type, row, meta) {
                        return typeof data === "undefined" ? "Sin servicio" : data;
                    }
                }, {
                    data: 'fecha_limite',
                    title: 'Lim. Pago',
                    render: function(data, type, row, meta) {
                        return moment(data).format("DD/MM/YYYY");
                    }
                }, {
                    data: 'comision',
                    title: 'Comisión',
                    render: function(data, type, row, meta) {
                        return typeof data === "undefined" ? "Sin comisión" : data + "%";
                    }
                }, {
                    data: 'costo',
                    title: 'Costo',
                    className: 'text-right',
                    render: function(data, type, row, meta) {
                        return typeof data === "undefined" || data === "" ? "Sin registro" : $.fn.dataTable.render.number(',', '.', 2, '$').display(data);
                    }
                }, {
                    data: null,
                    title: 'Pagos',
                    className: 'text-right',
                    render: function(data, type, row, meta) {
                        var payments = 0;
                        row.pagosProveedores.forEach(element => {
                            payments += parseFloat(element.monto);
                        });
                        return $.fn.dataTable.render.number(',', '.', 2, '$').display(payments);
                    }
                }, {
                    data: null,
                    title: 'Saldo',
                    className: 'text-right',
                    render: function(data, type, row, meta) {
                        var payments = 0;
                        row.pagosProveedores.forEach(element => {
                            payments += parseFloat(element.monto);
                        });
                        var cost = 0;
                        if (typeof row.costo !== "undefined" || row.costo !== "") {
                            cost = parseFloat(row.costo);
                        }

                        return $.fn.dataTable.render.number(',', '.', 2, '$').display(cost - payments);
                    }
                }, {
                    data: 'descripcion',
                    title: 'Descripción',
                    render: function(data, type, row, meta) {
                        if (typeof data === "undefined" || data === "") {
                            return 'Sin Descripción';
                        } else {
                            return data;
                        }
                    }
                }, ],
                footerCallback: function(row, data, start, end, display) {
                    var api = this.api();
                    var cost = 0,
                        payments = 0,
                        balance = 0;
                    data.forEach(service => {
                        cost += parseFloat(service.costo);

                        service.pagosProveedores.forEach(payment => {
                            payments += parseFloat(payment.monto);
                        });
                    });
                    balance = cost - payments;

                    $(api.column(5).footer()).html($.fn.dataTable.render.number(',', '.', 2, '$').display(cost));
                    $(api.column(6).footer()).html($.fn.dataTable.render.number(',', '.', 2, '$').display(payments));
                    $(api.column(7).footer()).html($.fn.dataTable.render.number(',', '.', 2, '$').display(balance));
                }
            });
        },
        clearFilters() {
            this.filters.minDate = moment().startOf('year').format('DD/MM/YYYY');
            this.filters.maxDate = moment().endOf('year').format('DD/MM/YYYY');
            this.filters.provider = "0";
            this.filters.service = "0";
            this.loadAgencySales();
        },
        initFlatpickr: function() {
            $("#min-date").flatpickr({
                dateFormat: "d/m/Y",
                locale: "es"
            });
            $("#max-date").flatpickr({
                dateFormat: "d/m/Y",
                locale: "es"
            });
        }
    },
})