const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: false,
})

Vue.http.options.emulateJSON = true;
var appExpenses = new Vue({
    el: "#expenses-app",
    mixins: [ appProveedorCreate ],
    data: {
        baseUrl: baseUrl,
        accounts_array: [],
        ways_to_pay: [],

        expense_model: {
            id_gasto: 0,
            descripcion: "",
            fecha_gasto: "",
            importe: "",
            referencia: "",
            id_forma_pago: 1,
            id_cuenta: 1,
            beneficiario: "",
            comprobante: "upload.png",
            observaciones: "",
            id_proveedor: null,
        },
        expenses_array: [],
        expenses_table: "",
    },
    mounted: function() {
        this.loadWaysToPay();
        this.loadProviders();
        this.loadAgencyAccounts();
        this.loadExpensesTable();

        this.initLibraries();
    },
    methods: {
        saveExpense: function() {
            var form_data = this.getFormData();
            this.$http.post(this.baseUrl + '/gastos/create/', form_data).then(function(response) {
                $('#cu-expenses').modal('hide');
                this.expenses_table.ajax.reload();
                if (response.body.id_gasto) {
                    Toast.fire({
                        icon: 'success',
                        text: 'Se registró el gasto.'
                    });
                } else {
                    var error_table = "<table class='table table-bordered table-striped'><tr>"
                    Object.values(response.body).forEach(element => {
                        error_table += "<td>" + element + "</td>";
                    });
                    error_table += "</tr></table>";
                    Swal.fire({
                        title: '¡Ops!',
                        icon: 'error',
                        html: "<p>Algo salió mal</p>" + error_table,
                    });
                }
            }, function(e) {
                console.log(e);
            });
        },
        updateExpense: function() {
            var form_data = this.getFormData();
            this.$http.post(this.baseUrl + '/gastos/update/', form_data).then(function(response) {
                $('#cu-expenses').modal('hide');
                this.expenses_table.ajax.reload();
                if (response.body.id_gasto) {
                    Toast.fire({
                        icon: 'success',
                        text: 'Se ha actualizado el registro'
                    });
                } else {
                    var error_table = "<table class='table table-bordered table-striped'><tr>"
                    Object.values(response.body).forEach(element => {
                        error_table += "<td>" + element + "</td>";
                    });
                    error_table += "</tr></table>";
                    Swal.fire({
                        title: '¡Ops!',
                        icon: 'error',
                        html: "<p>Algo salió mal</p>" + error_table,
                    });
                }
            }, function(e) {
                console.log(e);
            });
        },
        deleteExpense: function(index) {
            var id_gasto = this.expenses_array[index].id_gasto;
            Swal.fire({
                title: '¿Seguro?',
                text: "Eliminará el gasto registrado",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Confirmar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    this.$http.post(this.baseUrl + '/gastos/delete/' + id_gasto).then(function(response) {
                        appExpenses.clearModel();
                        var response_var = response.body;
                        if (response_var.success) {
                            appExpenses.expenses_table.ajax.reload();
                            Toast.fire({
                                icon: 'success',
                                text: 'Se eliminó el gasto.'
                            });
                        } else {
                            Toast.fire({
                                icon: 'error',
                                text: "Algo salió mal, recargue la página e intentelo de nuevo",
                            });
                        }
                    }, function(e) {
                        console.log(e);
                        Swal.fire({
                            type: 'error',
                            title: "¡Ops!",
                            html: "Algo salió mal. <div class='mt-1>" + e.body.data.message + "</div>",
                        });
                    });
                }
            });
        },
        loadAgencyAccounts: function() {
            this.$http.get(this.baseUrl + '/cuentasAgencia/getAgencyAccounts').then(function(response) {
                this.accounts_array = response.body;
            }, function(e) {
                console.log(e);
            });
        },
        loadWaysToPay: function() {
            this.$http.get(this.baseUrl + '/caja/getWaysToPay').then(function(response) {
                this.ways_to_pay = response.body;
            }, function(e) {
                console.log(e);
            });
        },
        loadExpensesTable: function() {
            var that = this;
            var url_rq = this.baseUrl + "/gastos/getAgencyExpenses";
            this.expenses_table = $("#expenses-table").DataTable({
                scrollX: true,
                fixedColumns: {
                    left: 1,
                    right: 1
                },
                language: { url: "//cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                ajax: {
                    "url": url_rq,
                    "dataSrc": function(json) {
                        that.expenses_array = json;
                        return json;
                    }
                },
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"B><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                bDestroy: true,
                buttons: [{
                    extend: "collection",
                    className: "btn btn-outline-secondary dropdown-toggle me-2",
                    text: feather.icons.share.toSvg({ class: "font-small-4 me-50" }) + "Exportar",
                    buttons: [{
                        extend: "csv",
                        text: feather.icons["file-text"].toSvg({ class: "font-small-4 me-50" }) + "Csv",
                        className: "dropdown-item",
                        //exportOptions: { columns: [3, 4, 5, 6, 7] } 
                    }, {
                        extend: "excel",
                        text: feather.icons.file.toSvg({ class: "font-small-4 me-50" }) + "Excel",
                        className: "dropdown-item",
                    }, {
                        extend: "pdf",
                        text: feather.icons.clipboard.toSvg({ class: "font-small-4 me-50" }) + "Pdf",
                        className: "dropdown-item",
                    }, {
                        extend: "copy",
                        text: feather.icons.copy.toSvg({ class: "font-small-4 me-50" }) + "Copiar",
                        className: "dropdown-item",
                    }],
                    init: function(e, t, a) {
                        $(t).removeClass("btn-secondary"), $(t).parent().removeClass("btn-group"), setTimeout((function() { $(t).closest(".dt-buttons").removeClass("btn-group").addClass("d-inline-flex") }), 50)

                    }
                }],
                columns: [{
                    data: "id_gasto",
                    render: function(data, type, row, meta) {
                        return meta.row + 1;
                    }
                }, {
                    data: "descripcion",
                }, {
                    data: "fecha_gasto",
                    render: function(data, type, row, meta) {
                        return moment(row.fecha_gasto).format("DD/MM/YYYY");
                    }
                }, {
                    data: "importe",
                    render: $.fn.dataTable.render.number(',', '.', 2, '$'),
                }, {
                    data: "referencia",
                    render: function(data, type, row, meta) {
                        return row.referencia == null ? "Sin registro" : row.referencia;
                    }
                }, {
                    data: "idFormaPago.descripcion",
                }, {
                    data: "idCuenta.descripcion",
                }, {
                    defaultContent: "Sin registro",
                    data: "idProveedor.nombre_comercial",
                }, {
                    data: "observaciones",
                    render: function(data, type, row, meta) {
                        return row.observaciones == null ? "Sin registro" : row.observaciones;
                    }
                }, {
                    data: "idUsuario.id",
                    render: function(data, type, row, meta) {
                        return row.idUsuario.profiles.firstname + " " + row.idUsuario.profiles.lastname;
                    }
                }, {
                    data: "id_cuenta",
                    sortable: false,
                    render: function(data, type, row, meta) {
                        var voucher_img = row.comprobante != null ? ('<a href="javascript:;" class="view-record" data-expense="' + row.id_gasto + '"data-bs-toggle="modal" data-bs-target="#voucher-modal">' + feather.icons.image.toSvg() + '</a>') : "";
                        return voucher_img + '<a href="javascript:;" class="edit-record" data-expense="' + row.id_gasto + '" data-bs-toggle="modal" data-bs-target="#cu-expenses">' + feather.icons.edit.toSvg() + '</a><a href="javascript:;" class="delete-record" data-expense="' + row.id_gasto + '">' + feather.icons.trash.toSvg() + '</a>';
                    }
                }],
                "drawCallback": function(settings, json) {
                    appExpenses.addCssToTable();
                }
            });
        },
        checkPaymentType: function() {
            if (this.expense_model.id_forma_pago == 1) {
                this.expense_model.id_cuenta = 1;
                $("#slct-account").prop("disabled", true);
                // $("#slct-account option[value=1]").show()
            } else {
                $("#slct-account").prop("disabled", false);
                $("#slct-account option[value=1]").hide();
                if (this.expense_model.id_cuenta == 1) this.expense_model.id_cuenta = this.accounts_array[0].id_cuenta;
            }
        },
        getFormData: function() {
            this.expense_model.fecha_gasto = moment($("#dp-expense").val(), "DD/MM/YYYY").format("YYYY-MM-DD");
            var form_data = new FormData();
            var that = this;
            for (var key in this.expense_model) {
                form_data.append(key, that.expense_model[key]);
            }
            return form_data;
        },
        setFileToModel: function() {
            this.expense_model.file_comprobante = event.target.files[0];
        },
        initLibraries: function() {
            this.initDateFlatpickr();
            this.initDropify();
        },
        initDateFlatpickr: function() {
            this.expense_flatpickr = $("#dp-expense").flatpickr({
                dateFormat: "d/m/Y",
                //minDate: "today",
                locale: "es"
            });
        },
        initDropify: function() {
            this.dropify = $("#dropify").dropify();
        },
        clearModel: function() {
            this.expense_model = {
                id_gasto: 0,
                descripcion: "",
                fecha_gasto: "",
                importe: "",
                referencia: "",
                id_forma_pago: 1,
                id_cuenta: 1,
                beneficiario: "",
                comprobante: "upload.png",
                observaciones: "",
            };
            this.expense_flatpickr.clear();
            //$(".dropify-clear").trigger("click");
            $(".dropify-render img").attr("src", (appExpenses.baseUrl + '/images/comprobantes/' + appExpenses.expense_model.comprobante));
            $(".dropify-filename-inner").html(appExpenses.expense_model.comprobante);
        },
        addCssToTable: function() {
            setTimeout(() => {
                $("tbody tr td").css("background", "white");
                $(".dtfc-fixed-left").css("z-index", "999");
            }, 1000);
        },
    }
})

$("body").on("click", ".view-record", function() {
    var expense_id = $(this).attr("data-expense");
    var expenseFinded = appExpenses.expenses_array.findIndex(x => x.id_gasto == expense_id);
    appExpenses.expense_model.comprobante = appExpenses.expenses_array[expenseFinded].comprobante;
    $(".dropify-render img").attr("src", (appExpenses.baseUrl + '/images/comprobantes/' + appExpenses.expense_model.comprobante));
    $(".dropify-filename-inner").html(appExpenses.expense_model.comprobante);
});

$("body").on("click", ".edit-record", function() {
    var expense_id = $(this).attr("data-expense");
    var expenseFinded = appExpenses.expenses_array.findIndex(x => x.id_gasto == expense_id);
    appExpenses.expense_model = appExpenses.expenses_array[expenseFinded];
    appExpenses.expense_flatpickr.setDate(moment(appExpenses.expense_model.fecha_gasto).format("DD/MM/YYYY"));
    if (appExpenses.expense_model.comprobante != null) {
        $(".dropify-render img").attr("src", (appExpenses.baseUrl + '/images/comprobantes/' + appExpenses.expense_model.comprobante));
        $(".dropify-filename-inner").html(appExpenses.expense_model.comprobante);
    }
    if(appExpenses.expense_model.id_proveedor != null || appExpenses.expense_model.id_proveedor != "") {
        $("#slct-provider-0").val(appExpenses.expense_model.id_proveedor);
        $("#slct-provider-0").trigger('change');
    }
});

$("body").on("click", ".delete-record", function() {
    var expense_id = $(this).attr("data-expense");
    var expenseFinded = appExpenses.expenses_array.findIndex(x => x.id_gasto == expense_id);
    appExpenses.deleteExpense(expenseFinded);
});

var expenses_modal = document.getElementById('cu-expenses')
expenses_modal.addEventListener('hide.bs.modal', function(event) {
    appExpenses.clearModel();
})