var appEventGroup = {
    data: {
        event_model: {},

        portrait_multimedia: "",
        lateral_multimedia: "",

        portrait_drpfy: "",
        portrait_image: "",

        lateral_drpfy: "",
        lateral_image: "",


        gallery_array: [],
        dpzGallery: "",
        dpzGallery_error: false,
        $masonry_gallery: "",

        comments_table: "",
    },
    methods: {
        saveEventInfo: function() {
            this.$http.post(this.baseUrl + "/eventos/update/", this.event_model).then(function(response) {
                if(response.body.id) {
                    Toast.fire({
                        icon: "success",
                        title: "Información actualizada"
                    });
                } else {
                    var error_table = "<table class='table table-bordered text-white'>";
                    Object.values(response.body).forEach(element => {
                        error_table += "<tr><td>" + element + "</td></tr>";
                    });
                    error_table += "</table>";
                    Swal.fire({
                        title: '¡Ops!',
                        icon: 'error',
                        html: "<p align='center'>Algo salió mal</p>" + error_table,
                    });
                }
            }, function() {
                console.log('Error')
            })
        },
        initDropify: function() {
            var options = {
                messages: {
                    'default': 'Arrastra una imagen o haz clic',
                    'replace': 'Arrastra una imagen o haz clic para reemplazar',
                    'remove': 'Quitar',
                    'error': 'Ooops, algo salió mal.'
                }
            }
            var portrait_dropify = $("#portrait-drpfy").dropify(options);
            this.portrait_drpfy = portrait_dropify.data("dropify");

            var lateral_dropify = $("#lateral-drpfy").dropify(options);
            this.lateral_drpfy = lateral_dropify.data("dropify");
        },
        setFileToModel: function(position) {
            if(position == "portada") {
                this.portrait_image = event.target.files[0];
            } else {
                this.lateral_image = event.target.files[0];
            }
        },
        saveMultimediaImage: function(position) {
            var data = new FormData();
            data.append("event_code", this.group_info.evento.id);
            if(position == "portada") {
                data.append("image", this.portrait_image);
            } else {
                data.append("image", this.lateral_image);
            }
            data.append("position", position);

            this.$http.post(this.baseUrl + "/eventos/saveMultimedia/", data).then(function(response) {
                Toast.fire({
                    icon: "success",
                    title: "Imagen guardada"
                })
            }, function() {
                console.log('Error')
            })
        },
        initDropzoneGallery: function() {
            this.dpzGallery = new Dropzone("#dpzGallery", {
                paramName: "images",
                params: {
                    event_code: appGroupsView.group_info.evento.id
                },
                acceptedFiles: "image/*",
                maxFilesize: .6,
                clickable: true,
                addRemoveLinks: true,
                autoProcessQueue: false,
                dictRemoveFile: "Eliminar",
                parallelUploads: 20,
                uploadMultiple: true,
                url: appGroupsView.baseUrl + "/eventos/uploadImages",
                method: 'POST',
                success: function(response) {
                    appGroupsView.gallery_array = JSON.parse(response.xhr.response);
                    Vue.nextTick(() => {
                        feather.replace();
                        appGroupsView.$masonry_gallery.masonry();
                        appGroupsView.$masonry_gallery.masonry('reloadItems');

                        setTimeout(() => {
                            $("#col-gallery-0").click();
                        }, 1000);
                    })
                },
                error: function(file, ex) {
                    appGroupsView.dpzGallery_error = true;
                    Swal.fire({
                        icon: "error",
                        text: ex
                    })
                },
                init: function() {
                    var e = this;
                    $("#clear-dropzone").on("click", (function() { e.removeAllFiles() }))
                },
                complete: function(file) {
                    appGroupsView.dpzGallery.removeFile(file);
                },
                queuecomplete: function() {
                    if (!appGroupsView.dpzGallery_error) {
                        Toast.fire({
                            icon: 'success',
                            title: 'Guardado con éxito.'
                        });
                    }
                    appGroupsView.dpzGallery_error = false;
                }
            });
        },
        proccessImages: function() {
            this.dpzGallery.processQueue();
        },
        initEventLibraries: function() {
            if(this.$masonry_gallery != "") {
                this.$masonry_gallery = $('#gallery-grid').masonry();
                this.initDropify();
            }
        },
        deleteImg: function(index) {
            this.$http.post(this.baseUrl + "/eventos/deleteImage/" + this.gallery_array[index].id).then(function(response) {
                if(response.body.success) {
                    this.$masonry_gallery.masonry('remove', $("#col-gallery-" + index)).masonry();
                } else {
                    Swal.fire({
                        title: '¡Ops!',
                        icon: 'error',
                        text: "Algo salió mal, recargue la página e intente de nuevo.",
                    });
                }
            }, function() {
                console.log('Error')
            })
        },
        loadCommentsTable: function() {
            var url_rq = this.baseUrl + "/eventos/getcomments/" + this.group_info.evento.id;
            this.comments_table = $("#comments-table").DataTable({
                ajax: {
                    "url": url_rq,
                    "dataSrc": function(json) {
                        //appGroupsView.habs_array = json;
                        return json;
                    }
                },
                language: { url: "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                bDestroy: true,
                columns: [{
                    width: "5%",
                    title: "#",
                    data: null,
                    render: function(data, type, row, meta) {
                        return meta.row + 1;
                    }
                }, {
                    width: "30%",
                    title: "Autor",
                    data: "autor"
                }, {
                    width: "60%",
                    title: "Comentario",
                    data: "comentario"
                }, {
                    width: "5%",
                    title: "",
                    data: null,
                    render: function(data, type, row, meta) {
                        return "<a href='javascript:;' class='delete-comment' data-comment=" + row.id + ">" + feather.icons.trash.toSvg() + "</a>";
                    }
                }]
            })
        },
        deleteComment: function(comment_id) {
            this.$http.get(this.baseUrl + "/eventosComentarios/delete/" + comment_id).then(function(response) {
                this.comments_table.ajax.reload();
                Toast.fire({
                    icon: "success",
                    title: "Comentario eliminado"
                })
            }, function() {
                console.log('Error')
            })
        },
    }
}

$("body").on("click", ".delete-comment", function() {
    var comment_code = $(this).attr("data-comment");
    appGroupsView.deleteComment(comment_code);
});