const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    showConfirmButton: false,
    timerProgressBar: true,
    timer: 3000,
})
Vue.http.options.emulateJSON = true;
var appGroups = new Vue({
    el: "#grupos",
    data: {
        baseUrl: baseUrl,
        group_type: group_type,
        group_model: {
            titulo_evento: "",
            num_habitaciones: "",
            hotel: "",
            tipo_habitacion: "",
            condiciones: "",
            estatus: "Activo",
        },

        hotels_array: [],
        groups_array: [],
        groups_table: "",
    },
    mounted: function() {
        this.loadGroupsTable();
        Vue.nextTick(() => {
            appGroups.initSelect2();
        })
    },
    methods: {
        loadGroupsTable: function() {
            var that = this;
            var url_rq = this.baseUrl + "/" + this.group_type + "/" + this.group_type + "api";
            this.groups_table = $(".datatable").DataTable({
                language: { url: "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                ajax: {
                    "url": url_rq,
                    "dataSrc": function(json) {
                        that.groups_array = json;
                        return json;
                    }
                },
                scrollX: true,
                // scrollY: 450,
                fixedColumns: {
                    left: 1,
                    right: 1
                },
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"B><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                bDestroy: true,
                buttons: [{
                    extend: "collection",
                    className: "btn btn-outline-secondary dropdown-toggle me-2",
                    text: feather.icons.share.toSvg({ class: "font-small-4 me-50" }) + "Exportar",
                    buttons: [{
                        extend: "csv",
                        text: feather.icons["file-text"].toSvg({ class: "font-small-4 me-50" }) + "Csv",
                        className: "dropdown-item",
                        //exportOptions: { columns: [3, 4, 5, 6, 7] } 
                    }, {
                        extend: "excel",
                        text: feather.icons.file.toSvg({ class: "font-small-4 me-50" }) + "Excel",
                        className: "dropdown-item",
                    }, {
                        extend: "pdf",
                        text: feather.icons.clipboard.toSvg({ class: "font-small-4 me-50" }) + "Pdf",
                        className: "dropdown-item",
                    }, {
                        extend: "copy",
                        text: feather.icons.copy.toSvg({ class: "font-small-4 me-50" }) + "Copiar",
                        className: "dropdown-item",
                    }],
                    init: function(e, t, a) {
                        $(t).removeClass("btn-secondary"), $(t).parent().removeClass("btn-group"), setTimeout((function() { $(t).closest(".dt-buttons").removeClass("btn-group").addClass("d-inline-flex") }), 50)

                    }
                }],
                columns: [
                    { data: 'idVentaservicio.idVenta.folio' },
                    { data: 'titulo_evento' },
                    { data: 'idVentaservicio.idVenta.pasajero_titular' },
                    {
                        data: null,
                        render: function(data, type, row, meta) {
                            return row.num_habitaciones;
                        }
                    },
                    { data: 'noches' },
                    { data: 'hotel' },
                    { data: 'tipo_habitacion' },
                    {
                        data: "id_grupo",
                        orderable: false,
                        render: function(data, type, row, meta) {
                            return '<a href="' + appGroups.baseUrl + '/' + appGroups.group_type + '/' + row.id_grupo + '">' + feather.icons.eye.toSvg() + '</a><a href="javascript:;" class="ms-50 edit-record" data-bs-toggle="modal" data-bs-target="#update-modal" data-group=' + row.id_grupo + '>' + feather.icons.edit.toSvg() + '</a><a href="javascript:void(0)" class="ms-50 delete-record" data-group=' + row.id_grupo + '>' + feather.icons["trash-2"].toSvg() + '</a>';
                        }
                    },

                ],
                "drawCallback": function(settings, json) {
                    appGroups.addCssToTable();
                }
            });
        },
        updateGroup: function() {
            this.$http.post(this.baseUrl + "/grupos/update/", this.group_model).then(function(response) {
                $('#update-modal').modal('hide');
                if (response.body.success) {
                    this.groups_table.ajax.reload();
                    Toast.fire({
                        icon: 'success',
                        text: 'Se ha actulizado la información.'
                    });
                } else {
                    Toast.fire({
                        icon: 'error',
                        text: "Algo salió mal, recargue la página e intentelo de nuevo",
                    });
                }
            }, function() {
                console.log('Error');
            });
        },
        deleteGroup: function(group_code) {
            var that = this;
            var index = this.groups_array.findIndex(x => x.id_grupo == group_code);
            var tipo = this.groups_array[index].tipo == "Grupo" ? "grupo" : "boda";
            Swal.fire({
                title: '¿Seguro?',
                text: "Esta a punto de cambiar el estatus de la " + tipo + ".",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Confirmar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    this.$http.post(this.baseUrl + "/grupos/delete/" + group_code).then(function(response) {
                        if (response.body.success) {
                            that.groups_table.ajax.reload();
                            Toast.fire({
                                icon: 'success',
                                text: 'Se ha cambiado estatus de la ' + tipo + '.'
                            });
                        } else {
                            Toast.fire({
                                icon: 'error',
                                text: "Algo salió mal, recargue la página e intentelo de nuevo",
                            });
                        }
                    }, function() {
                        console.log('Error');
                    });
                }
            });
        },
        initSelect2: function() {
            $("#slct-hotel").select2({
                dropdownParent: $("#update-modal"),
                placeholder: "Seleccione un hotel",
                minimumInputLength: 3,
                ajax: {
                    url: appGroups.baseUrl + "/site/searchHotel",
                    dataType: 'json',
                    processResults: function (data) {
                        appGroups.hotels_array = data;
                        return {
                            results: data
                        };
                    }
                }
            }).on("change", (function() {
                if(appGroups.hotels_array.length > 0) {
                    var e = $(this);
                    var found_index = appGroups.hotels_array.findIndex(x => x.id == e.val());
                    appGroups.group_model.hotel = appGroups.hotels_array[found_index].text;
                }
            })).on("select2:open", (function() {
                $(".select2-search__field")[0].focus();
            }))
        },
        addCssToTable: function() {
            setTimeout(() => {
                $("tbody tr td").css("background", "white");
                $(".dtfc-fixed-left").css("z-index", "999");
            }, 1000);
        },
    },
});

$("body").on("click", ".edit-record", function() {
    var group_code = $(this).attr("data-group");
    var index = appGroups.groups_array.findIndex(x => x.id_grupo == group_code);
    appGroups.group_model = appGroups.groups_array[index];

    if(appGroups.group_model.hotel != null && appGroups.group_model.hotel != "") {
        var newOption = new Option(appGroups.group_model.hotel, appGroups.group_model.hotel, true, true);
        $('#slct-hotel').append(newOption);
        $('#slct-hotel').trigger('change');
    }
});

$("body").on("click", ".delete-record", function() {
    var group_code = $(this).attr("data-group");
    appGroups.deleteGroup(group_code);
});

var myModalEl = document.getElementById('update-modal')
myModalEl.addEventListener('hidden.bs.modal', function (event) {
    $("#slct-hotel").html('');
})