const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    showConfirmButton: false,
    timerProgressBar: true,
    timer: 3000,
})

Vue.http.options.emulateJSON = true;
var appGroupsView = new Vue({
    el: "#app-group",
    mixins: [ appEventGroup ],
    data: {
        baseUrl: baseUrl,
        loaded: false,
        dropzoneFiles: "",
        group_code: group_code,
        group_type: group_type,

        group_info: {},
        habs_array: [],
        guests_table: "",
        invitations_model: [],

        hab_model: {
            id_habitacion: 0,
            id_grupo: group_code,
            tipo_habitacion: "",
            noches: 0,
            fecha_entrada: "",
            fecha_salida: "",
            habitacionesHuespedes: [{
                id_huesped: 0,
                id_habitacion: 0,
                nombres: "",
                apellidos: "",
                edad: "",
                correo: "",
                telefono: "",
            }],
        }
    },
    created: function() {
        this.formatter = new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD',
        });
    },
    mounted: function() {
        this.loadGroupInfo();
    },
    methods: {
        loadGroupInfo: function() {
            this.$http.post(this.baseUrl + "/grupos/getGroupInfo/", { id: this.group_code, tipo: this.group_type }).then(function(response) {
                this.group_info = response.body;
                this.loaded = true;

                Vue.nextTick(() => {
                    appGroupsView.initFlatpickr();
                    appGroupsView.date_flatpickr.setDate(moment(appGroupsView.group_info.idVentaservicio.inicio_servicio).format("DD/MM/YYYY") + " a " + moment(appGroupsView.group_info.idVentaservicio.fin_servicio).format("DD/MM/YYYY"));
                    appGroupsView.initDropzoneFiles();

                    if(response.body.evento.eventoMultimedia.filter(x => x.posicion == "portada").length > 0) {
                        appGroupsView.portrait_multimedia = response.body.evento.eventoMultimedia.filter(x => x.posicion == "portada")[0].path;
                    }
                    if(response.body.evento.eventoMultimedia.filter(x => x.posicion == "lateral").length > 0) {
                        appGroupsView.lateral_multimedia = response.body.evento.eventoMultimedia.filter(x => x.posicion == "lateral")[0].path;
                    }

                    appGroupsView.gallery_array = response.body.evento.eventoGaleria;
                    var aux = response;
                    delete aux.body.evento.eventoGaleria;
                    delete aux.body.evento.eventoMultimedia;
                    appGroupsView.event_model = aux.body.evento;

                    appGroupsView.initWeddingLibraries();
                    appGroupsView.loadCommentsTable();
                    feather.replace();
                });
            }, function() {
                console.log('Error');
            });
        },
        loadGuestsTable: function() {
            if (this.guests_table != "") return false;
            var url_rq = this.baseUrl + "/grupos/getGroupHabs/" + this.group_code;
            this.guests_table = $("#guest-table").DataTable({
                ajax: {
                    "url": url_rq,
                    "dataSrc": function(json) {
                        appGroupsView.habs_array = json;
                        return json;
                    }
                },
                language: { url: "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                bDestroy: true,
                columns: [{
                    data: null,
                    render: function(data, type, row, meta) {
                        var names = "";
                        row.habitacionesHuespedes.forEach(element => {
                            if(element.nombres != "")
                                names += element.nombres + " " + element.apellidos + ", ";
                        });
                        if(names == "")
                            return "Sin registro";
                        return names.slice(0, -2);
                    }
                }, {
                    data: null,
                    render: function(data, type, row, meta) {
                        var ages = "";
                        row.habitacionesHuespedes.forEach(element => {
                            if(element.edad != null)
                                ages += element.edad + ", ";
                        });
                        if(ages == "")
                            return "NA";
                        return ages.slice(0, -2);
                    }
                }, {
                    data: "tipo_habitacion"
                }, {
                    data: "fecha_entrada",
                    render: function(data, type, row, meta) {
                        return moment(data).format("DD/MM/YYYY");
                    }
                }, {
                    data: "fecha_salida",
                    render: function(data, type, row, meta) {
                        return moment(data).format("DD/MM/YYYY");
                    }
                }, {
                    data: "noches"
                }, {
                    data: null,
                    orderable: false,
                    render: function(data, type, row, meta) {
                        var wedding_icons = "<a href='javascript:;' class='ms-50 send-record' data-hab=" + row.id_habitacion + " data-bs-toggle='modal' data-bs-target='#invitations-modal'>" + feather.icons.mail.toSvg() + "</a>";
                        return "<a href='javascript:;' class='edit-record' data-hab=" + row.id_habitacion + " data-bs-toggle='modal' data-bs-target='#cu-modal'>" + feather.icons.edit.toSvg() + "</a>" + wedding_icons + "<a href='javascript:;' class='ms-50 delete-record' data-hab=" + row.id_habitacion + ">" + feather.icons.trash.toSvg() + "</a>";
                    }
                }]
            })
        },
        saveHab: function() {
            var url_rq = this.baseUrl + "/grupos";
            var msg_rp = "";
            if (this.hab_model.id_habitacion > 0) {
                url_rq += "/updateHab";
                msg_rp = "Habitación actualizada";
            } else {
                url_rq += "/createHab";
                msg_rp = "Habitación guardada"
            }

            var stay = ($("#stay-date").val()).split(" a ");
            var start = moment(stay[0], "DD/MM/YYYY");
            var end = moment(stay[1], "DD/MM/YYYY");
            this.hab_model.fecha_entrada = start.format("YYYY-MM-DD");
            this.hab_model.fecha_salida = end.format("YYYY-MM-DD");
            this.hab_model.noches = end.diff(start, "days");
            var rq = {
                hab: appGroupsView.hab_model,
                guests: appGroupsView.hab_model.habitacionesHuespedes
            }

            this.$http.post(url_rq, rq).then(function(response) {
                this.guests_table.ajax.reload();
                Toast.fire({
                    icon: 'success',
                    title: msg_rp
                })
            }, function() {
                console.log('Error')
            })
        },
        deleteHab: function(hab_code) {
            var that = this;
            Swal.fire({
                title: '¿Seguro?',
                text: "Eliminará este registro del sistema",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Confirmar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    this.$http.post(this.baseUrl + "/grupos/deleteHab/" + hab_code).then(function(response) {
                        if (response.body.success) {
                            that.guests_table.ajax.reload();
                            Toast.fire({
                                icon: 'success',
                                text: 'Se ha elimnado la habitación.'
                            });
                        } else {
                            Toast.fire({
                                icon: 'error',
                                text: "Algo salió mal, recargue la página e intentelo de nuevo",
                            });
                        }
                    }, function() {
                        console.log('Error');
                    });
                }
            });
        },
        saveInvitation: function() {
            var form_data = new FormData();
            form_data.append("id_invitacion", this.group_info.invitaciones.id_invitacion);
            form_data.append("id_boda", this.group_code);
            form_data.append("text", this.invitation_editor.getData());
            form_data.append("file_invitacion", this.img_invitation);
            this.$http.post(this.baseUrl + "/bodas/updateInvitation/", form_data).then(function(response) {
                if (response.body.id_invitacion) {
                    Toast.fire({
                        icon: 'success',
                        title: 'Invitación actualizada'
                    });
                }
            }, function() {
                console.log('Error');
            });
        },
        sendInvitation: function() {
            var rq = { id_invitacion: this.group_info.invitaciones.id_invitacion, guests: this.invitations_model.join() };
            this.$http.post(this.baseUrl + "/bodas/sendInvitations/", rq).then(function(response) {
                if (response.body.id_invitacion) {
                    Toast.fire({
                        icon: 'success',
                        title: 'Invitación actualizada'
                    });
                }
            }, function() {
                console.log('Error');
            });
        },
        addGuest: function() {
            this.hab_model.habitacionesHuespedes.push({
                id_huesped: 0,
                id_habitacion: 0,
                nombres: "",
                apellidos: "",
                edad: "",
                correo: "",
                telefono: ""
            });
            Vue.nextTick(() => {
                feather.replace();
            })
        },
        deleteGuest: function(guest_code) {
            var index = this.hab_model.habitacionesHuespedes.findIndex(x => x.id_huesped == guest_code);
            this.hab_model.habitacionesHuespedes.splice(index, 1);
        },
        openFile: function(path) {
            var url = this.baseUrl + "/files/" + path;
            window.open(url, '_blank').focus();
        },
        getIconFile: function(path) {
            var array_path = path.split(".");
            var ext = array_path[array_path.length - 1].toLocaleLowerCase();
            var url = this.baseUrl + "/template/vuexy/images/icons/";
            if (ext == "jpg") {
                url += "jpg.png";
            } else if (ext == "pdf") {
                url += "pdf.png";
            } else if (ext == "doc" || ext == "docx") {
                url += "doc.png";
            }
            return url;
        },
        checkHabModel: function() {
            var has_email = false;
            this.hab_model.habitacionesHuespedes.forEach(element => {
                has_email = element.correo != null && element.correo != "";
            });
            return has_email;
        },
        proccessFiles: function() {
            this.dropzoneFiles.processQueue();
        },
        clearHabModel: function() {
            this.hab_model = {
                id_habitacion: 0,
                id_grupo: group_code,
                tipo_habitacion: "",
                noches: 0,
                fecha_entrada: "",
                fecha_salida: "",
                habitacionesHuespedes: [{
                    id_huesped: 0,
                    id_habitacion: 0,
                    nombres: "",
                    apellidos: "",
                    edad: "",
                    correo: "",
                    telefono: "",
                }],
            };
            this.date_flatpickr.setDate(moment(this.group_info.idVentaservicio.inicio_servicio).format("DD/MM/YYYY") + " a " + moment(this.group_info.idVentaservicio.fin_servicio).format("DD/MM/YYYY"));
        },
        initFlatpickr: function() {
            this.date_flatpickr = $("#stay-date").flatpickr({
                mode: "range",
                dateFormat: "d/m/Y",
                locale: "es"
            });
        },
        initDropzoneFiles: function() {
            this.dropzoneFiles = new Dropzone("#dpzFiles", {
                paramName: "files",
                params: {
                    group_code: appGroupsView.group_code
                },
                //acceptedFiles: "image/*",
                maxFilesize: .6,
                clickable: true,
                addRemoveLinks: true,
                autoProcessQueue: false,
                dictRemoveFile: "Eliminar",
                parallelUploads: 20,
                uploadMultiple: true,
                url: appGroupsView.baseUrl + "/grupos/uploadFiles",
                method: 'POST',
                success: function(response) {
                    appGroupsView.group_info.gruposArchivoses = JSON.parse(response.xhr.response);
                },
                error: function(file, ex) {
                    appGroupsView.dropzone_error = true;
                    Swal.fire({
                        icon: "error",
                        text: ex
                    })
                },
                init: function() {
                    var e = this;
                    $("#clear-dropzone").on("click", (function() { e.removeAllFiles() }))
                },
                complete: function(file) {
                    appGroupsView.dropzoneFiles.removeFile(file);
                },
                queuecomplete: function() {
                    if (!appGroupsView.dropzone_error) {
                        Toast.fire({
                            icon: 'success',
                            title: 'Guardado con éxito.'
                        });
                    }
                    appGroupsView.dropzone_error = false;
                }
            });
        },
        initWeddingLibraries: function() {
            ClassicEditor.create(document.querySelector('#editor'), {
                toolbar: {
                    removeItems: ['uploadImage', 'mediaEmbed'],
                }
            }).then(newEditor => {
                appGroupsView.invitation_editor = newEditor;
            });
            //this.invitation_editor.setData(this.group_info.invitaciones.texto);
            this.img_dropify = $("#invitation-img").dropify();            
            this.initDropzoneGallery();
        },
        loadedImgInvitation: function() {
            this.img_invitation = event.target.files[0];
        },
        formatPrice: function(price) {
            var aux = parseFloat(price);
            return this.formatter.format(aux) + " MXN";
        },
        formatDate: function(string_date) {
            return moment(string_date).format("DD/MM/YYYY");
        },
        formatDateTime: function(string_date) {
            return moment(string_date).format("DD/MM/YYYY HH:mm:ss");
        }
    }
});

$("body").on("click", ".edit-record", function() {
    var hab_code = $(this).attr("data-hab");
    var index = appGroupsView.habs_array.findIndex(x => x.id_habitacion == hab_code);
    appGroupsView.hab_model = appGroupsView.habs_array[index];
    appGroupsView.date_flatpickr.setDate(moment(appGroupsView.habs_array[index].fecha_entrada).format("DD/MM/YYYY") + " a " + moment(appGroupsView.habs_array[index].fecha_salida).format("DD/MM/YYYY"));
});

$("body").on("click", ".delete-record", function() {
    var hab_code = $(this).attr("data-hab");
    appGroupsView.deleteHab(hab_code);
});

$("body").on("click", ".send-record", function() {
    var hab_code = $(this).attr("data-hab");
    var index = appGroupsView.habs_array.findIndex(x => x.id_habitacion == hab_code);
    appGroupsView.hab_model = appGroupsView.habs_array[index];
});

var cu_modal = document.getElementById('cu-modal');
cu_modal.addEventListener('shown.bs.modal', function(event) {
    feather.replace();
});
cu_modal.addEventListener('hidden.bs.modal', function(event) {
    appGroupsView.clearHabModel();
});

var invitations_modal = document.getElementById('invitations-modal');
invitations_modal.addEventListener('hidden.bs.modal', function(event) {
    appGroupsView.clearHabModel();
});