var formatter = new Intl.NumberFormat('en-US', {
    style: 'currency',
    currency: 'USD',
    minimumFractionDigits: 2
    // These options are needed to round to whole numbers if that's what you want.
    //minimumFractionDigits: 0, // (this suffices for whole numbers, but will print 2500.10 as $2,500.1)
    //maximumFractionDigits: 0, // (causes 2500.99 to be printed as $2,501)
});

var bodasGrupos = new Vue({
    el: '#bodasGrupos',
    data: {
        baseUrl: baseUrl,
        sales_array: [],
        ventas_bodasGrup:[],
        info_contrato:[],
        service_types_array: [],
        contrato_seleccionado: "",
        loadinfocontrato: false,
        pasajeroTitular:"",
        cont_Descripcion:"",
        cont_Total:0,
        cont_Fecha:"",
        cont_TotalHab:0,
    },
    created: function() {
        this.loadServiceTypes();
    },
    mounted: function () {
        this.loadSalesTable();
        this.loadVentasBodasGrupos();
    },
    methods: {
        showChildRow: function(rowData) {
            let htmlServs = '';
            rowData.ventasServicioses.forEach(service => {
                let desglose = JSON.parse(service.desglose);
                let serviceTxt = '';
                let detalleTxt = '';
                let menoresTxt = '';
                let agesTxt = '';
                let detalleServ = [];
                let menorServ = [];
                let ages = []; 
                this.service_types_array.forEach(serv => {
                    if(serv.id_servicio === service.id_tipo_servicio) {
                        serviceTxt = serv.tipo_servicio;
                        if(service.id_tipo_servicio === "1"){
                            serviceTxt += ': '+ desglose.hotel;
                            $.each(desglose.habitaciones, function(idx, h){
                                $.each(h.pasajeros.adultos, function(idx2, p){
                                    detalleServ.push(p.nombre + ' ' + p.apellidos); 
                                });
                                detalleTxt += detalleServ.length > 0 ? 'Habitación '+(idx +1)+': ' + detalleServ.join(' / ') : '';
                            });
                            $.each(desglose.habitaciones, function(idx, h){                                
                                $.each(h.pasajeros.menores, function(idx2, p){
                                    menorServ.push(p.nombre + ' ' + p.apellidos);
                                    ages.push(p.edad);
                                });
                                menoresTxt += menorServ.length > 0 ? 'Habitación '+(idx +1)+': ' + menorServ.join(' / ') : '';
                                agesTxt += ages.length > 0 ? 'Habitación '+(idx +1)+': ' + ages.join(',') : '';
                            });
                        } else if(service.id_tipo_servicio === "2") {
                            serviceTxt += ': '+ desglose.origen + ' - ' + desglose.destino;
                        } else if(service.id_tipo_servicio === "6") {
                            serviceTxt += ': '+ desglose.aerolinea+ ' ' + desglose.origen +'-'+desglose.destino
                        } else {
                            serviceTxt += ': '+ service.descripcion
                        }
                    }
                });
                htmlServs += '<tr>'+
                '<td>' + serviceTxt + '</td>'+
                '<td>' + detalleTxt + '</td>'+
                '<td>' + menoresTxt + '</td>'+
                '<td>' + agesTxt + '</td>'+
                '<td>'+moment(service.inicio_servicio).format('DD/MM/YYYY')+'</td>'+
                '<td>'+moment(service.fin_servicio).format('DD/MM/YYYY')+'</td>'+
                '<td>'+moment(service.limite_cliente).format('DD/MM/YYYY')+'</td>'+
                '<td>' + service.tarifa_publica + '</td>'+
                '</tr>';
            });
            return ('<table class="datatable dataTable no-footer border subtable">' + 
                '<thead><tr>'+
                '<th>Descripci&oacute;n Servicio</th>'+
                '<th>Pasajeros</th>'+
                '<th>Menor(es)</th>'+
                '<th>Edad(es)</th>'+
                '<th>Inicio Servicio</th>'+
                '<th>Fin Servicio</th>'+
                '<th>L&iacute;m.Pago</th>'+
                '<th>Costo</th>'+
                '</tr></thead>' +
                '<tbody>' + htmlServs + '</tbody>' +
                '</table>');
        },
        loadSalesTable: function () {

            this.loadinfocontrato = false;
            if (this.contrato_seleccionado !== "") {
                this.loadinfocontrato = true;
                bodasGrupos.loadInfoVenta();                
            }

            var url_rq = this.baseUrl + "/reportes/infoContratosDeBoda?id_venta=" + this.contrato_seleccionado;
            this.sales_table = $("#bodas-datatable").DataTable({
                language: { url: "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                scrollX: true,
                ajax: {
                    "url": url_rq,
                    "dataSrc": function (json) {
                        bodasGrupos.sales_array = json;
                        return json;
                    }
                },
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"B><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                bDestroy: true,
                paging: false,
                buttons: [{
                    extend: "collection",
                    className: "btn btn-outline-secondary dropdown-toggle me-2",
                    text: feather.icons.share.toSvg({ class: "font-small-4 me-50" }) + "Exportar",
                    buttons: [{
                        extend: "csv",
                        text: feather.icons["file-text"].toSvg({ class: "font-small-4 me-50" }) + "Csv",
                        className: "dropdown-item",
                        //exportOptions: { columns: [3, 4, 5, 6, 7] } 
                    }, {
                        extend: 'excelHtml5',
                        text: feather.icons.file.toSvg({ class: "font-small-4 me-50" }) + "Excel",
                        className: "dropdown-item",
                        footer: true,
                        customizeData: function(data){
                            var x = data.header.shift();
                            const dataBody = bodasGrupos.reorderData(data.body);
                            
                            data.header.pop();
                            data.body = dataBody;
                        }
                    }, {
                        extend: 'excelHtml5',
                        text: feather.icons.file.toSvg({ class: "font-small-4 me-50" }) + "Excel Habitaciones",
                        className: "dropdown-item",
                        footer: false,
                        customizeData: function(data){
                            
                            const dataBody = bodasGrupos.reorderDataHab(data.body);
                            
                            data.header = ['Folio','Descripción','Adultos','MNR(s)','Edad(es)','Fecha Entrada','Fecha Salida','',''];
                            data.body = dataBody;
                        }
                    }, {
                        extend: "pdf",
                        text: feather.icons.clipboard.toSvg({ class: "font-small-4 me-50" }) + "Pdf",
                        orientation: 'landscape',
                        className: "dropdown-item"
                    }, {
                        extend: "copy",
                        text: feather.icons.copy.toSvg({ class: "font-small-4 me-50" }) + "Copiar",
                        className: "dropdown-item",
                    }],
                    init: function (e, t, a) {
                        $(t).removeClass("btn-secondary"), $(t).parent().removeClass("btn-group"), setTimeout((function () { $(t).closest(".dt-buttons").removeClass("btn-group").addClass("d-inline-flex") }), 50)
                    }
                }],
                "drawCallback": function (settings, json) {
                    bodasGrupos.addCssToTable();
                },
                scrollCollapse: true,
                columns: [{
                    data: null,
                    className: 'dt-control',
                    orderable: false,
                    defaultContent: ''
                },
                {
                    data: "folio",
                    render: function (data, type, row, meta) {
                        //console.log(row);
                        return "<a href='" + this.baseUrl + "/ventas/update/" + row.id_venta + "'>" + data + "</a>";
                    }
                }, {
                    data: 'pasajero_titular',
                    render: function (data, type, row, meta) {
                        if (typeof data == "undefined" || data === "") {
                            return "Sin pasajeros";
                        } else {
                            return data;
                        }
                    }
                }, {
                    data: 'descripcion',
                    render: function (data, type, row, meta) {
                        if (typeof data == "undefined" || data === "") {
                            return "Sin descripción";
                        } else {
                            return data;
                        }
                    }
                },
                {
                    data: null,
                    render: function (data, type, row, meta) {
                        return row.limite_cancelacion !== null ? moment(row.limite_cancelacion).format("DD/MM/YYYY") : "";
                    }
                }, 
                {
                    data: null,
                    className: "text-right",
                    width: "30%",
                    render: function (data, type, row, meta) {
                        let habCantAdulto="";
                        let habCantMenor="";
                        let edadMenores = "";
                        let tituloHabitacion="";

                        let infoDetalleHabitacion="";

                        row.ventasServicioses.forEach(servicioVenta => {                         
                            if (servicioVenta.id_tipo_servicio==1) {    
                               let objetoJSON = JSON.parse(servicioVenta.desglose);
                                    objetoJSON.habitaciones.forEach((habitaciones, index, array) => {
                                        habCantMenor="";
                                        habCantAdulto="";

                                        tituloHabitacion= "<strong>Habitación " + (index + 1) + "</strong><br> ";
                                        if (parseFloat(habitaciones.adultos))habCantAdulto=" Adultos: " + parseFloat(habitaciones.adultos) + " <br>"; 

                                        if (parseInt(habitaciones.menores) > 0) habCantMenor=" Menores: " +parseInt(habitaciones.menores)+ " <br>";

                                        if (typeof habitaciones.pasajeros.menores !== undefined && habitaciones.pasajeros.menores.length > 0){
                                            edadMenores = " Edades: "
                                            habitaciones.pasajeros.menores.forEach((habMenores, index2, array2) => {                                               
                                                if (habMenores.edad !== null && typeof habMenores.edad !== 'undefined') {
                                                        edadMenores+=habMenores.edad ;
                                                        if (index2 < array2.length - 1) {
                                                            edadMenores += ", ";
                                                          }
                                                }  
                                            });   
                                        }
                                        infoDetalleHabitacion+=tituloHabitacion + habCantAdulto + habCantMenor + edadMenores;
                                        if (index < array.length - 1) {
                                            infoDetalleHabitacion+= "<br>";
                                          }
                                   });                             
                            }                     
                    
                       });
                        return infoDetalleHabitacion;
                    }
                },
                {
                    data: null,
                    className: "text-right",
                    width: "12%",
                    render: function (data, type, row, meta) {
                         let edadMenores = "";

                        row.ventasServicioses.forEach(servicioVenta => {                         
                            if (servicioVenta.id_tipo_servicio==1) {    
                               let objetoJSON = JSON.parse(servicioVenta.desglose);
                                    objetoJSON.habitaciones.forEach(habitaciones => {
                                        if (typeof habitaciones.pasajeros.menores !== 'undefined'){
                                            habitaciones.pasajeros.menores.forEach((habMenores, index, array) => {
                                                if (habMenores.edad !== null && typeof habMenores.edad !== 'undefined') {
                                                        edadMenores+=habMenores.edad ;
                                                        if (index < array.length - 1) {
                                                            edadMenores += ", ";
                                                          }
                                                }      
                  
                                            });   
                                        }
                                   });                             
                            }                          
                    
                       });
                        return edadMenores;
                    }
                },
                {
                    data: null,
                    className: "text-right",
                    width: "12%",
                    render: function (data, type, row, meta) {
                         var totHabContrato = 0;

                        row.ventasServicioses.forEach(servicioVenta => {                         
                            if (servicioVenta.id_tipo_servicio==1) {    
                               let objetoJSON = JSON.parse(servicioVenta.desglose);
                                    objetoJSON.habitaciones.forEach(habitaciones => {
                                        totHabContrato++;                                 
                                   });                             
                            }                          
                    
                       });
                        return $.fn.dataTable.render.number(',').display(totHabContrato);
                    }
                },
                {
                    data: null,
                    className: "text-right",
                    width: "12%",
                    render: function (data, type, row, meta) {
                         let totAdultos = 0;

                        row.ventasServicioses.forEach(servicioVenta => {                         
                            if (servicioVenta.id_tipo_servicio==1) {    
                               let objetoJSON = JSON.parse(servicioVenta.desglose);
                                    objetoJSON.habitaciones.forEach(habitaciones => {
                                        totAdultos+=parseFloat(habitaciones.adultos);                             
                                   });                             
                            }                          
                    
                       });
                        return $.fn.dataTable.render.number(',').display(totAdultos);
                    }
                },
                {
                    data: null,
                    className: "text-right",
                    width: "12%",
                    render: function (data, type, row, meta) {
                         let totMenores = 0;

                        row.ventasServicioses.forEach(servicioVenta => {                         
                            if (servicioVenta.id_tipo_servicio==1) {    
                               let objetoJSON = JSON.parse(servicioVenta.desglose);
                                    objetoJSON.habitaciones.forEach(habitaciones => {
                                        totMenores+=parseFloat(habitaciones.menores);                             
                                   });                             
                            }                          
                    
                       });
                        return $.fn.dataTable.render.number(',').display(totMenores);
                    }
                },
                {
                    data: null,
                    className: "text-right",
                    width: "12%",
                    render: function (data, type, row, meta) {
                         let total = 0;
                         let totalxVenta=0;

                        row.ventasServicioses.forEach(servicioVenta => {
                            totalxVenta = parseFloat(servicioVenta.tarifa_publica);
                            if (parseFloat(servicioVenta.fee)) totalxVenta += parseFloat(servicioVenta.fee);
                            total+=totalxVenta;
                       });
                        return $.fn.dataTable.render.number(',', '.', 2, '$').display(total);
                    }
                },
                 {
                    data: null,
                    className: "text-right",
                    width: "12%",
                    render: function (data, type, row, meta) {
                        let payments = 0;
                       row.ventasServicioses.forEach(servicioVenta => {
                             servicioVenta.pagosDetalles.forEach(payment => {
                                payments += parseFloat(payment.monto);
                            });
                     
                        });
                        return $.fn.dataTable.render.number(',', '.', 2, '$').display(payments);
                    }
                },
                 {
                    data: null,
                    className: "text-right",
                    width: "12%",
                    render: function (data, type, row, meta) {
                        var total = 0;
                        var totalxVenta=0;
                        var payments = 0;

                       row.ventasServicioses.forEach(servicioVenta => {
                           totalxVenta = parseFloat(servicioVenta.tarifa_publica);
                           if (parseFloat(servicioVenta.fee)) totalxVenta += parseFloat(servicioVenta.fee);
                           total+=totalxVenta;

                           servicioVenta.pagosDetalles.forEach(payment => {
                            payments += parseFloat(payment.monto);
                        });
                   
                      });

                        var balance = parseFloat(total - payments);
                        return $.fn.dataTable.render.number(',', '.', 2, '$').display(balance);
                    }
                },
                {
                    data: null,
                    className: "text-right",
                    visible: false,
                    render: function (data, type, row, meta) {
                        return row.ventasServicioses;
                    }
                }
                ],
                footerCallback: function (row, data, start, end, display) {
                    var api = this.api();

                    var total_general = 0,
                        payments_general = 0,
                        balance_general = 0,
                        total_hab= 0,
                        total_adultos= 0,
                        total_menores= 0;



                        let totalxVenta=0;  

                        data.forEach(element => {
                            element.ventasServicioses.forEach(servicioVenta => {
                                //total
                                totalxVenta = parseFloat(servicioVenta.tarifa_publica);
                                if (parseFloat(servicioVenta.fee)) totalxVenta += parseFloat(servicioVenta.fee);
                                total_general+=totalxVenta;
                                
                                //Pagos
                                servicioVenta.pagosDetalles.forEach(payment => {
                                 payments_general += parseFloat(payment.monto);
                                 });    
                                 
                                 //Habitaciones
                                 if (servicioVenta.id_tipo_servicio==1) {    
                                    let objetoJSON = JSON.parse(servicioVenta.desglose);
                                         objetoJSON.habitaciones.forEach(habitaciones => {
                                            total_hab++;  
                                            if (parseFloat(habitaciones.adultos)) total_adultos+=parseFloat(habitaciones.adultos); 
                                            if (parseFloat(habitaciones.menores)) total_menores+=parseFloat(habitaciones.menores);
                                                   
                                        });                             
                                 } 
                        
                             }); 
                        });
                     balance_general = total_general - payments_general;
                   
                    setTimeout(() => {
                        $('.global-totals #total_general').html($.fn.dataTable.render.number(',', '.', 2, '$').display(total_general))
                        $('.global-totals #pagado_general').html($.fn.dataTable.render.number(',', '.', 2, '$').display(payments_general))
                        $('.global-totals #saldo_general').html($.fn.dataTable.render.number(',', '.', 2, '$').display(balance_general))
                        $('.global-totals #total_hab').html(total_hab + " HABITACIONES")
                        $('.global-totals #total_adultos').html(total_adultos + " ADULTOS")
                        $('.global-totals #total_menores').html(total_menores + " MENORES")
                    }, 1000);
                },
                stateSave: true
            });
            
        },

        addCssToTable: function () {
            setTimeout(() => { }, 1000);
        },
        loadVentasBodasGrupos: function() {
            this.$http.get(this.baseUrl + "/reportes/ventasBodasGrupos").then(function(response) {
                this.ventas_bodasGrup = response.body;
            }, function() {
                console.log('Error')
            })
        },
        loadInfoVenta: function() {
            this.$http.get(this.baseUrl + "/reportes/infoContrato?id_venta="+this.contrato_seleccionado).then(function(response) {
                this.info_contrato = response.body;

                let totalContPrincipal=0;
                let totalServicio=0;
                let objetoJSON = JSON.parse(this.info_contrato[0].ventasServicioses[0].desglose);

                this.pasajeroTitular=this.info_contrato[0].pasajero_titular;
                this.cont_Descripcion=this.info_contrato[0].descripcion;
                this.cont_TotalHab= objetoJSON.no_hab; 

                if (objetoJSON.fecha_evento!= null) {
                    this.cont_Fecha= moment(objetoJSON.fecha_evento).format("DD/MM/YYYY")
                }

            }, function() {
                console.log('Error')
            })
        },
        reorderData: function(body) {
            let newBody = [];
            body.forEach(row => {
                row.shift();
                const services = row[row.length -1]//row.pop();
                
                newBody.push(row);
                if(services.length > 0) {
                    newBody.push(['SERVICIOS: ','DetalleServicio','Pasajero(s)','Menor(es)','Edad(es)','InicioServicio','FinServicio','Lim.Pago','Costo']);
                    
                    services.forEach(serv => {
                        var desglose = $.parseJSON(serv.desglose);
                        let serviceTxt = '';
                        let detalleTxt = '';
                        let menoresTxt = '';
                        let agesTxt = '';
                        let detalleServ = [];
                        let menorServ = [];
                        let ages = []; 
                        this.service_types_array.forEach(stype => {
                            if(stype.id_servicio === serv.id_tipo_servicio) {
                                serviceTxt = stype.tipo_servicio;
                                if(serv.id_tipo_servicio === "1"){
                                    serviceTxt += ': '+ desglose.hotel;
                                    $.each(desglose.habitaciones, function(idx, h){
                                        $.each(h.pasajeros.adultos, function(idx2, p){
                                            detalleServ.push(p.nombre + ' ' + p.apellidos); 
                                        });
                                        detalleTxt += detalleServ.length > 0 ? 'Habitación '+(idx +1)+': ' + detalleServ.join(' / ') : '';
                                    });
                                    $.each(desglose.habitaciones, function(idx, h){
                                        $.each(h.pasajeros.menores, function(idx2, p){
                                        menorServ.push(p.nombre + ' ' + p.apellidos);
                                        ages.push(p.edad);
                                        });
                                        menoresTxt += menorServ.length > 0 ? 'Habitación '+(idx +1)+': ' + menorServ.join(' / ') : '';
                                        agesTxt += ages.length > 0 ? 'Habitación '+(idx +1)+': ' + ages.join(',') : '';
                                    });
                                } else if(serv.id_tipo_servicio === "2") {
                                    serviceTxt += ': '+ desglose.origen + ' - ' + desglose.destino;
                                } else if(serv.id_tipo_servicio === "6") {
                                    serviceTxt += ': '+ desglose.aerolinea+ ' ' + desglose.origen +'-'+desglose.destino
                                } else {
                                    serviceTxt += ': '+ serv.descripcion
                                }
                            }
                        });
                        newBody.push(['', serviceTxt, detalleTxt, menoresTxt, agesTxt, moment(serv.inicio_servicio).format('DD/MM/YYYY'), moment(serv.fin_servicio).format('DD/MM/YYYY'), moment(serv.limite_cliente).format('DD/MM/YYYY'), $.fn.dataTable.render.number(',', '.', 2, '$').display(serv.tarifa_publica)]);
                    });
                    newBody.push(['']);
                }
           });
           return newBody;
        },
        loadServiceTypes: function() {
            this.$http.get(this.baseUrl + "/tipoServicios/serviciosapi/").then(function(response) {
                this.service_types_array = response.body;
            }, function() {
                console.log('Error')
            })
        },
        reorderDataHab: function(body) {
            let newBody = [];
            body.forEach(row => {
                row.shift();
                const services = row[row.length -1];

                if(services.length > 0) {
                    
                    services.forEach(serv => {
                        var desglose = $.parseJSON(serv.desglose);
                        let serviceTxt = '';
                        let detalleTxt = '';
                        let menoresTxt = '';
                        let agesTxt = '';
                        let detalleServ = [];
                        let menorServ = [];
                        let ages = []; 
                        this.service_types_array.forEach(stype => {
                            if(stype.id_servicio === serv.id_tipo_servicio && serv.id_tipo_servicio === "1") {
                                serviceTxt = stype.tipo_servicio;
                                if(serv.id_tipo_servicio === "1"){
                                    serviceTxt += ': '+ desglose.hotel;
                                    $.each(desglose.habitaciones, function(idx, h){
                                        $.each(h.pasajeros.adultos, function(idx2, p){
                                            detalleServ.push(p.nombre + ' ' + p.apellidos); 
                                        });
                                        detalleTxt += detalleServ.length > 0 ? detalleServ.join(' / ') : '';
                                        
                                        $.each(h.pasajeros.menores, function(idx2, p){
                                        menorServ.push(p.nombre + ' ' + p.apellidos);
                                        ages.push(p.edad);
                                        });
                                        menoresTxt += menorServ.length > 0 ? menorServ.join(' / ') : '';
                                        agesTxt += ages.length > 0 ? ages.join(',') : '';

                                        newBody.push([row[0], serviceTxt, detalleTxt, menoresTxt, agesTxt, moment(serv.inicio_servicio).format('DD/MM/YYYY'), moment(serv.fin_servicio).format('DD/MM/YYYY')]);

                                        detalleTxt = '';
                                        menoresTxt = '';
                                        agesTxt = '';
                                        detalleServ = [];
                                        menorServ = [];
                                        ages = []
                                    });
                                }
                            }
                        });
                    });
                }
           });
           return newBody;
        },
    }
});

bodasGrupos.sales_table.on('requestChild.dt', function (e, row) {
    row.child(bodasGrupos.showChildRow(row.data())).show();
});
 
// Add event listener for opening and closing details
$('#bodas-datatable tbody').on('click', 'td.dt-control', function () {
    var tr = $(this).parents('tr');
    var row = bodasGrupos.sales_table.row(tr);
    //console.log('click =>' + row.child.isShown())
    if (row.child.isShown()) {
        // This row is already open - close it
        row.child.hide();
        tr.removeClass('shown');
    }
    else {
        // Open this row (the format() function would return the data to be shown)
        row.child(bodasGrupos.showChildRow(row.data())).show();
        tr.addClass('shown');
    }
});