//Vue.http.options.emulateJSON = true;
var appPaymentPromises = new Vue({
    el: "#paymentPromiseModal",
    data: {
        baseUrl: baseUrl,
        period: "",
        amount: 0,
        start_date: moment().format("DD/MM/YYYY"),
        first_payment: false,
        formatter: new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD',
        }),
        payments_saved: [],
        payments_array: [],
    },
    mounted: function () {
        setTimeout(() => {
            this.loadPaymentsPromises();
        }, 3000);
    },
    methods: {
        savePaymentsPromises: function () {
            this.loadPaymentsPromises();

            if (this.payments_saved.length > 0) {
                this.deletePaymentsPromises(1);
            }

            this.$http.post(this.baseUrl + "/promesasPagos/create/", { payments: this.payments_array }).then(function (response) {
                if (response.body.success) {
                    Toast.fire({
                        icon: 'success',
                        title: 'Guardado correctamente'
                    });
                    this.loadPaymentsPromises();
                } else {
                    var error_table = "<table class='table table-bordered text-white'>";
                    response.body.payments.forEach(item => {
                        if (!item.id) {
                            Object.values(item).forEach(element => {
                                error_table += "<tr><td>" + element + "</td></tr>";
                            });
                        }
                    });
                    error_table += "</table>";
                    Swal.fire({
                        title: '¡Ops!',
                        icon: 'error',
                        html: "<p align='center'>Algo salió mal</p>" + error_table,
                    });
                }
            }, function (ex) {
                console.log(ex);
            })
        },
        deletePaymentsPromises: function (guardados) {
            if (this.payments_array.length == 0) {
                Toast.fire({
                    icon: 'warning',
                    title: 'Aún no ha generado promesas de pago.'
                });
            } else {
                this.$http.post(this.baseUrl + "/promesasPagos/deletePaymentsPromises/", { id_venta: appSales.sale_model.id_venta }).then(function (response) {
                    if (guardados != 1) {
                        this.payments_array = [];
                        if (response.body.success) {
                            Toast.fire({
                                icon: 'success',
                                title: 'Eliminado correctamente'
                            });
                        } else {
                            var error_table = "<table class='table table-bordered text-white'>";
                            response.body.payments.forEach(item => {
                                if (!item.id) {
                                    Object.values(item).forEach(element => {
                                        error_table += "<tr><td>" + element + "</td></tr>";
                                    });
                                }
                            });
                            error_table += "</table>";
                            Swal.fire({
                                title: '¡Ops!',
                                icon: 'error',
                                html: "<p align='center'>Algo salió mal</p>" + error_table,
                            });
                        }
                    }
                }, function (ex) {
                    console.log(ex);
                })
            }
            this.loadPaymentsPromises();
        },
        loadPaymentsPromises: function () {
            this.$http.post(this.baseUrl + "/promesasPagos/loadPaymentsPromises/", { id_venta: appSales.sale_model.id_venta }).then(function (response) {
                this.payments_saved = response.body;
            }, function (ex) {
                console.log(ex);
            })
        },
        setModels: function () {
            var that = this;
            appSales.service_array.forEach(element => {
                that.amount += parseFloat(element.tarifa_publica);
                if (!isNaN(parseFloat(element.fee))) {
                    that.amount += parseFloat(element.fee);
                }
            });
            if (parseFloat(appSales.sale_model.cargo_servicios)) this.amount += parseFloat(appSales.sale_model.cargo_servicios);

            this.start_date = moment(appSales.sale_model.log).format("YYYY-MM-DD");
        },
        calculatePaymentPromise: function () {
            this.payments_array = [];
            var start_date = moment(this.start_date);
            var end_date = this.getEarliestDate();
            var periods = 0;
            var period_type = "";

            switch (this.period) {
                case "weekly":
                case "biweekly":
                    period_type = "weeks";
                    periods = end_date.diff(start_date, period_type);
                    if (this.period == "biweekly") periods = periods / 2;
                    periods = parseInt(periods);
                    break;

                case "monthly":
                    period_type = "months";
                    periods = end_date.diff(start_date, period_type);
                    break;
            }

            if (moment(this.start_date).add(periods, period_type).isBefore(end_date)) periods++;
            var promise_amount = this.amount / (periods + 1);
            var that = this;

            for (let index = 0; index <= periods; index++) {
                var add_aux = that.period == "biweekly" ? (index * 2) : index;
                var start = moment(that.start_date);
                var aux_date = moment(that.start_date).add(add_aux, period_type);
                if (aux_date.isAfter(end_date)) {
                    that.payments_array.push({
                        fecha: end_date.format("YYYY-MM-DD"),
                        monto: promise_amount,
                        id_venta: appSales.sale_model.id_venta
                    });
                } else {
                    that.payments_array.push({
                        fecha: start.add(add_aux, period_type).format("YYYY-MM-DD"),
                        monto: promise_amount,
                        id_venta: appSales.sale_model.id_venta
                    });
                }
            }
        },
        getEarliestDate: function () {
            var end_date = appSales.service_array[0].fecha_limite;
            /* if(appSales.sale_model.limite_cancelacion != null) {
                end_date = appSales.sale_model.limite_cancelacion;
            } else {
            } */
            var aux = appSales.service_array.filter(x => x.id_tipo_servicio != 6);
            if (appSales.service_array.length == 1 || aux.length == 0) {
                if (appSales.service_array[0].limite_cliente == "0000-00-00" || appSales.service_array[0].limite_cliente == "" || appSales.service_array[0].limite_cliente == null) {
                    end_date = appSales.service_array[0].fecha_limite;
                } else {
                    end_date = appSales.service_array[0].limite_cliente;
                }
            } else {
                aux.forEach(element => {
                    if (element.limite_cliente == "0000-00-00" || element.limite_cliente == "" || element.limite_cliente == null) {
                        if (moment(element.fecha_limite).isBefore(end_date)) {
                            end_date = element.fecha_limite;
                        }
                    } else {
                        if (moment(element.limite_cliente).isBefore(end_date)) {
                            end_date = element.limite_cliente;
                        }
                    }
                });
            }
            return moment(end_date);
        },
        parseAsPrice: function (amount) {
            return this.formatter.format(amount);
        },
        parseDate: function (date) {
            return moment(date).format("DD/MM/YYYY");
        }
    }
})