var appProveedorCreate = {
    data: {
        provider_model: {
            id_proveedor: 0,
            id_agencia: id_agencia,
            nombre_comercial: "",
            correo: "",
            plataforma_url: "",
            usuario_plataforma: "",
            pwd_plataforma: "",
            cuidad: "",
            estado: "",
            detalles: "",
            comision: "",
            tipo_proveedor: view == "gastos" ? "general" : "turistico"
        },
        providers_array: [],
        index_provider: -1,

        view: view,
    },
    methods: {
        loadProviders: function() {
            this.$http.get(baseUrl + "/proveedores/getProviders?tsp=" + this.provider_model.tipo_proveedor).then(function(response) {
                this.providers_array = response.body;
                this.initSelect2(0);
            }, function() {
                console.log('Error')
            })
        },
        createProvider: function() {
            this.$http.post(baseUrl + "/proveedores/createApi/", this.provider_model).then(function(response) {
                if (response.body.id_proveedor) {
                    this.providers_array.push({
                        id: response.body.id_proveedor,
                        text: response.body.nombre_comercial,
                        comision: response.body.comision,
                    });
                    var newOption = new Option(response.body.nombre_comercial, response.body.id_proveedor, true, true);
                    $("#slct-provider-" + this.index_provider).append(newOption).trigger('change');

                    Toast.fire({
                        icon: 'success',
                        title: 'Proveedor registrado'
                    })
                    this.clearProviderModel();
                } else {
                    var error_table = "<table class='table table-bordered text-white'>"
                    Object.values(response.body).forEach(element => {
                        error_table += "<tr><td>" + element + "</td></tr>";
                    });
                    error_table += "</table>";
                    Swal.fire({
                        title: '¡Ops!',
                        icon: 'error',
                        html: "<p align='center'>Algo salió mal</p>" + error_table,
                    });
                }
            }, function() {
                console.log('Error')
            })
        },
        clearProviderModel: function() {
            this.provider_model = {
                id_proveedor: 0,
                id_agencia: id_agencia,
                nombre_comercial: "",
                correo: "",
                plataforma_url: "",
                usuario_plataforma: "",
                pwd_plataforma: "",
                cuidad: "",
                estado: "",
                detalles: "",
                comision: "",
                tipo_proveedor: "general"
            }
        },
        initSelect2: function(index) {
            var that = this;
            var select2_options = {
                placeholder: "Seleccione un proveedor",
                data: that.providers_array
            }
            if(this.view == "gastos") select2_options.dropdownParent = $("#cu-expenses");
            $(document).on("click", ".add-new-provider", (function() { $("#slct-provider-" + index).select2("close") }))
            $("#slct-provider-" + index).select2(select2_options).on("change", (function() {
                if(that.providers_array.length > 0) {
                    var e = $(this);
                    var index = e.attr('data-index');
                    if(that.view == "ventas") {
                        that.service_array[index].id_proveedor = e.val();
                        var index_provider = that.providers_array.findIndex(x => x.id == e.val());
                        if(that.service_array[index].desglose.comision == "%" && that.providers_array[index_provider].comision != null) {
                            that.service_array[index].comision = that.providers_array[index_provider].comision;
                        }
                    } else {
                        that.expense_model.id_proveedor = e.val();
                    }
                }
            })).on("select2:open", (function() {
                $(".select2-search__field")[0].focus();
                $(document).find(".add-new-provider").length || $(document).find(".select2-results__options").before('<div class="add-new-provider btn btn-flat-success cursor-pointer rounded-0 text-start mb-50 p-50 w-100" data-bs-toggle="modal" data-bs-target="#add-new-provider-sidebar" data-index="' + index + '">' + feather.icons.plus.toSvg({ class: "font-medium-1 me-50" }) + '<span class="align-middle">Agregar Proveedor</span></div>')
            }));
        }
    }
}

var myModalEl = document.getElementById('add-new-provider-sidebar')
myModalEl.addEventListener('hidden.bs.modal', function (event) {
    appSales.clearProviderModel();
});