const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    timer: 3000,
    showConfirmButton: false,
    //timerProgressBar: true,
});

Vue.http.options.emulateJSON = true;
var appPayments = new Vue({
    el: "#app-provider-payments",
    data: {
        baseUrl: baseUrl,

        providers_array: [],
        services_array: [],
        service_model: {},
        services_sales_array: [],
        ways_to_pay: [],
        ways_to_pay_account: [1, 11, 12],
        accounts_array: [],
        payment_model: {
            id_pago: 0,
            monto: "",
            descripcion: "",
            id_forma_pago: 1,
            id_ventaservicio: 0,
            id_cuenta: "",
        },

        total_amount: 0,
        total_payments: 0,
        total_balance: 0,

        service_amount: 0,
        service_payments: 0,
        service_balance: 0,

        name_filter: "",
        service_filter: "",
        provider_filter: "",
    },
    created: function() {
        this.loadAgencySales();
        this.loadAgencyAccounts();
        this.loadProviders();
        this.loadWaysToPay();
        this.loadTypeServices();

        this.formatter = new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD',
        });
    },
    methods: {
        savePayment: function() {
            $("#btn-save-payment").prop("disabled", true);
            this.$http.post(this.baseUrl + "/proveedores/savePayment", this.payment_model).then(function(response) {
                if (response.body.id_pago) {
                    this.service_model.pagosProveedores.push(response.body);
                    this.calculateServiceAmounts();
                    this.getTotalBalance();

                    this.payment_model.id_pago = response.body.id_pago;
                    this.loading_payment = false;
                    $("#btn-save-payment").prop("disabled", false);

                    Toast.fire({
                        icon: 'success',
                        title: 'Pago guardado con éxito'
                    });
                    this.payment_model.monto = "";
                }
            }, function(ex) {
                console.log(ex);
            })
        },
        loadProviders: function() {
            this.$http.get(this.baseUrl + "/proveedores/getProviders").then(function(response) {
                this.providers_array = response.body;
            }, function() {
                console.log('Error')
            })
        },
        loadAgencyAccounts: function() {
            this.$http.get(this.baseUrl + "/caja/getAgencyAccounts").then(function(response) {
                this.accounts_array = response.body;
                if (this.accounts_array.length == 1) {
                    this.payment_model.id_cuenta = response.body[0].id_cuenta;
                }
            }, function() {
                console.log('Error')
            })
        },
        loadWaysToPay: function() {
            this.$http.get(this.baseUrl + "/caja/getWaysToPay").then(function(response) {
                this.ways_to_pay = response.body;
            }, function() {
                console.log('Error')
            })
        },
        loadTypeServices: function() {
            this.$http.get(this.baseUrl + "/tipoServicios/serviciosapi").then(function(response) {
                this.services_array = response.body;
            }, function() {
                console.log('Error')
            })
        },
        loadAgencySales: function() {
            this.$http.get(this.baseUrl + "/proveedores/getServicesSalesAgency").then(function(response) {
                this.services_sales_array = response.body;
                this.getTotalBalance();
                setTimeout(() => {
                    appPayments.initStepper();
                }, 100);
            }, function() {
                console.log('Error')
            })
        },
        getTotalBalance: function() {
            var total = 0;
            var payments = 0;
            this.services_sales_array.forEach(service => {
                total += parseFloat(service.costo);
                service.pagosProveedores.forEach(element => {
                    payments += parseFloat(element.monto);
                });
            });

            this.total_amount = this.formatter.format(total);
            this.total_payments = this.formatter.format(payments);
            this.total_balance = this.formatter.format((total - payments));
        },
        getSaleBalance: function(sale) {
            var cost = parseFloat(sale.costo);

            var payments = 0;
            sale.pagosProveedores.forEach(element => {
                payments += parseFloat(element.monto);
            });

            return this.formatter.format((cost - payments));
        },
        setSaleModels: function(service_code) {
            var index = this.services_sales_array.findIndex(x => x.id_ventaservicio == service_code);
            this.service_model = this.services_sales_array[index];
            this.payment_model.id_ventaservicio = this.service_model.id_ventaservicio;
            this.calculateServiceAmounts();
        },
        calculateServiceAmounts: function() {
            var service_amount = parseFloat(this.service_model.costo);
            this.service_amount = this.formatter.format(this.service_model.costo);

            var service_payments = 0;
            this.service_model.pagosProveedores.forEach(element => {
                service_payments += parseFloat(element.monto);
            });
            this.service_payments = this.formatter.format(service_payments);

            var service_balance = service_amount - service_payments;
            this.service_balance = this.formatter.format(service_balance);
        },
        getLimitDate: function(service) {
            var limit_date = moment(service.fecha_limite);
            return limit_date.subtract(service.dias_limite, "days").format("DD/MM/YYYY");
        },
        initStepper: function() {
            var e = document.querySelector(".checkout-tab-steps");
            this.stepper = new Stepper(e, {
                linear: !1
            });
            $(e).find(".btn-next").each((function() {
                $(this).on("click", (function(s) {
                    appPayments.stepper.next()
                }))
            }))
        },
        wayToPayAccount: function(way_to_pay) {
            var aux = parseInt(way_to_pay);
            return this.ways_to_pay_account.includes(aux);
        },
        formatPrice: function(price) {
            var aux = parseFloat(price);
            return this.formatter.format(aux) + " MXN";
        },
        formatDate: function(date_string) {
            return moment(date_string).format("DD/MM/YYYY");
        }
    },
    computed: {
        filteredServices() {
            var that = this;
            return this.services_sales_array.filter(service => {
                return service.idVenta.idCliente.nombre.toLowerCase().includes(this.name_filter);
            }).filter(service => {
                if (this.service_filter == "") {
                    return service;
                }
                return service.id_tipo_servicio == this.service_filter;
            }).filter(service => {
                if (this.provider_filter == "") {
                    return service;
                }
                return service.id_proveedor == this.provider_filter;
            })
        }
    }
})