var appPayments = new Vue({
    el: "",
    data: {
        baseUrl: baseUrl,

        payments_table: "",
        payments_array: []
    },
    created: function() {
        this.loadPaymentsTable();
    },
    methods: {
        loadPaymentsTable: function() {
            var that = this;
            var url_rq = this.baseUrl + "/reportes/getPagosProveedores";
            this.payments_table = $("#payments-table").DataTable({
                scrollX: true,
                language: { url: "//cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                ajax: {
                    "url": url_rq,
                    "dataSrc": function(json) {
                        that.payments_array = json;
                        return json;
                    }
                },
                dom: '<"card-header border-bottom p-1"<"head-label"><"dt-action-buttons text-end"B>><"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                bDestroy: true,
                buttons: [{
                    extend: "collection",
                    className: "btn btn-outline-secondary dropdown-toggle me-2",
                    text: feather.icons.share.toSvg({ class: "font-small-4 me-50" }) + "Exportar",
                    buttons: [{
                        extend: "csv",
                        text: feather.icons["file-text"].toSvg({ class: "font-small-4 me-50" }) + "Csv",
                        className: "dropdown-item",
                        //exportOptions: { columns: [3, 4, 5, 6, 7] } 
                    }, {
                        extend: "excel",
                        text: feather.icons.file.toSvg({ class: "font-small-4 me-50" }) + "Excel",
                        className: "dropdown-item",
                    }, {
                        extend: "pdf",
                        text: feather.icons.clipboard.toSvg({ class: "font-small-4 me-50" }) + "Pdf",
                        className: "dropdown-item",
                    }, {
                        extend: "copy",
                        text: feather.icons.copy.toSvg({ class: "font-small-4 me-50" }) + "Copiar",
                        className: "dropdown-item",
                    }],
                    init: function(e, t, a) {
                        $(t).removeClass("btn-secondary"), $(t).parent().removeClass("btn-group"), setTimeout((function() { $(t).closest(".dt-buttons").removeClass("btn-group").addClass("d-inline-flex") }), 50)

                    }
                }],
                columns: [{
                    data: "id_pago",
                    render: function(data, type, row, meta) {
                        return meta.row + 1;
                    }
                }, {
                    data: "descripcion",
                }, {
                    data: "idFormaPago.descripcion"
                }, {
                    data: null,
                    render: function(data, type, row, meta) {
                        return (row.id_forma_pago == 1 || row.idCuenta.descripcion == null) ? "No aplica" : row.idCuenta.descripcion;
                    }
                }, {
                    data: "idVentaservicio.descripcion"
                }, {
                    data: "log",
                    render: function(data, type, row, meta) {
                        return moment(data).format("DD/MM/YYYY");
                    }
                    
                }, {
                    data: "monto",
                    render: $.fn.dataTable.render.number(',', '.', 2, '$')
                }],
                drawCallback: function(settings, json) {
                    $("div.head-label").html('<h4 class="card-title" key="Mis ventas">Pagos a proveedores</h4>');
                },
                footerCallback: function(row, data, start, end, display) {
                    var formatter = new Intl.NumberFormat('en-US', {
                        style: 'currency',
                        currency: 'USD',
                    });
                    var api = this.api(),
                        data;

                    var total = api.column(6).data().reduce(function(a, b) {
                        return parseFloat(a) + parseFloat(b);
                    }, 0);
                    $(api.column(6).footer()).html(formatter.format(total));
                }
            });
        }
    }
})