var formatter = new Intl.NumberFormat('en-US', {
    style: 'currency',
    currency: 'USD',
    minimumFractionDigits: 2
        // These options are needed to round to whole numbers if that's what you want.
        //minimumFractionDigits: 0, // (this suffices for whole numbers, but will print 2500.10 as $2,500.1)
        //maximumFractionDigits: 0, // (causes 2500.99 to be printed as $2,501)
});
var appCuentasPorCobrar = new Vue({
    el: '#cuentasPorPagar',
    data: {
        sales_array: [],
        baseUrl: baseUrl,
        date_filter: {
            start: moment().format("YYYY-MM-DD"),
            end: moment().format("YYYY-MM-DD"),
        },
    },
    created: function() {
    },
    mounted: function() {
        this.loadPaymentsTable();
        this.initDateRangePicker();
    },
    methods: {
        loadPaymentsTable: function() {
            $("#payments-table thead tr").clone(!0).appendTo("#payments-table thead"), $("#payments-table thead tr:eq(1) th").each((function(t) {
                var a = $(this).text();
                if(t != 6) {
                    $(this).html('<input type="text" class="form-control form-control-sm" placeholder="BUSCAR ' + a + '" />'), $("input", this).on("keyup change", (function() {
                        appCuentasPorCobrar.payments_table.column(t).search() !== this.value && appCuentasPorCobrar.payments_table.column(t).search(this.value).draw()
                    }))
                }
            }));

            var url_rq = this.baseUrl + "/reportes/ObtenerServiciosDeVentas?start=" + this.date_filter.start + "&end=" + this.date_filter.end;
            var that = this;
            this.payments_table = $("#payments-table").DataTable({
                language: { url: "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                scrollX: true,
                ajax: {
                    url: url_rq,
                    dataSrc: function(json) {
                        appCuentasPorCobrar.sales_array = json;
                        return json;
                    }
                },
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-4"B><"col-sm-12 col-md-4"l><"col-sm-12 col-md-4"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',

                bDestroy: true,
                buttons: [{
                    extend: "collection",
                    className: "btn btn-outline-secondary dropdown-toggle me-2",
                    text: feather.icons.share.toSvg({ class: "font-small-4 me-50" }) + "Exportar",
                    buttons: [{
                        extend: "csv",
                        text: feather.icons["file-text"].toSvg({ class: "font-small-4 me-50" }) + "Csv",
                        className: "dropdown-item",
                        //exportOptions: { columns: [3, 4, 5, 6, 7] } 
                    }, {
                        extend: "excel",
                        text: feather.icons.file.toSvg({ class: "font-small-4 me-50" }) + "Excel",
                        className: "dropdown-item",
                    }, {
                        extend: "pdf",
                        text: feather.icons.clipboard.toSvg({ class: "font-small-4 me-50" }) + "Pdf",
                        className: "dropdown-item",
                    }, {
                        extend: "copy",
                        text: feather.icons.copy.toSvg({ class: "font-small-4 me-50" }) + "Copiar",
                        className: "dropdown-item",
                    }],
                    init: function(e, t, a) {
                        $(t).removeClass("btn-secondary"), $(t).parent().removeClass("btn-group"), setTimeout((function() { $(t).closest(".dt-buttons").removeClass("btn-group").addClass("d-inline-flex") }), 50)

                    }
                }],
                "drawCallback": function(settings, json) {
                    appCuentasPorCobrar.addCssToTable();
                },
                scrollCollapse: true,
                columns: [
                    // { title: '#', data: 'id_pago', },
                    {
                        data: null,
                        render: function(data) {
                            return "<a href='" + this.baseUrl + "/ventas/update/" + data.id_venta + "'>" + data.folio + "</a>";
                        }
                    },
                    { data: 'forma_pago', },
                    {
                        data: 'monto',
                        className: 'text-right',
                        render: function(data) {
                            return formatter.format(data)
                        }
                    },
                    {
                        data: 'fecha_pago',
                        render: function(data) {
                            return moment(data).format('DD/MM/YYYY')
                        }
                    },
                    // { title: 'Pasajero', data: 'pasajero_titular', },
                    // { title: 'Descripción', data: 'descripcion', },
                    { data: 'moneda', },
                    { data: 'usuario', },
                    {
                        data: 'id_pago',
                        orderable: false,
                        render: function(data, type, row, meta) {
                            return '<a href="' + appCuentasPorCobrar.baseUrl + '/caja/viewInvoice/' + row.id_pago + '" target="_blank">' + feather.icons.eye.toSvg() + '</a>';
                        }
                    }

                ],
                "footerCallback": function(row, data, start, end, display) {
                    var api = this.api();
                    total = api
                        .column( 2, { search: 'applied' } )
                        .data()
                        .reduce( function (a, b) {
                            return parseFloat(a) + parseFloat(b);
                        }, 0);
                    /* var monto = 0;
                    data.forEach(pago => {
                        monto += parseFloat(pago.monto);
                    }); */
                    $(api.column(2).footer()).html(
                        formatter.format(total)
                    );
                }
            });
            setTimeout(() => {
                $("div.head-label").html('<h4 class="card-title" key="Mis ventas">Listado de Pagos</h4>');
            }, 50)
        },
        initDateRangePicker: function() {
            $('#date-filter').daterangepicker({
                ranges: {
                    'Hoy': [moment(), moment()],
                    'Ayer': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Semana pasada': [moment().subtract(6, 'days'), moment()],
                    'Últimos 30 días': [moment().subtract(29, 'days'), moment()],
                    'Este mes': [moment().startOf('month'), moment().endOf('month')],
                    'Mes pasado': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                },
                locale: {
                    format: 'DD/MM/YYYY',
                    separator: " - ",
                    applyLabel: "Aplicar",
                    cancelLabel: "Cancelar",
                    fromLabel: "De",
                    toLabel: "a",
                    customRangeLabel: "Personalizado",
                    weekLabel: "W",
                    daysOfWeek: [
                        "Do",
                        "Lu",
                        "Ma",
                        "Mi",
                        "Ju",
                        "Vi",
                        "Sa"
                    ],
                    monthNames: [
                        "Enero",
                        "Febrero",
                        "Marzo",
                        "Abril",
                        "Mayo",
                        "Junio",
                        "Julio",
                        "Agosto",
                        "Septiembre",
                        "Octubre",
                        "Noviembre",
                        "Diciembre"
                    ],
                    firstDay: 1
                },
                startDate: moment(),
                endDate: moment(),
                autoApply: true,
            }, function(start, end, label) {
                console.log(start.format("YYYY-MM-DD"));
                console.log(end.format("YYYY-MM-DD"));
                appCuentasPorCobrar.date_filter.start = start.format("YYYY-MM-DD");
                appCuentasPorCobrar.date_filter.end = end.format("YYYY-MM-DD");
                
                Vue.nextTick(() => {
                    appCuentasPorCobrar.payments_table.ajax.url(appCuentasPorCobrar.baseUrl + "/reportes/ObtenerServiciosDeVentas?start=" + appCuentasPorCobrar.date_filter.start + "&end=" + appCuentasPorCobrar.date_filter.end).load();
                })
            });
        },
        addCssToTable: function() {
            setTimeout(() => {}, 1000);
        },
    },
})