Vue.http.options.emulateJSON = true;
var appShopping = new Vue({
    el: "#shopping-form",
    data: {
        datoscli: '<h4 class="card-title lang" key="Datos del cliente">Datos del cliente</h4>',
        Nombre: '<p class="mb-0 lang" key="Nombre">Nombre</p>',
        Telefono: '<p class="mb-0 lang" key="Teléfono">Teléfono</p>',
        Correo: '<p class="mb-0 lang" key="Correo">Correo</p>',
        datosventa: '<h4 class="card-title lang" key="Datos de la venta">Datos de la venta</h4>',
        pastitular: '<p class="mb-0 lang" key="Pasajero titular">Pasajero titular</p>',
        Fecha: '<p class="mb-0 lang" key="Fecha">Fecha</p>',
        Descripcion: '<p class="mb-0 lang" key="Descripción">Descripción</p>',
        Observaciones: '<p class="mb-0 lang" key="Observaciones">Observaciones</p>',
        Moneda: '<p class="mb-0 lang" key="Moneda">Moneda</p>',
        Serviciosventa: '<h4 class="card-title lang" key="Servicios de la Venta">Servicios de la Venta</h4>',
        Proveedor: '<p class="mb-0 lang" key="Proveedor">Proveedor</p>',
        Codigo: '<p class="mb-0 lang" key="Código">Código</p>',
        Inicioservicio: '<p class="mb-0 lang" key="Inicio del servicio">Inicio del servicio</p>',
        Finservicio: '<p class="mb-0 lang" key="Fin del servicio">Fin del servicio</p>',
        Tiposervicio: '<p class="mb-0 lang" key="Tipo de servicio">Tipo de servicio</p>',
        Comision: '<p class="mb-0 lang" key="Comisión">Comisión</p>',
        Tarifapublica: '<p class="mb-0 lang" key="Tarifa pública">Tarifa pública</p>',
        Costo: '<p class="mb-0 lang" key="Costo">Costo</p>',
        Agregar: '<span class="lang" key="Agregar">Agregar</span>',
        Enviar: '<span class="lang" key="Enviar">Enviar</span>',
        monedas: '<option value="MXN" selected>MXN</option><option value="USD">USD</option>',
        detalle_proveedor: [],
        tipo_servicio: [],
        venta_info: {
            "folio": "",
            "fecha": moment().format('YYYY-MM-DD'),
            "pasajero_titular": "",
            "descripcion": "",
            "observaciones": "",
            "moneda": "MXN",
            "ventasServicioses": [{
                "id_proveedor": "",
                "id_tipo_servicio": "",
                "codigo": "",
                "descripcion": "",
                "inicio_servicio": "",
                "fin_servicio": "",
                "comision": "",
                "tarifa_publica": "",
                "fee": "",
                "costo": "",
            }],
            "idCliente": {                
                "nombre": "",
                "telefono": "",
                "correo": "",
            }
        },
        comision_proveedor_selected: 0,
 
    },
    created: function() {
        this.listaproveedores();
        this.tiposervicio();
        if (id_venta != "") {
            this.loadmodel(id_venta);
        }

    },
    mounted: function() {   
        this.jqueryautocomplete();
    },

    methods: {
        loadmodel: function(id_venta) {
            this.$http
                .get(
                    'https://erp.2businesstravel.com/admin/ventas/loadModels/id/' + id_venta
                )
                .then(function(response) {
                    this.venta_info = response.data;
                })
                .catch(function(error) {
                    console.log(error)
                });
        },
        addShop: function() {
            this.venta_info.ventasServicioses.push({
            });
        },
        deleteShop: function(index) {
            this.venta_info.ventasServicioses.splice(index, 1);
        },
        rellenarComisionProveedor: function(id_proveedor, index2) {
            this.detalle_proveedor.map((proveedor, index, array) => {
                if (proveedor.id_proveedor == id_proveedor) {
                    this.venta_info.ventasServicioses[index2].comision = proveedor.comision;
                    return proveedor;
                }
            });

        },
        listaproveedores: function() {
            this.$http
                .get(
                    'https://erp.2businesstravel.com/admin/proveedores/proveedoresapi/id/' + id_agencia
                )
                .then(function(response) {
                    this.detalle_proveedor = response.data;

                })
                .catch(function(error) {
                    console.log(error)
                });
        },
        tiposervicio: function() {
            this.$http
                .get(
                    'https://erp.2businesstravel.com/admin/tipoServicios/serviciosapi'
                )
                .then(function(response) {
                    this.tipo_servicio = response.data;
                })
                .catch(function(error) {
                    console.log(error)
                });
        },
        enviarDatos: function() {
            var shop = this.venta_info.ventasServicioses;
            var datos_cliente = this.venta_info.idCliente;
            var shop_datos = this.venta_info;
            this.$http
                .post(
                    'https://erp.2businesstravel.com/admin/ventas/createServicio', {
                        "shop": shop,
                        "datos_cliente": datos_cliente,
                        "shop_datos": shop_datos
                    }
                )
                .then(function(response) {
                    this.response_shop = response.data;
                    this.response_shop.id_venta;
                    console.log(this.response_shop);
                    //console.log(this.response_shop.id_venta);        	
                    window.location.href = 'https://erp.2businesstravel.com/admin/ventas/view/id/' + this.response_shop.id_venta
                })
                .catch(function(error) {
                    console.log(error)
                });
        },
        addServicios: function() {
            var shop = this.venta_info.ventasServicioses;
            var datos_cliente = this.venta_info.idCliente;
            var shop_datos = this.venta_info;
            this.$http
                .post(
                    'https://erp.2businesstravel.com/admin/ventas/updateServicio/id/' + id_venta, {
                        "shop": shop,
                        "datos_cliente": datos_cliente,
                        "shop_datos": shop_datos
                    }
                )
                .then(function(response) {
                    this.response_shop = response.data;
                    this.response_shop.id_venta;      	
                    window.location.href = 'https://erp.2businesstravel.com/admin/ventas/view/id/' + id_venta
                })
                .catch(function(error) {
                    console.log(error);
                });
        },
        jqueryautocomplete: function(){          
        $("#autocompleteInput").autocomplete({
            source:function(request,response){
                $.ajax({
                    url:"https://erp.2businesstravel.com/admin/clientes/clientesapiv2",
                    type:"GET",
                    dataType:"json",
                    data:{
                        search: request.term,                       
                    },
                    success:function(data){
                       response($.map(data, function (item) {
                            return {
                                label: item.label,
                                value: item.label,
                                id: item.value,                           
                                correo: item.correo,                              
                            }

                        }))

                    }
                })

            }
        });
        $('#autocompleteInput').on('autocompleteselect', function (e, ui) {
        $('#nombrecliente').html('You selected: ' + ui.item.label + ' y el correo ' + ui.item.correo + 'id cliente' + ui.item.id)
        $('#columna-correo').html(ui.item.correo)
            appShopping.venta_info.idCliente.id_cliente= ui.item.id
            appShopping.venta_info.idCliente.nombre= ui.item.label
                            
        });

       },

    },

})

