var appCardsInfo = new Vue({
    el: "#cards-info",
    data: {
        baseUrl: baseUrl,
        formatter: "",

        payments_table: "",
        payments_array: [],

        total_cobrar: "Calculando...",
        total_pagar: "Calculando...",
        total_ventas: "Calculando...",
        pagos_mes: "Calculando...",
        
        user_info: user_info,
    },
    created: function() {
        this.formatter = new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD',
        });
    },
    mounted: function() {
        this.loadInfo();
        //console.log(user_info, user_info.rol);
        setTimeout(() => {
            appCardsInfo.loadPaymentsDueSoonTable();
        }, 1000);
    },
    methods: {
        loadInfo: function() {
            this.$http.post(this.baseUrl + '/caja/getAgencyDashboardTotal/').then(function(response) {
                var rp = response.body;
                this.total_cobrar = this.formatter.format(rp.total_cobrar);
                this.total_pagar = this.formatter.format(rp.total_pagar);
                this.total_ventas = this.formatter.format(rp.total_ventas);
                this.pagos_mes = this.formatter.format(rp.pagos_mes);
            }, function(e) {
                console.log(e);
            });
        },
        loadPaymentsDueSoonTable: function() {
            var that = this;
            var url_rq = this.baseUrl + "/site/ObtenerServiciosProximasAVencer";
            this.payments_table = $(".datatable").DataTable({
                scrollX: true,
                bDestroy: true,
                scrollCollapse: true,
                paging: false,
                order: false,
                searching: false,
                language: { url: "//cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                ajax: {
                    "url": url_rq,
                    "dataSrc": function(json) {
                        that.payments_array = json;
                        return json;
                    }
                },
                columns: [{
                    data: "folio",
                    className: 'text-center',
                    render: function(data, type, row) {
                        if(user_info.rol !== 'Contabilidad') {
                            return "<a href='/admin/ventas/update/" + row.id_venta + "'>" + row.folio + "</a>";
                        } else {
                            return row.folio;
                        }
                    }
                }, {
                    data: null,
                    className: 'text-right',
                    render: function(data) {
                        var fee = parseFloat(data.fee);
                        var tarifa_publica = parseFloat(data.tarifa_publica);
                        if (isNaN(fee) || typeof fee == 'undefined') {
                            fee = 0;
                        }
                        if (isNaN(tarifa_publica) || typeof tarifa_publica == 'undefined') {
                            tarifa_publica = 0;
                        }
                        return appCardsInfo.formatter.format(parseFloat(tarifa_publica) + parseFloat(fee));
                    }
                }, {
                    data: null,
                    className: 'text-center',
                    render: function(data) {
                        return moment(data.fecha_limite).format('DD/MM/YYYY')
                    }
                }],
                footerCallback: function(row, data, start, end, display) {
                    var api = this.api();
                    var fee = 0;
                    var total = 0;
                    var tarifa_publica = 0;
                    console.log(data);
                    data.forEach(servicio => {
                        if (servicio.fee) {
                            fee += parseFloat(servicio.fee);
                        }
                        if (servicio.tarifa_publica) {
                            tarifa_publica += parseFloat(servicio.tarifa_publica);
                        }

                        if (isNaN(fee) || typeof fee == 'undefined') {
                            fee = 0;
                        }
                        if (isNaN(tarifa_publica) || typeof tarifa_publica == 'undefined') {
                            tarifa_publica = 0;
                        }
                    });

                    $(api.column(1).footer()).html(
                        appCardsInfo.formatter.format(parseFloat(tarifa_publica) + parseFloat(fee))
                    );
                }
            });
        }
    }
})