const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    timer: 3000,
    showConfirmButton: false,
});

Vue.http.options.emulateJSON = true;
var appRequest = new Vue({
    el: "#request",
    data: {
        baseUrl: baseUrl,
        request_status: ["Seguimiento", "En proceso", "Contrato", "Venta", "Cancelada"],
        request_filter: "",
        date_filter: {
            start: moment().format("DD/MM/YYYY"),
            end: moment().format("DD/MM/YYYY"),
        },
        status_filter: "Seguimiento",

        request_array: [],
        customers_array: [],
        request_model: {
            id_solicitud: 0,
            descripcion: "",
            id_usuario: 0,
            id_agencia: 0,
            id_cliente: 0,
            estatus: "Seguimiento",
            log: "",
        }
    },
    mounted: function() {
        this.getRequests();
        this.loadCustomers();
    },
    methods: {
        getRequests: function() {
            this.$http.post(this.baseUrl + '/solicitudes/getRequests/').then(function(response) {
                this.request_array = response.body;
            }, function(e) {
                console.log(e);
            });
        },
        loadCustomers: function() {
            this.$http.get(this.baseUrl + "/ventas/searchCustomers/").then(function(response) {
                this.customers_array = response.body;
                this.initSelect2Customers();
                this.initDateRangePicker();
            }, function() {
                console.log('Error')
            })
        },
        createRequest: function() {
            this.$http.post(this.baseUrl + '/solicitudes/create/', this.request_model).then(function(response) {
                if (response.body.id_solicitud) {
                    this.request_array.push(response.body);
                    this.clearRequestModel();
                    Toast.fire({
                        icon: 'success',
                        title: 'Solicitud registrada'
                    });
                } else {
                    var error_table = "<table class='table table-bordered text-white'>"
                    Object.values(response.body).forEach(element => {
                        error_table += "<tr><td>" + element + "</td></tr>";
                    });
                    error_table += "</table>";
                    Swal.fire({
                        title: '¡Ops!',
                        icon: 'error',
                        html: "<p align='center'>Algo salió mal</p>" + error_table,
                    });
                }
            }, function(e) {
                console.log(e);
            });
        },
        initSelect2Customers: function() {
            var p = $(".invoiceto");
            $(document).on("click", ".add-new-customer", (function() { p.select2("close") }))
            p.select2({
                placeholder: "Seleccione un cliente",
                data: appRequest.customers_array,
                dropdownParent: $("#request-cu"),
            }).on("change", (function() {
                var e = $(this);
                appRequest.request_model.id_cliente = e.val();
            })).on("select2:open", (function() {
                $(".select2-search__field")[0].focus();
                $(document).find(".add-new-customer").length || $(document).find(".select2-results__options").before('<div class="add-new-customer btn btn-flat-success cursor-pointer rounded-0 text-start mb-50 p-50 w-100" data-bs-toggle="modal" data-bs-target="#cu-customers">' + feather.icons.plus.toSvg({ class: "font-medium-1 me-50" }) + '<span class="align-middle">Agregar Cliente</span></div>')
            }))
        },
        initDateRangePicker: function() {
            $('#date-filter').daterangepicker({
                ranges: {
                    'Hoy': [moment(), moment()],
                    'Ayer': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Semana pasada': [moment().subtract(6, 'days'), moment()],
                    'Últimos 30 días': [moment().subtract(29, 'days'), moment()],
                    'Este mes': [moment().startOf('month'), moment().endOf('month')],
                    'Mes pasado': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                },
                locale: {
                    format: 'DD/MM/YYYY',
                    separator: " - ",
                    applyLabel: "Aplicar",
                    cancelLabel: "Cancelar",
                    fromLabel: "De",
                    toLabel: "a",
                    customRangeLabel: "Personalizado",
                    weekLabel: "W",
                    daysOfWeek: [
                        "Do",
                        "Lu",
                        "Ma",
                        "Mi",
                        "Ju",
                        "Vi",
                        "Sa"
                    ],
                    monthNames: [
                        "Enero",
                        "Febrero",
                        "Marzo",
                        "Abril",
                        "Mayo",
                        "Junio",
                        "Julio",
                        "Agosto",
                        "Septiembre",
                        "Octubre",
                        "Noviembre",
                        "Diciembre"
                    ],
                    firstDay: 1
                },
                startDate: moment(),
                endDate: moment(),
                autoApply: true,
            }, function(start, end, label) {
                appRequest.date_filter.start = start.format("DD/MM/YYYY");
                appRequest.date_filter.end = end.format("DD/MM/YYYY");
            });
        },
        clearRequestModel: function() {
            this.request_model = {
                id_solicitud: 0,
                descripcion: "",
                id_usuario: 0,
                id_agencia: 0,
                id_cliente: 0,
                estatus: "Seguimiento",
                log: "",
            };
        },
        formatDate: function(string_date) {
            return moment(string_date).format("DD/MM/YYYY");
        }
    },
    computed: {
        filteredRequests() {
            var start = moment(this.date_filter.start, "DD/MM/YYYY");
            var end = moment(this.date_filter.end, "DD/MM/YYYY");
            return this.request_array.filter(request => {
                return request.descripcion.toLowerCase().includes(this.request_filter);
            }).filter(date => {
                var log = moment(date.log, "YYYY-MM-DD");
                return log.isBetween(start, end, undefined, "[]");
            }).filter(status => {
                return this.status_filter == status.estatus;
            });
        }
    }
})