const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    timer: 3000,
    showConfirmButton: false,
});

Vue.http.options.emulateJSON = true;
var appRequestDetail = new Vue({
    el: "#request-detail",
    data: {
        baseUrl: baseUrl,
        view: view,
        request_code: request_code,

        prices_array: [],
        prices_string: "", //aux prices_array
        users_array: [],
        customers_array: [],
        request_model: {
            id_solicitud: 0,
            descripcion: "",
            id_usuario: 0,
            id_agencia: 0,
            id_cliente: 0,
            estatus: "Seguimiento",
            log: "",
        }
    },
    created: function() {
        this.formatter = new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD',
        });
    },
    mounted: function() {
        this.getRequestInfo();
        this.loadPriceTable();
        this.loadCustomers();
        this.loadAgenciesUsers();
    },
    methods: {
        getRequestInfo: function() {
            this.$http.post(this.baseUrl + '/solicitudes/getRequestInfo/' + this.request_code).then(function(response) {
                this.request_model = response.body;
            }, function(e) {
                console.log(e);
            });
        },
        getPricesRequest: function() {
            this.$http.post(this.baseUrl + '/cotizaciones/getPricesRequest/' + this.request_code).then(function(response) {
                this.prices_array = response.body;
                Vue.nextTick(function() {
                    feather.replace();
                });
            }, function(e) {
                console.log(e);
            });
        },
        loadAgenciesUsers: function() {
            this.$http.post(this.baseUrl + '/usuariosAgencias/usuariosapi/').then(function(response) {
                this.users_array = response.body;
            }, function(e) {
                console.log(e);
            });
        },
        loadPriceTable: function() {
            var that = this;
            var url_rq = this.baseUrl + '/cotizaciones/getPricesRequest/' + this.request_code;
            this.accounts_table = $("#price-table").DataTable({
                scrollX: true,
                bDestroy: true,
                scrollCollapse: true,
                language: { url: "//cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                ajax: {
                    "url": url_rq,
                    "dataSrc": function(json) {
                        that.prices_array = json;
                        return json;
                    }
                },
                columns: [{
                    data: "id_cuenta",
                    render: function(data, type, row, meta) {
                        return meta.row + 1;
                    }
                }, {
                    title: "Cliente",
                    data: "idCliente.nombre",
                }, {
                    title: "Fecha creación",
                    data: "log",
                    render: $.fn.dataTable.render.moment("YYYY-MM-DD HH:mm:ss", "DD/MM/YYYY HH:mm:ss")
                }, {
                    title: "Estancia",
                    render: function(data, type, row, meta) {
                        return moment(row.fecha_inicial).format("DD/MM/YYYY") + " a " + moment(row.fecha_final).format("DD/MM/YYYY");
                    }
                }, {
                    title: "T. Pública",
                    render: function(data, type, row, meta) {
                        var total = 0;
                        row.cotizacionDetalles.forEach(element => {
                            total += parseFloat(element.total_publico);
                            if(!isNaN(parseFloat(element.fee))) {
                                total += parseFloat(element.fee);
                            }
                        });
                        return that.formatter.format(total);
                    }
                }, {
                    title: "Agente",
                    data: "idUsuario.username"
                }, {
                    title: "Estatus",
                    render: function(data, type, row, meta) {
                        return row.contrato.id_contrato == undefined ? "Cotización" : "Contrato";
                    }
                }, {
                    title: "",
                    sortable: false,
                    render: function(data, type, row, meta) {
                        return '<a href="'+ that.baseUrl +'/cotizaciones/update/' + row.id_cotizacion + '">' + feather.icons.eye.toSvg() + '</a>';
                    }
                }]
            });
        },
        loadCustomers: function() {
            this.$http.get(this.baseUrl + "/ventas/searchCustomers/").then(function(response) {
                this.customers_array = response.body;
                this.initSelect2Customers();
            }, function() {
                console.log('Error')
            })
        },
        updateRequest: function() {
            this.$http.post(this.baseUrl + '/solicitudes/update/', this.request_model).then(function(response) {
                if (response.body.id_solicitud) {
                    Toast.fire({
                        icon: 'success',
                        title: 'Solicitud actualizada'
                    });
                } else {
                    var error_table = "<table class='table table-bordered text-white'>"
                    Object.values(response.body).forEach(element => {
                        error_table += "<tr><td>" + element + "</td></tr>";
                    });
                    error_table += "</table>";
                    Swal.fire({
                        title: '¡Ops!',
                        icon: 'error',
                        html: "<p align='center'>Algo salió mal</p>" + error_table,
                    });
                }
            }, function(e) {
                console.log(e);
            });
        },
        setPriceModel: function(price_id) {
            var index = this.prices_array.findIndex(x => x.id_cotizacion = price_id);
            appPricesCrud.price_model = this.prices_array[index];
        },
        getTotalPrice: function(price) {
            var total = 0;
            price.cotizacionDetalles.forEach(item => {
                total += parseFloat(item.total_publico);
            });
            return this.formatPrice(total);
        },
        getTotalBooking: function(bookings) {
            var total = 0;
            bookings.forEach(element => {
                total += parseFloat(element.total_publico);
            });
            return this.formatPrice(total);
        },
        initSelect2Customers: function() {
            var p = $(".invoiceto");
            $(document).on("click", ".add-new-customer", (function() { p.select2("close") }))
            p.select2({
                placeholder: "Seleccione un cliente",
                data: appRequestDetail.customers_array,
            }).on("change", (function() {
                var e = $(this);
                appRequestDetail.request_model.id_cliente = e.val();
            })).on("select2:open", (function() {
                $(".select2-search__field")[0].focus();
            }));
            $('.invoiceto').val(appRequestDetail.request_model.id_cliente);
            $('.invoiceto').trigger("change");
        },
        formatDate: function(string_date) {
            return moment(string_date).format("DD/MM/YYYY");
        },
        formatPrice: function(price) {
            var aux = parseFloat(price);
            return aux ? this.formatter.format(aux) + " MXN" : "0.00 MXN";
        },
    }
})