flatpickr.localize(flatpickr.l10ns.es);
flatpickr.l10ns.default.firstDayOfWeek = 7;
const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    timer: 3000,
    showConfirmButton: false,
    //timerProgressBar: true,
});

Vue.http.options.emulateJSON = true;
var appSales = new Vue({
    el: "#app-sales",
    mixins: [ appProveedorCreate ],
    data: {
        baseUrl: baseUrl,
        action: action,
        id_usuario: id_usuario,
        id_agencia: id_agencia,
        payment_limit: "",

        formatter: new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD',
        }),
        array_adults: [1, 2, 3, 4, 5, 6, 7, 8],
        array_children: [0, 1, 2, 3, 4, 5],
        age_options: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17],
        total_guests: "2 adultos, 0 menor(es)",
        
        check_sale_payments: true,
        load_info: false,
        sale_model: {
            id_venta: 0,
            folio: "",
            fecha: "",
            pasajero_titular: "",
            descripcion: "",
            observaciones: "",
            terminos_condiciones: "",
            moneda: "MXN",
            estatus: "venta",
            id_agencia: id_agencia,
            id_usuario: id_usuario,
            id_cliente: 0,
        },
        service_array: [{
            id_ventaservicio: 0,
            id_venta: 0,
            id_proveedor: "",
            id_tipo_servicio: "",
            codigo: "",
            descripcion: "",
            desglose: {},
            inicio_servicio: "",
            fin_servicio: "",
            fecha_limite: "",
            limite_cliente: "",
            comision: "",
            comision_pesos: "",
            tarifa_publica: "",
            fee: "",
            costo: "",
            num_habs: 1,
            desglose: {
                comision: "%"
            }
        }],
        index_aux: 0,
        comission_type: "%",
        customers_array: [],
        customer_selected: {},

        service_types_array: [],
        hotels_array: [],

        sale_flatpickr: "",
        flatpickr_array: [],
        flatpickr_limit: [],
        flatpickr_customer_limit: [],
        flatpickr_arrive: [],
        flatpickr_end: [],
    },
    created: function() {
        this.loadProviders();
        this.loadCustomers();
        this.loadServiceTypes();
    },
    mounted: function() {
        var i = new Date;
        this.sale_flatpickr = $(".date-picker").flatpickr({
            defaultDate: i,
            dateFormat: "d/m/Y",
        });
        if (this.action == "update") {
            Vue.nextTick(() => {
                appSales.loadSaleInfo();
            })
        } else {
            this.initLibraries();
        }
    },
    methods: {
        saveSale: function() {
            event.preventDefault();
            this.sale_model.fecha = moment($(".date-picker").val(), "DD/MM/YYYY").format("YYYY-MM-DD");
            this.service_array.forEach((element, index) => {
                var array_dates = ($("#dp-stay-" + index).val()).split(" a ");
                appSales.service_array[index].inicio_servicio = moment(array_dates[0], "DD/MM/YYYY").format("YYYY-MM-DD");
                fecha_final = array_dates[0];
                if (array_dates.length > 1) {
                    fecha_final = array_dates[1];
                }
                appSales.service_array[index].fin_servicio = moment(fecha_final, "DD/MM/YYYY").format("YYYY-MM-DD");
                appSales.service_array[index].fecha_limite = moment($("#dp-limit-" + index).val(), "DD/MM/YYYY").format("YYYY-MM-DD");
                appSales.service_array[index].limite_cliente = moment($("#dp-customer-limit-" + index).val(), "DD/MM/YYYY").format("YYYY-MM-DD");
                if ($("#dp-customer-limit-" + index).val() == null && $("#dp-customer-limit-" + index).val() == "" && $("#dp-customer-limit-" + index).val() == "0000-00-00") appSales.service_array[index].limite_cliente = appSales.service_array[index].fecha_limite;
            });
            var rq = {
                sale: appSales.sale_model,
                services: appSales.service_array,
            }
            var url_rq = "";
            if (this.action == "update") {
                url_rq = this.baseUrl + "/ventas/updateApi/";
            } else {
                url_rq = this.baseUrl + "/ventas/createApi/";
            }
            this.$http.post(url_rq, rq).then(function(response) {
                // console.log(response);
                // return true;
                if(response.body.success) {
                    Toast.fire({
                        icon: 'success',
                        title: 'Venta registrada'
                    })
                    window.location.href = this.baseUrl + '/ventas/update/' + response.body.sale.id_venta;
                } else {
                    var error_table = "<table class='table table-bordered text-white'>";
                        switch(response.body.error) {
                            case "sale":
                            case "group":
                            case "contract":
                            case "event":
                                Object.values(response.body[response.body.error]).forEach(element => {
                                    error_table += "<tr><td>" + element + "</td></tr>";
                                });
                                break;
                            
                            case "services":
                                response.body.services.forEach(item => {
                                    if(!item.id_ventaservicio) {
                                        Object.values(item).forEach(element => {
                                            error_table += "<tr><td>" + element + "</td></tr>";
                                        });
                                    }
                                });
                                break;
                        }
                        error_table += "</table>";
                        Swal.fire({
                            title: '¡Ops!',
                            icon: 'error',
                            html: "<p align='center'>Error al crear '" + response.body.error +"'</p>" + error_table,
                        });
                }
            }, function() {
                console.log('Error')
            })
        },
        loadSaleInfo: function() { //se usará para cuando sea update de una venta 
            this.sale_model.id_venta = id_venta;
            this.$http.get(this.baseUrl + "/ventas/getSaleInfo/" + this.sale_model.id_venta).then(function(response) {
                this.sale_model = response.body;
                this.service_array = response.body.ventasServicioses;
                this.getPaymentLimit();

                this.load_info = true;
                appPaymentPromises.setModels();
                this.sale_flatpickr.setDate(moment(this.sale_model.fecha).format("DD/MM/YYYY"));

                this.customers_array.push({
                    id: response.body.idCliente.id_cliente,
                    text: response.body.idCliente.nombre,
                    mail: response.body.idCliente.correo,
                    phone: response.body.idCliente.telefono,
                })
                var newOption = new Option(this.sale_model.idCliente.nombre, this.sale_model.idCliente.id_cliente, true, true);
                $('.invoiceto').append(newOption).trigger('change');

                Vue.nextTick(function() {
                    feather.replace();
                    for (let index = 0; index < appSales.service_array.length; index++) {
                        if (appSales.check_sale_payments) appSales.check_sale_payments = appSales.service_array[index].pagosDetalles.length > 0;

                        /* if(appSales.service_array[index].id_tipo_servicio == 6) {
                            if(appSales.service_array[index].desglose.internacional) {
                                appSales.service_array[index].desglose.internacional = false;
                            } else {
                                appSales.service_array[index].desglose.internacional = true;
                                if(!appSales.service_array[index].desglose.fecha_nacimiento) {
                                    appSales.service_array[index].desglose.fecha_nacimiento = {
                                        dia: "",
                                        mes: "",
                                        año: ""
                                    };
                                }
                            }
                        } */

                        appSales.flatpickr_array.push($("#dp-stay-" + index).flatpickr({
                            mode: "range",
                            dateFormat: "d/m/Y",
                        }));
                        appSales.flatpickr_array[index].setDate(moment(appSales.service_array[index].inicio_servicio).format("DD/MM/YYYY") + " a " + moment(appSales.service_array[index].fin_servicio).format("DD/MM/YYYY"));

                        appSales.flatpickr_limit.push($("#dp-limit-" + index).flatpickr({
                            dateFormat: "d/m/Y",
                            minDate: "today"
                        }));
                        if (appSales.service_array[index].fecha_limite != null || appSales.service_array[index].fecha_limite != "" || appSales.service_array[index].fecha_limite != "0000-00-00") appSales.flatpickr_limit[index].setDate(moment(appSales.service_array[index].fecha_limite).format("DD/MM/YYYY"));

                        appSales.flatpickr_customer_limit.push($("#dp-customer-limit-" + index).flatpickr({
                            dateFormat: "d/m/Y",
                            minDate: "today"
                        }));
                        if (appSales.service_array[index].limite_cliente != null || appSales.service_array[index].limite_cliente != "" || appSales.service_array[index].limite_cliente != "0000-00-00") appSales.flatpickr_customer_limit[index].setDate(moment(appSales.service_array[index].limite_cliente).format("DD/MM/YYYY"));

                        appSales.initSelect2(index);
                        $('#slct-provider-' + index).val(appSales.service_array[index].id_proveedor);
                        $('#slct-provider-' + index).trigger("change");

                        if(appSales.service_array[index].id_tipo_servicio == 1) {
                            appSales.initHotelSelect2(index);
                            var newOption = new Option(appSales.service_array[index].desglose.hotel, appSales.service_array[index].desglose.hotel, true, true);
                            $('#slct-hotel-' + index).append(newOption);
                            $('#slct-hotel-' + index).trigger('change');
                        }
                    }
                })
            }, function() {
                console.log('Error')
            })
        },
        loadCustomers: function() {
            this.$http.get(this.baseUrl + "/ventas/searchCustomers/").then(function(response) {
                this.customers_array = response.body;
                this.initSelect2Customers();
            }, function() {
                console.log('Error')
            })
        },
        loadServiceTypes: function() {
            this.$http.get(this.baseUrl + "/tipoServicios/serviciosapi/").then(function(response) {
                this.service_types_array = response.body;
            }, function() {
                console.log('Error')
            })
        },
        changeComissionType: function(index) {
            this.service_array[index].desglose.comision = this.service_array[index].desglose.comision == "%" ? "MXN" : "%";
        },
        addRoom: function(index) {
            this.service_array[index].desglose.habitaciones.push({
                plan: "",
                adultos: "2",
                menores: "0",
                ocupacion: "2 adulto(s), 0 menor(es)",
                pasajeros: {
                    adultos: [{
                        nombre: "",
                        apellidos: "",
                    }, {
                        nombre: "",
                        apellidos: "",
                    }],
                    menores: [],
                },
                tipo_cama: "",
                total_neto: "",
                total_publico: "",
                base_habitacion: "",
                tipo_habitacion: ""
            });
            Vue.nextTick(function() {
                feather.replace();
            });
        },
        deleteRoom: function(index_price, index) {
            this.service_array[index_price].desglose.habitaciones.splice(index, 1);
        },
        changeOccupancy: function(index_price, index = -1) {
            if(index >= 0) {
                this.service_array[index_price].desglose.habitaciones[index].ocupacion = this.service_array[index_price].desglose.habitaciones[index].adultos + " adulto(s), " + this.service_array[index_price].desglose.habitaciones[index].menores + " menor(es)";
                
                var that = this;

                /* add - remove adults of pax array */
                if(this.service_array[index_price].desglose.habitaciones[index].adultos > this.service_array[index_price].desglose.habitaciones[index].pasajeros.adultos.length) {
                    var count = this.service_array[index_price].desglose.habitaciones[index].adultos - this.service_array[index_price].desglose.habitaciones[index].pasajeros.adultos.length;
                    for (let i = 0; i < count; i++) {
                        that.service_array[index_price].desglose.habitaciones[index].pasajeros.adultos.push({
                            nombre: "",
                            apellidos: "",
                        });
                    }
                }

                if(this.service_array[index_price].desglose.habitaciones[index].adultos < this.service_array[index_price].desglose.habitaciones[index].pasajeros.adultos) {
                    var count = this.service_array[index_price].desglose.habitaciones[index].pasajeros.adultos.length - this.service_array[index_price].desglose.habitaciones[index].adultos;
                    for (let i = 0; i < count; i++) {
                        that.service_array[index_price].desglose.habitaciones[index].pasajeros.adultos.pop();
                    }
                }
                /* add - remove adults of pax array */

                /* add - remove children of pax array */
                if(this.service_array[index_price].desglose.habitaciones[index].menores > this.service_array[index_price].desglose.habitaciones[index].pasajeros.menores.length) {
                    var count = this.service_array[index_price].desglose.habitaciones[index].menores - this.service_array[index_price].desglose.habitaciones[index].pasajeros.menores.length;
                    for (let i = 0; i < count; i++) {
                        that.service_array[index_price].desglose.habitaciones[index].pasajeros.menores.push({
                            nombre: "",
                            apellidos: "",
                            fecha_nacimiento: {
                                dia: "",
                                mes: "",
                                año: ""
                            },
                            edad: "",
                        });
                    }
                }

                if(this.service_array[index_price].desglose.habitaciones[index].menores < this.service_array[index_price].desglose.habitaciones[index].pasajeros.menores.length) {
                    var count = this.service_array[index_price].desglose.habitaciones[index].pasajeros.menores.length - this.service_array[index_price].desglose.habitaciones[index].menores;
                    for (let i = 0; i < count; i++) {
                        that.service_array[index_price].desglose.habitaciones[index].pasajeros.menores.pop();
                    }
                }
                /* add - remove children of pax array */
            } else {
                this.service_array[index_price].desglose.ocupacion = this.service_array[index_price].desglose.adultos + " adulto(s), " + this.service_array[index_price].desglose.menores + " menor(es)";

                var that = this;
                
                /* add - remove adults of pax array */
                if(this.service_array[index_price].desglose.adultos > this.service_array[index_price].desglose.pasajeros.adultos.length) {
                    var count = this.service_array[index_price].desglose.adultos - this.service_array[index_price].desglose.pasajeros.adultos.length;
                    for (let i = 0; i < count; i++) {
                        that.service_array[index_price].desglose.pasajeros.adultos.push({
                            nombre: "",
                            apellidos: "",
                        });
                    }
                }

                if(this.service_array[index_price].desglose.adultos < this.service_array[index_price].desglose.pasajeros.adultos.length) {
                    var count = this.service_array[index_price].desglose.pasajeros.adultos.length - this.service_array[index_price].desglose.adultos;
                    for (let i = 0; i < count; i++) {
                        that.service_array[index_price].desglose.pasajeros.adultos.pop();
                    }
                }
                /* add - remove adults of pax array */

                /* add - remove children of pax array */
                if(this.service_array[index_price].desglose.menores > this.service_array[index_price].desglose.pasajeros.menores.length) {
                    var count = this.service_array[index_price].desglose.menores - this.service_array[index_price].desglose.pasajeros.menores.length;
                    for (let i = 0; i < count; i++) {
                        that.service_array[index_price].desglose.pasajeros.menores.push({
                            nombre: "",
                            apellidos: "",
                            fecha_nacimiento: {
                                dia: "",
                                mes: "",
                                año: ""
                            },
                            edad: "",
                        });
                    }
                }

                if(this.service_array[index_price].desglose.menores < this.service_array[index_price].desglose.pasajeros.menores.length) {
                    var count = this.service_array[index_price].desglose.pasajeros.menores.length - this.service_array[index_price].desglose.menores;
                    for (let i = 0; i < count; i++) {
                        that.service_array[index_price].desglose.pasajeros.menores.pop();
                    }
                }
                /* add - remove children of pax array */
            }
        },
        editPaxList: function(index) {
            if(this.service_array[index].id_tipo_servicio == 6) {
                if(this.service_array[index].desglose.internacional) {
                    $("#modal-pax").removeClass("modal-lg");
                    $("#modal-pax").addClass("modal-xl");
                } else {
                    $("#modal-pax").removeClass("modal-xl");
                    $("#modal-pax").addClass("modal-lg");
                }
            } else {
                if($("#modal-pax").hasClass("modal-xl")) {
                    $("#modal-pax").removeClass("modal-xl");
                    $("#modal-pax").addClass("modal-lg");
                }
            }
            this.index_aux = index;
        },
        setAgeChild: function(index) {
            if(this.service_array[this.index_aux].desglose.pasajeros.menores[index].fecha_nacimiento.año != "" && this.service_array[this.index_aux].desglose.pasajeros.menores[index].fecha_nacimiento.año.length == 4) {
                var birthdate = this.service_array[this.index_aux].desglose.pasajeros.menores[index].fecha_nacimiento.año + "-" + this.service_array[this.index_aux].desglose.pasajeros.menores[index].fecha_nacimiento.mes + "-" + this.service_array[this.index_aux].desglose.pasajeros.menores[index].fecha_nacimiento.dia;

                var end = moment();
                var start = moment(birthdate);
                var age = end.diff(start, 'years', true);
                this.service_array[this.index_aux].desglose.pasajeros.menores[index].edad = parseInt(age);
            }
        },
        changeRoundService: function(index) {
            var service_date = $("#dp-stay-" + index).val();
            if(this.service_array[index].desglose.redondo) {
                appSales.flatpickr_array[index].set("mode", "range");
                var new_date = $("#dp-stay-" + index).val() + " a " + moment($("#dp-stay-" + index).val(), "DD/MM/YYYY").add(3, "days").format("DD/MM/YYYY");
                appSales.flatpickr_array[index].setDate(new_date);
            } else {
                if(service_date != "") {
                    var array_date = ($("#dp-stay-" + index).val()).split(" a ");
                    var new_date = array_date[0];
                    appSales.flatpickr_array[index].setDate(new_date);
                }
                appSales.flatpickr_array[index].set("mode", "single");
            }
        },
        addService: function() {
            this.service_array.push({
                id_ventaservicio: 0,
                id_venta: action == "update" ? id_venta : 0,
                id_proveedor: "",
                id_tipo_servicio: "",
                codigo: "",
                descripcion: "",
                desglose: {},
                inicio_servicio: "",
                fin_servicio: "",
                fecha_limite: "",
                limite_cliente: "",
                comision: "",
                comision_pesos: "",
                tarifa_publica: "",
                fee: "",
                costo: "",
                num_habs: 1,
                desglose: {
                    comision: "%"
                }
            });
            var index = this.service_array.length - 1;
            Vue.nextTick(function() {
                feather.replace();
                $("#dp-stay-" + index).flatpickr({
                    mode: "range",
                    dateFormat: "d/m/Y",
                });
                $("#dp-limit-" + index).flatpickr({
                    dateFormat: "d/m/Y",
                    minDate: "today"
                });
                $("#dp-customer-limit-" + index).flatpickr({
                    dateFormat: "d/m/Y",
                    minDate: "today"
                });
                appSales.initSelect2(index);
            })
        },
        removeService: function(index) {
            this.service_array.splice(index, 1);
        },
        setSaleDetail: function(index) {
            if (this.service_array[index].desglose) {
                var that = this;
                var desglose = {};
                if (this.service_array[index].id_tipo_servicio == 1) {
                    desglose = {
                        hotel: "",
                        destino: "",
                        comision: "%",
                        habitaciones: [{
                            plan: "",
                            adultos: 2,
                            menores: 0,
                            ocupacion: "2 adulto(s), 0 menor(es)",
                            pasajeros: {
                                adultos: [{
                                    nombre: "",
                                    apellidos: "",
                                }, {
                                    nombre: "",
                                    apellidos: "",
                                }],
                                menores: [],
                            },
                            tipo_cama: "",
                            total_neto: "",
                            total_publico: "",
                            base_habitacion: "",
                            tipo_habitacion: ""
                        }]
                    };
                } else if (this.service_array[index].id_tipo_servicio == 2 || this.service_array[index].id_tipo_servicio == 6) {
                    desglose = {
                        redondo: true,
                        adultos: 2,
                        menores: 0,
                        ocupacion: "2 adulto(s), 0 menor(es)",
                        pasajeros: {
                            adultos: [{
                                nombre: "",
                                apellidos: "",
                            }, {
                                nombre: "",
                                apellidos: "",
                            }],
                            menores: [],
                        },
                        comision: "%",
                        origen: "",
                        destino: "",
                        salida_origen: "",
                        llegada_destino: "",
                        salida_destino: "",
                        llegada_origen: "",
                        equipaje: []
                    };
                    if(this.service_array[index].id_tipo_servicio == 2) { //traslados
                        desglose.recogida_hotel = "";
                    }

                    if(this.service_array[index].id_tipo_servicio == 6) { //vuelos
                        desglose.aerolinea = "";
                        desglose.internacional = "0";
                        desglose.escala_origen = "0";
                        desglose.escala_destino = "0";
                    }
                } else {
                    desglose = {
                        comision: "%",
                        adultos: 2,
                        menores: 0,
                        ocupacion: "2 adulto(s), 0 menor(es)",
                        pasajeros: {
                            adultos: [{
                                nombre: "",
                                apellidos: "",
                            }, {
                                nombre: "",
                                apellidos: "",
                            }],
                            menores: [],
                        },
                    };
                }
                this.service_array[index].desglose = desglose;

                if([1,2,6].includes(parseInt(this.service_array[index].id_tipo_servicio))) {
                    if(this.service_array.length > 1) {
                        var find = -1;
                        if([2,6].includes(parseInt(this.service_array[index].id_tipo_servicio))) {
                            find = this.service_array.findIndex((x, i) => [2,6].includes(parseInt(x.id_tipo_servicio)) && i != index);
                        } else {
                            find = this.service_array.findIndex((x, i) => x.id_tipo_servicio == this.service_array[index].id_tipo_servicio && i != index);
                        }
                        if(find >= 0) {
                            if(this.service_array[index].id_tipo_servicio == 1) {
                                this.service_array[index].desglose.habitaciones = this.service_array[find].desglose.habitaciones;
                            } else if([ 2, 6 ].includes(parseInt(this.service_array[index].id_tipo_servicio))) {
                                if(this.service_array[index].id_tipo_servicio == this.service_array[find].id_tipo_servicio) {
                                    this.service_array[index].desglose = this.service_array[find].desglose;
                                } else {
                                    this.service_array[index].desglose.adultos = this.service_array[find].desglose.adultos;
                                    this.service_array[index].desglose.menores = this.service_array[find].desglose.menores;
                                    this.service_array[index].desglose.ocupacion = this.service_array[find].desglose.ocupacion;
                                    this.service_array[index].desglose.pasajeros = this.service_array[find].desglose.pasajeros;
                                    this.service_array[index].desglose.salida_origen = this.service_array[find].desglose.salida_origen;
                                    this.service_array[index].desglose.llegada_destino = this.service_array[find].desglose.llegada_destino;
                                    this.service_array[index].desglose.salida_destino = this.service_array[find].desglose.salida_destino;
                                    this.service_array[index].desglose.llegada_origen = this.service_array[find].desglose.llegada_origen;

                                    /* if(this.service_array[index].id_tipo_servicio == 2 && this.service_array[find].id_tipo_servicio == 6) {

                                    } else if(this.service_array[index].id_tipo_servicio == 6 && this.service_array[find].id_tipo_servicio == 2) {
                                        
                                    } */
                                }
                            }
                        } else {
                            var aux = this.service_array.findIndex((x, i) => [1,2,6].includes(parseInt(x.id_tipo_servicio)) && i != index);
                            if(aux >= 0) {
                                if(this.service_array[index].id_tipo_servicio == 1) {
                                    this.service_array[index].desglose.habitaciones[0].pasajeros.adultos = [];
                                    this.service_array[index].desglose.habitaciones[0].pasajeros.menores = [];
        
                                    this.service_array[index].desglose.habitaciones[0].adultos = this.service_array[aux].desglose.adultos;
                                    this.service_array[index].desglose.habitaciones[0].menores = this.service_array[aux].desglose.menores;
                                    this.service_array[index].desglose.habitaciones[0].ocupacion = this.service_array[aux].desglose.adultos + " adulto(s), " + this.service_array[aux].desglose.menores + " menor(es)";
        
                                    this.service_array[aux].desglose.pasajeros.adultos.forEach(adult => {
                                        that.service_array[index].desglose.habitaciones[0].pasajeros.adultos.push(adult);
                                    });
        
                                    this.service_array[aux].desglose.pasajeros.menores.forEach(child => {
                                        that.service_array[index].desglose.habitaciones[0].pasajeros.menores.push(child);
                                    });
                                } else if([ 2, 6 ].includes(parseInt(this.service_array[index].id_tipo_servicio))) {
                                    this.service_array[index].desglose.pasajeros.adultos = [];
                                    this.service_array[index].desglose.pasajeros.menores = [];
        
                                    var find_service = parseInt(this.service_array[index].id_tipo_servicio) == 2 ? 6 : 2;
                                    var i = this.service_array.findIndex(x => x.id_tipo_servicio == find_service);
                                    if(i >= 0 && i != index) {
                                        this.service_array[index].desglose.salida_origen = this.service_array[i].desglose.salida_origen;
                                        this.service_array[index].desglose.llegada_destino = this.service_array[i].desglose.llegada_destino;
                                        this.service_array[index].desglose.salida_destino = this.service_array[i].desglose.salida_destino;
                                        this.service_array[index].desglose.llegada_origen = this.service_array[i].desglose.llegada_origen;
                                        this.service_array[index].desglose.adultos = this.service_array[i].desglose.adultos;
                                        this.service_array[index].desglose.menores = this.service_array[i].desglose.menores;
                                    } else {
                                        this.service_array[index].desglose.adultos = 0;
                                        this.service_array[index].desglose.menores = 0;
                                        this.service_array[aux].desglose.habitaciones.forEach(hab => {
                                            that.service_array[index].desglose.adultos += parseInt(hab.adultos);
                                            that.service_array[index].desglose.menores += parseInt(hab.menores);
            
                                            hab.pasajeros.adultos.forEach(adult => {
                                                that.service_array[index].desglose.pasajeros.adultos.push(adult);
                                            });
            
                                            hab.pasajeros.menores.forEach(child => {
                                                that.service_array[index].desglose.pasajeros.menores.push(child);
                                            });
                                        });
                                    }
                                    
                                    this.service_array[index].desglose.ocupacion = this.service_array[index].desglose.adultos + " adulto(s), " + this.service_array[index].desglose.menores + " menor(es)";
                                }
                            }
                        }
                    }
                }

                var index = this.service_array.length - 1;
                Vue.nextTick(function() {
                    feather.replace();
                    
                    var array_date = ($("#dp-stay-0").val()).split(" a ");
                    var aux_default_date = appSales.service_array.length > 1 ? [array_date[0], array_date[1]] : [moment().format("DD/MM/YYYY"), moment().add(3, 'days').format("DD/MM/YYYY")];
                    
                    appSales.flatpickr_array.splice(index, 1);
                    appSales.flatpickr_array.push(flatpickr(("#dp-stay-" + index), {
                        mode: "range",
                        dateFormat: "d/m/Y",
                        defaultDate: aux_default_date,
                        minDate: "today",
                        onValueUpdate: function(dObj, dStr, fp, dayElem) {
                            var stay = dStr.split(" a ");
                            if(stay.length > 1) {
                                appSales.service_array[index].inicio_servicio = moment(stay[0], "DD/MM/YYYY").format("YYYY-MM-DD");
                                appSales.service_array[index].fin_servicio = moment(stay[1], "DD/MM/YYYY").format("YYYY-MM-DD");
                            } else {
                                appSales.service_array[index].inicio_servicio = moment(stay[0], "DD/MM/YYYY").format("YYYY-MM-DD");
                                appSales.service_array[index].fin_servicio = null;
                            }
                        },
                    }));

                    if(that.service_array[index].id_tipo_servicio == 1) {
                        appSales.initHotelSelect2(index);
                    }
                })
            }
        },
        setFlightType: function(index) {
            if(this.service_array[index].desglose.internacional) {
                var that = this;
                this.service_array[index].desglose.pasajeros.adultos.forEach(function(element, i) {
                    that.service_array[index].desglose.pasajeros.adultos[i].no_pasaporte = "";
                    that.service_array[index].desglose.pasajeros.adultos[i].no_visa = "";
                    that.service_array[index].desglose.pasajeros.adultos[i].fecha_nacimiento = {
                        dia: "",
                        mes: "",
                        año: ""
                    };
                });
    
                this.service_array[index].desglose.pasajeros.menores.forEach(function(element, i) {
                    that.service_array[index].desglose.pasajeros.menores[i].no_pasaporte = "";
                    that.service_array[index].desglose.pasajeros.menores[i].no_visa = "";
                });

                $("#modal-pax").removeClass("modal-lg");
                $("#modal-pax").addClass("modal-xl");
            } else {
                $("#modal-pax").removeClass("modal-xl");
                $("#modal-pax").addClass("modal-lg");
            }
        },
        uploadContract: function() {
            var file = event.target.files[0];
            var data = new FormData();
            data.append("id_contrato", this.sale_model.contratos.id_contrato);
            data.append("previous_contract", file);
            
            this.$http.post(this.baseUrl + "/contratos/uploadPreviousContract/", data).then(function(response) {
                if(response.body.id_contrato) {
                    this.sale_model.contratos.version++;
                    Toast.fire({
                        icon: 'success',
                        title: 'Se guardó el archivo'
                    })
                } else {
                    var error_table = "<table class='table table-bordered text-white'>";
                    Object.values(response.body).forEach(element => {
                        error_table += "<tr><td>" + element + "</td></tr>";
                    });
                    error_table += "</table>";
                    Swal.fire({
                        title: '¡Ops!',
                        icon: 'error',
                        html: "<p align='center'>Algo salió mal</p>" + error_table,
                    });
                }
            }, function() {
                console.log('Error')
            })
        },
        initLibraries: function() {
            $("#dp-stay-0").flatpickr({
                mode: "range",
                dateFormat: "d/m/Y",
            });
            $("#dp-limit-0").flatpickr({
                dateFormat: "d/m/Y",
                minDate: "today"
            });
            $("#dp-customer-limit-0").flatpickr({
                dateFormat: "d/m/Y",
                minDate: "today"
            });
        },
        initSelect2Customers: function() {
            var p = $(".invoiceto");
            $(document).on("click", ".add-new-customer", (function() { p.select2("close") }))
            p.select2({
                placeholder: "Seleccione un cliente",
                data: appSales.customers_array,
                //dropdownParent: $(".invoice-customer"),
            }).on("change", (function() {
                var e = $(this);
                //console.log(e.val());
                appSales.sale_model.id_cliente = e.val();
                var index = appSales.customers_array.findIndex(x => x.id == e.val());
                appSales.customer_selected = appSales.customers_array[index];
            })).on("select2:open", (function() {
                appCustomerCrud.clearCustomerModel();
                $(".select2-search__field")[0].focus();
                $(document).find(".add-new-customer").length || $(document).find(".select2-results__options").before('<div class="add-new-customer btn btn-flat-success cursor-pointer rounded-0 text-start mb-50 p-50 w-100" data-bs-toggle="modal" data-bs-target="#cu-customers">' + feather.icons.plus.toSvg({ class: "font-medium-1 me-50" }) + '<span class="align-middle">Agregar Cliente</span></div>')
            }))
        },
        initHotelSelect2: function(index) {
            $("#slct-hotel-" + index).select2({
                placeholder: "Seleccione un hotel",
                minimumInputLength: 3,
                ajax: {
                    url: appSales.baseUrl + "/site/searchHotel",
                    dataType: 'json',
                    processResults: function (data) {
                        appSales.hotels_array = data;
                        return {
                            results: data
                        };
                    }
                }
            }).on("change", (function() {
                if(appSales.hotels_array.length > 0) {
                    var e = $(this);
                    var found_index = appSales.hotels_array.findIndex(x => x.id == e.val());
                    appSales.service_array[index].desglose.hotel = appSales.hotels_array[found_index].text;
                    appSales.service_array[index].desglose.destino = appSales.hotels_array[found_index].destino;
                }
            })).on("select2:open", (function() {
                $(".select2-search__field")[0].focus();
            }))
        },
        calculateSubtotal: function() {
            var subtotal = 0;
            this.service_array.forEach(element => {
                if (parseFloat(element.tarifa_publica)) {
                    subtotal += parseFloat(element.tarifa_publica);
                }
            });
            return this.formatter.format(subtotal);
        },
        calculateFee: function() {
            var fee = 0;
            this.service_array.forEach(element => {
                if (parseFloat(element.fee)) {
                    fee += parseFloat(element.fee);
                }
            });
            return this.formatter.format(fee);
        },
        calculateTotal: function() {
            var total = 0;
            this.service_array.forEach(element => {
                var aux_com = element.comision / 100;
                if (parseFloat(element.tarifa_publica) || element.id_tipo_servicio == 1) {
                    
                    var aux_com = element.comision / 100;
                    if (element.id_tipo_servicio == 1) {
                        var total_item = 0;
                        element.desglose.habitaciones.forEach(item => {
                            if (item.total_publico > 0) {
                                total_item += parseFloat(item.total_publico);
                                item.total_neto = (parseFloat(item.total_publico) / (1 + aux_com)).toFixed(2);
                            }
                        });

                        element.tarifa_publica = total_item;
                    }

                    if (element.desglose.comision == "%") {
                        element.costo = ((element.tarifa_publica / (1 + aux_com))).toFixed(2);
                    } else {
                        element.costo = (element.tarifa_publica - element.comision_pesos).toFixed(2);
                    }
                    appSales.calculateCommission(element)
                    total += parseFloat(element.tarifa_publica);
                }

                if (parseFloat(element.fee)) {
                    total += parseFloat(element.fee);
                }
            });
            return this.formatter.format(total);
        },
        calculateCommission: function(element) {
            /* if (element.tipo_comision == "%") {
                element.comision_pesos = (element.comision * element.tarifa_publica) / 100;
            } else {
                element.comision = (element.comision_pesos * 100) / element.tarifa_publica;
            } */

            if(element.desglose) {
                if (element.desglose.comision == "%") {
    
                    if (element.tarifa_publica > 0) {
                        /* element.costo = (element.tarifa_publica / (1 + aux_com)).toFixed(2); */
                        element.comision_pesos = (element.tarifa_publica - element.costo).toFixed(2);
                    }
                } else {
                    if (element.comision_pesos > 0) {
    
                        /* var aux_neto = element.total_publico - element.comision_pesos;
                        element.costo = aux_neto.toFixed(2); */
                        element.comision = (((element.tarifa_publica / element.costo) * 100) - 100).toFixed(2);
                    }
                }
            }
        },
        getPaymentLimit: function() {
            this.service_array.forEach(element => {
                if(element.id_tipo_servicio != 6) {
                    if(appSales.payment_limit == "") {
                        appSales.payment_limit = element.limite_cliente;
                    } else {
                        if(element.limite_cliente != "") {
                            if(moment(element.limite_cliente).isBefore(appSales.payment_limit)) {
                                appSales.payment_limit = element.limite_cliente;
                            }
                        } else {
                            if(moment(element.fecha_limite).isBefore(appSales.payment_limit)) {
                                appSales.payment_limit = element.fecha_limite;
                            }
                        }
                    }
                }
            });

            if(this.payment_limit == "") {
                if(this.service_array[0].limite_cliente) this.payment_limit = this.service_array[0].limite_cliente;
                else this.payment_limit = this.service_array[0].fecha_limite;
            }

            appSales.payment_limit = moment(appSales.payment_limit).format("DD/MM/YYYY");
        },
        formatPrice: function(price) {
            var aux = parseFloat(price);
            return this.formatter.format(aux) + " MXN";
        },
        formatDate: function(date_string) {
            return moment(date_string).format("DD/MM/YYYY");
        }
    }
})

$("body").on("click", ".add-new-provider", function() {
    var index = $(this).attr("data-index");
    appSales.index_provider = index;
});

function close_panel_dropdown() {
    $('.panel-dropdown').removeClass("active");
}
$('.panel-dropdown input').on('click', function(e) {
    //$('.panel-dropdown a').on('click', function(e) {
    if ($(this).parent().is(".active")) {
        close_panel_dropdown();
    } else {
        close_panel_dropdown();
        $(this).parent().addClass('active');
    }
});
var mouse_is_inside = false;
$('.panel-dropdown-content').hover(function() {
    mouse_is_inside = true;
}, function() {
    mouse_is_inside = false;
});
$("body").mouseup(function() {
    if (!mouse_is_inside) close_panel_dropdown();
});