const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    timer: 3000,
    showConfirmButton: false,
});

Vue.http.options.emulateJSON = true;
var appSales = new Vue({
    el: "#sales-index",
    data: {
        baseUrl: baseUrl,

        sales_array: [],
    },
    created: function() {
        // this.loadSales();
    },
    mounted: function() {
        this.loadSales();
    },
    methods: {
        loadSales: function() {
            $("#sales-table thead tr").clone(!0).appendTo("#sales-table thead"), $("#sales-table thead tr:eq(1) th").each((function(t) {
                var a = $(this).text();
                if(t != 8) {
                    $(this).html('<input type="text" class="form-control form-control-sm" placeholder="BUSCAR ' + a + '" />'), $("input", this).on("keyup change", (function() {
                        appSales.sales_table.column(t).search() !== this.value && appSales.sales_table.column(t).search(this.value).draw()
                    }))
                }
            }));

            var url_rq = this.baseUrl + "/ventas/ventasapi"
            var that = this;
            this.sales_table = $("#sales-table").DataTable({
                language: { url: "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                scrollX: true,
                ajax: {
                    url: url_rq,
                    dataSrc: function(json) {
                        appSales.sales_array = json;
                        return json;
                    }
                },
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"B><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',

                bDestroy: true,
                buttons: [{
                    extend: "collection",
                    className: "btn btn-outline-secondary dropdown-toggle me-2",
                    text: feather.icons.share.toSvg({ class: "font-small-4 me-50" }) + "Exportar",
                    buttons: [{
                        extend: "csv",
                        text: feather.icons["file-text"].toSvg({ class: "font-small-4 me-50" }) + "Csv",
                        className: "dropdown-item",
                    }, {
                        extend: "excel",
                        text: feather.icons.file.toSvg({ class: "font-small-4 me-50" }) + "Excel",
                        className: "dropdown-item",
                    }, {
                        extend: "pdf",
                        text: feather.icons.clipboard.toSvg({ class: "font-small-4 me-50" }) + "Pdf",
                        className: "dropdown-item",
                    }, {
                        extend: "copy",
                        text: feather.icons.copy.toSvg({ class: "font-small-4 me-50" }) + "Copiar",
                        className: "dropdown-item",
                    }],
                    init: function(e, t, a) {
                        $(t).removeClass("btn-secondary"), $(t).parent().removeClass("btn-group"), setTimeout((function() { $(t).closest(".dt-buttons").removeClass("btn-group").addClass("d-inline-flex") }), 50)
                    }
                }],
                "drawCallback": function(settings, json) {
                    appSales.addCssToTable();
                },
                order: [[ 1, "desc" ]],
                scrollCollapse: true,
                columns: [{
                    data: 'folio',
                }, {
                    data: 'fecha',
					render: function(data) {
						return moment(data).format('DD/MM/YYYY')
					}
                }, {
                    data: 'pasajero_titular',
                }, {
                    data: 'descripcion',
                }, {
                    data: 'observaciones',
                }, {
                    data: "agente",
                }, {
                    data: null,
                      render: function(data, row) {
                        console.log(data);
                        return data.id_tipo_venta != null ? data.idTipoVenta.tipo : "NA";
                        return "NA";
                    }
                }, {
                    data: null,
                    render: function(data, row) {
                        return data.pertenece_a != null ? data.perteneceA.folio : "NA";
                        return "NA";
                    }
                }, {
                    data: null,
                    title: '',
                    width: "9%",
                    orderable: false,
                    render: function(data, row) {
                        return '<a href="' + appSales.baseUrl + '/caja/accountDetail/' + data.id_venta + '" target="_blank">' + feather.icons.eye.toSvg() + '</a><a href="' + appSales.baseUrl + '/ventas/update/' + data.id_venta + '" class="edit-rate-record ms-25">' + feather.icons.edit.toSvg() + '</a><a onclick="deleteSale(' + data.id_venta + ')" href="javascript:void(0)" class="delete-rate-record ms-25">' + feather.icons["x-circle"].toSvg() + '</a>';
                    }
                }]

            });

        },
        alertDeleteSale: function(sale_code) {
            var that = this;
            Swal.fire({
                title: '¿Estas seguro que desea eliminarlo?',
                text: "Cambiará el estatus de la venta y los servicios",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    that.$http.get(that.baseUrl + "/ventas/delete/" + sale_code).then(function(response) {
                        if (response.data.success) {
                            that.loadSales();
                            Toast.fire({
                                icon: 'success',
                                title: 'Se ha cambiado el estatus de la venta y servicios'
                            });
                        } else {
                            Swal.fire({
                                title: 'Error',
                                timer: 2000,
                                icon: 'error',
                                text: response.data.mensaje,
                            }, )
                        }
                    }, function(error) {
                        Swal.fire({
                            title: 'Error',
                            timer: 2000,
                            icon: 'error',
                            text: 'Ha ocurrido un error',
                        })
                    });
                }
            })
        },
        addCssToTable: function() {
            setTimeout(() => {}, 1000);
        },
    },
});

function deleteSale(id) {
    appSales.alertDeleteSale(id);
}