var formatter = new Intl.NumberFormat('en-US', {
    style: 'currency',
    currency: 'USD',
    minimumFractionDigits: 2
        // These options are needed to round to whole numbers if that's what you want.
        //minimumFractionDigits: 0, // (this suffices for whole numbers, but will print 2500.10 as $2,500.1)
        //maximumFractionDigits: 0, // (causes 2500.99 to be printed as $2,501)
});
var appContratosProx = new Vue({
    el: '#contratosProximos',
    data: {
        sales_array: [],
        baseUrl: baseUrl,
        date_filter: {
            start: moment().format("YYYY-MM-DD"),
            end: moment().format("YYYY-MM-DD"),
        },
    },
    created: function() {
    },
    mounted: function() {
        this.loadPaymentsTable();
        this.initDateRangePicker();
    },
    methods: {
        loadPaymentsTable: function() {
            $("#contratosProx thead tr").clone(!0).appendTo("#contratosProx thead"), $("#contratosProx thead tr:eq(1) th").each((function(t) {
                var a = $(this).text();
                if(t != 9) {
                    $(this).html('<input type="text" class="form-control form-control-sm" placeholder="BUSCAR ' + a + '" />'), $("input", this).on("keyup change", (function() {
                        appContratosProx.contrato_table.column(t).search() !== this.value && appContratosProx.contrato_table.column(t).search(this.value).draw()
                    }))
                }
            }));

            var url_rq = this.baseUrl + "/reportes/ventasProxFechas?start=" + this.date_filter.start + "&end=" + this.date_filter.end;
            var that = this;
            this.contrato_table = $("#contratosProx").DataTable({
                language: { url: "https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                scrollX: true,
                ajax: {
                    url: url_rq,
                    dataSrc: function(json) {
                        appContratosProx.sales_array = json;
                        return json;
                    }
                },
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-4"B><"col-sm-12 col-md-4"l><"col-sm-12 col-md-4"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',

                bDestroy: true,
                buttons: [{
                    extend: "collection",
                    className: "btn btn-outline-secondary dropdown-toggle me-2",
                    text: feather.icons.share.toSvg({ class: "font-small-4 me-50" }) + "Exportar",
                    buttons: [{
                        extend: "csv",
                        text: feather.icons["file-text"].toSvg({ class: "font-small-4 me-50" }) + "Csv",
                        className: "dropdown-item",
                        //exportOptions: { columns: [3, 4, 5, 6, 7] } 
                    }, {
                        extend: "excel",
                        text: feather.icons.file.toSvg({ class: "font-small-4 me-50" }) + "Excel",
                        className: "dropdown-item",
                    }, {
                        extend: "pdf",
                        text: feather.icons.clipboard.toSvg({ class: "font-small-4 me-50" }) + "Pdf",
                        className: "dropdown-item",
                    }, {
                        extend: "copy",
                        text: feather.icons.copy.toSvg({ class: "font-small-4 me-50" }) + "Copiar",
                        className: "dropdown-item",
                    }],
                    init: function(e, t, a) {
                        $(t).removeClass("btn-secondary"), $(t).parent().removeClass("btn-group"), setTimeout((function() { $(t).closest(".dt-buttons").removeClass("btn-group").addClass("d-inline-flex") }), 50)

                    }
                }],
                "drawCallback": function(settings, json) {
                    appContratosProx.addCssToTable();
                },
                scrollCollapse: true,
                columns: [
                    {
                        data: null,
                        orderable: false,
                        render: function(data, type, row, meta) {
                            return "<a href='" + this.baseUrl + "/ventas/update/" + data.id_venta + "' target='_blank'>" + data.folio + "</a>";
                        }
                    },
                    { data: 'idCliente.nombre', },
                    // {
                    //     data: null, //fecha
                    //     className: "text-center",
                    //     render: function(data) {
                    //         return moment(data.fecha).format('DD/MM/YYYY');
                    //     }
                    // },   
                    {
                        data: null, //tarifa publica
                        className: "text-right",
                        render: function(data) {
                            var dataServicio = data.ventasServicioses;
                            var total = 0;
                            dataServicio.forEach(servicio => {
                                var tarifa_publica = parseFloat(servicio.tarifa_publica);
                                total += tarifa_publica;
                            });
                            return formatter.format(total);
                        }
                    },                                    
                    {
                        data: null, //costo
                        className: "text-right",
                        render: function(data) {
                            var aux = parseFloat(data.costototalporventa);
                            if(isNaN(aux) || typeof aux == "undefined") {
                                return formatter.format(0);
                            }
                            return formatter.format(data.costototalporventa);
                        }
                    },
                    {
                        data: null, //fee
                        className: 'text-center',
                        render: function(data) {
                            var dataServicio = data.ventasServicioses;
                            var total = 0;
                            dataServicio.forEach(servicio => {
                                var fee = parseFloat(servicio.fee);
                                if (isNaN(fee) || typeof fee == 'undefined') {
                                    fee = 0;
                                }
                                total += fee;
                            });
                            return formatter.format(total);
                        }
                    },
                    {
                        data: null, //cargo por servicios
                        className: 'text-center',
                        render: function(data) {
                            if(parseFloat(data.cargo_servicios)) {
                                return formatter.format(parseFloat(data.cargo_servicios));
                            }
                            return "$ 0.00";
                        }
                    },
                    {
                        data: null, //cargo por servicios / 2
                        className: 'text-center',
                        render: function(data) {
                            if(parseFloat(data.cargo_servicios)) {
                                return formatter.format(parseFloat(data.cargo_servicios) / 2);
                            }
                            return "$ 0.00";
                        }
                    },
                    {
                        data: null, //total
                        className: "text-right",
                        render: function(data) {
                            var dataServicio = data.ventasServicioses;
                            var total = 0;
                            dataServicio.forEach(servicio => {
                                var tarifa_publica = parseFloat(servicio.tarifa_publica);
                                var fee = parseFloat(servicio.fee);
                                if (isNaN(fee) || typeof fee == 'undefined') {
                                    fee = 0;
                                }
                                total += tarifa_publica + fee;
                            });
                            return formatter.format(total);
                        }
                    }, {
                        data: null, //utilidad
                        className: "text-right",
                        render: function(data) {
                            var dataServicio = data.ventasServicioses;
                            var costo = 0;
                            var aux_costo = parseFloat(data.costototalporventa);
                            if(isNaN(aux_costo) || typeof aux_costo == "undefined") {
                                coston = 0;
                            } else {
                                costo = data.costototalporventa;
                            }

                            var total = 0;
                            dataServicio.forEach(servicio => {
                                var tarifa_publica = parseFloat(servicio.tarifa_publica);
                                var fee = parseFloat(servicio.fee);
                                if (isNaN(fee) || typeof fee == 'undefined') {
                                    fee = 0;
                                }
                                total += tarifa_publica + fee;
                            });
                            var utilidad = total - costo;
                            return formatter.format(utilidad);
                        }
                    }

                ],
            });
            setTimeout(() => {
                $("div.head-label").html('<h4 class="card-title" key="Mis ventas">Lista de Contratos Próximos </h4>');
            }, 50)
        },
        initDateRangePicker: function() {
            $('#date-filter').daterangepicker({
                ranges: {
                    'Hoy': [moment(), moment()],
                    'Ayer': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Semana pasada': [moment().subtract(6, 'days'), moment()],
                    'Últimos 30 días': [moment().subtract(29, 'days'), moment()],
                    'Este mes': [moment().startOf('month'), moment().endOf('month')],
                    'Mes pasado': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                },
                locale: {
                    format: 'DD/MM/YYYY',
                    separator: " - ",
                    applyLabel: "Aplicar",
                    cancelLabel: "Cancelar",
                    fromLabel: "De",
                    toLabel: "a",
                    customRangeLabel: "Personalizado",
                    weekLabel: "W",
                    daysOfWeek: [
                        "Do",
                        "Lu",
                        "Ma",
                        "Mi",
                        "Ju",
                        "Vi",
                        "Sa"
                    ],
                    monthNames: [
                        "Enero",
                        "Febrero",
                        "Marzo",
                        "Abril",
                        "Mayo",
                        "Junio",
                        "Julio",
                        "Agosto",
                        "Septiembre",
                        "Octubre",
                        "Noviembre",
                        "Diciembre"
                    ],
                    firstDay: 1
                },
                startDate: moment().startOf('month'),
                endDate:moment().endOf('month'),
                autoApply: true,
            }, function(start, end, label) {
                appContratosProx.date_filter.start = start.format("YYYY-MM-DD");
                appContratosProx.date_filter.end = end.format("YYYY-MM-DD");
                
                Vue.nextTick(() => {
                    appContratosProx.contrato_table.ajax.url(appContratosProx.baseUrl + "/reportes/ventasProxFechas?start=" + appContratosProx.date_filter.start + "&end=" + appContratosProx.date_filter.end).load();
                })
            });
        },
        addCssToTable: function() {
            setTimeout(() => {}, 1000);
        },
    },
})