<?php

// Set the path of Bootstrap to be the root of the project.
//Yii::setPathOfAlias('bootstrap', realpath(dirname(__FILE__).'/../../../'));

$config = array(
	'basePath'=>realpath(dirname(__FILE__).'/..'),
	'name'=>'Casate Conmigo',
	'language'=>'es',	
	'sourceLanguage'=>'en',	
	'charset'=>'UTF-8',
	'preload'=>array(
		'bootstrap',
		'log',
	),
	'import'=>array(
		'application.models.*',
		'application.components.*',
        	'application.modules.user.models.*',
        	'application.modules.user.components.*',
	),
	'modules'=>array(
		'gii'=>array(
			'class'=>'system.gii.GiiModule',
			'password'=>'pass',
			'ipFilters'=>false,
			'generatorPaths'=>array('bootstrap.gii'),
		), 
		'user'=>array(
			# encrypting method (php hash function)
			'hash' => 'md5',
			# send activation email
			'sendActivationMail' => true,
			# allow access for non-activated users
			'loginNotActiv' => false,
			# activate user on registration (only sendActivationMail = false)
			'activeAfterRegister' => false,
			# automatically login from registration
			'autoLogin' => true,
			# registration path
			'registrationUrl' => array('/user/registration'),
			# recovery password path
			'recoveryUrl' => array('/user/recovery'),
			# login form path
			'loginUrl' => array('/user/login'),
			# page after login
			'returnUrl' => array('/'),
			# page after logout
			'returnLogoutUrl' => array('/user/login'),
		),

	),
	'components'=>array(
		'bootstrap'=>array(
			'class'=>'ext.bootstrap.components.Bootstrap',
			'responsiveCss'=>false,
		),
		'user'=>array(
			// enable cookie-based authentication
				'class' => 'WebUser',
				'allowAutoLogin'=>true,
				'loginUrl' => array('/user/login'),
		),
		'db'=>array(
			'connectionString' => 'mysql:host=localhost;dbname=businesstravel_weddings',
			'emulatePrepare' => true,
			'username' => 'business_erp',
			'password' => '$t.s5z*Cr;t*',
			'charset' => 'utf8',
			'tablePrefix' => '',
		),
		 'db1'=>array(
			//'connectionString' => 'mysql:host=localhost;dbname=rutamaya_extranetdemo2',
			'connectionString' => 'mysql:host=rutamayatravel.com;dbname=rutamaya_travel',
			'class'=>'CDbConnection',
			'emulatePrepare' => true,
			'username' => 'rutamaya_travel',
			'password' => 'hMeTGDFne]_g',			
			//'password' => 'vQalT4SeIc24',
			'charset' => 'utf8',
			'tablePrefix' => 'tbl_',
		),
		'authManager'=>array(
            'class'=>'CDbAuthManager',
            'connectionID'=>'db',
        ),
		'errorHandler'=>array(
			'errorAction'=>'site/error',
		),
		'fb'=>array(
			'class'=>'ext.facebook.components.FacebookConnect',
			'appID'=>'',
			'appNamespace'=>'yii-bootstrap',
		),
		'log'=>array(
			'class'=>'CLogRouter',
			'routes'=>array(
				array(
					'class'=>'CFileLogRoute',
					'levels'=>'error, warning',
				),
			),
		),
		'ePdf' => array(
        'class'         => 'ext.yii-pdf.EYiiPdf',
        'params'        => array(
            'mpdf'     => array(
                'librarySourcePath' => 'application.vendors.mpdf.*',
                'constants'         => array(
                    '_MPDF_TEMP_PATH' => Yii::getPathOfAlias('application.runtime'),
                ),
                'class'=>'mpdf', // the literal class filename to be loaded from the vendors folder
                'defaultParams'     => array( // More info: http://mpdf1.com/manual/index.php?tid=184
                    'mode'              => '', //  This parameter specifies the mode of the new document.
                    'format'            => 'letter', // format A4, A5, ...
                    //'default_font_size' => 0, // Sets the default document font size in points (pt)
                    //'default_font'      => '', // Sets the default font-family for the new document.
                    'mgl'               => 15, // margin_left. Sets the page margins for the new document.
                    'mgr'               => 15, // margin_right
                    'mgt'               => 16, // margin_top
                    'mgb'               => 16, // margin_bottom
                    'mgh'               => 9, // margin_header
                    'mgf'               => 9, // margin_footer
                    'orientation'       => 'P', // landscape or portrait orientation
                )
            ),
		  ),
		),
		'urlManager'=>array(
			'showScriptName'=>false,
			'urlFormat'=>'path',
			'urlSuffix'=>'.html',
			'rules'=>array(
				/* 'admin' => 'admin/index',
				'boda' => 'boda/index',
				'boda/expo' => 'bodasParejas/index',
				'dashboard' => 'dashboard/index',
				'seccion' => 'seccion/index',
				'banners' => 'banners/index',
				'landing' => 'landing/index',
				'correos' => 'correos/index',
				'index'=>'site/index',
				'setup'=>'site/setup',
				'<slug>' => 'website/slug',
				'website/<slug>' => 'website/slug',
				'gii'=>'gii' */
				//'gii'=>'gii',
				'<controller:\w+>/<id:\d+>'=>'<controller>/view',
				'<controller:\w+>/<action:\w+>/<id:\d+>'=>'<controller>/<action>',
				'<controller:\w+>/<action:\w+>'=>'<controller>/<action>',
				'<slug>' => 'website/slug',
				'website/<slug>' => 'website/slug',
			),
		),
	),

	// Application-level parameters
	'params'=>array(
		'appTitle'=>'CasateConmigo',
		'appDescription'=>'BY RUTA MAYA TRAVEL',
		//BASE DEMO
		'appDB'=>'rutamaya_travel',
		//BASE PRODUCCION
		//'appDB'=>'rutamaya_travel',
	),
);

return file_exists(dirname(__FILE__).'/local.php')
		? CMap::mergeArray($config, require('local.php'))
		: $config;