<?php

class BodaController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */

	public $layout = '//layouts/main';

	/**
	 * @return array action filters
	 */

	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */

	public function accessRules()
	{
		return array(
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view'),
				'users' => array('@'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update', 'GeneratePdf', 'GenerateExcel', 'expo', 'getWeddings', 'getBloqueos', 'getLayouts', 'test', 'nueva', 'getInfoBoda', 'getBanners', 'insert', 'updateImagen', 'getFotos', 'insertImagen'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete', 'deleteBanner', 'deleteImagen'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actionGetWeddings()
	{
		$model = Boda::model()->findAll();
		$general = Yii::app()->createController('General')[0];
		$response = $general->convertModelToArray($model);

		foreach ($response as $key => $value) {
			$response[$key]["idHotel"] = Hoteles::model()->findByPk($value["lugar"]);
			$response[$key]["idBloqueo"] = Bloqueos::model()->findByPk($value["id_bloqueo"]);
		}
		echo CJSON::encode($response);
	}

	public function actionGetInfoBoda($id)
	{
		$model = Boda::model()->findAll('id='.$id);
		$general = Yii::app()->createController('General')[0];
		$response = array(
			"data" => $general->convertModelToArray($model)
		);

		foreach ($response["data"] as $key => $value) {
			$response["data"][$key]["idHotel"] = Hoteles::model()->findByPk($value["lugar"]);
			$response["data"][$key]["idBloqueo"] = Bloqueos::model()->findByPk($value["id_bloqueo"]);
			$response["data"][$key]["idLayout"] = Layout::model()->findByPk($value["id_layout"]);
			$response["data"][$key]["idAgencia"] = Agencias::model()->findByPk($response["data"][$key]["idBloqueo"]["id_agencia"]);
		}
		echo CJSON::encode($response);
	}

	public function actiongetBanners()
	{
		$model=	Banners::model()->findAll("id_boda = ". $_GET["idBoda"]);
		echo CJSON::encode($model);
	}

	public function actionGetBloqueos()
	{
		$consult = Bloqueos::model()->with("idHotel")->findAll("tipo = 'GRUPAL' AND novios IS NOT NULL AND titulo_evento LIKE '%" . $_GET["query"] . "%'");
		$general = Yii::app()->createController('General')[0];
		$response = $general->convertModelToArray($consult);
		echo json_encode($response);
	}

	/* public function actionGetHoteles() {

	} */

	public function actionGetLayouts()
	{
		$model = Layout::model()->findAll();
		echo CJSON::encode($model);
	}

	public function actionTest()
	{
		$response = Hoteles::model()->findByPk(9);
		echo CJSON::encode($response);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */

	public function actionView($id)
	{
		$this->render('view');
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */

	public function actionCreate() {
		$model = new Boda;
		$model->attributes = $_POST;
		$model->slug = strtolower($_POST['novia']) . "-y-" . strtolower($_POST['novio']);
		$model->fecha_entrada = implode('-', array_reverse(explode('/', $_POST['fecha_entrada'])));
		$model->fecha_salida = implode('-', array_reverse(explode('/', $_POST['fecha_salida'])));
		$model->fecha_boda = implode('-', array_reverse(explode('/', $_POST['fecha_boda'])));
		$model->fecha_lim_reserva = implode('-', array_reverse(explode('/', $_POST['fecha_lim_reserva'])));

		if ($model->save()) {
			echo CJSON::encode($model);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);
		$model->attributes = $_POST;
		$model->slug = strtolower($_POST['novia']) . "y" . strtolower($_POST['novio']);
		$model->fecha_boda = implode('-', array_reverse(explode('/', $_POST['fecha_boda'])));

		if ($model->save()) {
			echo CJSON::encode($model);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	public function actionDelete()
	{
		$model = $this->loadModel($_POST["id"]);
		if ($model->delete()) {
			echo json_encode(array(
				"success" => true
			));
		} else {
			echo json_encode(array(
				"success" => false
			));
		}
	}

	public function actionDeleteBanner()
	{
		$model=Banners::model()->findByPk($_POST['id_banner']);
		if ($model->delete()) {
			echo json_encode(array(
				"success" => true
			));
		} else {
			echo json_encode(array(
				"success" => false
			));
		}
	}

	public function actionInsert()
	{
		$model=new Banners;

		if(isset($_FILES))
		{
			// $model->attributes=$_POST['Banners']
			if (is_uploaded_file($_FILES['file']['tmp_name'])) {
				$model->id_boda = $_POST['idBoda'];
				$model->titulo = $_POST['bannerstitulo'];
				$model->posicion = $_POST['bannersposicion'];
				$model->nombre_real = date('Y-m-d_H.i.s').'_'.str_replace(')', '',str_replace('(','',str_replace(' ','',$_FILES["file"]["name"])));
				$dir = $_SERVER['DOCUMENT_ROOT'] . '/images/banners/' . $model->nombre_real;
				if($model->save()){
					if (move_uploaded_file($_FILES['file']['tmp_name'], $dir)) {
						echo "El archivo se subio correctamente";
					}else{
						echo "No se subió el archivo";
					}
				}else{
					echo CJSON::encode($model->getErrors());
				}
			}
		}
	}

	public function actionupdateImagen(){
		// $model = new Banners;

		$model = Banners::model()->findByPk($_POST['id_banner']);
		$model->titulo = $_POST['actualizarTitulo'];
		$model->posicion = $_POST['actualizarPosicion'];
		
		// if (isset($_FILES))
		// {
		if (is_uploaded_file($_FILES['actualizarimagen']['tmp_name'])) {
			$model->nombre_real = date('Y-m-d_H.i.s').'_'.str_replace(')', '',str_replace('(','',str_replace(' ','',$_FILES["actualizarimagen"]["name"])));
			$dir = $_SERVER['DOCUMENT_ROOT'] . '/images/banners/' . $model->nombre_real;
			if($model->save()){
				if (move_uploaded_file($_FILES['actualizarimagen']['tmp_name'], $dir)) {
					echo "El archivo se subio correctamente";
				}else{
					echo "No se subió el archivo";
				}
			}else{
				echo CJSON::encode($model->getErrors());
			}
		}else{
			if($model->save()){
				echo "Los datos se actualizaron correctamente";
			}else{
				echo CJSON::encode($model->getErrors());
			}
		}
		// }

	}

	public function actiongetFotos()
	{

		if($_POST){
			$model->id_boda = $_POST['idBoda'];
			$model = new Album;
			$model->name_real = date('Y-m-d_H.i.s').'_'.str_replace(')', '',str_replace('(','',str_replace(' ','',$_FILES["file"]["name"])));
			$dir = $_SERVER['DOCUMENT_ROOT'] . '/images/album/' . $model->name_real;
			if($model->save()){
				move_uploaded_file($_FILES['file']['tmp_name'], $dir);

			} else {
				echo $model->getErrors();
			}
		}


		$model=	Album::model()->findAll("id_boda = ". $_GET["idBoda"]);
		echo CJSON::encode($model);
	}

	public function actioninsertImagen() {
		
		// $model->attributes=$_POST['Banners']
		// echo json_encode($_FILES);
		$total_leng = count($_FILES["file"]["name"]);
		if ($total_leng > 0) {
			
			$response = array();
			for ($i = 0; $i < $total_leng; $i++) {
				$model = new Album;
				$model->id_boda = $_POST['idBoda'];
				$model->name_real = date('Y-m-d_H.i.s').'_'.str_replace(')', '',str_replace('(','',str_replace(' ','',$_FILES["file"]["name"][$i])));
				$tmp = $_SERVER['DOCUMENT_ROOT'] . '/images/album/tmp_' . $model->name_real;
				$dir = $_SERVER['DOCUMENT_ROOT'] . '/images/album/' . $model->name_real;
				if($model->save()){
					


					move_uploaded_file($_FILES['file']['tmp_name'][$i], $tmp);

					$this->GenerateThumbnail($tmp,$dir,1200,600,0.80);
				    // Delete full size
					unlink($tmp);

					array_push($response, $model);
				} else {
					array_push($response, $model->getErrors());
				}
			}
		}

	}

	public function GenerateThumbnail($im_filename,$th_filename,$max_width,$max_height,$quality = 0.75)
	{
// The original image must exist
		if(is_file($im_filename))
		{
    // Let's create the directory if needed
			$th_path = dirname($th_filename);
			if(!is_dir($th_path))
				mkdir($th_path, 0777, true);
    // If the thumb does not aleady exists
			if(!is_file($th_filename))
			{
        // Get Image size info
				list($width_orig, $height_orig, $image_type) = @getimagesize($im_filename);
				if(!$width_orig)
					return 2;
				switch($image_type)
				{
					case 1: $src_im = @imagecreatefromgif($im_filename);    break;
					case 2: $src_im = @imagecreatefromjpeg($im_filename);   break;
					case 3: $src_im = @imagecreatefrompng($im_filename);    break;
				}
				if(!$src_im)
					return 3;


				$aspect_ratio = (float) $height_orig / $width_orig;

				$thumb_height = $max_height;
				$thumb_width = round($thumb_height / $aspect_ratio);
				if($thumb_width > $max_width)
				{
					$thumb_width    = $max_width;
					$thumb_height   = round($thumb_width * $aspect_ratio);
				}

				$width = $thumb_width;
				$height = $thumb_height;

				$dst_img = @imagecreatetruecolor($width, $height);
				if(!$dst_img)
					return 4;
				$success = @imagecopyresampled($dst_img,$src_im,0,0,0,0,$width,$height,$width_orig,$height_orig);
				if(!$success)
					return 4;
				switch ($image_type) 
				{
					case 1: $success = @imagegif($dst_img,$th_filename); break;
					case 2: $success = @imagejpeg($dst_img,$th_filename,intval($quality*100));  break;
					case 3: $success = @imagepng($dst_img,$th_filename,intval($quality*9)); break;
				}
				if(!$success)
					return 4;
			}
			return 0;
		}
		return 1;
	}

	public function actionDeleteImagen() {
		$model=Album::model()->findByPk($_POST['id_album']);
		if ($model->delete()) {
			echo json_encode(array(
				"success" => true
			));
		} else {
			echo json_encode(array(
				"success" => false
			));
		}
	}


	public function actionCreateOriginal()
	{
		$model = new Boda;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		$layouts = Layout::model()->findAll();
		if (isset($_POST['Boda'])) {
			$model->attributes = $_POST['Boda'];
			$model->slug = strtolower($_POST['Boda']['novia']) . "y" . strtolower($_POST['Boda']['novio']);
			$model->fecha_entrada = implode('-', array_reverse(explode('/', $_POST['Boda']['fecha_entrada'])));
			$model->fecha_salida = implode('-', array_reverse(explode('/', $_POST['Boda']['fecha_salida'])));
			$model->fecha_boda = implode('-', array_reverse(explode('/', $_POST['Boda']['fecha_boda'])));
			$model->fecha_lim_reserva = implode('-', array_reverse(explode('/', $_POST['Boda']['fecha_lim_reserva'])));

			if ($model->save()) {
				if (is_uploaded_file($_FILES['logo']['tmp_name'])) {
					$fileName = "logoR" . $model->id . $_FILES['logo']['type'];
					$dir = $_SERVER['DOCUMENT_ROOT'] . Yii::app()->baseUrl . '/images/' . $fileName;
					if (move_uploaded_file($_FILES['logo']['tmp_name'], $dir)) {
						echo "El archivo se subio correctamente";
					}
				}

				if (is_uploaded_file($_FILES['fact_sheet']['tmp_name'])) {
					$fileName = "fact_sheet_" . $model->id . ".pdf";
					$dir = $_SERVER['DOCUMENT_ROOT'] . Yii::app()->baseUrl . '/archivos/' . $fileName;
					if (move_uploaded_file($_FILES['fact_sheet']['tmp_name'], $dir)) {
						echo "El archivo se subio correctamente";
					}
				}

				$this->redirect(array('view', 'id' => $model->id));
			}
		}

		$this->render('create', array(
			'model' => $model, 'layout' => $layouts,
		));
	}

	public function actionNueva()
	{
		$this->render("nueva");
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */

	public function actionUpdateOriginal($id)
	{
		$model = $this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		$layouts = Layout::model()->findAll();

		if (isset($_POST['Boda'])) {
			$model->attributes = $_POST['Boda'];
			if (isset($_POST['Boda']['novio'])) {
				$slug = $model->novia . "y" . strtolower($_POST['Boda']['novio']);
			} else $slug = $model->slug;
			if (isset($_POST['Boda']['novia'])) {
				$slug = strtolower($_POST['Boda']['novio']) . "y" . $model->novio;
			} else $slug = $model->slug;

			if (isset($_POST['Boda']['novio']) && isset($_POST['Boda']['novia'])) {
				$slug = strtolower($_POST['Boda']['novia']) . "y" . strtolower($_POST['Boda']['novio']);
			} else $slug = $model->slug;

			$model->slug = $slug;

			$model->fecha_entrada = implode('-', array_reverse(explode('/', $_POST['Boda']['fecha_entrada'])));
			$model->fecha_salida = implode('-', array_reverse(explode('/', $_POST['Boda']['fecha_salida'])));
			$model->fecha_boda = implode('-', array_reverse(explode('/', $_POST['Boda']['fecha_boda'])));
			$model->fecha_lim_reserva = implode('-', array_reverse(explode('/', $_POST['Boda']['fecha_lim_reserva'])));

			if ($model->save()) {
				if (is_uploaded_file($_FILES['logo']['tmp_name'])) {
					$fileName = "logoR" . $model->id . ".jpg";
					$dir = $_SERVER['DOCUMENT_ROOT'] . Yii::app()->baseUrl . '/images/' . $fileName;
					if (is_readable($dir)) unlink($dir);

					if (move_uploaded_file($_FILES['logo']['tmp_name'], $dir)) {
						echo "El archivo se subio correctamente";
					}
				}

				if (is_uploaded_file($_FILES['fact_sheet']['tmp_name'])) {
					$fileName = "fact_sheet_" . $model->id . ".pdf";
					$dir = $_SERVER['DOCUMENT_ROOT'] . Yii::app()->baseUrl . '/archivos/' . $fileName;
					if (is_readable($dir)) unlink($dir);
					if (move_uploaded_file($_FILES['fact_sheet']['tmp_name'], $dir)) {
						echo "El archivo se subio correctamente";
					}
				}

				$this->redirect(array('view', 'id' => $model->id));
			}
		}

		$this->render('update', array(
			'model' => $model, 'layout' => $layouts,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */

	public function actionDeleteOringinal($id)
	{
		if (Yii::app()->request->isPostRequest) {
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();
			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if (!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		} else
		throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
	}

	public function actionGetHoteles()
	{
		if ($_POST['id_hotel'] != "") {
			$bloqueo = Bloqueos::model()->findByPk($_POST['id_hotel']);
			$hotel = Hoteles::model()->findAll('id_hotel=' . $bloqueo->idHotel->id_hotel);
			echo CJSON::encode($hotel);
		} else {
			$hotel = Hoteles::model()->findAll(array('condition' => 'estatus=1 and proveedor=0 or proveedor=2'));
			echo CJSON::encode($hotel);
		}
	}

	/**
	 * Lists all models.
	 */

	public function actionIndex()
	{
		if (Yii::app()->user->id == 3) {
			$this->redirect(array('bodasParejas/index'));
			exit;
		}

		$session = new CHttpSession;
		$session->open();
		$criteria = new CDbCriteria();

		$model = new Boda('search');
		$model->unsetAttributes();  // clear any default values

		if (isset($_GET['Boda'])) {
			$model->attributes = $_GET['Boda'];

			if (!empty($model->id)) $criteria->addCondition("id = '" . $model->id . "'");

			if (!empty($model->novio)) $criteria->addCondition("novio = '" . $model->novio . "'");

			if (!empty($model->novia)) $criteria->addCondition("novia = '" . $model->novia . "'");

			if (!empty($model->lugar)) $criteria->addCondition("lugar = '" . $model->lugar . "'");

			if (!empty($model->fecha_entrada)) $criteria->addCondition("fecha_entrada = '" . $model->fecha_entrada . "'");

			if (!empty($model->fecha_salida)) $criteria->addCondition("fecha_salida = '" . $model->fecha_salida . "'");

			if (!empty($model->hora_inicio)) $criteria->addCondition("hora_inicio = '" . $model->hora_inicio . "'");

			if (!empty($model->hora_fin)) $criteria->addCondition("hora_fin = '" . $model->hora_fin . "'");

			if (!empty($model->id_layout)) $criteria->addCondition("id_layout = '" . $model->id_layout . "'");

			$session['Boda_records'] = Boda::model()->findAll($criteria);
		}

		$this->render('index', array(
			'model' => $model,
		));
	}

	/**
	 * Manages all models.
	 */

	public function actionAdmin()
	{
		$model = new Boda('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['Boda']))
			$model->attributes = $_GET['Boda'];

		$this->render('admin', array(
			'model' => $model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */

	public function loadModel($id)
	{
		$model = Boda::model()->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');

		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */

	protected function performAjaxValidation($model)
	{
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'boda-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}

	public function actionGenerateExcel()
	{
		$session = new CHttpSession;
		$session->open();

		if (isset($session['Boda_records'])) {
			$model = $session['Boda_records'];
		} else
		$model = Boda::model()->findAll();

		Yii::app()->request->sendFile(
			date('YmdHis') . '.xls',

			$this->renderPartial('excelReport', array(
				'model' => $model
			), true)
		);
	}

	public function actionGeneratePdf()
	{
		$session = new CHttpSession;
		$session->open();

		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

		if (isset($session['Boda_records'])) {
			$model = $session['Boda_records'];
		} else
		$model = Boda::model()->findAll();

		$html = $this->renderPartial('expenseGridtoReport', array(
			'model' => $model
		), true);

		//die($html);

		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Boda Report');
		$pdf->SetSubject('Boda Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by " . Yii::app()->name, "");
		$pdf->setHeaderFont(array('helvetica', '', 8));
		$pdf->setFooterFont(array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("Boda_002.pdf", "I");
	}
}
