<?php
class GeneralController extends Controller {
	public function convertModelToArray($models) {
        if (is_array($models))
            $arrayMode = TRUE;
        else {
            $models = array($models);
            $arrayMode = FALSE;
        }

        $result = array();

        foreach ($models as $model) {
            $attributes = $model->getAttributes();
            $relations = array();

            foreach ($model->relations() as $key => $related) {
                if ($model->hasRelated($key)) {
                	if ($model->$key) {
                    	$relations[$key] = $this->convertModelToArray($model->$key);	
                	}else{
                		$relations[$key] =[];
                	}
                }
            }

            $all = array_merge($attributes, $relations);

            if ($arrayMode)
                array_push($result, $all);
            else
                $result = $all;
        }

        return $result;
    }
}