<?php

class UsersController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view'),
				'users' => array('@'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update', 'GeneratePdf', 'GenerateExcel', 'Administrar', 'profile', 'getInfoUser', 'editProfile', 'changePassword', 'getUsers'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view', array(
			'model' => $this->loadModel($id),
		));
	}

	public function actionProfile()
	{
		$this->render("profile");
	}

	public function actionGetInfoUser()
	{
		$model = Users::model()->findByPk(Yii::app()->user->id);
		$general = Yii::app()->createController('General')[0];
		$response = $general->convertModelToArray($model);
		$response["userProfile"] = Profiles::model()->findByPk(Yii::app()->user->id);
		echo CJSON::encode($response);
	}

	public function actionEditProfile()
	{
		$model = Users::model()->findByPk(Yii::app()->user->id);
		$profile = Profile::model()->findByPk(Yii::app()->user->id);
		$model->username = $_POST["username"];
		$model->email = $_POST["email"];
		$profile->firstname = $_POST["firstname"];
		$profile->lastname = $_POST["lastname"];

		if ($model->save()) {
			if ($profile->save()) {
				$general = Yii::app()->createController('General')[0];
				$response = $general->convertModelToArray($model);
				$response["userProfile"] = $profile;
				echo CJSON::encode($response);
			} else {
				echo CJSON::encode($profile->getErrors());
			}
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	public function actionChangePassword()
	{
		$model = Users::model()->findByPk(Yii::app()->user->id);
		$password_decode = base64_decode($_POST["pwd"]);
		$model->password = md5($password_decode);

		if ($model->save()) {
			echo CJSON::encode($model);
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	public function actionGetUsers()
	{
		$model = Users::model()->findAll("id != " . Yii::app()->user->id);
		$general = Yii::app()->createController('General')[0];
		$response = array(
			"data" => $general->convertModelToArray($model)
		);

		foreach ($response["data"] as $key => $value) {
			$response["data"][$key]["userProfile"] = Profiles::model()->findByPk($value["id"]);
		}
		echo CJSON::encode($response);
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new Users;
		$model->attributes = $_POST['user'];
		$model->activkey = md5(microtime() . $model->password);
		$model->password = md5($model->password);
		if ($model->save()) {
			$profile = new Profile;
			$profile->attributes = $_POST['profile'];
			if ($profile->save()) {
				$general = Yii::app()->createController('General')[0];
				$response = $general->convertModelToArray($model);
				$response["userProfile"] = Profiles::model()->findByPk($response["id"]);
				echo CJSON::encode($response);
			} else {
				echo CJSON::encode($profile->getErrors());
			}
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate()
	{
		$model = $this->loadModel($_POST['user']['id']);
		$pwd = $model->password;
		$model->attributes = $_POST['user'];
		if ($pwd == md5($_POST["password"])) {
			$model->password = md5($model->password);
		}
		if ($model->save()) {
			$profile = Profile::model()->findByPk($_POST["user"]['id']);
			$profile->attributes = $_POST["profile"];
			if ($profile->save()) {
				$general = Yii::app()->createController('General')[0];
				$response = $general->convertModelToArray($model);
				$response["userProfile"] = Profiles::model()->findByPk($response["id"]);
				echo CJSON::encode($response);
			} else {
				echo CJSON::encode($profile->getErrors());
			}
		} else {
			echo CJSON::encode($model->getErrors());
		}
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$model = $this->loadModel($id);
		$model->status = 0;
		$model->save();
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$session = new CHttpSession;
		$session->open();
		$criteria = new CDbCriteria();

		$model = new Users('search');
		$model->unsetAttributes();  // clear any default values

		if (isset($_GET['Users'])) {
			$model->attributes = $_GET['Users'];

			if (!empty($model->id)) $criteria->addCondition("id = '" . $model->id . "'");

			if (!empty($model->username)) $criteria->addCondition("username = '" . $model->username . "'");

			if (!empty($model->password)) $criteria->addCondition("password = '" . $model->password . "'");

			if (!empty($model->email)) $criteria->addCondition("email = '" . $model->email . "'");

			if (!empty($model->activkey)) $criteria->addCondition("activkey = '" . $model->activkey . "'");

			if (!empty($model->create_at)) $criteria->addCondition("create_at = '" . $model->create_at . "'");

			if (!empty($model->lastvisit_at)) $criteria->addCondition("lastvisit_at = '" . $model->lastvisit_at . "'");

			if (!empty($model->superuser)) $criteria->addCondition("superuser = '" . $model->superuser . "'");

			if (!empty($model->status)) $criteria->addCondition("status = '" . $model->status . "'");

			$session['Users_records'] = Users::model()->findAll($criteria);
		}

		$this->render('index', array(
			'model' => $model,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Users('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['Users']))
			$model->attributes = $_GET['Users'];

		$this->render('admin', array(
			'model' => $model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Users::model()->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'users-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}

	public function actionGenerateExcel()
	{
		$session = new CHttpSession;
		$session->open();

		if (isset($session['Users_records'])) {
			$model = $session['Users_records'];
		} else
			$model = Users::model()->findAll();

		Yii::app()->request->sendFile(
			date('YmdHis') . '.xls',
			$this->renderPartial('excelReport', array(
				'model' => $model
			), true)
		);
	}

	public function actionGeneratePdf()
	{
		$session = new CHttpSession;
		$session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

		if (isset($session['Users_records'])) {
			$model = $session['Users_records'];
		} else
			$model = Users::model()->findAll();

		$html = $this->renderPartial('expenseGridtoReport', array(
			'model' => $model
		), true);

		//die($html);

		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Users Report');
		$pdf->SetSubject('Users Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by " . Yii::app()->name, "");
		$pdf->setHeaderFont(array('helvetica', '', 8));
		$pdf->setFooterFont(array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("Users_002.pdf", "I");
	}

	public function actionAdministrar()
	{
		$this->layout = '//layouts/main';
		$this->render('administrar');
	}
}
