<?php

class WebsiteController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','slug'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('*'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('*'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actionSlug($slug){
		$session=new CHttpSession;
		$session->open();
		$_SESSION['cancelUrl']= "http://".$_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
		$prueba = explode('?',$_SESSION['cancelUrl']);
		$_SESSION['cancelUrl']= $prueba[0];

		$model = $this->loadModelBySlug($slug);
		$id = $model->id;
		#$model=Boda::model()->findByPk($id);
		

		$msjs = Comentarios::model()->findAll(array("condition" => "id_boda = '".$id."'","order" => "id_comentario DESC"));
		$slider = Banners::model()->findAll(array("condition" => "id_boda = '".$id."' and posicion=1","order" => "orden"));
		$banner_left = Banners::model()->findAll(array("condition" => "id_boda = '".$id."' and posicion=2","order" => "id_banner DESC","limit"=>1));
		$img_firmas = Banners::model()->findAll(array("condition" => "id_boda = '".$id."' and posicion=3","order" => "id_banner DESC","limit"=>1));
		$img_ceremonia = Banners::model()->findAll(array("condition" => "id_boda = '".$id."' and posicion=4","order" => "id_banner DESC","limit"=>1));
		$registro = Banners::model()->findAll(array("condition" => "id_boda = '".$id."' and posicion=5","order" => "id_banner DESC","limit"=>1));
		$album = Album::model()->findAll("id_boda=".$id);

		$this->layout='//layouts/boda';
		$hotel = $model->lugar;
		$fecha = explode('-',$model->fecha_boda);
		$fecha_dia=intval($fecha[2]);
		$fecha_mes= intval($fecha[1]);
		//$fecha_max = explode('-',$model->idBloqueo->fecha_final);
		$fecha_max = explode('-',$model->idBloqueo->idTarifa->fecha_promo);
		$fecha_mes_max= intval($fecha[1]);
		$meses = array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
		for ($i=0; $i <count($meses); $i++)
			if ($fecha_mes==$i+1) 
				$fecha_mes=$meses[$i];
		for ($i=0; $i <count($meses); $i++)
			if ($fecha_mes_max==$i+1) 
				$fecha_mes_max=$meses[$i];

		$dias = array("Domingo","Lunes","Martes","Miercoles","Jueves","Viernes","Sábado");
		for ($i=0; $i <count($dias) ; $i++)
			if (date('w',strtotime($model->fecha_boda))==$i)
				$fecha_dia_week=$dias[$i];
				
		$fecha_anio= $fecha[0];
		$fecha_c=$fecha_mes." ".$fecha_dia.", ".$fecha_anio;
		$this->pageTitle=$model->novio." y ".$model->novia." - Casate Conmigo by Ruta Maya Travel";
			$this->render('/site/boda'.$model->id_layout,array(
				'model'=>$model,'hotel'=>$hotel,'fecha_dia'=>$fecha_dia,
				'fecha_mes'=>$fecha_mes,'fecha_anio'=>$fecha_anio,'fecha'=>$fecha_c,
				'fecha_dia_week'=>$fecha_dia_week,'msjs'=>$msjs,'slider'=>$slider,
				'banner_left'=>$banner_left,'img_firmas'=>$img_firmas,'img_ceremonia'=>$img_ceremonia,
				'registro'=>$registro,'album'=>$album,'fecha_mes_max'=>$fecha_mes_max,
			));
	}
	public function loadModel($id)
	{
		$model=Product::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}
	public function loadModelBySlug($slug){
		$model = Boda::model()->findByAttributes(array('slug' => $slug));
		if ($model === null) {
			throw new CHttpException(404, 'The requested Product does not exist.');
		}
		return $model;
	}
}
