<?php

/**
 * This is the model class for table "banners".
 *
 * The followings are the available columns in table 'banners':
 * @property integer $id_banner
 * @property string $titulo
 * @property integer $posicion
 * @property integer $orden
 * @property string $nombre_real
 * @property integer $id_boda
 *
 * The followings are the available model relations:
 * @property Boda $idBoda
 */
class Banners extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Banners the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'banners';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('titulo, posicion, nombre_real, id_boda', 'required'),
			array('posicion, orden, id_boda', 'numerical', 'integerOnly'=>true),
			array('titulo, nombre_real', 'length', 'max'=>150),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_banner, titulo, posicion, orden, nombre_real, id_boda', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idBoda' => array(self::BELONGS_TO, 'Boda', 'id_boda'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_banner' => 'Id Banner',
			'titulo' => 'Titulo',
			'posicion' => 'Posicion',
			'orden' => 'Orden',
			'nombre_real' => 'Nombre Real',
			'id_boda' => 'Id Boda',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_banner',$this->id_banner);
		$criteria->compare('titulo',$this->titulo,true);
		$criteria->compare('posicion',$this->posicion);
		$criteria->compare('orden',$this->orden);
		$criteria->compare('nombre_real',$this->nombre_real,true);
		$criteria->compare('id_boda',$this->id_boda);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}


	public static function posicion($p)

	{

		switch ($p){

			case 1: $nombre = "Slider"; break;

			case 2: $nombre = "Lateral Izquierdo"; break;

			case 3: $nombre = "Libro de Firmas"; break;

			case 4: $nombre = "Ceremonia Nupcial"; break;

			case 5: $nombre = "Registro"; break;

		}

		return $nombre;

	}

}