<?php

/**
 * This is the model class for table "{{bloqueos}}".
 *
 * The followings are the available columns in table '{{bloqueos}}':
 * @property string $id_bloqueo
 * @property string $titulo
 * @property string $titulo_evento
 * @property string $descripcion_hotel
 * @property string $descripcion_evento
 * @property string $id_hotel
 * @property string $tipo
 * @property integer $id_agencia
 * @property double $comision
 * @property integer $id_paquete
 * @property string $novios
 * @property string $fecha_inicio
 * @property string $fecha_final
 * @property string $numero_habitaciones
 * @property string $id_tipo_plan
 * @property string $id_tipo_habitacion
 * @property string $id_tarifa
 * @property integer $tiempo_limite
 * @property integer $id_contrato
 * @property string $fecha_creacion
 * @property integer $id_usuario
 * @property string $observaciones
 * @property string $observaciones2
 * @property string $motivo
 * @property integer $estatus
 * @property integer $suspendido
 * @property integer $visibilidad
 * @property integer $es_promo
 * @property integer $mostrar_al_inicio
 *
 * The followings are the available model relations:
 * @property ContratosRelacion[] $contratosRelacions
 * @property EventsWeddings[] $eventsWeddings
 * @property GruposCotizaciones[] $gruposCotizaciones
 * @property GruposCotizacionesTour[] $gruposCotizacionesTours
 */
class Bloqueos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Bloqueos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return CDbConnection database connection
	 */
	public function getDbConnection()
	{
		return Yii::app()->db1;
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{bloqueos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_hotel, tipo, numero_habitaciones, id_tipo_plan, id_tipo_habitacion, id_tarifa, fecha_creacion, id_usuario', 'required'),
			array('id_agencia, id_paquete, tiempo_limite, id_contrato, id_usuario, estatus, suspendido, visibilidad, es_promo, mostrar_al_inicio', 'numerical', 'integerOnly'=>true),
			array('comision', 'numerical'),
			array('id_hotel, numero_habitaciones, id_tipo_plan, id_tipo_habitacion, id_tarifa', 'length', 'max'=>10),
			array('tipo', 'length', 'max'=>20),
			array('novios', 'length', 'max'=>100),
			array('titulo, titulo_evento, descripcion_hotel, descripcion_evento, fecha_inicio, fecha_final, observaciones, observaciones2, motivo', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_bloqueo, titulo, titulo_evento, descripcion_hotel, descripcion_evento, id_hotel, tipo, id_agencia, comision, id_paquete, novios, fecha_inicio, fecha_final, numero_habitaciones, id_tipo_plan, id_tipo_habitacion, id_tarifa, tiempo_limite, id_contrato, fecha_creacion, id_usuario, observaciones, observaciones2, motivo, estatus, suspendido, visibilidad, es_promo, mostrar_al_inicio', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'contratosRelacions' => array(self::HAS_MANY, 'ContratosRelacion', 'id_bloqueo'),
			'eventsWeddings' => array(self::HAS_MANY, 'EventsWeddings', 'id_bloqueo'),
			'gruposCotizaciones' => array(self::HAS_MANY, 'GruposCotizaciones', 'id_grupo'),
			'gruposCotizacionesTours' => array(self::HAS_MANY, 'GruposCotizacionesTour', 'id_grupo'),
			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_bloqueo' => 'Id Bloqueo',
			'titulo' => 'Titulo',
			'titulo_evento' => 'Titulo Evento',
			'descripcion_hotel' => 'Descripcion Hotel',
			'descripcion_evento' => 'Descripcion Evento',
			'id_hotel' => 'Id Hotel',
			'tipo' => 'Tipo',
			'id_agencia' => 'Id Agencia',
			'comision' => 'Comision',
			'id_paquete' => 'Id Paquete',
			'novios' => 'Novios',
			'fecha_inicio' => 'Fecha Inicio',
			'fecha_final' => 'Fecha Final',
			'numero_habitaciones' => 'Numero Habitaciones',
			'id_tipo_plan' => 'Id Tipo Plan',
			'id_tipo_habitacion' => 'Id Tipo Habitacion',
			'id_tarifa' => 'Id Tarifa',
			'tiempo_limite' => 'Tiempo Limite',
			'id_contrato' => 'Id Contrato',
			'fecha_creacion' => 'Fecha Creacion',
			'id_usuario' => 'Id Usuario',
			'observaciones' => 'Observaciones',
			'observaciones2' => 'Observaciones2',
			'motivo' => 'Motivo',
			'estatus' => 'Estatus',
			'suspendido' => 'Suspendido',
			'visibilidad' => 'Visibilidad',
			'es_promo' => 'Es Promo',
			'mostrar_al_inicio' => 'Mostrar Al Inicio',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_bloqueo',$this->id_bloqueo,true);
		$criteria->compare('titulo',$this->titulo,true);
		$criteria->compare('titulo_evento',$this->titulo_evento,true);
		$criteria->compare('descripcion_hotel',$this->descripcion_hotel,true);
		$criteria->compare('descripcion_evento',$this->descripcion_evento,true);
		$criteria->compare('id_hotel',$this->id_hotel,true);
		$criteria->compare('tipo',$this->tipo,true);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('comision',$this->comision);
		$criteria->compare('id_paquete',$this->id_paquete);
		$criteria->compare('novios',$this->novios,true);
		$criteria->compare('fecha_inicio',$this->fecha_inicio,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);
		$criteria->compare('numero_habitaciones',$this->numero_habitaciones,true);
		$criteria->compare('id_tipo_plan',$this->id_tipo_plan,true);
		$criteria->compare('id_tipo_habitacion',$this->id_tipo_habitacion,true);
		$criteria->compare('id_tarifa',$this->id_tarifa,true);
		$criteria->compare('tiempo_limite',$this->tiempo_limite);
		$criteria->compare('id_contrato',$this->id_contrato);
		$criteria->compare('fecha_creacion',$this->fecha_creacion,true);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('observaciones2',$this->observaciones2,true);
		$criteria->compare('motivo',$this->motivo,true);
		$criteria->compare('estatus',$this->estatus);
		$criteria->compare('suspendido',$this->suspendido);
		$criteria->compare('visibilidad',$this->visibilidad);
		$criteria->compare('es_promo',$this->es_promo);
		$criteria->compare('mostrar_al_inicio',$this->mostrar_al_inicio);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}