<?php

/**
 * This is the model class for table "boda".
 *
 * The followings are the available columns in table 'boda':
 * @property integer $id
 * @property string $novio
 * @property string $novia
 * @property string $slug
 * @property integer $lugar
 * @property string $fecha_boda
 * @property string $fecha_entrada
 * @property string $fecha_salida
 * @property string $fecha_lim_reserva
 * @property string $hora_inicio
 * @property string $hora_fin
 * @property integer $id_layout
 * @property string $correo_novio
 * @property string $correo_novia
 * @property integer $id_bloqueo
 * @property string $url
 *
 * The followings are the available model relations:
 * @property Album[] $albums
 * @property Banners[] $banners
 * @property Layout $idLayout
 * @property Comentarios[] $comentarioses
 */
class Boda extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Boda the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'boda';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('novio, novia, slug, lugar, fecha_boda, fecha_entrada, fecha_salida, fecha_lim_reserva, hora_inicio, hora_fin, id_layout, id_bloqueo', 'required'),
			array('lugar, id_layout, id_bloqueo', 'numerical', 'integerOnly'=>true),
			array('novio, novia', 'length', 'max'=>150),
			array('slug', 'length', 'max'=>255),
			array('correo_novio, correo_novia', 'length', 'max'=>100),
			array('url', 'length', 'max'=>250),
			array('datos_pago', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, novio, novia, slug, lugar, fecha_boda, fecha_entrada, fecha_salida, fecha_lim_reserva, hora_inicio, hora_fin, id_layout, correo_novio, correo_novia, id_bloqueo, url , datos_pago', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'albums' => array(self::HAS_MANY, 'Album', 'id_boda'),
			'banners' => array(self::HAS_MANY, 'Banners', 'id_boda'),
			'idLayout' => array(self::BELONGS_TO, 'Layout', 'id_layout'),
			'idBloqueo' => array(self::BELONGS_TO, 'Bloqueos', 'id_bloqueo'),
			'comentarioses' => array(self::HAS_MANY, 'Comentarios', 'id_boda'),
			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'lugar'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'novio' => 'Novio',
			'novia' => 'Novia',
			'slug' => 'Slug',
			'lugar' => 'Lugar',
			'fecha_boda' => 'Fecha Boda',
			'fecha_entrada' => 'Fecha Entrada',
			'fecha_salida' => 'Fecha Salida',
			'fecha_lim_reserva' => 'Fecha Lim Reserva',
			'hora_inicio' => 'Hora Inicio',
			'hora_fin' => 'Hora Fin',
			'id_layout' => 'Id Layout',
			'correo_novio' => 'Correo Novio',
			'correo_novia' => 'Correo Novia',
			'id_bloqueo' => 'Id Bloqueo',
			'url' => 'Url',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('novio',$this->novio,true);
		$criteria->compare('novia',$this->novia,true);
		$criteria->compare('slug',$this->slug,true);
		$criteria->compare('lugar',$this->lugar);
		$criteria->compare('fecha_boda',$this->fecha_boda,true);
		$criteria->compare('fecha_entrada',$this->fecha_entrada,true);
		$criteria->compare('fecha_salida',$this->fecha_salida,true);
		$criteria->compare('fecha_lim_reserva',$this->fecha_lim_reserva,true);
		$criteria->compare('hora_inicio',$this->hora_inicio,true);
		$criteria->compare('hora_fin',$this->hora_fin,true);
		$criteria->compare('id_layout',$this->id_layout);
		$criteria->compare('correo_novio',$this->correo_novio,true);
		$criteria->compare('correo_novia',$this->correo_novia,true);
		$criteria->compare('id_bloqueo',$this->id_bloqueo);
		$criteria->compare('url',$this->url,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}