<?php

/**
 * This is the model class for table "{{hoteles}}".
 *
 * The followings are the available columns in table '{{hoteles}}':
 * @property string $id_hotel
 * @property integer $id_destino
 * @property integer $id_destinoLocal
 * @property string $nombre_hotel
 * @property string $slug
 * @property string $tel_hotel1
 * @property string $tel_hotel2
 * @property string $tel_hotel3
 * @property string $contacto_hotel
 * @property string $email_hotel
 * @property string $contacto_reservas_1
 * @property string $email_reservas_1
 * @property string $contacto_reservas_2
 * @property string $email_reservas_2
 * @property string $estrellas
 * @property integer $max_ninios
 * @property integer $max_jrs
 * @property double $comision
 * @property string $observaciones
 * @property string $id_pais_hotel
 * @property string $id_estado_hotel
 * @property string $id_ciudad_hotel
 * @property string $id_colonia_hotel
 * @property string $municipio_hotel
 * @property string $cp_hotel
 * @property string $calle_hotel
 * @property string $num_exterior_hotel
 * @property string $num_interior_hotel
 * @property string $cruzamientos_hotel
 * @property string $razon_social
 * @property string $rfc_hotel
 * @property string $id_pais_fiscal
 * @property string $id_estado_fiscal
 * @property string $id_ciudad_fiscal
 * @property string $id_colonia_fiscal
 * @property string $calle_fiscal
 * @property string $cruzamientos_fiscal
 * @property string $cp_fiscal
 * @property string $municipio_fiscal
 * @property string $num_interior_fiscal
 * @property string $num_exterior_fiscal
 * @property string $log
 * @property integer $estatus
 * @property integer $mismadir
 * @property integer $id_categoria
 * @property string $codigo
 * @property string $ubicacion
 * @property double $latitud
 * @property double $longitud
 * @property integer $solo_adultos
 * @property integer $gay
 * @property double $tipo_cambio
 * @property integer $id_cadena
 * @property integer $alerta_disponibilidad
 * @property integer $proveedor
 * @property double $precio
 * @property integer $busqueda
 * @property integer $no_listar
 *
 * The followings are the available model relations:
 * @property Allotment[] $allotments
 * @property Apihotelesrel[] $apihotelesrels
 * @property ContratosBloqueos[] $contratosBloqueoses
 * @property FechaLimite[] $fechaLimites
 * @property GruposCotizaciones[] $gruposCotizaciones
 * @property Lotes[] $lotes
 * @property PaqueteHotel[] $paqueteHotels
 * @property PaquetesBoda[] $paquetesBodas
 * @property PlanHotel[] $planHotels
 * @property Release[] $releases
 * @property TabuladorHoteles[] $tabuladorHoteles
 */
class Hoteles extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Hoteles the static model class
	 */
	public static $db_pagina;
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return CDbConnection database connection
	 */
	public function getDbConnection(){
		if(self::$db_pagina !== null) {
			return self::$db_pagina;
		} else {
			self::$db_pagina = Yii::app()->db1;

			if (self::$db_pagina instanceof CDbConnection){
				self::$db_pagina->setActive(true);
				return self::$db_pagina;
			} else 
				throw new CDbException(Yii::t('yii','Active Record requires a "db_" CDbConnection application component.'));
		}
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return Yii::app()->params['appDB'].'.{{hoteles}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nombre_hotel, tel_hotel1, id_pais_hotel, municipio_hotel, cp_hotel, log, proveedor', 'required'),
			array('id_destino, id_destinoLocal, max_ninios, max_jrs, estatus, mismadir, id_categoria, solo_adultos, gay, id_cadena, alerta_disponibilidad, proveedor, busqueda, no_listar', 'numerical', 'integerOnly'=>true),
			array('comision, latitud, longitud, tipo_cambio, precio', 'numerical'),
			array('nombre_hotel, contacto_hotel, email_hotel, id_estado_hotel, id_ciudad_hotel, id_colonia_hotel, municipio_hotel, calle_hotel, razon_social, id_pais_fiscal, calle_fiscal', 'length', 'max'=>255),
			array('tel_hotel1, tel_hotel2, tel_hotel3, num_exterior_hotel, num_interior_hotel, cruzamientos_hotel, rfc_hotel, id_estado_fiscal, id_ciudad_fiscal, id_colonia_fiscal, cruzamientos_fiscal, cp_fiscal, municipio_fiscal, num_interior_fiscal, num_exterior_fiscal', 'length', 'max'=>45),
			array('contacto_reservas_1, email_reservas_1, contacto_reservas_2, email_reservas_2', 'length', 'max'=>100),
			array('estrellas', 'length', 'max'=>20),
			array('id_pais_hotel', 'length', 'max'=>10),
			array('cp_hotel', 'length', 'max'=>15),
			array('codigo', 'length', 'max'=>50),
			array('slug, observaciones, ubicacion', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_hotel, id_destino, id_destinoLocal, nombre_hotel, slug, tel_hotel1, tel_hotel2, tel_hotel3, contacto_hotel, email_hotel, contacto_reservas_1, email_reservas_1, contacto_reservas_2, email_reservas_2, estrellas, max_ninios, max_jrs, comision, observaciones, id_pais_hotel, id_estado_hotel, id_ciudad_hotel, id_colonia_hotel, municipio_hotel, cp_hotel, calle_hotel, num_exterior_hotel, num_interior_hotel, cruzamientos_hotel, razon_social, rfc_hotel, id_pais_fiscal, id_estado_fiscal, id_ciudad_fiscal, id_colonia_fiscal, calle_fiscal, cruzamientos_fiscal, cp_fiscal, municipio_fiscal, num_interior_fiscal, num_exterior_fiscal, log, estatus, mismadir, id_categoria, codigo, ubicacion, latitud, longitud, solo_adultos, gay, tipo_cambio, id_cadena, alerta_disponibilidad, proveedor, precio, busqueda, no_listar', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'allotments' => array(self::HAS_MANY, 'Allotment', 'id_hotel'),
			'apihotelesrels' => array(self::HAS_MANY, 'Apihotelesrel', 'idHotel'),
			'contratosBloqueoses' => array(self::HAS_MANY, 'ContratosBloqueos', 'id_hotel'),
			'fechaLimites' => array(self::HAS_MANY, 'FechaLimite', 'id_hotel'),
			'gruposCotizaciones' => array(self::HAS_MANY, 'GruposCotizaciones', 'id_hotel'),
			'lotes' => array(self::HAS_MANY, 'Lotes', 'id_hotel'),
			'paqueteHotels' => array(self::HAS_MANY, 'PaqueteHotel', 'id_hotel'),
			'paquetesBodas' => array(self::HAS_MANY, 'PaquetesBoda', 'id_hotel'),
			'planHotels' => array(self::HAS_MANY, 'PlanHotel', 'id_hotel'),
			'releases' => array(self::HAS_MANY, 'Release', 'id_hotel'),
			'tabuladorHoteles' => array(self::HAS_MANY, 'TabuladorHoteles', 'id_hotel'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_hotel' => 'Id Hotel',
			'id_destino' => 'Id Destino',
			'id_destinoLocal' => 'Id Destino Local',
			'nombre_hotel' => 'Nombre Hotel',
			'slug' => 'Slug',
			'tel_hotel1' => 'Tel Hotel1',
			'tel_hotel2' => 'Tel Hotel2',
			'tel_hotel3' => 'Tel Hotel3',
			'contacto_hotel' => 'Contacto Hotel',
			'email_hotel' => 'Email Hotel',
			'contacto_reservas_1' => 'Contacto Reservas 1',
			'email_reservas_1' => 'Email Reservas 1',
			'contacto_reservas_2' => 'Contacto Reservas 2',
			'email_reservas_2' => 'Email Reservas 2',
			'estrellas' => 'Estrellas',
			'max_ninios' => 'Max Ninios',
			'max_jrs' => 'Max Jrs',
			'comision' => 'Comision',
			'observaciones' => 'Observaciones',
			'id_pais_hotel' => 'Id Pais Hotel',
			'id_estado_hotel' => 'Id Estado Hotel',
			'id_ciudad_hotel' => 'Id Ciudad Hotel',
			'id_colonia_hotel' => 'Id Colonia Hotel',
			'municipio_hotel' => 'Municipio Hotel',
			'cp_hotel' => 'Cp Hotel',
			'calle_hotel' => 'Calle Hotel',
			'num_exterior_hotel' => 'Num Exterior Hotel',
			'num_interior_hotel' => 'Num Interior Hotel',
			'cruzamientos_hotel' => 'Cruzamientos Hotel',
			'razon_social' => 'Razon Social',
			'rfc_hotel' => 'Rfc Hotel',
			'id_pais_fiscal' => 'Id Pais Fiscal',
			'id_estado_fiscal' => 'Id Estado Fiscal',
			'id_ciudad_fiscal' => 'Id Ciudad Fiscal',
			'id_colonia_fiscal' => 'Id Colonia Fiscal',
			'calle_fiscal' => 'Calle Fiscal',
			'cruzamientos_fiscal' => 'Cruzamientos Fiscal',
			'cp_fiscal' => 'Cp Fiscal',
			'municipio_fiscal' => 'Municipio Fiscal',
			'num_interior_fiscal' => 'Num Interior Fiscal',
			'num_exterior_fiscal' => 'Num Exterior Fiscal',
			'log' => 'Log',
			'estatus' => 'Estatus',
			'mismadir' => 'Mismadir',
			'id_categoria' => 'Id Categoria',
			'codigo' => 'Codigo',
			'ubicacion' => 'Ubicacion',
			'latitud' => 'Latitud',
			'longitud' => 'Longitud',
			'solo_adultos' => 'Solo Adultos',
			'gay' => 'Gay',
			'tipo_cambio' => 'Tipo Cambio',
			'id_cadena' => 'Id Cadena',
			'alerta_disponibilidad' => 'Alerta Disponibilidad',
			'proveedor' => 'Proveedor',
			'precio' => 'Precio',
			'busqueda' => 'Busqueda',
			'no_listar' => 'No Listar',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_hotel',$this->id_hotel,true);
		$criteria->compare('id_destino',$this->id_destino);
		$criteria->compare('id_destinoLocal',$this->id_destinoLocal);
		$criteria->compare('nombre_hotel',$this->nombre_hotel,true);
		$criteria->compare('slug',$this->slug,true);
		$criteria->compare('tel_hotel1',$this->tel_hotel1,true);
		$criteria->compare('tel_hotel2',$this->tel_hotel2,true);
		$criteria->compare('tel_hotel3',$this->tel_hotel3,true);
		$criteria->compare('contacto_hotel',$this->contacto_hotel,true);
		$criteria->compare('email_hotel',$this->email_hotel,true);
		$criteria->compare('contacto_reservas_1',$this->contacto_reservas_1,true);
		$criteria->compare('email_reservas_1',$this->email_reservas_1,true);
		$criteria->compare('contacto_reservas_2',$this->contacto_reservas_2,true);
		$criteria->compare('email_reservas_2',$this->email_reservas_2,true);
		$criteria->compare('estrellas',$this->estrellas,true);
		$criteria->compare('max_ninios',$this->max_ninios);
		$criteria->compare('max_jrs',$this->max_jrs);
		$criteria->compare('comision',$this->comision);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('id_pais_hotel',$this->id_pais_hotel,true);
		$criteria->compare('id_estado_hotel',$this->id_estado_hotel,true);
		$criteria->compare('id_ciudad_hotel',$this->id_ciudad_hotel,true);
		$criteria->compare('id_colonia_hotel',$this->id_colonia_hotel,true);
		$criteria->compare('municipio_hotel',$this->municipio_hotel,true);
		$criteria->compare('cp_hotel',$this->cp_hotel,true);
		$criteria->compare('calle_hotel',$this->calle_hotel,true);
		$criteria->compare('num_exterior_hotel',$this->num_exterior_hotel,true);
		$criteria->compare('num_interior_hotel',$this->num_interior_hotel,true);
		$criteria->compare('cruzamientos_hotel',$this->cruzamientos_hotel,true);
		$criteria->compare('razon_social',$this->razon_social,true);
		$criteria->compare('rfc_hotel',$this->rfc_hotel,true);
		$criteria->compare('id_pais_fiscal',$this->id_pais_fiscal,true);
		$criteria->compare('id_estado_fiscal',$this->id_estado_fiscal,true);
		$criteria->compare('id_ciudad_fiscal',$this->id_ciudad_fiscal,true);
		$criteria->compare('id_colonia_fiscal',$this->id_colonia_fiscal,true);
		$criteria->compare('calle_fiscal',$this->calle_fiscal,true);
		$criteria->compare('cruzamientos_fiscal',$this->cruzamientos_fiscal,true);
		$criteria->compare('cp_fiscal',$this->cp_fiscal,true);
		$criteria->compare('municipio_fiscal',$this->municipio_fiscal,true);
		$criteria->compare('num_interior_fiscal',$this->num_interior_fiscal,true);
		$criteria->compare('num_exterior_fiscal',$this->num_exterior_fiscal,true);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('estatus',$this->estatus);
		$criteria->compare('mismadir',$this->mismadir);
		$criteria->compare('id_categoria',$this->id_categoria);
		$criteria->compare('codigo',$this->codigo,true);
		$criteria->compare('ubicacion',$this->ubicacion,true);
		$criteria->compare('latitud',$this->latitud);
		$criteria->compare('longitud',$this->longitud);
		$criteria->compare('solo_adultos',$this->solo_adultos);
		$criteria->compare('gay',$this->gay);
		$criteria->compare('tipo_cambio',$this->tipo_cambio);
		$criteria->compare('id_cadena',$this->id_cadena);
		$criteria->compare('alerta_disponibilidad',$this->alerta_disponibilidad);
		$criteria->compare('proveedor',$this->proveedor);
		$criteria->compare('precio',$this->precio);
		$criteria->compare('busqueda',$this->busqueda);
		$criteria->compare('no_listar',$this->no_listar);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}