<?php

class RecoveryController extends Controller
{
	public $defaultAction = 'recovery';
	public $layout='//layouts/login';
	/**
	 * Recovery password
	 */
	public function actionRecovery () {
		$form = new UserRecoveryForm;
		if (Yii::app()->user->id) {
		    	$this->redirect(Yii::app()->controller->module->returnUrl);
		    } else {
				$email = ((isset($_GET['email']))?$_GET['email']:'');
				$activkey = ((isset($_GET['activkey']))?$_GET['activkey']:'');
				if ($email&&$activkey) {
					$form2 = new UserChangePassword;
		    		$find = User::model()->notsafe()->findByAttributes(array('email'=>$email));
		    		if(isset($find)&&$find->activkey==$activkey) {
			    		if(isset($_POST['UserChangePassword'])) {
							$form2->attributes=$_POST['UserChangePassword'];
							if($form2->validate()) {
								$find->password = Yii::app()->controller->module->encrypting($form2->password);
								$find->activkey=Yii::app()->controller->module->encrypting(microtime().$form2->password);
								if ($find->status==0) {
									$find->status = 1;
								}
								$find->save();
								Yii::app()->user->setFlash('success',UserModule::t("La nueva contraseña ha sido guardada."));
								$this->redirect(Yii::app()->controller->module->recoveryUrl);
							}
						} 
						$this->render('changepassword',array('model'=>$form2));
		    		} else {
		    			Yii::app()->user->setFlash('error',UserModule::t("Vínculo de recuperación incorrecto."));
						$this->redirect(Yii::app()->controller->module->recoveryUrl);
		    		}
		    	} else {
			    	if(isset($_POST['UserRecoveryForm'])) {
			    		$form->attributes=$_POST['UserRecoveryForm'];
			    		if($form->validate()) {
			    			$user = User::model()->notsafe()->findbyPk($form->user_id);
							$activation_url = 'https://' . $_SERVER['HTTP_HOST'].$this->createUrl(implode(Yii::app()->controller->module->recoveryUrl).'/recovery',array("activkey" => $user->activkey, "email" => $user->email));
							
							$subject = UserModule::t("Sistema de recuperacion de contraseña de {site_name}",
			    					array(
			    						'{site_name}'=>Yii::app()->name,
			    					));
			    			$message = UserModule::t("Ha solicitado nuestro servicio de recuperación de contraseña. Para recibir una nueva contraseña, dar clic en {activation_url}. <br>Atentamente, el equipo de {site_name}",
			    					array(
			    						'{site_name}'=>Yii::app()->name,
			    						'{activation_url}'=>$activation_url,
			    					));
							
			    			UserModule::sendMail($user->email,$subject,$message);
			    			
							Yii::app()->user->setFlash('info',UserModule::t("Por favor revise su correo electrónico. Se enviarón instrucciones para recuperar su contraseña."));
			    			$this->refresh();
			    		}
			    	}
		    		$this->render('recovery',array('model'=>$form));
		    	}
		    }
	}

}