<?php
	$this->pageTitle = 'Weddings - Inicio de sesión';
    $this->breadcrumbs=array(
        UserModule::t("Sistema de Control de Documentos de Entrada"),
    );
	$assets = Yii::app()->baseUrl ."/template/vuexy";
?>

<div class="auth-wrapper auth-v2">
    <div class="auth-inner row m-0">
        <!-- Left Text-->
        <div class="d-none d-lg-flex col-lg-8 align-items-center p-5 h-100" style="overflow: hidden;">
            <div class="w-100 d-lg-flex align-items-center justify-content-center px-5"><img style="width: 90%; margin: auto;" src="<?= $assets; ?>/images/pages/dashboardboda.png" alt="Login V2" /></div>
        </div>
        <!-- /Left Text-->
        <!-- Login-->
        <div class="d-flex col-lg-4 align-items-center auth-bg px-2 p-lg-5">
            <div class="col-12 col-sm-8 col-md-6 col-lg-12 px-xl-2 mx-auto">
                <h2 class="card-title font-weight-bold mb-1">Inicio de sesión</h2>
                <p class="card-text mb-2">Por favor inicia sesión con tu cuenta.</p>

                <?php $form=$this->beginWidget('ext.bootstrap.widgets.TbActiveForm', array(
                    'type'=>'horizontal',
                    'htmlOptions'=>array('class'=>'reg-page'),
                )); ?>           
                    <div class="form-group">
                        <label class="form-label" for="login-email">Usuario</label>
                        <?php echo $form->textField($model, 'username' ,array("placeholder" => "Usuario", "class"=>"form-control", "id" => "login-email", "aria-describedby" => "login-email", "autofocus" => "", "tabindex" => "1")); ?>
                    </div>

                    <div class="form-group">
                        <div class="d-flex justify-content-between">
                            <label for="login-password">Contraseña</label><a href="<?= Yii::app()->createUrl('user/recovery')?>"><small>Olvidé mi contraseña</small></a>
                        </div>
                        <div class="input-group input-group-merge form-password-toggle">
                            <?php echo $form->passwordField($model, 'password', array("placeholder" => "Contraseña", "class" => "form-control form-control-merge", "id" => "login-password", "aria-describedby" => "login-password", "tabindex" => "2")); ?>
                            <div class="input-group-append"><span class="input-group-text cursor-pointer"><i data-feather="eye"></i></span></div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="custom-control custom-checkbox">
                            <?php echo $form->checkBox($model, 'rememberMe', array("class" => "custom-control-input", "id" => "remember-me", "tabindex" => "3")); ?>
                            <label class="custom-control-label" for="remember-me"> Recordarme en este dispositivo</label>
                        </div>
                    </div>
                    <?php $this->widget('bootstrap.widgets.TbButton',array(
                        'label' => UserModule::t("Iniciar sesión"),
                        'buttonType' => 'submit',
                        'htmlOptions' => array('class' => 'btn btn-primary btn-block'),
                    )); ?>

                    <?php echo $form->errorSummary($model); ?>
   			
                <?php $this->endWidget(); ?>
            </div>
        </div>
        <!-- /Login-->
    </div>
</div>