<?php
	/* @var $this SiteController */
	$this->pageTitle = Yii::app()->name . ' - Usuarios';
?>

<section id="user">
  	<div class="row">
	    <div class="col-12">
      		<div class="card">
        		<div class="card-header border-bottom">
          			<h4 class="card-title">Usuarios en sistema</h4>
					<div class="dt-action-buttons text-right">
					  	<div class="dt-buttons d-inline-flex">
					  		<button class="dt-button create-new btn btn-primary" tabindex="0" aria-controls="DataTables_Table_0" type="button" data-toggle="modal" data-target="#modal-cu-user">
							  	<span>
								  	<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus mr-50 font-small-4">
									  	<line x1="12" y1="5" x2="12" y2="19"></line>
										<line x1="5" y1="12" x2="19" y2="12"></line>
									</svg>
									Registrar usuario
								</span>
							</button>
						</div>
					</div>
        		</div>

        		<div class="card-datatable">
          			<table id="table-users" class="table">
            			<thead>
              				<tr>
								<th></th>
								<th>Nombre(s)</th>
								<th>Apellidos</th>
								<th>Email</th>
								<th>Usuario</th>
								<th>Admin</th>
								<th>Estatus</th>
								<th>Acciones</th>
              				</tr>
            			</thead>
          			</table>
        		</div>
      		</div>
    	</div>
  	</div>
</section>

<?php $this->renderPartial("modal-cu-user"); ?>

<?php
    Yii::app()->clientScript->registerScript('id0', '
        var baseUrl = "'. Yii::app()->baseUrl .'";
    ', CClientScript::POS_HEAD);

    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/dataTables.bootstrap4.min.css');
	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/responsive.bootstrap4.min.css');
	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/buttons.bootstrap4.min.css');
	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/rowGroup.bootstrap4.min.css');
	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/pickers/flatpickr/flatpickr.min.css');
	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/css/plugins/forms/pickers/form-flat-pickr.min.css');
	Yii::app()->clientScript->registerCssFile('https://unpkg.com/vue-multiselect@2.1.0/dist/vue-multiselect.min.css');

	Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/jquery.dataTables.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/datatables.bootstrap4.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/dataTables.responsive.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/responsive.bootstrap4.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/datatables.buttons.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/jszip.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/pdfmake.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/vfs_fonts.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/buttons.html5.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/buttons.print.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/dataTables.rowGroup.min.js', CClientScript::POS_END);

	Yii::app()->clientScript->registerScriptFile('//cdn.jsdelivr.net/npm/sweetalert2@10', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/vue/user-index.js?v='. time(), CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/vue/user-cu.js?v='. time(), CClientScript::POS_END);
?>