<?php
	/* @var $this SiteController */
	$this->pageTitle = Yii::app()->name . ' - Mi Pefil';
?>

<section id="account-settings">
    <div class="row">
        <!-- left menu section -->
        <div class="col-md-3 mb-2 mb-md-0">
            <ul class="nav nav-pills flex-column nav-left">
                <!-- general -->
                <li class="nav-item">
                    <a class="nav-link active" id="account-pill-general" data-toggle="pill" href="#account-vertical-general" aria-expanded="true">
                        <i data-feather="user" class="font-medium-3 mr-1"></i>
                        <span class="font-weight-bold">Información general</span>
                    </a>
                </li>
                <!-- change password -->
                <li class="nav-item">
                    <a class="nav-link" id="account-pill-password" data-toggle="pill" href="#account-vertical-password" aria-expanded="false">
                        <i data-feather="lock" class="font-medium-3 mr-1"></i>
                        <span class="font-weight-bold">Cambiar contraseña</span>
                    </a>
                </li>
            </ul>
        </div>
        <!--/ left menu section -->

        <!-- right content section -->
        <div class="col-md-9">
            <div class="card">
                <div class="card-body">
                    <div class="tab-content">
                        <!-- general tab -->
                        <div role="tabpanel" class="tab-pane active" id="account-vertical-general" aria-labelledby="account-pill-general" aria-expanded="true">
                            <div class="row" v-if="loaded">
                                <div class="col-12 col-sm-6">
                                    <div class="form-group">
                                        <label for="account-name">Nombre(s)</label>
                                        <input type="text" class="form-control" id="account-name" name="name" placeholder="José Luis" v-model="model_user.userProfile.firstname" />
                                    </div>
                                </div>
                                <div class="col-12 col-sm-6">
                                    <div class="form-group">
                                        <label for="account-company">Apellidos</label>
                                        <input type="text" class="form-control" id="account-company" name="company" placeholder="Hernández  García" v-model="model_user.userProfile.lastname" />
                                    </div>
                                </div>
                                <div class="col-12 col-sm-6">
                                    <div class="form-group">
                                        <label for="account-user">Usuario</label>
                                        <input type="text" class="form-control" id="account-user" placeholder="Username" v-model="model_user.username" />
                                    </div>
                                </div>
                                <div class="col-12 col-sm-6">
                                    <div class="form-group">
                                        <label for="account-e-mail">Correo electrónico</label>
                                        <input type="email" class="form-control" id="account-e-mail" placeholder="usuario@gmail.com" v-model="model_user.email" />
                                    </div>
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary mt-2 mr-1" @click="applyChanges()">Guardar cambios</button>
                                    <!-- <button type="reset" class="btn btn-outline-secondary mt-2">Cancelar</button> -->
                                </div>
                            </div>
                        </div>
                        <!--/ general tab -->

                        <!-- change password -->
                        <div class="tab-pane fade" id="account-vertical-password" role="tabpanel" aria-labelledby="account-pill-password" aria-expanded="false">
                            <!-- form -->
                            <form class="validate-form">
                                <div class="row">
                                    <div class="col-12 col-sm-6">
                                        <div class="form-group">
                                            <label for="account-new-password">Nueva contraseña</label>
                                            <div class="input-group form-password-toggle input-group-merge">
                                                <input type="password" id="account-new-password" name="new-password" class="form-control" placeholder="******************" />
                                                <div class="input-group-append">
                                                    <div class="input-group-text cursor-pointer">
                                                        <i data-feather="eye"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6">
                                        <div class="form-group">
                                            <label for="account-retype-new-password">Repetir contraseña</label>
                                            <div class="input-group form-password-toggle input-group-merge">
                                                <input type="password" class="form-control" id="account-retype-new-password" name="confirm-new-password" placeholder="******************" />
                                                <div class="input-group-append">
                                                    <div class="input-group-text cursor-pointer"><i data-feather="eye"></i></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="button" id="pwd-change" class="btn btn-primary mr-1 mt-1">Guardar cambios</button>
                                        <!-- <button type="reset" class="btn btn-outline-secondary mt-1">Cancel</button> -->
                                    </div>
                                </div>
                            </form>
                            <!--/ form -->
                        </div>
                        <!--/ change password -->
                    </div>
                </div>
            </div>
        </div>
        <!--/ right content section -->
    </div>
</section>
<!-- / account setting page -->

<?php
    Yii::app()->clientScript->registerScript('id0', '
        var baseUrl = "'. Yii::app()->baseUrl .'";
    ', CClientScript::POS_HEAD);
    /* Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/js/scripts/pages/page-account-settings.min.js', CClientScript::POS_END); */
    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/css/plugins/forms/form-validation.css');
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/forms/validation/jquery.validate.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/extensions/sweetalert2.min.css');
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/template/vuexy/vendors/js/extensions/sweetalert2.all.min.js', CClientScript::POS_END);
    // Yii::app()->clientScript->registerScriptFile('//cdn.jsdelivr.net/npm/sweetalert2@10', CClientScript::POS_END);

    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/vue/user-profile.js?v='. time(), CClientScript::POS_END);
?>