Vue.http.options.emulateJSON = true;
var appBanner = new Vue({
    el: "#bannerIcon",
    data: {
        rmt_url: baseUrl,
        loaded: false,
        showing: false,
        array_banner: [],
        banners: {
            'titulo': '',
            'posicion': ''
        },
        mostrarimagen: ''
    },
    created: function() {},
    mounted: function() {
        this.loadBanners();
    },
    methods: {
        loadBanners: function() {
            this.$http.post(this.rmt_url + "/boda/getBanners/idBoda/" + idBoda).then(function(response) {
                this.array_banner = response.body;
            }, function(ex) {
                console.log(ex);
            });
        },
        insertImagen: function() {
            var that = this;
            var fd = new FormData();
            var files = $("#file")[0].files;
            if (files.length > 0) {
                var titulo = $("#bannerstitulo").val();
                var posicion = $("#basicSelect").val();
                fd.append('idBoda', idBoda);
                fd.append('file', files[0]);
                fd.append('bannerstitulo', titulo);
                fd.append('bannersposicion', posicion);
                this.$http.post(this.rmt_url + '/boda/insert', fd).then(function(response) {
                    this.loadBanners();
                }, function(ex) {
                    console.log(ex);
                });
            } else {
                // alert("Please select a file.");
            }
        },
        posicion: function(posicion) {
            var recibir = "";
            switch (parseInt(posicion)) {
                case 1:
                    recibir = "Portada";
                    break;

                case 2:
                    recibir = 'Lateral Izquierdo';
                    break;

                case 3:
                    recibir = 'Libro de Firmas';
                    break;

                case 4:
                    recibir = 'Ceremonia Nupcial';
                    break;

                case 5:
                    recibir = 'Registro';
                    break;
            }

            return recibir;
        },
        dropifyVue: function(banner) {
            this.banners = banner;
            $(".dropify2").attr("data-default-file", urlimage + '/images/banners/' + banner.nombre_real);
            $(".dropify2").dropify({
                messages: {
                    default: "Agregar imagen",
                    replace: 'Click aquí para reemplazar imagen',
                    remove: 'Quitar',
                    error: 'Ooops, algo salió mal'
                },
            });
        },
        updateImagen: function(banner) {
            var titulo = $("#actualizarTitulo").val();
            var posicion = $("#actualizarPosicion").val();

            var fd = new FormData();
            fd.append('idBoda', idBoda);
            fd.append('id_banner', this.banners.id_banner);
            fd.append('actualizarTitulo', titulo);
            fd.append('actualizarPosicion', posicion);

            var files = $("#actualizarimagen")[0].files;
            if (files.length > 0) {
                fd.append('actualizarimagen', files[0]);
            }

            this.$http.post(this.rmt_url + '/boda/updateImagen', fd).then(function(response) {
                this.loadBanners();
            }, function(ex) {
                console.log(ex);
            });
        },
        deleteBanner: function(id_banner) {
            var that = this;
            Swal.fire({
                title: "¿Seguro?",
                text: "Esta a punto de eliminar esta imagen",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Confirmar",
                cancelButtonText: "Cancelar",
            }).then((result) => {
                if (result.value) {
                    this.$http.post(this.rmt_url + "/boda/deleteBanner", { id_banner: id_banner }).then(function(response) {
                        this.array_banner = response.body;
                        if (response.body.success) {
                            Swal.fire({
                                icon: "success",
                                title: "Correcto",
                                text: "Se ha eliminado la imagen correctamente",
                            });
                        } else {
                            Swal.fire({
                                icon: "error",
                                title: "¡Ups!",
                                text: "Algo salió mal, recargue la página e intentelo de nuevo",
                            });
                        }
                        that.loadBanners();
                    }, function(ex) {
                        console.log(ex);
                    });
                }
            });
        },
    },
});

$(document).ready(function() {
    $(".dropify").dropify({
        messages: {
            default: "Agregar imagen",
            replace: "Click aquí para reemplazar imagen",
            remove: "Quitar",
            error: "Ooops, algo salió mal"
        },
    });
})