Vue.http.options.emulateJSON = true;
// console.log(idBoda)
// if (typeof idBoda === "undefined") {
//     idBoda = "1";
// }
var appComentarios = new Vue({
    el: '#commentIcon',
    data: {
        rmt_url: baseUrl,
        idBoda: idBoda,
        array_comentarios: [],
        table_comentarios: "",
    },
    created: function() {},
    mounted: function() {
        this.loadTableComentarios();
    },
    methods: {
        loadTableComentarios: function() {
            var that = this;
            this.table_comentarios = $('#table-comentarios').DataTable({
                language: { url: "//cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json" },
                destroy: true,
                ajax: {
                    "url": this.rmt_url + "/comentarios/getComentarios",
                    "type": "POST",
                    "data": {
                        "idBoda": that.idBoda
                    },
                    "dataSrc": function(json) {
                        that.array_comentarios = json;
                        return json;
                    }
                },
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                order:[[1, 'desc']],
                columnDefs: [{
                        targets: 0,
                        data: "nombre",
                        width: "20%",
                    }, {
                        targets: 1,
                        render: function(data, type, row, meta) {
                            return moment(row.fecha).format("DD/MM/YYYY");
                        }
                    }, {
                        targets: 2,
                        data: "comentario",
                    },
                    {
                        targets: -1,
                        orderable: false,
                        render: function(data, type, row, meta) {
                            return '</a><a href="javascript:;" class="delete-record ml-1" data-comentario="' + row.id_comentario + '">' + feather.icons["trash-2"].toSvg({
                                class: "font-small-4"
                            }) + '</a>';
                        }
                    }
                ]
            });
            // $("div.head-label").html('<h6 class="mb-0">DataTable with Buttons</h6>');
        },
        deleteComentario: function(id_comentario) {
            Swal.fire({
                title: '¿Seguro?',
                text: "Esta a punto de eliminar este comentario",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Confirmar',
                cancelButtonText: 'Cancelar'

            }).then((result) => {
                if (result.value) {
                    this.$http.post(this.rmt_url + '/comentarios/delete', { "id": id_comentario }).then(function(response) {
                        var response_var = response.body;
                        if (response_var.success) {
                            appComentarios.table_comentarios.ajax.reload();
                            Swal.fire({
                                icon: 'success',
                                title: 'Correcto',
                                text: 'Se ha eliminado tu comentario.'
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: "¡Ups!",
                                text: "Algo salió mal, recargue la página e intentelo de nuevo",
                            });
                        }
                    });
                }
            });
        },
        round: function(value, decimals) {
            return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        },
    }
});

$("body").on("click", ".delete-record", function() {
    var id_comentario = $(this).attr("data-comentario");
    appComentarios.deleteComentario(id_comentario);
});