const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    showConfirmButton: false,
    timer: 3000
});
Dropzone.autoDiscover = false;
Vue.http.options.emulateJSON = true;

var appPhotos = new Vue({
    el: "#photoIcon",
    data: {
        rmt_url: baseUrl,
        loaded: false,
        showing: false,
        array_fotos: [],
    },
    created: function() {},
    mounted: function() {
        this.loadFotos();
        this.initDropzone();
    },
    methods: {
        loadFotos: function() {
            this.$http.get(this.rmt_url + "/boda/getFotos/idBoda/" + idBoda).then(function(response) {
                this.array_fotos = response.body;
            });
        },
        insertFoto: function() {
            this.dropzoneImages.processQueue();
        },
        deleteImagen: function(id_album) {
            var that = this;
            Swal.fire({
                title: "¿Seguro?",
                text: "Esta a punto de eliminar esta imagen",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Confirmar",
                cancelButtonText: "Cancelar",
            }).then((result) => {
                if (result.value) {
                    this.$http
                        .post(this.rmt_url + "/boda/deleteImagen", { id_album: id_album })
                        .then(function(response) {
                            this.array_banner = response.body;
                            if (response.body.success) {
                                Swal.fire({
                                    icon: "success",
                                    title: "Correcto",
                                    text: "Se ha eliminado la imagen correctamente",
                                });
                            } else {
                                Swal.fire({
                                    icon: "error",
                                    title: "¡Ups!",
                                    text: "Algo salió mal, recargue la página e intentelo de nuevo",
                                });
                            }
                            that.loadFotos();
                        });
                }
            });
        },
        initDropzone: function() {
            this.dropzoneImages = new Dropzone("#dpzImages", {
                acceptedFiles: "image/*",
                // maxFilesize: .5,
                clickable: true,
                addRemoveLinks: true,
                autoProcessQueue: true,
                dictRemoveFile: "Eliminar",
                parallelUploads: 20,
                uploadMultiple: true,
                init: function() {
                    var e = this;
                    $("#clear-dropzone").on("click", (function() { e.removeAllFiles() }))
                }
            });
            this.dropzoneImages.on("queuecomplete", function() {
                appPhotos.loadFotos();
                Toast.fire({
                    icon: 'success',
                    title: 'Guardado con éxito.'
                });
                feather.replacce();
            });
            this.dropzoneImages.on("complete", file => {
                appPhotos.dropzoneImages.removeFile(file);
            });
        }
    },
});