Vue.component('v-multiselect', window.VueMultiselect.default);
Vue.http.options.emulateJSON = true;

var appModalWedding = new Vue({
    el: '#modal-cu-wedding',
    data: {
        rmt_url: baseUrl,
        loaded: false,
        showing: false,
        action: "create",

        loading_bloqueos: false,
        options_bloqueos: [],
        array_layouts: [],

        model_wedding: {
            id: 0,
            novio: "",
            novia: "",
            slug: "",
            lugar: 0,
            fecha_boda: "",
            fecha_entrada: "0000-00-00",
            fecha_salida: "0000-00-00",
            fecha_lim_reserva: "0000-00-00",
            hora_inicio: "00:00:00",
            hora_fin: "00:00:00",
            id_layout: 0,
            correo_novio: "",
            correo_novia: "",
            id_bloqueo: 0,
            url: "",
            datos_pago:""
        },
        selected_bloqueo: [],
        nombre_hotel: "",
    },
    created: function() {},
    mounted: function() {
        this.loadLayouts();
        this.initLibraries();
    },
    methods: {
        createWedding: function() {
            delete this.model_wedding.id;
            this.setModelDatePickers();
            this.$http.post(this.rmt_url + "/boda/create", this.model_wedding).then(function(response) {
                $('#modal-cu-wedding').modal('hide');
                var response_var = response.body;
                if (response_var.id) {
                    this.clearModel();
                    Swal.fire({
                        icon: 'success',
                        title: 'Correcto',
                        text: 'Se ha creado la boda.'
                    });
                    appWeddings.table_weddings.ajax.reload();
                } else {
                    var error_table = "<table class='table table-bordered table-striped'><tr>"
                    Object.values(response.body).forEach(element => {
                        error_table += "<td>" + element + "</td>";
                    });
                    error_table += "</tr></table>";
                    Swal.fire({
                        icon: 'error',
                        title: "¡Ops!",
                        html: "<p>Algo salió mal</p>" + error_table,
                    });
                }
            }, function(ex) {
                Swal.fire({
                    icon: 'error',
                    title: "¡Ops!",
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(ex.body) + "</pre></code>",
                });
                console.log(ex.body);
            });
        },
        updateWedding: function() {
            this.setModelDatePickers();
            this.$http.post(this.rmt_url + "/boda/update?id=" + this.model_wedding.id, this.model_wedding).then(function(response) {
                $('#modal-cu-wedding').modal('hide');
                var response_var = response.body;
                if (response_var.id) {
                    this.clearModel();
                    Swal.fire({
                        icon: 'success',
                        title: 'Correcto',
                        text: 'Se han aplicados los cambios realizados.'
                    });
                    appWeddings.table_weddings.ajax.reload();
                } else {
                    var error_table = "<table class='table table-bordered table-striped'><tr>"
                    Object.values(response.body).forEach(element => {
                        error_table += "<td>" + element + "</td>";
                    });
                    error_table += "</tr></table>";
                    Swal.fire({
                        icon: 'error',
                        title: "¡Ops!",
                        html: "<p>Algo salió mal</p>" + error_table,
                    });
                }
            }, function(ex) {
                Swal.fire({
                    icon: 'error',
                    title: "¡Ops!",
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(ex.body) + "</pre></code>",
                });
                console.log(ex.body);
            });
        },
        deleteWedding: function(id_boda) {
            Swal.fire({
                title: '¿Seguro?',
                text: "Esta a punto de eliminar esta boda",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Confirmar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    this.$http.post(this.rmt_url + '/boda/delete', { "id": id_boda }).then(function(response) {
                        var response_var = response.body;
                        if (response_var.success) {
                            appWeddings.table_weddings.ajax.reload();
                            Swal.fire({
                                icon: 'success',
                                title: 'Correcto',
                                text: 'Se ha eliminado el registro de la boda.'
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: "¡Ops!",
                                text: "Algo salió mal, recargue la página e intentelo de nuevo",
                            });
                        }
                    }, function(e) {
                        console.log(e);
                        Swal.fire({
                            type: 'error',
                            title: "¡Ops!",
                            html: "Algo salió mal. <div class='uk-margin-top'>" + ex.body.data.message + "</div>",
                        });
                    });
                }
            });
        },
        loadLayouts: function() {
            this.$http.get(this.rmt_url + "/boda/getLayouts").then(function(response) {
                var response_var = response.body;
                this.array_layouts = response_var;
            }, function(ex) {
                console.log(ex.body);
            });
        },
        findBloqueos: function(query) {
            if (query.length >= 3) {
                this.loading_bloqueos = true;
                this.$http.get(this.rmt_url + "/boda/getBloqueos?query=" + query, {
                    before(request) {
                        // abort previous request, if exists
                        if (this.previousRequest) {
                            this.previousRequest.abort();
                        }
                        // set previous request on Vue instance
                        this.previousRequest = request;
                    }
                }).then(function(response) {
                    this.loading_bloqueos = false;
                    var response_var = response.body;
                    this.options_bloqueos = response_var;
                }, function() {
                    this.loading_bloqueos = false;
                    console.log('Error');
                });
            }
        },
        selectedBloqueo: function(selectedOption, id) {
            this.model_wedding.id_bloqueo = selectedOption.id_bloqueo;
            this.selected_hotel = selectedOption.idHotel;
            this.model_wedding.lugar = selectedOption.idHotel.id_hotel;
            this.nombre_hotel = selectedOption.idHotel.nombre_hotel;
        },
        setModelDatePickers: function() {
            this.model_wedding.fecha_boda = $("#text-fecha-boda").val();
        },
        initLibraries: function() {
            this.dpw = $("#text-fecha-boda").flatpickr({ dateFormat: "d/m/Y" });
        },
        clearModel: function() {
            this.model_wedding = {
                id: 0,
                novio: "",
                novia: "",
                slug: "",
                lugar: 0,
                fecha_boda: "",
                fecha_entrada: "",
                fecha_salida: "",
                fecha_lim_reserva: "",
                hora_inicio: "",
                hora_fin: "",
                id_layout: 0,
                correo_novio: "",
                correo_novia: "",
                id_bloqueo: 0,
                url: "",
                datos_pago:""
            }
            this.selected_bloqueo = [];
            this.nombre_hotel = "";
        }
    }
});

$("body").on("click", ".edit-record", function() {
    appModalWedding.action = "update";
    var id_boda = $(this).attr("data-boda");
    var weddingFinded = appWeddings.array_weedings.findIndex(x => x.id == id_boda);
    appModalWedding.model_wedding = appWeddings.array_weedings[weddingFinded];

    var wedding_date = moment(appModalWedding.model_wedding.fecha_boda).format("DD/MM/YYYY");

    appModalWedding.dpw.setDate(wedding_date);

    appModalWedding.selected_bloqueo = appModalWedding.model_wedding.idBloqueo;
    appModalWedding.nombre_hotel = appWeddings.array_weedings[weddingFinded].idHotel.nombre_hotel;
});

$("body").on("click", ".delete-record", function() {
    var id_boda = $(this).attr("data-boda");
    appModalWedding.deleteWedding(id_boda);
});

$('#modal-cu-wedding').on('hidden.bs.modal', function(event) {
    appModalWedding.action = "create";
    appModalWedding.clearModel();
})